/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ElementRule;

class WeekdayRule<D extends CalendarDate>
implements ElementRule<D, Weekday> {
    private final Weekmodel stdWeekmodel;
    private final ChronoFunction<D, CalendarSystem<D>> calsysFunc;

    WeekdayRule(Weekmodel weekmodel, ChronoFunction<D, CalendarSystem<D>> chronoFunction) {
        this.stdWeekmodel = weekmodel;
        this.calsysFunc = chronoFunction;
    }

    @Override
    public Weekday getValue(D d) {
        return WeekdayRule.getWeekday(d.getDaysSinceEpochUTC());
    }

    @Override
    public Weekday getMinimum(D d) {
        CalendarSystem<D> calendarSystem = this.calsysFunc.apply(d);
        int n = this.getValue(d).getValue(this.stdWeekmodel);
        if (d.getDaysSinceEpochUTC() + 1L - (long)n < calendarSystem.getMinimumSinceUTC()) {
            return WeekdayRule.getWeekday(calendarSystem.getMinimumSinceUTC());
        }
        return this.stdWeekmodel.getFirstDayOfWeek();
    }

    @Override
    public Weekday getMaximum(D d) {
        CalendarSystem<D> calendarSystem = this.calsysFunc.apply(d);
        int n = this.getValue(d).getValue(this.stdWeekmodel);
        if (d.getDaysSinceEpochUTC() + 7L - (long)n > calendarSystem.getMaximumSinceUTC()) {
            return WeekdayRule.getWeekday(calendarSystem.getMaximumSinceUTC());
        }
        return this.stdWeekmodel.getFirstDayOfWeek().roll(6);
    }

    @Override
    public boolean isValid(D d, Weekday weekday) {
        CalendarSystem<D> calendarSystem;
        if (weekday == null) {
            return false;
        }
        int n = this.getValue(d).getValue(this.stdWeekmodel);
        int n2 = weekday.getValue(this.stdWeekmodel);
        long l = d.getDaysSinceEpochUTC() + (long)n2 - (long)n;
        return l >= (calendarSystem = this.calsysFunc.apply(d)).getMinimumSinceUTC() && l <= calendarSystem.getMaximumSinceUTC();
    }

    @Override
    public D withValue(D d, Weekday weekday, boolean bl) {
        CalendarSystem<D> calendarSystem;
        if (weekday == null) {
            throw new IllegalArgumentException("Missing weekday.");
        }
        int n = this.getValue(d).getValue(this.stdWeekmodel);
        int n2 = weekday.getValue(this.stdWeekmodel);
        long l = d.getDaysSinceEpochUTC() + (long)n2 - (long)n;
        if (l >= (calendarSystem = this.calsysFunc.apply(d)).getMinimumSinceUTC() && l <= calendarSystem.getMaximumSinceUTC()) {
            return (D)((CalendarDate)calendarSystem.transform(l));
        }
        throw new IllegalArgumentException("New day out of supported range.");
    }

    @Override
    public ChronoElement<?> getChildAtFloor(D d) {
        return null;
    }

    @Override
    public ChronoElement<?> getChildAtCeiling(D d) {
        return null;
    }

    private static Weekday getWeekday(long l) {
        return Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1);
    }
}

