/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import net.time4j.CalendarUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.calendar.astro.AstroUtils;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.MoonPosition;
import net.time4j.calendar.astro.SolarTime;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.engine.CalendarDate;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class LunarTime
implements GeoLocation,
Serializable {
    private static final int MRD = 1000000000;
    private static final long serialVersionUID = -8029871830105935048L;
    private final double latitude;
    private final double longitude;
    private final int altitude;
    private final TZID observerZoneID;

    private LunarTime(double d, double d2, int n, TZID tZID) {
        LunarTime.check(d, d2, n, tZID);
        this.latitude = d;
        this.longitude = d2;
        this.altitude = n;
        this.observerZoneID = tZID;
    }

    public static Builder ofLocation(TZID tZID) {
        if (tZID == null) {
            throw new NullPointerException("Missing observer timezone.");
        }
        return new Builder(tZID);
    }

    public static LunarTime ofLocation(TZID tZID, double d, double d2) {
        return LunarTime.ofLocation(tZID, d, d2, 0);
    }

    public static LunarTime ofLocation(TZID tZID, double d, double d2, int n) {
        return new LunarTime(d, d2, n, tZID);
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public int getAltitude() {
        return this.altitude;
    }

    public TZID getObserverZoneID() {
        return this.observerZoneID;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LunarTime) {
            LunarTime lunarTime = (LunarTime)object;
            return this.altitude == lunarTime.altitude && Double.compare(this.latitude, lunarTime.latitude) == 0 && Double.compare(this.longitude, lunarTime.longitude) == 0 && this.observerZoneID.canonical().equals(lunarTime.observerZoneID.canonical());
        }
        return false;
    }

    public int hashCode() {
        return 7 * AstroUtils.hashCode(this.latitude) + 31 * AstroUtils.hashCode(this.longitude) + 37 * this.altitude;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LunarTime[");
        stringBuilder.append(",observer-tz=");
        stringBuilder.append(this.observerZoneID.canonical());
        stringBuilder.append(",latitude=");
        stringBuilder.append(this.latitude);
        stringBuilder.append(",longitude=");
        stringBuilder.append(this.longitude);
        if (this.altitude != 0) {
            stringBuilder.append(",altitude=");
            stringBuilder.append(this.altitude);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Moonlight on(CalendarDate calendarDate) {
        PlainDate plainDate = SolarTime.toGregorian(calendarDate);
        Timezone timezone = Timezone.of(this.observerZoneID);
        Moment moment = timezone.getHistory() == null ? plainDate.at(PlainTime.midnightAtStartOfDay()).in(timezone) : plainDate.atFirstMoment(this.observerZoneID);
        double d = JulianDay.ofMeanSolarTime(moment).getMJD();
        double d2 = Math.toRadians(this.longitude);
        double d3 = Math.cos(Math.toRadians(this.latitude));
        double d4 = Math.sin(Math.toRadians(this.latitude));
        double d5 = StdSolarCalculator.TIME4J.getGeodeticAngle(this.latitude, this.altitude);
        double d6 = AstroUtils.refractionFactorOfStdAtmosphere(this.altitude) * 34.0 / 60.0;
        double d7 = TimeScale.deltaT(plainDate);
        double d8 = 1.0;
        double d9 = LunarTime.sinAlt(d, 0.0, d2, d3, d4, d5, d6, d7);
        double[] dArray = new double[4];
        boolean bl = d9 > 0.0;
        boolean bl2 = false;
        boolean bl3 = false;
        double d10 = Double.NaN;
        double d11 = Double.NaN;
        do {
            double d12;
            double d13;
            int n;
            if ((n = LunarTime.interpolate(d9, d13 = LunarTime.sinAlt(d, d8, d2, d3, d4, d5, d6, d7), d12 = LunarTime.sinAlt(d, d8 + 1.0, d2, d3, d4, d5, d6, d7), dArray)) == 1) {
                double d14 = dArray[2];
                if (Double.isNaN(d14)) {
                    d14 = dArray[3];
                }
                if (d9 < 0.0) {
                    d10 = d8 + d14;
                    bl2 = true;
                } else {
                    d11 = d8 + d14;
                    bl3 = true;
                }
            } else if (n == 2) {
                if (dArray[1] < 0.0) {
                    d10 = d8 + dArray[3];
                    d11 = d8 + dArray[2];
                } else {
                    d10 = d8 + dArray[2];
                    d11 = d8 + dArray[3];
                }
                bl2 = true;
                bl3 = true;
            }
            d9 = d12;
        } while (!((d8 += 2.0) > 25.0) && (!bl2 || !bl3));
        Moment moment2 = null;
        Moment moment3 = null;
        if (bl2 && !(moment2 = LunarTime.add(moment, d10)).toZonalTimestamp(this.observerZoneID).getCalendarDate().equals(plainDate)) {
            moment2 = null;
        }
        if (bl3 && !(moment3 = LunarTime.add(moment, d11)).toZonalTimestamp(this.observerZoneID).getCalendarDate().equals(plainDate)) {
            moment3 = null;
        }
        return new Moonlight(plainDate, this.observerZoneID, moment2, moment3, bl);
    }

    private static Moment add(Moment moment, double d) {
        double d2 = d * 3600.0;
        long l = (long)Math.floor(d2);
        long l2 = (long)((d2 - (double)l) * 1.0E9);
        return (Moment)((Moment)((Moment)moment.plus(l, TimeUnit.SECONDS)).plus(l2, TimeUnit.NANOSECONDS)).with(Moment.PRECISION, TimeUnit.SECONDS);
    }

    private static double sinAlt(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d + d2 / 24.0;
        double d10 = LunarTime.toJulianCenturies(d9 + d8 / 86400.0);
        double[] dArray = MoonPosition.calculateMeeus47(d10);
        double d11 = dArray[0] * Math.cos(Math.toRadians(dArray[1]));
        double d12 = AstroUtils.gmst(d9) + Math.toRadians(d11) + d3 - Math.toRadians(dArray[2]);
        double d13 = Math.toRadians(dArray[3]);
        double d14 = d5 * Math.sin(d13) + d4 * Math.cos(d13) * Math.cos(d12);
        double d15 = 0.7275 * LunarTime.getHorizontalParallax(dArray[4]) - d7 - d6;
        return d14 - Math.sin(Math.toRadians(d15));
    }

    private static double toJulianCenturies(double d) {
        return (d - 51544.5) / 36525.0;
    }

    private static int interpolate(double d, double d2, double d3, double[] dArray) {
        double d4 = 0.5 * (d3 + d) - d2;
        double d5 = 0.5 * (d3 - d);
        double d6 = -d5 / (2.0 * d4);
        double d7 = (d4 * d6 + d5) * d6 + d2;
        double d8 = d5 * d5 - 4.0 * d4 * d2;
        double d9 = Double.NaN;
        double d10 = Double.NaN;
        int n = 0;
        if (d8 >= 0.0) {
            double d11 = 0.5 * Math.sqrt(d8) / Math.abs(d4);
            if (Math.abs(d6 - d11) <= 1.0) {
                d9 = d6 - d11;
                ++n;
            }
            if (Math.abs(d6 + d11) <= 1.0) {
                d10 = d6 + d11;
                ++n;
            }
        }
        dArray[0] = d6;
        dArray[1] = d7;
        dArray[2] = d9;
        dArray[3] = d10;
        return n;
    }

    private static double getHorizontalParallax(double d) {
        return Math.toDegrees(Math.asin(6378.14 / d));
    }

    private static void check(double d, double d2, int n, TZID tZID) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException("Latitude must be a finite value: " + d);
        }
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException("Longitude must be a finite value: " + d2);
        }
        if (Double.compare(d, 90.0) > 0 || Double.compare(d, -90.0) < 0) {
            throw new IllegalArgumentException("Degrees out of range -90.0 <= latitude <= +90.0: " + d);
        }
        if (Double.compare(d2, 180.0) >= 0 || Double.compare(d2, -180.0) < 0) {
            throw new IllegalArgumentException("Degrees out of range -180.0 <= longitude < +180.0: " + d2);
        }
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            throw new IllegalArgumentException("Altitude must be finite: " + n);
        }
        if (n < 0 || n >= 11000) {
            throw new IllegalArgumentException("Meters out of range 0 <= altitude < +11,000: " + n);
        }
        Timezone.of(tZID);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        LunarTime.check(this.latitude, this.longitude, this.altitude, this.observerZoneID);
    }

    public static class Moonlight {
        private final TZID observerZoneID;
        private final Moment startOfDay;
        private final Moment endOfDay;
        private final Moment moonrise;
        private final Moment moonset;
        private final boolean above;

        private Moonlight(PlainDate plainDate, TZID tZID, Moment moment, Moment moment2, boolean bl) {
            this.observerZoneID = tZID;
            Timezone timezone = Timezone.of(tZID);
            PlainDate plainDate2 = (PlainDate)plainDate.plus(1L, CalendarUnit.DAYS);
            if (timezone.getHistory() == null) {
                this.startOfDay = plainDate.atStartOfDay().in(timezone);
                this.endOfDay = plainDate2.atStartOfDay().in(timezone);
            } else {
                this.startOfDay = plainDate.atFirstMoment(tZID);
                this.endOfDay = plainDate2.atFirstMoment(tZID);
            }
            this.moonrise = moment;
            this.moonset = moment2;
            this.above = bl;
        }

        public Moment moonrise() {
            return this.moonrise;
        }

        public PlainTimestamp moonriseLocal() {
            if (this.moonrise == null) {
                return null;
            }
            return this.moonrise.toZonalTimestamp(this.observerZoneID);
        }

        public PlainTimestamp moonrise(TZID tZID) {
            if (this.moonrise == null) {
                return null;
            }
            return this.moonrise.toZonalTimestamp(tZID);
        }

        public Moment moonset() {
            return this.moonset;
        }

        public PlainTimestamp moonsetLocal() {
            if (this.moonset == null) {
                return null;
            }
            return this.moonset.toZonalTimestamp(this.observerZoneID);
        }

        public PlainTimestamp moonset(TZID tZID) {
            if (this.moonset == null) {
                return null;
            }
            return this.moonset.toZonalTimestamp(tZID);
        }

        public boolean isPresent(Moment moment) {
            if (moment.isBefore(this.startOfDay) || !moment.isBefore(this.endOfDay)) {
                return false;
            }
            if (this.moonrise == null) {
                if (this.moonset == null) {
                    return this.above;
                }
                assert (this.above);
                return moment.isBefore(this.moonset);
            }
            if (this.moonset == null) {
                assert (!this.above);
                return !moment.isBefore(this.moonrise);
            }
            if (this.moonrise.isBefore(this.moonset)) {
                assert (!this.above);
                return !moment.isBefore(this.moonrise) && moment.isBefore(this.moonset);
            }
            assert (this.above);
            return moment.isBefore(this.moonset) || !moment.isBefore(this.moonrise);
        }

        public boolean isPresentAllDay() {
            return this.above && this.moonrise == null && this.moonset == null;
        }

        public boolean isAbsent() {
            return this.length() == 0;
        }

        public int length() {
            if (this.moonrise == null) {
                if (this.moonset == null) {
                    if (this.above) {
                        return (int)this.startOfDay.until(this.endOfDay, TimeUnit.SECONDS);
                    }
                    return 0;
                }
                assert (this.above);
                return (int)this.startOfDay.until(this.moonset, TimeUnit.SECONDS);
            }
            if (this.moonset == null) {
                assert (!this.above);
                return (int)this.moonrise.until(this.endOfDay, TimeUnit.SECONDS);
            }
            if (this.moonrise.isBefore(this.moonset)) {
                assert (!this.above);
                return (int)this.moonrise.until(this.moonset, TimeUnit.SECONDS);
            }
            assert (this.above);
            long l = this.startOfDay.until(this.moonset, TimeUnit.SECONDS);
            return (int)(l += this.moonrise.until(this.endOfDay, TimeUnit.SECONDS));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Moonlight[");
            stringBuilder.append("tz=");
            stringBuilder.append(this.observerZoneID.canonical());
            stringBuilder.append(" | ");
            if (this.moonrise == null) {
                if (this.moonset == null) {
                    stringBuilder.append("always ");
                    stringBuilder.append(this.above ? "up" : "down");
                } else {
                    stringBuilder.append("moonset=");
                    stringBuilder.append(this.moonset.toZonalTimestamp(this.observerZoneID));
                }
            } else if (this.moonset == null) {
                stringBuilder.append("moonrise=");
                stringBuilder.append(this.moonrise.toZonalTimestamp(this.observerZoneID));
            } else if (this.moonrise.isBefore(this.moonset)) {
                stringBuilder.append("moonrise=");
                stringBuilder.append(this.moonrise.toZonalTimestamp(this.observerZoneID));
                stringBuilder.append(" | moonset=");
                stringBuilder.append(this.moonset.toZonalTimestamp(this.observerZoneID));
            } else {
                stringBuilder.append("moonset=");
                stringBuilder.append(this.moonset.toZonalTimestamp(this.observerZoneID));
                stringBuilder.append(" | moonrise=");
                stringBuilder.append(this.moonrise.toZonalTimestamp(this.observerZoneID));
            }
            stringBuilder.append(" | length=");
            stringBuilder.append(this.length());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    public static class Builder {
        private double latitude = Double.NaN;
        private double longitude = Double.NaN;
        private int altitude = 0;
        private final TZID observerZoneID;

        private Builder(TZID tZID) {
            this.observerZoneID = tZID;
        }

        public Builder northernLatitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 90);
            if (Double.isNaN(this.latitude)) {
                this.latitude = (double)n + (double)n2 / 60.0 + d / 3600.0;
                return this;
            }
            throw new IllegalStateException("Latitude has already been set.");
        }

        public Builder southernLatitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 90);
            if (Double.isNaN(this.latitude)) {
                this.latitude = -1.0 * ((double)n + (double)n2 / 60.0 + d / 3600.0);
                return this;
            }
            throw new IllegalStateException("Latitude has already been set.");
        }

        public Builder easternLongitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 179);
            if (Double.isNaN(this.longitude)) {
                this.longitude = (double)n + (double)n2 / 60.0 + d / 3600.0;
                return this;
            }
            throw new IllegalStateException("Longitude has already been set.");
        }

        public Builder westernLongitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 180);
            if (Double.isNaN(this.longitude)) {
                this.longitude = -1.0 * ((double)n + (double)n2 / 60.0 + d / 3600.0);
                return this;
            }
            throw new IllegalStateException("Longitude has already been set.");
        }

        public Builder atAltitude(int n) {
            if (Double.isInfinite(n) || Double.isNaN(n)) {
                throw new IllegalArgumentException("Altitude must be finite: " + n);
            }
            if (n < 0 || n >= 11000) {
                throw new IllegalArgumentException("Meters out of range 0 <= altitude < +11,000: " + n);
            }
            this.altitude = n;
            return this;
        }

        public LunarTime build() {
            if (Double.isNaN(this.latitude)) {
                throw new IllegalStateException("Latitude was not yet set.");
            }
            if (Double.isNaN(this.longitude)) {
                throw new IllegalStateException("Longitude was not yet set.");
            }
            return new LunarTime(this.latitude, this.longitude, this.altitude, this.observerZoneID);
        }

        private static void check(int n, int n2, double d, int n3) {
            if (n < 0 || n > n3 || n == n3 && n3 != 179 && (n2 > 0 || Double.compare(d, 0.0) > 0)) {
                double d2 = (double)n + (double)n2 / 60.0 + d / 3600.0;
                throw new IllegalArgumentException("Degrees out of range: " + n + " (decimal=" + d2 + ")");
            }
            if (n2 < 0 || n2 >= 60) {
                throw new IllegalArgumentException("Arc minutes out of range: " + n2);
            }
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw new IllegalArgumentException("Arc seconds must be finite.");
            }
            if (Double.compare(d, 0.0) < 0 || Double.compare(d, 60.0) >= 0) {
                throw new IllegalArgumentException("Arc seconds out of range: " + d);
            }
        }
    }
}

