/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.IndianCalendar;
import net.time4j.calendar.IndianMonth;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.astro.SolarTime;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.calendar.hindu.AdjustableTextElement;
import net.time4j.calendar.hindu.HinduCS;
import net.time4j.calendar.hindu.HinduDay;
import net.time4j.calendar.hindu.HinduEra;
import net.time4j.calendar.hindu.HinduMonth;
import net.time4j.calendar.hindu.HinduPrimitive;
import net.time4j.calendar.hindu.HinduRule;
import net.time4j.calendar.hindu.HinduVariant;
import net.time4j.calendar.hindu.SPX;
import net.time4j.calendar.service.RelatedGregorianYearRule;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.calendar.service.WeekdayRule;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.ValidationElement;
import net.time4j.engine.VariantSource;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.DisplayElement;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.DualFormatElement;
import net.time4j.tz.TZID;
import net.time4j.tz.ZonalOffset;

@CalendarType(value="hindu")
public final class HinduCalendar
extends CalendarVariant<HinduCalendar>
implements LocalizedPatternSupport {
    private static final int MIN_YEAR = 1200;
    private static final int MAX_YEAR = 5999;
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_YEAR_INDEX = 1;
    @FormattableElement(format="G")
    public static final ChronoElement<HinduEra> ERA = new StdEnumDateElement<HinduEra, HinduCalendar>("ERA", HinduCalendar.class, HinduEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, HinduCalendar> YEAR_OF_ERA = new StdIntegerDateElement<HinduCalendar>("YEAR_OF_ERA", HinduCalendar.class, 0, 6000, 'y');
    @FormattableElement(format="M")
    public static final AdjustableTextElement<HinduMonth> MONTH_OF_YEAR = MonthElement.SINGLETON;
    @FormattableElement(format="d")
    public static final AdjustableTextElement<HinduDay> DAY_OF_MONTH = DayOfMonthElement.SINGLETON;
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, HinduCalendar> DAY_OF_YEAR = new StdIntegerDateElement<HinduCalendar>("DAY_OF_YEAR", HinduCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, HinduCalendar> DAY_OF_WEEK = new StdWeekdayElement<HinduCalendar>(HinduCalendar.class, IndianCalendar.getDefaultWeekmodel());
    private static final Map<String, HinduCS> CALSYS;
    private static final CalendarFamily<HinduCalendar> ENGINE;
    private static final long serialVersionUID = 4078031838043675524L;
    private final transient HinduVariant variant;
    private final transient int kyYear;
    private final transient HinduMonth month;
    private final transient HinduDay dayOfMonth;
    private final transient long utcDays;

    HinduCalendar(HinduVariant hinduVariant, int n, HinduMonth hinduMonth, HinduDay hinduDay, long l) {
        if (hinduVariant == null) {
            throw new NullPointerException("Missing variant.");
        }
        if (hinduMonth == null) {
            throw new NullPointerException("Missing month.");
        }
        if (hinduDay == null) {
            throw new NullPointerException("Missing day of month.");
        }
        this.variant = hinduVariant;
        this.kyYear = n;
        this.month = hinduMonth;
        this.dayOfMonth = hinduDay;
        this.utcDays = l;
    }

    public static HinduCalendar nowInSystemTime(HinduVariant hinduVariant) {
        StartOfDay startOfDay = HinduCalendar.family().getDefaultStartOfDay();
        return HinduCalendar.nowInSystemTime(hinduVariant, startOfDay);
    }

    public static HinduCalendar nowInSystemTime(HinduVariant hinduVariant, StartOfDay startOfDay) {
        return SystemClock.inLocalView().now(HinduCalendar.family(), hinduVariant, startOfDay).toDate();
    }

    public static HinduCalendar ofOldSolar(int n, int n2, int n3) {
        if (n3 > 31) {
            throw new IllegalArgumentException("Day-of-month out of range: " + n3);
        }
        HinduMonth hinduMonth = HinduMonth.ofSolar(n2);
        HinduDay hinduDay = HinduDay.valueOf(n3);
        return HinduCalendar.of(HinduVariant.VAR_OLD_SOLAR, HinduEra.KALI_YUGA, n, hinduMonth, hinduDay);
    }

    public static HinduCalendar ofOldLunar(int n, HinduMonth hinduMonth, int n2) {
        if (n2 > 30) {
            throw new IllegalArgumentException("Day-of-month out of range: " + n2);
        }
        HinduDay hinduDay = HinduDay.valueOf(n2);
        return HinduCalendar.of(HinduVariant.VAR_OLD_LUNAR, HinduEra.KALI_YUGA, n, hinduMonth, hinduDay);
    }

    public static HinduCalendar of(HinduVariant hinduVariant, HinduEra hinduEra, int n, HinduMonth hinduMonth, HinduDay hinduDay) {
        HinduCS hinduCS = hinduVariant.with(hinduEra).getCalendarSystem();
        int n2 = HinduEra.KALI_YUGA.yearOfEra(hinduEra, n);
        if (!hinduVariant.isUsingElapsedYears()) {
            --n2;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Kali yuga year must not be smaller than 0: " + n2);
        }
        if (!hinduVariant.isOld() && n2 < 1200) {
            throw new IllegalArgumentException("Year out of range in modern Hindu calendar: " + n2);
        }
        if (hinduCS.isValid(n2, hinduMonth, hinduDay)) {
            return hinduCS.create(n2, hinduMonth, hinduDay);
        }
        throw new IllegalArgumentException("Invalid values: " + hinduVariant + "[" + hinduEra + "/" + n + "/" + hinduMonth + "/" + hinduDay + "]");
    }

    public static boolean isValid(HinduVariant hinduVariant, HinduEra hinduEra, int n, HinduMonth hinduMonth, HinduDay hinduDay) {
        HinduCS hinduCS = hinduVariant.with(hinduEra).getCalendarSystem();
        int n2 = HinduEra.KALI_YUGA.yearOfEra(hinduEra, n);
        if (!hinduVariant.isUsingElapsedYears()) {
            --n2;
        }
        if (n2 < 0 || !hinduVariant.isOld() && n2 < 1200) {
            return false;
        }
        return hinduCS.isValid(n2, hinduMonth, hinduDay);
    }

    public int lengthOfMonth() {
        HinduCalendar hinduCalendar = this.withFirstDayOfMonth();
        HinduCalendar hinduCalendar2 = this.withMidOfMonth(1).withFirstDayOfMonth();
        return (int)(hinduCalendar2.utcDays - hinduCalendar.utcDays);
    }

    public int lengthOfYear() {
        return (Integer)this.getMaximum(DAY_OF_YEAR);
    }

    @Override
    public String getVariant() {
        return this.variant.getVariant();
    }

    public HinduEra getEra() {
        HinduEra hinduEra = this.variant.getDefaultEra();
        if (hinduEra.yearOfEra(HinduEra.KALI_YUGA, this.kyYear) < 0) {
            hinduEra = HinduEra.KALI_YUGA;
        }
        return hinduEra;
    }

    public int getYear() {
        int n = this.getEra().yearOfEra(HinduEra.KALI_YUGA, this.kyYear);
        if (!this.variant.isUsingElapsedYears()) {
            ++n;
        }
        return n;
    }

    public HinduMonth getMonth() {
        return this.month;
    }

    public HinduDay getDayOfMonth() {
        return this.dayOfMonth;
    }

    public Weekday getDayOfWeek() {
        return Weekday.valueOf(MathUtils.floorModulo(this.utcDays + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return (int)(this.utcDays - this.withNewYear().utcDays + 1L);
    }

    public HinduCalendar previousDay() {
        return this.getCalendarSystem().transform(this.utcDays - 1L);
    }

    public HinduCalendar previousMonth() {
        HinduCalendar hinduCalendar = this.withMidOfMonth(-1).withAdjustedDayInMonth(this.dayOfMonth);
        if (hinduCalendar.utcDays < this.variant.getCalendarSystem().getMinimumSinceUTC()) {
            throw new IllegalArgumentException("Hindu date out of range");
        }
        return hinduCalendar;
    }

    public HinduCalendar previousYear() {
        return this.withYearChangedBy(-1);
    }

    public HinduCalendar nextDay() {
        return this.getCalendarSystem().transform(this.utcDays + 1L);
    }

    public HinduCalendar nextMonth() {
        HinduCalendar hinduCalendar = this.withMidOfMonth(1).withAdjustedDayInMonth(this.dayOfMonth);
        if (hinduCalendar.utcDays > this.variant.getCalendarSystem().getMaximumSinceUTC()) {
            throw new IllegalArgumentException("Hindu date out of range");
        }
        return hinduCalendar;
    }

    public HinduCalendar nextYear() {
        return this.withYearChangedBy(1);
    }

    public GeneralTimestamp<HinduCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<HinduCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HinduCalendar) {
            HinduCalendar hinduCalendar = (HinduCalendar)object;
            return this.variant.equals(hinduCalendar.variant) && this.kyYear == hinduCalendar.kyYear && this.month.equals(hinduCalendar.month) && this.dayOfMonth.equals(hinduCalendar.dayOfMonth) && this.utcDays == hinduCalendar.utcDays;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 7 * this.variant.hashCode() + 17 * this.kyYear + 31 * this.month.hashCode() + 37 * this.dayOfMonth.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.variant);
        stringBuilder.append(",era=");
        stringBuilder.append(this.getEra());
        stringBuilder.append(",year-of-era=");
        stringBuilder.append(this.getYear());
        stringBuilder.append(",month=");
        stringBuilder.append(this.month);
        stringBuilder.append(",day-of-month=");
        stringBuilder.append(this.dayOfMonth);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public long getDaysSinceEpochUTC() {
        return this.utcDays;
    }

    public static CalendarFamily<HinduCalendar> family() {
        return ENGINE;
    }

    @Override
    protected CalendarFamily<HinduCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected HinduCalendar getContext() {
        return this;
    }

    @Override
    protected CalendarSystem<HinduCalendar> getCalendarSystem() {
        return this.variant.getCalendarSystem();
    }

    int getExpiredYearOfKaliYuga() {
        return this.kyYear;
    }

    HinduCalendar withNewYear() {
        HinduCalendar hinduCalendar;
        if (this.variant.isPurnimanta()) {
            HinduCalendar hinduCalendar2 = this.variant.toAmanta().create(this.kyYear, HinduMonth.ofLunisolar(1), HinduDay.valueOf(15)).withNewYear();
            return this.variant.getCalendarSystem().create(hinduCalendar2.getDaysSinceEpochUTC());
        }
        HinduMonth hinduMonth = this.variant.isSolar() ? HinduMonth.ofSolar(1) : HinduMonth.ofLunisolar(this.variant.getFirstMonthOfYear());
        HinduCS hinduCS = this.variant.getCalendarSystem();
        HinduCalendar hinduCalendar3 = hinduCS.create(this.kyYear, hinduMonth, HinduDay.valueOf(15));
        if (this.variant.isLunisolar() && (hinduCalendar = hinduCS.create(hinduCalendar3.utcDays - 30L)).getMonth().isLeap() && hinduCalendar.kyYear == this.kyYear) {
            hinduCalendar3 = hinduCalendar;
        }
        return hinduCalendar3.withFirstDayOfMonth();
    }

    HinduCalendar withFirstDayOfMonth() {
        HinduDay hinduDay = HinduDay.valueOf(1);
        HinduCS hinduCS = this.variant.getCalendarSystem();
        int n = this.kyYear;
        if (this.variant.isLunisolar()) {
            int n2 = 3;
            if (this.variant.isPurnimanta()) {
                hinduDay = HinduDay.valueOf(16);
                if (this.isChaitra() && this.dayOfMonth.getValue() < 16) {
                    HinduCalendar hinduCalendar = this.withNewYear();
                    if (this.month.equals(hinduCalendar.month)) {
                        --n;
                    }
                }
            }
            while (hinduCS.isExpunged(n, this.month, hinduDay)) {
                if (n2 == 0) {
                    throw new IllegalArgumentException("Cannot determine first day of month: " + this);
                }
                hinduDay = hinduDay.isLeap() ? HinduDay.valueOf(hinduDay.getValue() + 1) : hinduDay.withLeap();
                --n2;
            }
        }
        return hinduCS.create(n, this.month, hinduDay);
    }

    private HinduCalendar withMidOfMonth(int n) {
        int n2 = this.dayOfMonth.getValue();
        if (this.variant.isPurnimanta()) {
            n2 = n2 >= 16 ? (n2 -= 15) : (n2 += 15);
        }
        long l = this.utcDays + Math.round((double)n * (this.variant.isSolar() ? 30.4 : 29.5)) + 15L - (long)n2;
        return this.variant.getCalendarSystem().create(l);
    }

    private HinduCalendar withYearChangedBy(int n) {
        return (HinduCalendar)this.with((ChronoElement<Integer>)YEAR_OF_ERA, this.getYear() + n);
    }

    private HinduCalendar withAdjustedDayInMonth(HinduDay hinduDay) {
        int n;
        boolean bl;
        HinduDay hinduDay2 = hinduDay;
        HinduCS hinduCS = this.variant.getCalendarSystem();
        int n2 = 5;
        boolean bl2 = this.variant.isPurnimanta();
        boolean bl3 = bl = bl2 && this.isChaitra() && this.withNewYear().month.equals(this.month);
        while (hinduCS.isExpunged(n = this.criticalYear(bl, hinduDay2), this.month, hinduDay2)) {
            if (hinduDay2.getValue() == (bl2 ? 16 : 1) && !hinduDay2.isLeap()) {
                return this.withFirstDayOfMonth();
            }
            if (n2 == 0) {
                if (hinduCS.isExpunged(n, this.month)) {
                    throw new IllegalArgumentException("Kshaia (lost) month is never valid: kali-yuga-year=" + n + ", month=" + this.month);
                }
                throw new IllegalArgumentException("No valid day found for: " + this + " => (desired day=" + hinduDay + ")");
            }
            if (hinduDay2.isLeap()) {
                hinduDay2 = HinduDay.valueOf(hinduDay2.getValue());
            } else {
                int n3 = hinduDay2.getValue() - 1;
                if (bl2 && n3 == 0) {
                    n3 = 30;
                }
                hinduDay2 = HinduDay.valueOf(n3);
                if (this.variant.isLunisolar()) {
                    hinduDay2 = hinduDay2.withLeap();
                }
            }
            --n2;
        }
        return hinduCS.create(n, this.month, hinduDay2);
    }

    private int criticalYear(boolean bl, HinduDay hinduDay) {
        if (bl) {
            if (this.dayOfMonth.getValue() >= 16 && hinduDay.getValue() < 16) {
                return this.kyYear + 1;
            }
            if (this.dayOfMonth.getValue() < 16 && hinduDay.getValue() >= 16) {
                return this.kyYear - 1;
            }
        }
        return this.kyYear;
    }

    private boolean isChaitra() {
        return this.month.getValue().equals(IndianMonth.CHAITRA);
    }

    private static int parseLeadingLeapInfo(CharSequence charSequence, int n, int n2, boolean bl, String string, char c, Locale locale) {
        boolean bl2 = false;
        int n3 = n;
        int n4 = n3 + string.length();
        if (n4 < n2) {
            String string2 = string;
            String string3 = charSequence.subSequence(n3, n4).toString();
            if (bl) {
                string2 = string2.toUpperCase(locale);
                string3 = string3.toUpperCase(locale);
            }
            if (string2.equals(string3)) {
                bl2 = true;
                n3 = n4;
                if (n3 < n2 && charSequence.charAt(n3) == ' ') {
                    ++n3;
                }
            }
        }
        if (!bl2) {
            return HinduCalendar.parseLeapIndicator(charSequence, n, bl, c);
        }
        return n3;
    }

    private static int parseTrailingLeapInfo(CharSequence charSequence, int n, int n2, boolean bl, String string, char c, Locale locale) {
        boolean bl2 = false;
        int n3 = n;
        int n4 = n3 + string.length();
        if (n4 < n2 && charSequence.charAt(n3) == ' ') {
            ++n3;
            ++n4;
        }
        if (n4 < n2) {
            String string2 = string;
            String string3 = charSequence.subSequence(n3, n4).toString();
            if (bl) {
                string2 = string2.toUpperCase(locale);
                string3 = string3.toUpperCase(locale);
            }
            if (string2.equals(string3)) {
                bl2 = true;
                n3 = n4;
            }
        }
        if (!bl2) {
            return HinduCalendar.parseLeapIndicator(charSequence, n, bl, c);
        }
        return n3;
    }

    private static int parseLeapIndicator(CharSequence charSequence, int n, boolean bl, char c) {
        char c2 = charSequence.charAt(n);
        char c3 = c;
        if (bl) {
            c2 = Character.toUpperCase(c2);
            c3 = Character.toUpperCase(c3);
        }
        return c2 == c3 ? n + 1 : -1;
    }

    private static HinduVariant getVariant(ChronoDisplay chronoDisplay, AttributeQuery attributeQuery) {
        if (chronoDisplay instanceof VariantSource) {
            return HinduVariant.from(((VariantSource)((Object)chronoDisplay)).getVariant());
        }
        if (attributeQuery.contains(Attributes.CALENDAR_VARIANT)) {
            return HinduVariant.from(attributeQuery.get(Attributes.CALENDAR_VARIANT));
        }
        String string = chronoDisplay == null ? "<attributes>" : chronoDisplay.toString();
        throw new IllegalArgumentException("Cannot infer Hindu calendar variant: " + string);
    }

    private Object writeReplace() {
        return new SPX(this, 20);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        VariantMap variantMap = new VariantMap();
        for (HinduRule hinduRule : HinduRule.values()) {
            variantMap.accept(hinduRule.variant());
        }
        variantMap.accept(HinduVariant.VAR_OLD_SOLAR);
        variantMap.accept(HinduVariant.VAR_OLD_LUNAR);
        CALSYS = variantMap;
        Chronology.Builder builder = ((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)CalendarFamily.Builder.setUp(HinduCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, (ElementRule)new RelatedGregorianYearRule(CALSYS, DAY_OF_YEAR))).appendElement((ChronoElement)ERA, (ElementRule)new EraRule())).appendElement((ChronoElement)YEAR_OF_ERA, (ElementRule)new IntegerRule(0))).appendElement((ChronoElement)MONTH_OF_YEAR, (ElementRule)MonthElement.SINGLETON)).appendElement((ChronoElement)DAY_OF_MONTH, (ElementRule)DayOfMonthElement.SINGLETON)).appendElement((ChronoElement)DAY_OF_YEAR, (ElementRule)new IntegerRule(1))).appendElement((ChronoElement)DAY_OF_WEEK, new WeekdayRule<HinduCalendar>(IndianCalendar.getDefaultWeekmodel(), HinduCalendar::getCalendarSystem));
        ENGINE = ((CalendarFamily.Builder)builder).build();
    }

    private static class Merger
    implements ChronoMerger<HinduCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
            return IndianCalendar.axis().getFormatPattern(formatStyle, locale);
        }

        @Override
        public HinduCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            String string = attributeQuery.get(Attributes.CALENDAR_VARIANT, "");
            if (string.isEmpty()) {
                return null;
            }
            HinduVariant hinduVariant = HinduVariant.from(string);
            GeoLocation geoLocation = hinduVariant.getLocation();
            TZID tZID = attributeQuery.contains(Attributes.TIMEZONE_ID) ? attributeQuery.get(Attributes.TIMEZONE_ID) : ZonalOffset.atLongitude(BigDecimal.valueOf(hinduVariant.getLocation().getLongitude()));
            StartOfDay startOfDay = StartOfDay.definedBy(SolarTime.ofLocation(geoLocation.getLatitude(), geoLocation.getLongitude(), geoLocation.getAltitude(), StdSolarCalculator.CC).sunrise());
            StartOfDay startOfDay2 = attributeQuery.get(Attributes.START_OF_DAY, startOfDay);
            return (HinduCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, string, tZID, startOfDay2).toDate();
        }

        @Override
        public HinduCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n;
            HinduVariant hinduVariant;
            String string = attributeQuery.get(Attributes.CALENDAR_VARIANT, "");
            if (string.isEmpty()) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Hindu calendar variant.");
                return null;
            }
            try {
                hinduVariant = HinduVariant.from(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Hindu calendar variant.");
                return null;
            }
            HinduCS hinduCS = hinduVariant.getCalendarSystem();
            HinduEra hinduEra = hinduVariant.getDefaultEra();
            if (chronoEntity.contains(ERA)) {
                hinduEra = chronoEntity.get(ERA);
            }
            if ((n = chronoEntity.getInt(YEAR_OF_ERA)) == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Hindu year.");
                return null;
            }
            int n2 = HinduEra.KALI_YUGA.yearOfEra(hinduEra, n);
            if (!hinduVariant.isUsingElapsedYears()) {
                --n2;
            }
            if (chronoEntity.contains(MONTH_OF_YEAR) && chronoEntity.contains(DAY_OF_MONTH)) {
                HinduDay hinduDay;
                HinduMonth hinduMonth = chronoEntity.get(MONTH_OF_YEAR);
                if (hinduCS.isValid(n2, hinduMonth, hinduDay = chronoEntity.get(DAY_OF_MONTH))) {
                    return hinduCS.create(n2, hinduMonth, hinduDay);
                }
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Hindu date.");
            } else {
                int n3 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n3 != Integer.MIN_VALUE) {
                    if (n3 >= 1) {
                        HinduCalendar hinduCalendar = hinduCS.create(n2, HinduMonth.of(IndianMonth.AGRAHAYANA), HinduDay.valueOf(1));
                        long l = hinduCS.create(hinduCalendar.utcDays).withNewYear().utcDays + (long)n3 - 1L;
                        HinduCalendar hinduCalendar2 = hinduCS.create(l);
                        if (hinduCS.getMinimumSinceUTC() <= l && hinduCS.getMaximumSinceUTC() >= l && (bl || hinduCalendar2.kyYear == n2)) {
                            return hinduCalendar2;
                        }
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Hindu date.");
                }
            }
            return null;
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.definedBy(SolarTime.ofLocation(HinduVariant.UJJAIN.getLatitude(), HinduVariant.UJJAIN.getLongitude()).sunrise());
        }

        @Override
        public int getDefaultPivotYear() {
            return 100;
        }
    }

    private static class DayOfMonthElement
    extends DisplayElement<HinduDay>
    implements AdjustableTextElement<HinduDay>,
    ElementRule<HinduCalendar, HinduDay> {
        static final DayOfMonthElement SINGLETON = new DayOfMonthElement();
        private static final long serialVersionUID = 992340906349614332L;

        private DayOfMonthElement() {
            super("DAY_OF_MONTH");
        }

        @Override
        public HinduDay getValue(HinduCalendar hinduCalendar) {
            return hinduCalendar.dayOfMonth;
        }

        @Override
        public HinduDay getMinimum(HinduCalendar hinduCalendar) {
            return hinduCalendar.withFirstDayOfMonth().dayOfMonth;
        }

        @Override
        public HinduDay getMaximum(HinduCalendar hinduCalendar) {
            HinduCalendar hinduCalendar2 = hinduCalendar.withMidOfMonth(1).withFirstDayOfMonth();
            HinduCS hinduCS = hinduCalendar.variant.getCalendarSystem();
            return hinduCS.create(hinduCalendar2.utcDays - 1L).dayOfMonth;
        }

        @Override
        public boolean isValid(HinduCalendar hinduCalendar, HinduDay hinduDay) {
            if (hinduDay == null || hinduDay.isLeap() && hinduCalendar.variant.isSolar()) {
                return false;
            }
            boolean bl = hinduCalendar.variant.isPurnimanta() && hinduCalendar.isChaitra() && hinduCalendar.withNewYear().month.equals(hinduCalendar.month);
            int n = hinduCalendar.criticalYear(bl, hinduDay);
            return hinduCalendar.variant.getCalendarSystem().isValid(n, hinduCalendar.month, hinduDay);
        }

        @Override
        public HinduCalendar withValue(HinduCalendar hinduCalendar, HinduDay hinduDay, boolean bl) {
            if (!(hinduDay == null || hinduDay.isLeap() && hinduCalendar.variant.isSolar())) {
                boolean bl2 = hinduCalendar.variant.isPurnimanta() && hinduCalendar.isChaitra() && hinduCalendar.withNewYear().month.equals(hinduCalendar.month);
                int n = hinduCalendar.criticalYear(bl2, hinduDay);
                HinduCS hinduCS = hinduCalendar.variant.getCalendarSystem();
                if (hinduCS.isValid(n, hinduCalendar.month, hinduDay)) {
                    return hinduCS.create(n, hinduCalendar.month, hinduDay);
                }
            }
            throw new IllegalArgumentException("Invalid day of month: " + hinduDay);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HinduCalendar hinduCalendar) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HinduCalendar hinduCalendar) {
            return null;
        }

        @Override
        public Class<HinduDay> getType() {
            return HinduDay.class;
        }

        @Override
        public char getSymbol() {
            return 'd';
        }

        @Override
        public HinduDay getDefaultMinimum() {
            return HinduDay.valueOf(1);
        }

        @Override
        public HinduDay getDefaultMaximum() {
            return HinduDay.valueOf(32);
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        protected Object readResolve() throws ObjectStreamException {
            return SINGLETON;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            Object object;
            HinduVariant hinduVariant = HinduCalendar.getVariant(chronoDisplay, attributeQuery);
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            int n = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
            HinduDay hinduDay = chronoDisplay.get(DAY_OF_MONTH);
            boolean bl = false;
            char c = '*';
            String string = "";
            if (hinduDay.isLeap()) {
                object = CalendarText.getInstance("generic", locale).getTextForms();
                bl = attributeQuery.get(HinduPrimitive.ADHIKA_IS_TRAILING, "R".equals(object.get("leap-alignment")));
                c = attributeQuery.get(HinduPrimitive.ADHIKA_INDICATOR, Character.valueOf(((String)object.get("leap-indicator")).charAt(0))).charValue();
                string = CalendarText.getInstance("hindu", locale).getTextForms().get("adhika");
            }
            if (hinduDay.isLeap() && !bl) {
                if (n >= 2) {
                    appendable.append(string);
                    appendable.append(' ');
                } else {
                    appendable.append(c);
                }
            }
            object = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            char c2 = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(((NumberSystem)((Object)object)).getDigits().charAt(0))).charValue();
            String string2 = DualFormatElement.toNumeral((NumberSystem)((Object)object), c2, hinduDay.getValue());
            if (hinduVariant.isSolar() && ((NumberSystem)((Object)object)).isDecimal()) {
                for (int i = n - string2.length(); i > 0; --i) {
                    appendable.append(c2);
                }
            }
            appendable.append(string2);
            if (bl) {
                if (n >= 2) {
                    appendable.append(' ');
                    appendable.append(string);
                } else {
                    appendable.append(c);
                }
            }
        }

        @Override
        public HinduDay parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            int n;
            int n2;
            int n3;
            Object object;
            int n4;
            int n5 = parsePosition.getIndex();
            int n6 = n5;
            if (n6 >= (n4 = charSequence.length())) {
                parsePosition.setErrorIndex(n5);
                return null;
            }
            HinduVariant hinduVariant = HinduCalendar.getVariant(null, attributeQuery);
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            boolean bl = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
            boolean bl2 = false;
            char c = '*';
            String string = "";
            boolean bl3 = false;
            boolean bl4 = hinduVariant.isSolar();
            if (!bl4) {
                object = CalendarText.getInstance("generic", locale).getTextForms();
                bl2 = attributeQuery.get(HinduPrimitive.ADHIKA_IS_TRAILING, "R".equals(object.get("leap-alignment")));
                c = attributeQuery.get(HinduPrimitive.ADHIKA_INDICATOR, Character.valueOf(((String)object.get("leap-indicator")).charAt(0))).charValue();
                string = CalendarText.getInstance("hindu", locale).getTextForms().get("adhika");
                if (!bl2 && (n3 = HinduCalendar.parseLeadingLeapInfo(charSequence, n6, n4, bl, string, c, locale)) != -1) {
                    n6 = n3;
                    bl3 = true;
                }
            }
            if (n6 >= n4) {
                parsePosition.setErrorIndex(n5);
                return null;
            }
            object = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            n3 = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(((NumberSystem)((Object)object)).getDigits().charAt(0))).charValue();
            int n7 = 0;
            if (bl4 && ((NumberSystem)((Object)object)).isDecimal()) {
                while (n6 < n4 && charSequence.charAt(n6) == n3) {
                    ++n6;
                }
            }
            int n8 = n2 = bl4 ? 32 : 30;
            while (n2 >= 1 && n7 == 0) {
                String string2 = DualFormatElement.toNumeral((NumberSystem)((Object)object), (char)n3, n2);
                int n9 = string2.length();
                int n10 = 0;
                while (n4 <= n6 + n10 || charSequence.charAt(n6 + n10) == string2.charAt(n10)) {
                    if (n10 + 1 == n9) {
                        n7 = n2;
                        n6 += n9;
                        break;
                    }
                    ++n10;
                }
                --n2;
            }
            if (n7 == 0) {
                parsePosition.setErrorIndex(n5);
                return null;
            }
            HinduDay hinduDay = HinduDay.valueOf(n7);
            if (bl2 && (n = HinduCalendar.parseTrailingLeapInfo(charSequence, n6, n4, bl, string, c, locale)) != -1) {
                n6 = n;
                bl3 = true;
            }
            if (bl3) {
                hinduDay = hinduDay.withLeap();
            }
            parsePosition.setIndex(n6);
            return hinduDay;
        }
    }

    private static class MonthElement
    extends DisplayElement<HinduMonth>
    implements AdjustableTextElement<HinduMonth>,
    ElementRule<HinduCalendar, HinduMonth> {
        static final MonthElement SINGLETON = new MonthElement();
        private static final long serialVersionUID = 7462717336727909653L;

        private MonthElement() {
            super("MONTH_OF_YEAR");
        }

        @Override
        public HinduMonth getValue(HinduCalendar hinduCalendar) {
            return hinduCalendar.month;
        }

        @Override
        public HinduMonth getMinimum(HinduCalendar hinduCalendar) {
            return hinduCalendar.withNewYear().month;
        }

        @Override
        public HinduMonth getMaximum(HinduCalendar hinduCalendar) {
            if (hinduCalendar.variant.isSolar()) {
                return HinduMonth.ofSolar(12);
            }
            HinduCalendar hinduCalendar2 = hinduCalendar.variant.getCalendarSystem().create(hinduCalendar.withNewYear().utcDays - 20L);
            return hinduCalendar2.month;
        }

        @Override
        public boolean isValid(HinduCalendar hinduCalendar, HinduMonth hinduMonth) {
            if (hinduMonth == null || hinduMonth.isLeap() && hinduCalendar.variant.isSolar()) {
                return false;
            }
            if (hinduMonth.isLeap()) {
                HinduCalendar hinduCalendar2 = hinduCalendar.withNewYear();
                int n = 0;
                while (!hinduCalendar2.month.equals(hinduMonth)) {
                    if (!hinduCalendar2.month.isLeap() && ++n >= 12) {
                        return false;
                    }
                    hinduCalendar2 = hinduCalendar2.nextMonth();
                }
            }
            if (hinduCalendar.variant.isLunisolar() && !hinduCalendar.variant.isOld()) {
                return !hinduCalendar.variant.getCalendarSystem().isExpunged(hinduCalendar.kyYear, hinduMonth);
            }
            return true;
        }

        @Override
        public HinduCalendar withValue(HinduCalendar hinduCalendar, HinduMonth hinduMonth, boolean bl) {
            if (hinduMonth == null || hinduMonth.isLeap() && hinduCalendar.variant.isSolar()) {
                throw new IllegalArgumentException("Invalid month: " + hinduMonth);
            }
            HinduCalendar hinduCalendar2 = hinduCalendar.withNewYear();
            int n = 0;
            while (!hinduCalendar2.month.equals(hinduMonth)) {
                if (!hinduCalendar2.month.isLeap() && ++n >= 12) {
                    throw new IllegalArgumentException("Invalid month: " + hinduMonth);
                }
                hinduCalendar2 = hinduCalendar2.nextMonth();
            }
            return hinduCalendar2.withAdjustedDayInMonth(hinduCalendar.dayOfMonth);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HinduCalendar hinduCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HinduCalendar hinduCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public Class<HinduMonth> getType() {
            return HinduMonth.class;
        }

        @Override
        public char getSymbol() {
            return 'M';
        }

        @Override
        public HinduMonth getDefaultMinimum() {
            return HinduMonth.ofLunisolar(1);
        }

        @Override
        public HinduMonth getDefaultMaximum() {
            return HinduMonth.ofLunisolar(12);
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        protected Object readResolve() throws ObjectStreamException {
            return SINGLETON;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            Object object;
            HinduVariant hinduVariant = HinduCalendar.getVariant(chronoDisplay, attributeQuery);
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            int n = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
            HinduMonth hinduMonth = chronoDisplay.get(MONTH_OF_YEAR);
            boolean bl = false;
            char c = '*';
            String string = "";
            if (hinduMonth.isLeap()) {
                object = CalendarText.getInstance("generic", locale).getTextForms();
                bl = attributeQuery.get(HinduPrimitive.ADHIKA_IS_TRAILING, "R".equals(object.get("leap-alignment")));
                c = attributeQuery.get(HinduPrimitive.ADHIKA_INDICATOR, Character.valueOf(((String)object.get("leap-indicator")).charAt(0))).charValue();
                string = CalendarText.getInstance("hindu", locale).getTextForms().get("adhika");
            }
            if (n == 0) {
                if (hinduVariant.isSolar() && attributeQuery.get(HinduMonth.RASI_NAMES, hinduVariant.prefersRasiNames()).booleanValue()) {
                    appendable.append(hinduMonth.getRasi(locale));
                } else {
                    object = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                    OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
                    if (hinduMonth.isLeap() && !bl) {
                        if (object == TextWidth.WIDE) {
                            appendable.append(string);
                            appendable.append(' ');
                        } else {
                            appendable.append(c);
                        }
                        hinduMonth = HinduMonth.of(hinduMonth.getValue());
                    }
                    appendable.append(hinduMonth.getDisplayName(locale, (TextWidth)((Object)object), outputContext));
                    if (bl) {
                        if (object == TextWidth.WIDE) {
                            appendable.append(' ');
                            appendable.append(string);
                        } else {
                            appendable.append(c);
                        }
                    }
                }
            } else {
                if (hinduMonth.isLeap() && !bl) {
                    appendable.append(c);
                }
                int n2 = hinduVariant.isSolar() ? hinduMonth.getRasi() : hinduMonth.getValue().getValue();
                NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                char c2 = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(numberSystem.getDigits().charAt(0))).charValue();
                String string2 = DualFormatElement.toNumeral(numberSystem, c2, n2);
                if (hinduVariant.isSolar() && numberSystem.isDecimal()) {
                    for (int i = n - string2.length(); i > 0; --i) {
                        appendable.append(c2);
                    }
                }
                appendable.append(string2);
                if (bl) {
                    appendable.append(c);
                }
            }
        }

        @Override
        public HinduMonth parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            int n;
            Enum enum_;
            Object object;
            int n2;
            int n3 = parsePosition.getIndex();
            int n4 = n3;
            if (n4 >= (n2 = charSequence.length())) {
                parsePosition.setErrorIndex(n3);
                return null;
            }
            HinduVariant hinduVariant = HinduCalendar.getVariant(null, attributeQuery);
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            int n5 = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
            boolean bl = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
            boolean bl2 = false;
            char c = '*';
            String string = "";
            boolean bl3 = false;
            boolean bl4 = hinduVariant.isSolar();
            if (!bl4) {
                int n6;
                object = CalendarText.getInstance("generic", locale).getTextForms();
                bl2 = attributeQuery.get(HinduPrimitive.ADHIKA_IS_TRAILING, "R".equals(object.get("leap-alignment")));
                c = attributeQuery.get(HinduPrimitive.ADHIKA_INDICATOR, Character.valueOf(object.get("leap-indicator").charAt(0))).charValue();
                string = CalendarText.getInstance("hindu", locale).getTextForms().get("adhika");
                if (!bl2 && (n6 = HinduCalendar.parseLeadingLeapInfo(charSequence, n4, n2, bl, string, c, locale)) != -1) {
                    n4 = n6;
                    bl3 = true;
                }
            }
            if (n4 >= n2) {
                parsePosition.setErrorIndex(n3);
                return null;
            }
            if (n5 == 0) {
                parsePosition.setIndex(n4);
                enum_ = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
                CalendarText calendarText = CalendarText.getInstance("indian", locale);
                IndianMonth indianMonth = calendarText.getStdMonths((TextWidth)enum_, outputContext).parse(charSequence, parsePosition, IndianMonth.class, attributeQuery);
                if (indianMonth == null && bl4) {
                    parsePosition.setIndex(n4);
                    parsePosition.setErrorIndex(-1);
                    TextAccessor textAccessor = CalendarText.getInstance("hindu", locale).getTextForms("R", IndianMonth.class, new String[0]);
                    int n7 = textAccessor.parse(charSequence, parsePosition, IndianMonth.class, attributeQuery).getValue();
                    indianMonth = HinduMonth.ofSolar(n7).getValue();
                }
                if (indianMonth == null) {
                    parsePosition.setErrorIndex(n3);
                    return null;
                }
                object = HinduMonth.of(indianMonth);
                n4 = parsePosition.getIndex();
            } else {
                enum_ = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                char c2 = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(((NumberSystem)enum_).getDigits().charAt(0))).charValue();
                int n8 = 0;
                if (bl4 && ((NumberSystem)enum_).isDecimal()) {
                    while (n4 < n2 && charSequence.charAt(n4) == c2) {
                        ++n4;
                    }
                }
                block1: for (int i = 12; i >= 1 && n8 == 0; --i) {
                    String string2 = DualFormatElement.toNumeral((NumberSystem)enum_, c2, i);
                    int n9 = string2.length();
                    int n10 = 0;
                    while (n2 <= n4 + n10 || charSequence.charAt(n4 + n10) == string2.charAt(n10)) {
                        if (n10 + 1 == n9) {
                            n8 = i;
                            n4 += n9;
                            continue block1;
                        }
                        ++n10;
                    }
                }
                if (n8 == 0) {
                    parsePosition.setErrorIndex(n3);
                    return null;
                }
                Object object2 = object = bl4 ? HinduMonth.ofSolar(n8) : HinduMonth.ofLunisolar(n8);
            }
            if (bl2 && (n = HinduCalendar.parseTrailingLeapInfo(charSequence, n4, n2, bl, string, c, locale)) != -1) {
                n4 = n;
                bl3 = true;
            }
            if (bl3) {
                object = ((HinduMonth)object).withLeap();
            }
            parsePosition.setIndex(n4);
            return object;
        }
    }

    private static class IntegerRule
    implements IntElementRule<HinduCalendar> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        @Override
        public int getInt(HinduCalendar hinduCalendar) {
            switch (this.index) {
                case 0: {
                    return hinduCalendar.getYear();
                }
                case 1: {
                    return hinduCalendar.getDayOfYear();
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(HinduCalendar hinduCalendar, int n) {
            int n2 = this.getMin(hinduCalendar);
            int n3 = this.getMax(hinduCalendar);
            return n2 <= n && n3 >= n;
        }

        @Override
        public HinduCalendar withValue(HinduCalendar hinduCalendar, int n, boolean bl) {
            if (!this.isValid(hinduCalendar, n)) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            switch (this.index) {
                case 0: {
                    HinduMonth hinduMonth;
                    HinduCS hinduCS;
                    boolean bl2;
                    int n2 = HinduEra.KALI_YUGA.yearOfEra(hinduCalendar.getEra(), n);
                    if (!hinduCalendar.variant.isUsingElapsedYears()) {
                        --n2;
                    }
                    if (n2 == hinduCalendar.kyYear) {
                        return hinduCalendar;
                    }
                    int n3 = 15;
                    if (hinduCalendar.variant.isPurnimanta()) {
                        int n4 = n3 = hinduCalendar.dayOfMonth.getValue() >= 16 ? 29 : 2;
                    }
                    if (bl2 = (hinduCS = hinduCalendar.variant.getCalendarSystem()).isExpunged(n2, hinduMonth = hinduCalendar.month)) {
                        long l;
                        HinduMonth hinduMonth2;
                        hinduMonth = HinduMonth.of(hinduCalendar.month.getValue().roll(n2 > hinduCalendar.kyYear ? -1 : 1));
                        if (n2 < hinduCalendar.kyYear && (hinduMonth2 = hinduCS.create(l = hinduCS.create(n2, hinduMonth, HinduDay.valueOf(n3)).getDaysSinceEpochUTC() - 30L).month).equals(hinduMonth.withLeap())) {
                            hinduMonth = hinduMonth2;
                        }
                    }
                    HinduCalendar hinduCalendar2 = hinduCS.create(n2, hinduMonth, HinduDay.valueOf(n3));
                    if (!bl2 && hinduMonth.isLeap() && (hinduCalendar2 = hinduCS.transform(hinduCalendar2.utcDays)).month.getValue().getValue() > hinduMonth.getValue().getValue()) {
                        hinduCalendar2 = hinduCS.create(hinduCalendar2.utcDays - 30L);
                    }
                    return hinduCalendar2.withAdjustedDayInMonth(hinduCalendar.dayOfMonth);
                }
                case 1: {
                    int n5 = n - this.getInt(hinduCalendar);
                    return (HinduCalendar)hinduCalendar.plus(CalendarDays.of(n5));
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getValue(HinduCalendar hinduCalendar) {
            return this.getInt(hinduCalendar);
        }

        @Override
        public Integer getMinimum(HinduCalendar hinduCalendar) {
            return this.getMin(hinduCalendar);
        }

        @Override
        public Integer getMaximum(HinduCalendar hinduCalendar) {
            return this.getMax(hinduCalendar);
        }

        @Override
        public boolean isValid(HinduCalendar hinduCalendar, Integer n) {
            return n != null && this.isValid(hinduCalendar, (int)n);
        }

        @Override
        public HinduCalendar withValue(HinduCalendar hinduCalendar, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing new value.");
            }
            return this.withValue(hinduCalendar, (int)n, bl);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HinduCalendar hinduCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HinduCalendar hinduCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        private int getMin(HinduCalendar hinduCalendar) {
            switch (this.index) {
                case 0: {
                    int n = hinduCalendar.variant.isOld() ? 0 : 1200;
                    return hinduCalendar.variant.isUsingElapsedYears() ? n : n + 1;
                }
                case 1: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        private int getMax(HinduCalendar hinduCalendar) {
            switch (this.index) {
                case 0: {
                    int n = hinduCalendar.variant.isUsingElapsedYears() ? 5999 : 6000;
                    return hinduCalendar.getEra().yearOfEra(HinduEra.KALI_YUGA, n);
                }
                case 1: {
                    HinduCalendar hinduCalendar2 = hinduCalendar.withNewYear();
                    HinduCalendar hinduCalendar3 = hinduCalendar.variant.getCalendarSystem().create(hinduCalendar2.utcDays + 400L).withNewYear();
                    return (int)(hinduCalendar3.utcDays - hinduCalendar2.utcDays);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }
    }

    private static class EraRule
    implements ElementRule<HinduCalendar, HinduEra> {
        private EraRule() {
        }

        @Override
        public HinduEra getValue(HinduCalendar hinduCalendar) {
            return hinduCalendar.getEra();
        }

        @Override
        public HinduEra getMinimum(HinduCalendar hinduCalendar) {
            return HinduEra.KALI_YUGA;
        }

        @Override
        public HinduEra getMaximum(HinduCalendar hinduCalendar) {
            if (!hinduCalendar.variant.isOld()) {
                HinduEra[] hinduEraArray = HinduEra.values();
                for (int i = hinduEraArray.length - 1; i >= 1; --i) {
                    HinduEra hinduEra = hinduEraArray[i];
                    if (hinduEra.yearOfEra(HinduEra.KALI_YUGA, hinduCalendar.kyYear) < 0) continue;
                    return hinduEra;
                }
            }
            return HinduEra.KALI_YUGA;
        }

        @Override
        public boolean isValid(HinduCalendar hinduCalendar, HinduEra hinduEra) {
            return hinduCalendar.variant.isOld() ? hinduEra == HinduEra.KALI_YUGA : hinduEra != null;
        }

        @Override
        public HinduCalendar withValue(HinduCalendar hinduCalendar, HinduEra hinduEra, boolean bl) {
            if (this.isValid(hinduCalendar, hinduEra)) {
                HinduVariant hinduVariant = hinduCalendar.variant.with(hinduEra);
                if (hinduVariant == hinduCalendar.variant) {
                    return hinduCalendar;
                }
                return new HinduCalendar(hinduVariant, hinduCalendar.kyYear, hinduCalendar.month, hinduCalendar.dayOfMonth, hinduCalendar.utcDays);
            }
            throw new IllegalArgumentException("Invalid Hindu era: " + hinduEra);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HinduCalendar hinduCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HinduCalendar hinduCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class VariantMap
    extends ConcurrentHashMap<String, HinduCS> {
        private VariantMap() {
        }

        @Override
        public HinduCS get(Object object) {
            String string;
            HinduCS hinduCS;
            HinduCS hinduCS2 = (HinduCS)super.get(object);
            if (hinduCS2 == null && (hinduCS = this.putIfAbsent(string = object.toString(), hinduCS2 = HinduVariant.from(string).getCalendarSystem())) != null) {
                hinduCS2 = hinduCS;
            }
            return hinduCS2;
        }

        void accept(HinduVariant hinduVariant) {
            this.put(hinduVariant.getVariant(), hinduVariant.getCalendarSystem());
        }
    }
}

