/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Locale;
import java.util.Optional;
import net.time4j.PlainDate;
import net.time4j.base.ResourceLoader;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarProvider;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.Converter;
import net.time4j.format.internal.FormatUtils;
import net.time4j.history.ChronoHistory;

final class CalendarConverter<T extends ChronoEntity<T>>
implements Converter<CalendarDate, T> {
    private final Chronology<T> chronology;
    private final String calendarVariant;

    private CalendarConverter(Chronology<T> chronology, String string) {
        this.chronology = chronology;
        this.calendarVariant = string;
    }

    static Chronology<CalendarDate> getChronology(Locale locale) {
        String string = locale.getUnicodeLocaleType("ca");
        if (string == null) {
            switch (FormatUtils.getRegion(locale)) {
                case "AF": 
                case "IR": {
                    string = "persian";
                    break;
                }
                case "SA": {
                    string = "islamic-umalqura";
                    break;
                }
                case "TH": {
                    string = "buddhist";
                    break;
                }
                default: {
                    return CalendarConverter.adapt(PlainDate.axis(), "");
                }
            }
        } else if (string.equals("ethiopic-amete-alem")) {
            string = "ethioaa";
        } else if (string.equals("islamicc")) {
            string = "islamic-civil";
        } else if (string.equals("islamic")) {
            string = "islamic-icu4j";
        }
        for (CalendarProvider calendarProvider : ResourceLoader.getInstance().services(CalendarProvider.class)) {
            Optional<Chronology<? extends CalendarDate>> optional = calendarProvider.findChronology(string);
            if (!optional.isPresent()) continue;
            String string2 = "";
            if (string.equals("historic")) {
                string2 = ChronoHistory.of(locale).getVariant();
            } else if (string.indexOf(45) > 0) {
                string2 = string;
            }
            return CalendarConverter.adapt(optional.get(), string2);
        }
        throw new IllegalArgumentException("Could not find any calendar for: " + string);
    }

    @Override
    public T translate(CalendarDate calendarDate) {
        CalendarSystem<T> calendarSystem = this.chronology instanceof CalendarFamily ? this.chronology.getCalendarSystem(this.calendarVariant) : this.chronology.getCalendarSystem();
        return (T)((ChronoEntity)calendarSystem.transform(calendarDate.getDaysSinceEpochUTC()));
    }

    @Override
    public Class<CalendarDate> getSourceType() {
        return CalendarDate.class;
    }

    @Override
    public CalendarDate from(T t) {
        return (CalendarDate)t;
    }

    private static <T extends ChronoEntity<T>> Chronology<CalendarDate> adapt(Chronology<?> chronology, String string) {
        Chronology<?> chronology2 = chronology;
        CalendarConverter calendarConverter = new CalendarConverter(chronology2, string);
        return new BridgeChronology(calendarConverter, chronology2);
    }
}

