/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.time4j.tz.TZID;

class ZoneLabels {
    private final Node root;

    ZoneLabels(Node node) {
        this.root = node;
    }

    public String toString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.collect(this.root, new StringBuilder(), arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("count=");
        stringBuilder.append(arrayList.size());
        stringBuilder.append(",labels={");
        for (String string : arrayList) {
            stringBuilder.append(string);
            stringBuilder.append("=>");
            stringBuilder.append(this.find(string));
            stringBuilder.append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1).append('}');
        return stringBuilder.toString();
    }

    static Node insert(Node node, String string, TZID tZID) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Empty key cannot be inserted.");
        }
        if (tZID == null) {
            throw new NullPointerException("Missing timezone id.");
        }
        return ZoneLabels.insert(node, string, tZID, 0);
    }

    String longestPrefixOf(CharSequence charSequence, int n) {
        int n2 = n;
        Node node = this.root;
        int n3 = n;
        int n4 = charSequence.length();
        while (node != null && n3 < n4) {
            char c = charSequence.charAt(n3);
            if (c < node.c) {
                node = node.left;
                continue;
            }
            if (c > node.c) {
                node = node.right;
                continue;
            }
            ++n3;
            if (node.zoneIDs != null) {
                n2 = n3;
            }
            node = node.mid;
        }
        return n >= n2 ? "" : charSequence.subSequence(n, n2).toString();
    }

    List<TZID> find(String string) {
        if (string.isEmpty()) {
            return Collections.emptyList();
        }
        Node node = ZoneLabels.find(this.root, string, 0);
        if (node == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(node.zoneIDs);
    }

    private static Node find(Node node, String string, int n) {
        if (node == null) {
            return null;
        }
        char c = string.charAt(n);
        if (c < node.c) {
            return ZoneLabels.find(node.left, string, n);
        }
        if (c > node.c) {
            return ZoneLabels.find(node.right, string, n);
        }
        if (n < string.length() - 1) {
            return ZoneLabels.find(node.mid, string, n + 1);
        }
        return node;
    }

    private static Node insert(Node node, String string, TZID tZID, int n) {
        char c = string.charAt(n);
        if (node == null) {
            node = new Node(c);
        }
        node = c < node.c ? node.withLeft(ZoneLabels.insert(node.left, string, tZID, n)) : (c > node.c ? node.withRight(ZoneLabels.insert(node.right, string, tZID, n)) : (n < string.length() - 1 ? node.withMid(ZoneLabels.insert(node.mid, string, tZID, n + 1)) : node.with(tZID)));
        return node;
    }

    private void collect(Node node, StringBuilder stringBuilder, List<String> list) {
        if (node == null) {
            return;
        }
        this.collect(node.left, stringBuilder, list);
        if (node.zoneIDs != null) {
            list.add(stringBuilder.toString() + node.c);
        }
        this.collect(node.mid, stringBuilder.append(node.c), list);
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        this.collect(node.right, stringBuilder, list);
    }

    static class Node {
        private final char c;
        private final Node left;
        private final Node mid;
        private final Node right;
        private final List<TZID> zoneIDs;

        private Node(char c) {
            this(c, null, null, null, null);
        }

        private Node(char c, Node node, Node node2, Node node3, List<TZID> list) {
            this.c = c;
            this.left = node;
            this.mid = node2;
            this.right = node3;
            this.zoneIDs = list;
        }

        private Node withLeft(Node node) {
            return new Node(this.c, node, this.mid, this.right, this.zoneIDs);
        }

        private Node withMid(Node node) {
            return new Node(this.c, this.left, node, this.right, this.zoneIDs);
        }

        private Node withRight(Node node) {
            return new Node(this.c, this.left, this.mid, node, this.zoneIDs);
        }

        private Node with(TZID tZID) {
            ArrayList<TZID> arrayList = new ArrayList<TZID>();
            if (this.zoneIDs != null) {
                arrayList.addAll(this.zoneIDs);
            }
            arrayList.add(tZID);
            return new Node(this.c, this.left, this.mid, this.right, arrayList);
        }
    }
}

