/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.time4j.CalendarUnit;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.JucheEra;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.SPX17;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.RelatedGregorianYearRule;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.calendar.service.WeekdayRule;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="juche")
public final class JucheCalendar
extends Calendrical<CalendarUnit, JucheCalendar>
implements LocalizedPatternSupport {
    @FormattableElement(format="G")
    public static final ChronoElement<JucheEra> ERA = new StdEnumDateElement<JucheEra, JucheCalendar>("ERA", JucheCalendar.class, JucheEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, JucheCalendar> YEAR_OF_ERA = new StdIntegerDateElement<JucheCalendar>("YEAR_OF_ERA", JucheCalendar.class, 1, 999998088, 'y');
    @FormattableElement(format="M", alt="L")
    public static final StdCalendarElement<Month, JucheCalendar> MONTH_OF_YEAR = new StdEnumDateElement<Month, JucheCalendar>("MONTH_OF_YEAR", JucheCalendar.class, Month.class, 'M');
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, JucheCalendar> DAY_OF_MONTH = new StdIntegerDateElement<JucheCalendar>("DAY_OF_MONTH", JucheCalendar.class, 1, 31, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, JucheCalendar> DAY_OF_YEAR = new StdIntegerDateElement<JucheCalendar>("DAY_OF_YEAR", JucheCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, JucheCalendar> DAY_OF_WEEK = new StdWeekdayElement<JucheCalendar>(JucheCalendar.class, JucheCalendar.getDefaultWeekmodel());
    private static final WeekdayInMonthElement<JucheCalendar> WIM_ELEMENT = new WeekdayInMonthElement<JucheCalendar>(JucheCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<JucheCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    private static final Map<Object, ChronoElement<?>> CHILDREN;
    private static final EraYearMonthDaySystem<JucheCalendar> CALSYS;
    private static final TimeAxis<CalendarUnit, JucheCalendar> ENGINE;
    private static final long serialVersionUID = 757676060690932159L;
    private final PlainDate iso;

    JucheCalendar(PlainDate plainDate) {
        if (plainDate.getYear() < 1912) {
            throw new IllegalArgumentException("Juche calendar not valid before gregorian year 1912.");
        }
        this.iso = plainDate;
    }

    public static JucheCalendar of(int n, Month month, int n2) {
        return JucheCalendar.of(n, month.getValue(), n2);
    }

    public static JucheCalendar of(int n, int n2, int n3) {
        int n4 = JucheCalendar.toProlepticYear(n);
        PlainDate plainDate = PlainDate.of(n4, n2, n3);
        return new JucheCalendar(plainDate);
    }

    public static JucheCalendar nowInSystemTime() {
        return (JucheCalendar)SystemClock.inLocalView().now(JucheCalendar.axis());
    }

    public JucheEra getEra() {
        return JucheEra.JUCHE;
    }

    public int getYear() {
        return this.iso.getYear() - 1911;
    }

    public Month getMonth() {
        return Month.valueOf(this.iso.getMonth());
    }

    public int getDayOfMonth() {
        return this.iso.getDayOfMonth();
    }

    public Weekday getDayOfWeek() {
        return this.iso.get(PlainDate.DAY_OF_WEEK);
    }

    public int getDayOfYear() {
        return this.iso.getInt(PlainDate.DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return this.iso.lengthOfMonth();
    }

    public int lengthOfYear() {
        return this.iso.lengthOfYear();
    }

    public boolean isLeapYear() {
        return this.iso.isLeapYear();
    }

    public static boolean isValid(int n, int n2, int n3) {
        return CALSYS.isValid(JucheEra.JUCHE, n, n2, n3);
    }

    public GeneralTimestamp<JucheCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<JucheCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JucheCalendar) {
            JucheCalendar jucheCalendar = (JucheCalendar)object;
            return this.iso.equals(jucheCalendar.iso);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.iso.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.getEra());
        stringBuilder.append('-');
        stringBuilder.append(this.getYear());
        stringBuilder.append('-');
        int n = this.getMonth().getValue();
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        stringBuilder.append('-');
        int n2 = this.getDayOfMonth();
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(new Locale("ko", "KP"));
    }

    public static TimeAxis<CalendarUnit, JucheCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<CalendarUnit, JucheCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected JucheCalendar getContext() {
        return this;
    }

    PlainDate toISO() {
        return this.iso;
    }

    private static int toProlepticYear(int n) {
        return MathUtils.safeAdd(n, 1911);
    }

    private static void registerUnits(TimeAxis.Builder<CalendarUnit, JucheCalendar> builder) {
        EnumSet<CalendarUnit> enumSet = EnumSet.range(CalendarUnit.MILLENNIA, CalendarUnit.MONTHS);
        EnumSet<CalendarUnit> enumSet2 = EnumSet.range(CalendarUnit.WEEKS, CalendarUnit.DAYS);
        for (CalendarUnit calendarUnit : CalendarUnit.values()) {
            builder.appendUnit(calendarUnit, new JucheUnitRule(calendarUnit), calendarUnit.getLength(), calendarUnit.compareTo(CalendarUnit.WEEKS) < 0 ? enumSet : enumSet2);
        }
    }

    private Object writeReplace() {
        return new SPX17(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        HashMap<ChronoElement<JucheEra>, StdCalendarElement<Object, JucheCalendar>> hashMap = new HashMap<ChronoElement<JucheEra>, StdCalendarElement<Object, JucheCalendar>>();
        hashMap.put(ERA, YEAR_OF_ERA);
        hashMap.put(YEAR_OF_ERA, MONTH_OF_YEAR);
        hashMap.put(MONTH_OF_YEAR, DAY_OF_MONTH);
        CHILDREN = Collections.unmodifiableMap(hashMap);
        CALSYS = new Transformer();
        Chronology.Builder builder = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(CalendarUnit.class, JucheCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)ERA, (ElementRule)FieldRule.of(ERA))).appendElement(YEAR_OF_ERA, FieldRule.of(YEAR_OF_ERA), CalendarUnit.YEARS).appendElement(MONTH_OF_YEAR, FieldRule.of(MONTH_OF_YEAR), CalendarUnit.MONTHS).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<JucheCalendar>(CALSYS, DAY_OF_YEAR))).appendElement(DAY_OF_MONTH, FieldRule.of(DAY_OF_MONTH), CalendarUnit.DAYS).appendElement(DAY_OF_YEAR, FieldRule.of(DAY_OF_YEAR), CalendarUnit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<JucheCalendar>(JucheCalendar.getDefaultWeekmodel(), jucheCalendar -> CALSYS), CalendarUnit.DAYS).appendElement(WIM_ELEMENT, (ElementRule)WeekdayInMonthElement.getRule(WIM_ELEMENT))).appendExtension(new CommonElements.Weekengine(JucheCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, JucheCalendar.getDefaultWeekmodel()));
        JucheCalendar.registerUnits((TimeAxis.Builder<CalendarUnit, JucheCalendar>)builder);
        ENGINE = ((TimeAxis.Builder)builder).build();
    }

    private static class JucheUnitRule
    implements UnitRule<JucheCalendar> {
        private final CalendarUnit unit;

        JucheUnitRule(CalendarUnit calendarUnit) {
            this.unit = calendarUnit;
        }

        @Override
        public JucheCalendar addTo(JucheCalendar jucheCalendar, long l) {
            return new JucheCalendar(jucheCalendar.iso.plus(l, this.unit));
        }

        @Override
        public long between(JucheCalendar jucheCalendar, JucheCalendar jucheCalendar2) {
            return this.unit.between(jucheCalendar.iso, jucheCalendar2.iso);
        }
    }

    private static class Transformer
    implements EraYearMonthDaySystem<JucheCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            try {
                if (calendarEra instanceof JucheEra) {
                    int n4 = JucheCalendar.toProlepticYear(n);
                    return n >= 1 && n4 <= 999999999 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= GregorianMath.getLengthOfMonth(n4, n2);
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            try {
                int n3 = JucheCalendar.toProlepticYear(n);
                return PlainDate.of(n3, n2, 1).lengthOfMonth();
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(runtimeException.getMessage(), runtimeException);
            }
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            try {
                int n2 = JucheCalendar.toProlepticYear(n);
                return PlainDate.of(n2, Month.JANUARY, 1).lengthOfYear();
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(runtimeException.getMessage(), runtimeException);
            }
        }

        @Override
        public JucheCalendar transform(long l) {
            return new JucheCalendar(PlainDate.of(l, EpochDays.UTC));
        }

        @Override
        public long transform(JucheCalendar jucheCalendar) {
            return jucheCalendar.iso.get(EpochDays.UTC);
        }

        @Override
        public long getMinimumSinceUTC() {
            return -21915L;
        }

        @Override
        public long getMaximumSinceUTC() {
            return PlainDate.axis().getCalendarSystem().getMaximumSinceUTC();
        }

        @Override
        public List<CalendarEra> getEras() {
            return Collections.singletonList(JucheEra.JUCHE);
        }
    }

    private static class Merger
    implements ChronoMerger<JucheCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
            return GenericDatePatterns.get("roc", formatStyle, locale);
        }

        @Override
        public JucheCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (JucheCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        @Override
        public JucheCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            if (chronoEntity.contains(PlainDate.COMPONENT)) {
                return new JucheCalendar(chronoEntity.get(PlainDate.COMPONENT));
            }
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Juche year.");
                return null;
            }
            int n2 = JucheCalendar.toProlepticYear(n);
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n3 = ((Month)chronoEntity.get(MONTH_OF_YEAR)).getValue();
                int n4 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n4 != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(JucheEra.JUCHE, n, n3, n4)) {
                        return JucheCalendar.of(n, n3, n4);
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Juche date.");
                }
            } else {
                int n5 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n5 != Integer.MIN_VALUE) {
                    if (n5 > 0) {
                        int n6 = 1;
                        int n7 = 0;
                        while (n6 <= 12) {
                            int n8 = GregorianMath.getLengthOfMonth(n2, n6);
                            if (n5 > n7 + n8) {
                                ++n6;
                                n7 += n8;
                                continue;
                            }
                            int n9 = n5 - n7;
                            return JucheCalendar.of(n, n6, n9);
                        }
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Juche date.");
                }
            }
            return null;
        }

        @Override
        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear() - 1911;
        }
    }

    private static class FieldRule<V extends Comparable<V>>
    implements ElementRule<JucheCalendar, V> {
        private final ChronoElement<V> element;

        private FieldRule(ChronoElement<V> chronoElement) {
            this.element = chronoElement;
        }

        static <V extends Comparable<V>> FieldRule<V> of(ChronoElement<V> chronoElement) {
            return new FieldRule<V>(chronoElement);
        }

        @Override
        public V getValue(JucheCalendar jucheCalendar) {
            Object object;
            if (this.element == ERA) {
                object = JucheEra.JUCHE;
            } else if (this.element.equals(YEAR_OF_ERA)) {
                object = jucheCalendar.getYear();
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = jucheCalendar.getMonth();
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = jucheCalendar.getDayOfMonth();
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = jucheCalendar.getDayOfYear();
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        @Override
        public V getMinimum(JucheCalendar jucheCalendar) {
            Object object;
            if (this.element == ERA) {
                object = JucheEra.JUCHE;
            } else if (Integer.class.isAssignableFrom(this.element.getType())) {
                object = 1;
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = Month.JANUARY;
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        @Override
        public V getMaximum(JucheCalendar jucheCalendar) {
            Object object;
            if (this.element == ERA) {
                object = JucheEra.JUCHE;
            } else if (this.element.equals(YEAR_OF_ERA)) {
                object = 999998088;
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = Month.DECEMBER;
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = jucheCalendar.iso.getMaximum(PlainDate.DAY_OF_MONTH);
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = jucheCalendar.iso.getMaximum(PlainDate.DAY_OF_YEAR);
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        @Override
        public boolean isValid(JucheCalendar jucheCalendar, V v) {
            if (v == null) {
                return false;
            }
            if (this.element == ERA) {
                return true;
            }
            V v2 = this.getMinimum(jucheCalendar);
            V v3 = this.getMaximum(jucheCalendar);
            return v2.compareTo(v) <= 0 && v.compareTo(v3) <= 0;
        }

        @Override
        public JucheCalendar withValue(JucheCalendar jucheCalendar, V v, boolean bl) {
            if (!this.isValid(jucheCalendar, v)) {
                throw new IllegalArgumentException("Out of range: " + v);
            }
            if (this.element == ERA) {
                return jucheCalendar;
            }
            if (this.element.equals(YEAR_OF_ERA)) {
                JucheCalendar jucheCalendar2 = JucheCalendar.of(FieldRule.toNumber(v), jucheCalendar.getMonth(), 1);
                return (JucheCalendar)jucheCalendar2.with((ChronoElement<Integer>)DAY_OF_MONTH, Math.min(jucheCalendar.getDayOfMonth(), jucheCalendar2.lengthOfMonth()));
            }
            if (this.element.equals(MONTH_OF_YEAR)) {
                PlainDate plainDate = (PlainDate)jucheCalendar.iso.with(PlainDate.MONTH_OF_YEAR, (Month)Month.class.cast(v));
                return new JucheCalendar(plainDate);
            }
            if (this.element.equals(DAY_OF_MONTH)) {
                PlainDate plainDate = (PlainDate)jucheCalendar.iso.with((ChronoElement<Integer>)PlainDate.DAY_OF_MONTH, FieldRule.toNumber(v));
                return new JucheCalendar(plainDate);
            }
            if (this.element.equals(DAY_OF_YEAR)) {
                PlainDate plainDate = (PlainDate)jucheCalendar.iso.with((ChronoElement<Integer>)PlainDate.DAY_OF_YEAR, FieldRule.toNumber(v));
                return new JucheCalendar(plainDate);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JucheCalendar jucheCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JucheCalendar jucheCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        private static int toNumber(Object object) {
            return (Integer)Integer.class.cast(object);
        }
    }
}

