/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.time.Clock;
import java.time.Instant;
import net.time4j.Moment;
import net.time4j.ZonalClock;
import net.time4j.base.ResourceLoader;
import net.time4j.base.TimeSource;
import net.time4j.scale.LeapSeconds;
import net.time4j.scale.TickProvider;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class SystemClock
implements TimeSource<Moment> {
    private static final int MIO = 1000000;
    private static final int MRD = 1000000000;
    private static final TickProvider PROVIDER;
    private static final boolean MONOTON_MODE;
    public static final SystemClock INSTANCE;
    public static final SystemClock MONOTONIC;
    private final boolean monotonic;
    private final long offset;

    private SystemClock(boolean bl, long l) {
        this.monotonic = bl;
        this.offset = l;
    }

    @Override
    public Moment currentTime() {
        if ((this.monotonic || MONOTON_MODE) && LeapSeconds.getInstance().isEnabled()) {
            long l = this.utcNanos();
            return Moment.of(Math.floorDiv(l, 1000000000), Math.floorMod(l, 1000000000), TimeScale.UTC);
        }
        long l = System.currentTimeMillis();
        int n = Math.floorMod(l, 1000) * 1000000;
        return Moment.of(Math.floorDiv(l, 1000), n, TimeScale.POSIX);
    }

    public long currentTimeInMillis() {
        if (this.monotonic || MONOTON_MODE) {
            long l = this.utcNanos();
            long l2 = LeapSeconds.getInstance().strip(Math.floorDiv(l, 1000000000));
            return Math.multiplyExact(l2, 1000) + (long)Math.floorMod(l, 1000000);
        }
        return System.currentTimeMillis();
    }

    public long currentTimeInMicros() {
        if (this.monotonic || MONOTON_MODE) {
            long l = this.utcNanos();
            long l2 = LeapSeconds.getInstance().strip(Math.floorDiv(l, 1000000000));
            return Math.multiplyExact(l2, 1000000) + (long)Math.floorMod(l, 1000);
        }
        return Math.multiplyExact(System.currentTimeMillis(), 1000);
    }

    public long realTimeInMicros() {
        if (this.monotonic || MONOTON_MODE) {
            return Math.floorDiv(this.utcNanos(), 1000);
        }
        long l = System.currentTimeMillis();
        long l2 = LeapSeconds.getInstance().enhance(Math.floorDiv(l, 1000));
        return Math.multiplyExact(l2, 1000000) + (long)(Math.floorMod(l, 1000) * 1000);
    }

    public static ZonalClock inPlatformView() {
        return new ZonalClock(INSTANCE, Timezone.ofPlatform());
    }

    public static ZonalClock inLocalView() {
        return ZonalClock.ofSystem();
    }

    public static ZonalClock inZonalView(TZID tZID) {
        return new ZonalClock(INSTANCE, tZID);
    }

    public static ZonalClock inZonalView(String string) {
        return new ZonalClock(INSTANCE, string);
    }

    public static Moment currentMoment() {
        return INSTANCE.currentTime();
    }

    public SystemClock recalibrated() {
        return new SystemClock(this.monotonic, SystemClock.calibrate());
    }

    public SystemClock synchronizedWith(TimeSource<?> timeSource) {
        Moment moment = Moment.from(timeSource.currentTime());
        long l = MONOTON_MODE ? System.nanoTime() : PROVIDER.getNanos();
        long l2 = moment.getElapsedTime(TimeScale.UTC);
        long l3 = Math.multiplyExact(l2, 1000000000) + (long)moment.getNanosecond(TimeScale.UTC);
        long l4 = Math.subtractExact(l3, l);
        return new SystemClock(this.monotonic, l4);
    }

    private static long calibrate() {
        Instant instant = Clock.systemUTC().instant();
        long l = MONOTON_MODE ? System.nanoTime() : PROVIDER.getNanos();
        long l2 = LeapSeconds.getInstance().enhance(instant.getEpochSecond());
        long l3 = Math.multiplyExact(l2, 1000000000) + (long)instant.getNano();
        return Math.subtractExact(l3, l);
    }

    private long utcNanos() {
        long l = MONOTON_MODE ? System.nanoTime() : PROVIDER.getNanos();
        return Math.addExact(l, this.offset);
    }

    static {
        String string = System.getProperty("java.vm.name");
        TickProvider tickProvider = null;
        for (TickProvider tickProvider2 : ResourceLoader.getInstance().services(TickProvider.class)) {
            if (!string.equals(tickProvider2.getPlatform())) continue;
            tickProvider = tickProvider2;
            break;
        }
        if (tickProvider == null) {
            tickProvider = new StdTickProvider();
        }
        PROVIDER = tickProvider;
        MONOTON_MODE = Boolean.getBoolean("net.time4j.systemclock.nanoTime");
        INSTANCE = new SystemClock(false, SystemClock.calibrate());
        MONOTONIC = new SystemClock(true, SystemClock.calibrate());
    }

    private static class StdTickProvider
    implements TickProvider {
        private StdTickProvider() {
        }

        @Override
        public String getPlatform() {
            return "";
        }

        @Override
        public long getNanos() {
            return System.nanoTime();
        }
    }
}

