/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.base;

import net.time4j.base.GregorianDate;

public final class GregorianMath {
    public static final int MIN_YEAR = -999999999;
    public static final int MAX_YEAR = 999999999;
    private static final int OFFSET = 678881;

    private GregorianMath() {
    }

    public static boolean isLeapYear(int n) {
        if (n > 1900 && n < 2100) {
            return (n & 3) == 0;
        }
        return (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static int getLengthOfMonth(int n, int n2) {
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return GregorianMath.isLeapYear(n) ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid month: " + n2);
    }

    public static boolean isValid(int n, int n2, int n3) {
        return n >= -999999999 && n <= 999999999 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= GregorianMath.getLengthOfMonth(n, n2);
    }

    public static void checkDate(int n, int n2, int n3) {
        if (n < -999999999 || n > 999999999) {
            throw new IllegalArgumentException("YEAR out of range: " + n);
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("MONTH out of range: " + n2);
        }
        if (n3 < 1 || n3 > 31) {
            throw new IllegalArgumentException("DAY_OF_MONTH out of range: " + n3);
        }
        if (n3 > GregorianMath.getLengthOfMonth(n, n2)) {
            throw new IllegalArgumentException("DAY_OF_MONTH exceeds month length in given year: " + GregorianMath.toString(n, n2, n3));
        }
    }

    public static int getDayOfWeek(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n3 < 1 || n3 > 31) {
            throw new IllegalArgumentException("Day out of range: " + n3);
        }
        if (n3 > GregorianMath.getLengthOfMonth(n, n2)) {
            throw new IllegalArgumentException("Day exceeds month length: " + GregorianMath.toString(n, n2, n3));
        }
        int n6 = GregorianMath.gaussianWeekTerm(n2);
        int n7 = n % 100;
        int n8 = Math.floorDiv(n, 100);
        if (n7 < 0) {
            n7 += 100;
        }
        if (n2 <= 2 && --n7 < 0) {
            n7 = 99;
            --n8;
        }
        if ((n5 = (n3 + n6 + n7 + n7 / 4 + (n4 = Math.floorDiv(n8, 4)) - 2 * n8) % 7) <= 0) {
            n5 += 7;
        }
        return n5;
    }

    public static int readYear(long l) {
        return (int)(l >> 32);
    }

    public static int readMonth(long l) {
        return (int)(l >> 16 & 0xFFL);
    }

    public static int readDayOfMonth(long l) {
        return (int)(l & 0xFFL);
    }

    public static long toPackedDate(long l) {
        int n;
        int n2;
        long l2;
        long l3;
        long l4 = Math.addExact(l, 678881L);
        if (l4 >= 694266L && l4 < 766950L) {
            l3 = Math.floorDiv(l4 += 15L, 1461);
            int n3 = Math.floorMod(l4, 1461);
            if (n3 == 1460) {
                l2 = (l3 + 1L) * 4L;
                n2 = 2;
                n = 29;
            } else {
                int n4 = n3 / 365;
                int n5 = n3 % 365;
                l2 = l3 * 4L + (long)n4;
                n2 = (n5 + 31) * 5 / 153 + 2;
                n = n5 - (n2 + 1) * 153 / 5 + 123;
                if (n2 > 12) {
                    ++l2;
                    n2 -= 12;
                }
            }
        } else {
            l3 = Math.floorDiv(l4, 146097);
            int n6 = Math.floorMod(l4, 146097);
            if (n6 == 146096) {
                l2 = (l3 + 1L) * 400L;
                n2 = 2;
                n = 29;
            } else {
                int n7 = n6 / 36524;
                int n8 = n6 % 36524;
                int n9 = n8 / 1461;
                int n10 = n8 % 1461;
                if (n10 == 1460) {
                    l2 = l3 * 400L + (long)(n7 * 100) + (long)((n9 + 1) * 4);
                    n2 = 2;
                    n = 29;
                } else {
                    int n11 = n10 / 365;
                    int n12 = n10 % 365;
                    l2 = l3 * 400L + (long)(n7 * 100) + (long)(n9 * 4) + (long)n11;
                    n2 = (n12 + 31) * 5 / 153 + 2;
                    n = n12 - (n2 + 1) * 153 / 5 + 123;
                    if (n2 > 12) {
                        ++l2;
                        n2 -= 12;
                    }
                }
            }
            if (l2 < -999999999L || l2 > 999999999L) {
                throw new IllegalArgumentException("Year out of range: " + l2);
            }
        }
        l3 = l2 << 32;
        l3 |= (long)(n2 << 16);
        return l3 |= (long)n;
    }

    public static long toMJD(GregorianDate gregorianDate) {
        return GregorianMath.toMJD(gregorianDate.getYear(), gregorianDate.getMonth(), gregorianDate.getDayOfMonth());
    }

    public static long toMJD(int n, int n2, int n3) {
        GregorianMath.checkDate(n, n2, n3);
        long l = n;
        int n4 = n2;
        if (n4 < 3) {
            --l;
            n4 += 12;
        }
        long l2 = l * 365L + Math.floorDiv(l, 4) + (long)((n4 + 1) * 153 / 5) - 123L + (long)n3;
        l2 = n >= 1901 && n < 2100 ? (l2 -= 15L) : l2 - Math.floorDiv(l, 100) + Math.floorDiv(l, 400);
        return l2 - 678881L;
    }

    private static String toString(int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append('-');
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append('-');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }

    private static int gaussianWeekTerm(int n) {
        switch (n) {
            case 1: {
                return 28;
            }
            case 2: {
                return 31;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 12;
            }
            case 8: {
                return 15;
            }
            case 9: {
                return 18;
            }
            case 10: {
                return 20;
            }
            case 11: {
                return 23;
            }
            case 12: {
                return 25;
            }
        }
        throw new IllegalArgumentException("Month out of range: " + n);
    }
}

