/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.ObjectStreamException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.calendar.ChineseEra;
import net.time4j.calendar.EastAsianYear;
import net.time4j.calendar.SexagesimalName;

public final class CyclicYear
extends SexagesimalName {
    private static final CyclicYear[] INSTANCES;
    private static final long serialVersionUID = 4908662352833192131L;

    private CyclicYear(int n) {
        super(n);
    }

    public static CyclicYear of(int n) {
        if (n < 1 || n > 60) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return INSTANCES[n - 1];
    }

    public static CyclicYear of(SexagesimalName.Stem stem, SexagesimalName.Branch branch) {
        SexagesimalName sexagesimalName = SexagesimalName.of(stem, branch);
        return CyclicYear.of(sexagesimalName.getNumber());
    }

    public static CyclicYear parse(String string, Locale locale) throws ParseException {
        SexagesimalName sexagesimalName = SexagesimalName.parse(string, locale);
        return CyclicYear.of(sexagesimalName.getNumber());
    }

    @Override
    public CyclicYear roll(int n) {
        if (n == 0) {
            return this;
        }
        SexagesimalName sexagesimalName = super.roll(n);
        return CyclicYear.of(sexagesimalName.getNumber());
    }

    public EastAsianYear inQingDynasty(ChineseEra chineseEra) {
        if (chineseEra.isQingDynasty()) {
            if (chineseEra == ChineseEra.QING_KANGXI_1662_1723 && this.getNumber() == 39) {
                throw new IllegalArgumentException("Ambivalent cyclic year in Kangxi-era (1662 or 1722): " + this.getDisplayName(Locale.ROOT));
            }
            int n = chineseEra.getStartAsGregorianYear();
            int n2 = this.getNumber() - EastAsianYear.forGregorian(n).getYearOfCycle().getNumber();
            return () -> n + n2 + (n2 < 0 ? 2696 : 2636);
        }
        throw new IllegalArgumentException("Chinese era must be related to a Qing dynasty.");
    }

    public EastAsianYear inCycle(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Cycle number must not be smaller than 1: " + n);
        }
        return () -> (n - 1) * 60 + this.getNumber() - 1;
    }

    static CyclicYear parse(CharSequence charSequence, ParsePosition parsePosition, Locale locale, boolean bl) {
        SexagesimalName sexagesimalName = SexagesimalName.parse(charSequence, parsePosition, locale, bl);
        return sexagesimalName == null ? null : CyclicYear.of(sexagesimalName.getNumber());
    }

    @Override
    Object readResolve() throws ObjectStreamException {
        return CyclicYear.of(super.getNumber());
    }

    static {
        CyclicYear[] cyclicYearArray = new CyclicYear[60];
        for (int i = 0; i < 60; ++i) {
            cyclicYearArray[i] = new CyclicYear(i + 1);
        }
        INSTANCES = cyclicYearArray;
    }
}

