/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.time.YearMonth;
import java.time.format.FormatStyle;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import net.time4j.CalendarUnit;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.SystemClock;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.Converter;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.ThreetenAdapter;
import net.time4j.engine.TimeLine;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.PatternType;
import net.time4j.range.Boundary;
import net.time4j.range.FixedCalendarInterval;
import net.time4j.range.FixedCalendarTimeLine;
import net.time4j.range.Months;
import net.time4j.range.SPX;
import net.time4j.range.Years;
import net.time4j.tz.Timezone;

@CalendarType(value="iso8601")
public final class CalendarMonth
extends FixedCalendarInterval<CalendarMonth>
implements ThreetenAdapter,
LocalizedPatternSupport {
    @FormattableElement(format="u")
    public static final ChronoElement<Integer> YEAR = PlainDate.YEAR;
    @FormattableElement(format="M", alt="L")
    public static final ChronoElement<Month> MONTH_OF_YEAR = PlainDate.MONTH_OF_YEAR;
    public static final ChronoElement<Integer> MONTH_AS_NUMBER = PlainDate.MONTH_AS_NUMBER;
    private static final Chronology<CalendarMonth> ENGINE = Chronology.Builder.setUp(CalendarMonth.class, new Merger()).appendElement(YEAR, new YearRule()).appendElement(MONTH_OF_YEAR, new EnumMonthRule()).appendElement(MONTH_AS_NUMBER, new IntMonthRule()).build();
    private static final ChronoFormatter<CalendarMonth> PARSER = ChronoFormatter.setUp(CalendarMonth.chronology(), Locale.ROOT).addPattern("uuuu-MM|uuuuMM", PatternType.CLDR).build();
    private static final Chronology<YearMonth> THREETEN;
    private static final long serialVersionUID = -5097347953941448741L;
    private final transient int year;
    private final transient Month month;
    private final transient Boundary<PlainDate> start;
    private final transient Boundary<PlainDate> end;

    private CalendarMonth(int n, Month month) {
        if (n < -999999999 || n > 999999999) {
            throw new IllegalArgumentException("Year out of bounds: " + n);
        }
        if (month == null) {
            throw new NullPointerException("Missing month of calendar year.");
        }
        this.year = n;
        this.month = month;
        this.start = Boundary.ofClosed(PlainDate.of(this.year, month, 1));
        this.end = Boundary.ofClosed(PlainDate.of(n, month, GregorianMath.getLengthOfMonth(n, month.getValue())));
    }

    public static CalendarMonth of(int n, int n2) {
        return new CalendarMonth(n, Month.valueOf(n2));
    }

    public static CalendarMonth of(int n, Month month) {
        return new CalendarMonth(n, month);
    }

    public static CalendarMonth nowInSystemTime() {
        return SystemClock.inLocalView().now(CalendarMonth.chronology());
    }

    public PlainDate atDayOfMonth(int n) {
        if (n == 1) {
            return this.start.getTemporal();
        }
        return (PlainDate)this.start.getTemporal().with((ChronoElement<Integer>)PlainDate.DAY_OF_MONTH, n);
    }

    public PlainDate atEndOfMonth() {
        return this.end.getTemporal();
    }

    public int getYear() {
        return this.year;
    }

    public Month getMonth() {
        return this.month;
    }

    @Override
    public Boundary<PlainDate> getStart() {
        return this.start;
    }

    @Override
    public Boundary<PlainDate> getEnd() {
        return this.end;
    }

    @Override
    public boolean contains(PlainDate plainDate) {
        return plainDate.getYear() == this.year && plainDate.getMonth() == this.month.getValue();
    }

    @Override
    public boolean isAfter(PlainDate plainDate) {
        return this.start.getTemporal().isAfter(plainDate);
    }

    @Override
    public boolean isBefore(PlainDate plainDate) {
        return this.end.getTemporal().isBefore(plainDate);
    }

    public int length() {
        return GregorianMath.getLengthOfMonth(this.year, this.month.getValue());
    }

    public static CalendarMonth from(GregorianDate gregorianDate) {
        PlainDate plainDate = PlainDate.from(gregorianDate);
        return CalendarMonth.of(plainDate.getYear(), plainDate.getMonth());
    }

    public static CalendarMonth from(YearMonth yearMonth) {
        return CalendarMonth.of(yearMonth.getYear(), yearMonth.getMonthValue());
    }

    public CalendarMonth plus(Years<CalendarUnit> years) {
        if (years.isEmpty()) {
            return this;
        }
        return CalendarMonth.of(MathUtils.safeAdd(this.year, years.getAmount()), this.month);
    }

    public CalendarMonth plus(Months months) {
        if (months.isEmpty()) {
            return this;
        }
        long l = (long)this.year * 12L + (long)this.month.getValue() - 1L + (long)months.getAmount();
        int n = MathUtils.safeCast(MathUtils.floorDivide(l, 12));
        Month month = Month.valueOf(MathUtils.floorModulo(l, 12) + 1);
        return CalendarMonth.of(n, month);
    }

    public CalendarMonth minus(Years<CalendarUnit> years) {
        if (years.isEmpty()) {
            return this;
        }
        return CalendarMonth.of(MathUtils.safeSubtract(this.year, years.getAmount()), this.month);
    }

    public CalendarMonth minus(Months months) {
        if (months.isEmpty()) {
            return this;
        }
        long l = (long)this.year * 12L + (long)this.month.getValue() - 1L - (long)months.getAmount();
        int n = MathUtils.safeCast(MathUtils.floorDivide(l, 12));
        Month month = Month.valueOf(MathUtils.floorModulo(l, 12) + 1);
        return CalendarMonth.of(n, month);
    }

    @Override
    public int compareTo(CalendarMonth calendarMonth) {
        if (this.year < calendarMonth.year) {
            return -1;
        }
        if (this.year > calendarMonth.year) {
            return 1;
        }
        return this.month.compareTo(calendarMonth.month);
    }

    @Override
    public Iterator<PlainDate> iterator() {
        return new Iter();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CalendarMonth) {
            CalendarMonth calendarMonth = (CalendarMonth)object;
            return this.year == calendarMonth.year && this.month == calendarMonth.month;
        }
        return false;
    }

    public int hashCode() {
        return this.year ^ this.month.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        CalendarMonth.formatYear(stringBuilder, this.year);
        stringBuilder.append('-');
        int n = this.month.getValue();
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    public static CalendarMonth parseISO(String string) throws ParseException {
        return PARSER.parse(string);
    }

    @Override
    public YearMonth toTemporalAccessor() {
        return YearMonth.of(this.year, this.month.getValue());
    }

    public static Chronology<CalendarMonth> chronology() {
        return ENGINE;
    }

    public static Chronology<YearMonth> threeten() {
        return THREETEN;
    }

    public static TimeLine<CalendarMonth> timeline() {
        return FixedCalendarTimeLine.forMonths();
    }

    @Override
    protected Chronology<CalendarMonth> getChronology() {
        return ENGINE;
    }

    @Override
    protected CalendarMonth getContext() {
        return this;
    }

    @Override
    long toProlepticNumber() {
        return this.year * 12 + (this.month.getValue() - 1);
    }

    static CalendarMonth from(long l) {
        int n = MathUtils.safeCast(Math.floorDiv(l, 12));
        int n2 = MathUtils.floorModulo(l, 12) + 1;
        return CalendarMonth.of(n, n2);
    }

    private Object writeReplace() {
        return new SPX(this, 38);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        Converter<YearMonth, CalendarMonth> converter = new Converter<YearMonth, CalendarMonth>(){

            @Override
            public CalendarMonth translate(YearMonth yearMonth) {
                return CalendarMonth.of(yearMonth.getYear(), yearMonth.getMonthValue());
            }

            @Override
            public YearMonth from(CalendarMonth calendarMonth) {
                return YearMonth.of(calendarMonth.year, calendarMonth.month.getValue());
            }

            @Override
            public Class<YearMonth> getSourceType() {
                return YearMonth.class;
            }
        };
        THREETEN = new BridgeChronology<YearMonth, CalendarMonth>(converter, ENGINE);
    }

    private class Iter
    implements Iterator<PlainDate> {
        private PlainDate current;

        private Iter() {
            this.current = (PlainDate)CalendarMonth.this.start.getTemporal();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public PlainDate next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            PlainDate plainDate = this.current;
            PlainDate plainDate2 = plainDate.plus(1L, CalendarUnit.DAYS);
            this.current = plainDate2.getMonth() == plainDate.getMonth() ? plainDate2 : null;
            return plainDate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Merger
    implements ChronoMerger<CalendarMonth> {
        private Merger() {
        }

        @Override
        public CalendarMonth createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                timezone = Timezone.of(attributeQuery.get(Attributes.TIMEZONE_ID));
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                timezone = Timezone.ofSystem();
            } else {
                return null;
            }
            PlainDate plainDate = Moment.from(timeSource.currentTime()).toZonalTimestamp(timezone.getID()).toDate();
            return CalendarMonth.of(plainDate.getYear(), Month.valueOf(plainDate.getMonth()));
        }

        @Override
        public CalendarMonth createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = chronoEntity.getInt(YEAR);
            if (n >= -999999999 && n <= 999999999) {
                int n2 = chronoEntity.getInt(PlainDate.MONTH_AS_NUMBER);
                if (n2 == Integer.MIN_VALUE && chronoEntity.contains(MONTH_OF_YEAR)) {
                    n2 = chronoEntity.get(MONTH_OF_YEAR).getValue();
                }
                if (n2 != Integer.MIN_VALUE) {
                    return CalendarMonth.of(n, Month.valueOf(n2));
                }
            } else if (n > Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Year out of bounds: " + n);
            }
            return null;
        }

        @Override
        public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
            Map<String, String> map = CalendarText.getIsoInstance(locale).getTextForms();
            String string = null;
            switch (formatStyle) {
                case FULL: {
                    string = "F_yMMMM";
                    break;
                }
                case LONG: {
                    string = "F_yMMM";
                    break;
                }
                case MEDIUM: {
                    string = "F_yMM";
                    break;
                }
                case SHORT: {
                    string = "F_yM";
                }
            }
            String string2 = Merger.getFormatPattern(map, string);
            return string2 == null ? "uuuu-MM" : string2;
        }

        private static String getFormatPattern(Map<String, String> map, String string) {
            if (map.containsKey(string)) {
                return map.get(string);
            }
            switch (string) {
                case "F_yMMMM": {
                    return Merger.getFormatPattern(map, "F_yMMM");
                }
                case "F_yMMM": {
                    return Merger.getFormatPattern(map, "F_yMM");
                }
                case "F_yMM": {
                    return Merger.getFormatPattern(map, "F_yM");
                }
            }
            return null;
        }
    }

    private static class YearRule
    implements IntElementRule<CalendarMonth> {
        private YearRule() {
        }

        @Override
        public Integer getValue(CalendarMonth calendarMonth) {
            return calendarMonth.year;
        }

        @Override
        public Integer getMinimum(CalendarMonth calendarMonth) {
            return -999999999;
        }

        @Override
        public Integer getMaximum(CalendarMonth calendarMonth) {
            return 999999999;
        }

        @Override
        public boolean isValid(CalendarMonth calendarMonth, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= -999999999 && n2 <= 999999999;
        }

        @Override
        public CalendarMonth withValue(CalendarMonth calendarMonth, Integer n, boolean bl) {
            if (this.isValid(calendarMonth, n)) {
                return CalendarMonth.of((int)n, calendarMonth.month);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(CalendarMonth calendarMonth) {
            return MONTH_OF_YEAR;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(CalendarMonth calendarMonth) {
            return MONTH_OF_YEAR;
        }

        @Override
        public int getInt(CalendarMonth calendarMonth) {
            return calendarMonth.year;
        }

        @Override
        public boolean isValid(CalendarMonth calendarMonth, int n) {
            return n >= -999999999 && n <= 999999999;
        }

        @Override
        public CalendarMonth withValue(CalendarMonth calendarMonth, int n, boolean bl) {
            if (this.isValid(calendarMonth, n)) {
                return CalendarMonth.of(n, calendarMonth.month);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }
    }

    private static class EnumMonthRule
    implements ElementRule<CalendarMonth, Month> {
        private EnumMonthRule() {
        }

        @Override
        public Month getValue(CalendarMonth calendarMonth) {
            return calendarMonth.month;
        }

        @Override
        public Month getMinimum(CalendarMonth calendarMonth) {
            return Month.JANUARY;
        }

        @Override
        public Month getMaximum(CalendarMonth calendarMonth) {
            return Month.DECEMBER;
        }

        @Override
        public boolean isValid(CalendarMonth calendarMonth, Month month) {
            return month != null;
        }

        @Override
        public CalendarMonth withValue(CalendarMonth calendarMonth, Month month, boolean bl) {
            if (this.isValid(calendarMonth, month)) {
                return CalendarMonth.of(calendarMonth.year, month);
            }
            throw new IllegalArgumentException("Not valid: " + month);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(CalendarMonth calendarMonth) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(CalendarMonth calendarMonth) {
            return null;
        }
    }

    private static class IntMonthRule
    implements IntElementRule<CalendarMonth> {
        private IntMonthRule() {
        }

        @Override
        public Integer getValue(CalendarMonth calendarMonth) {
            return calendarMonth.month.getValue();
        }

        @Override
        public Integer getMinimum(CalendarMonth calendarMonth) {
            return 1;
        }

        @Override
        public Integer getMaximum(CalendarMonth calendarMonth) {
            return 12;
        }

        @Override
        public boolean isValid(CalendarMonth calendarMonth, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= 1 && n2 <= 12;
        }

        @Override
        public CalendarMonth withValue(CalendarMonth calendarMonth, Integer n, boolean bl) {
            if (this.isValid(calendarMonth, n)) {
                return CalendarMonth.of(calendarMonth.year, n);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(CalendarMonth calendarMonth) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(CalendarMonth calendarMonth) {
            return null;
        }

        @Override
        public int getInt(CalendarMonth calendarMonth) {
            return calendarMonth.month.getValue();
        }

        @Override
        public boolean isValid(CalendarMonth calendarMonth, int n) {
            return n >= 1 && n <= 12;
        }

        @Override
        public CalendarMonth withValue(CalendarMonth calendarMonth, int n, boolean bl) {
            if (this.isValid(calendarMonth, n)) {
                return CalendarMonth.of(calendarMonth.year, n);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }
    }
}

