/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.ClockUnit;
import net.time4j.Moment;
import net.time4j.PlainTimestamp;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.calendar.EastAsianCalendar;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.StartOfDay;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

abstract class AbstractMergerEA<C extends EastAsianCalendar<?, C>>
implements ChronoMerger<C> {
    private final Class<C> chronoType;

    AbstractMergerEA(Class<C> clazz) {
        this.chronoType = clazz;
    }

    public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
        return GenericDatePatterns.get("chinese", displayStyle, locale);
    }

    public C createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
        TZID tZID;
        if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
            tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID);
        } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
            tZID = Timezone.ofSystem().getID();
        } else {
            return null;
        }
        StartOfDay startOfDay = (StartOfDay)attributeQuery.get(Attributes.START_OF_DAY, (Object)this.getDefaultStartOfDay());
        PlainTimestamp plainTimestamp = Moment.from((UnixTime)timeSource.currentTime()).toZonalTimestamp(tZID);
        int n = startOfDay.getDeviation((Calendrical)plainTimestamp.getCalendarDate(), tZID);
        plainTimestamp = plainTimestamp.minus((long)n, ClockUnit.SECONDS);
        return (C)((Object)((EastAsianCalendar)plainTimestamp.getCalendarDate().transform(this.chronoType)));
    }

    @Deprecated
    public C createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
        boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
        return this.createFrom(chronoEntity, attributeQuery, bl2, bl);
    }

    public abstract C createFrom(ChronoEntity<?> var1, AttributeQuery var2, boolean var3, boolean var4);

    public ChronoDisplay preformat(C c, AttributeQuery attributeQuery) {
        return c;
    }

    public int getDefaultPivotYear() {
        return 100;
    }
}

