/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.engine.CalendarEra;
import net.time4j.format.TextWidth;

public enum ChineseEra implements CalendarEra
{
    QING_SHUNZHI_1644_1662,
    QING_KANGXI_1662_1723,
    QING_YONGZHENG_1723_1736,
    QING_QIANLONG_1736_1796,
    QING_JIAQING_1796_1821,
    QING_DAOGUANG_1821_1851,
    QING_XIANFENG_1851_1862,
    QING_TONGZHI_1862_1875,
    QING_GUANGXU_1875_1909,
    QING_XUANTONG_1909_1912,
    YELLOW_EMPEROR;


    @Deprecated
    public int getValue() {
        return this.isQingDynasty() ? this.ordinal() - 9 : 1;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth) {
        String string = locale.getLanguage();
        switch (this) {
            case QING_SHUNZHI_1644_1662: {
                if (string.equals("zh")) {
                    return "\u9806\u6cbb";
                }
                if (string.isEmpty()) {
                    return "Shunzhi";
                }
                return "Sh\u00f9nzh\u00ec";
            }
            case QING_KANGXI_1662_1723: {
                if (string.equals("zh")) {
                    return "\u5eb7\u7199";
                }
                if (string.isEmpty()) {
                    return "Kangxi";
                }
                return "K\u0101ngx\u012b";
            }
            case QING_YONGZHENG_1723_1736: {
                if (string.equals("zh")) {
                    return "\u96cd\u6b63";
                }
                if (string.isEmpty()) {
                    return "Yongzheng";
                }
                return "Y\u014dngzh\u00e8ng";
            }
            case QING_QIANLONG_1736_1796: {
                if (string.equals("zh")) {
                    return "\u4e7e\u9686";
                }
                if (string.isEmpty()) {
                    return "Qianlong";
                }
                return "Qi\u00e1nl\u00f3ng";
            }
            case QING_JIAQING_1796_1821: {
                if (string.equals("zh")) {
                    return "\u5609\u6176";
                }
                if (string.isEmpty()) {
                    return "Jiaqing";
                }
                return "Ji\u0101q\u00ecng";
            }
            case QING_DAOGUANG_1821_1851: {
                if (string.equals("zh")) {
                    return "\u9053\u5149";
                }
                if (string.isEmpty()) {
                    return "Daoguang";
                }
                return "D\u00e0ogu\u0101ng";
            }
            case QING_XIANFENG_1851_1862: {
                if (string.equals("zh")) {
                    return "\u54b8\u8c50";
                }
                if (string.isEmpty()) {
                    return "Xianfeng";
                }
                return "Xi\u00e1nf\u0113ng";
            }
            case QING_TONGZHI_1862_1875: {
                if (string.equals("zh")) {
                    return "\u540c\u6cbb";
                }
                if (string.isEmpty()) {
                    return "Tongzhi";
                }
                return "T\u00f3ngzh\u00ec";
            }
            case QING_GUANGXU_1875_1909: {
                if (string.equals("zh")) {
                    return "\u5149\u7dd2";
                }
                if (string.isEmpty()) {
                    return "Guangxu";
                }
                return "Gu\u0101ngx\u00f9";
            }
            case QING_XUANTONG_1909_1912: {
                if (string.equals("zh")) {
                    return "\u5ba3\u7d71";
                }
                if (string.isEmpty()) {
                    return "Xuantong";
                }
                return "Xu\u0101nt\u01d2ng";
            }
            case YELLOW_EMPEROR: {
                if (string.equals("zh")) {
                    return "\u9ec4\u5e1d\u7d00\u5e74";
                }
                if (textWidth == TextWidth.WIDE) {
                    return string.isEmpty() ? "Anno Huangdi" : "Anno Hu\u00e1ngd\u00ec";
                }
                if (textWidth == TextWidth.NARROW) {
                    return "H";
                }
                return string.isEmpty() ? "Huangdi" : "Hu\u00e1ngd\u00ec";
            }
        }
        throw new UnsupportedOperationException("Not yet implemented: " + this.name());
    }

    public boolean isQingDynasty() {
        return this.ordinal() <= QING_XUANTONG_1909_1912.ordinal();
    }

    int getMinYearOfEra() {
        return this == YELLOW_EMPEROR ? 4343 : 1;
    }

    int getMaxYearOfEra() {
        switch (this) {
            case QING_SHUNZHI_1644_1662: {
                return 18;
            }
            case QING_KANGXI_1662_1723: {
                return 61;
            }
            case QING_YONGZHENG_1723_1736: {
                return 13;
            }
            case QING_QIANLONG_1736_1796: {
                return 60;
            }
            case QING_JIAQING_1796_1821: {
                return 25;
            }
            case QING_DAOGUANG_1821_1851: {
                return 30;
            }
            case QING_XIANFENG_1851_1862: {
                return 11;
            }
            case QING_TONGZHI_1862_1875: {
                return 13;
            }
            case QING_GUANGXU_1875_1909: {
                return 34;
            }
            case QING_XUANTONG_1909_1912: {
                return 3;
            }
            case YELLOW_EMPEROR: {
                return 5697;
            }
        }
        throw new UnsupportedOperationException("Not yet implemented: " + this.name());
    }

    int getStartAsGregorianYear() {
        switch (this) {
            case QING_SHUNZHI_1644_1662: {
                return 1644;
            }
            case QING_KANGXI_1662_1723: {
                return 1662;
            }
            case QING_YONGZHENG_1723_1736: {
                return 1723;
            }
            case QING_QIANLONG_1736_1796: {
                return 1736;
            }
            case QING_JIAQING_1796_1821: {
                return 1796;
            }
            case QING_DAOGUANG_1821_1851: {
                return 1821;
            }
            case QING_XIANFENG_1851_1862: {
                return 1851;
            }
            case QING_TONGZHI_1862_1875: {
                return 1862;
            }
            case QING_GUANGXU_1875_1909: {
                return 1875;
            }
            case QING_XUANTONG_1909_1912: {
                return 1909;
            }
            case YELLOW_EMPEROR: {
                return -2697;
            }
        }
        throw new UnsupportedOperationException("Not yet implemented: " + this.name());
    }
}

