/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.calendar.RelatedGregorianYearElement;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.service.StdDateElement;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.format.internal.FormatUtils;

public class CommonElements {
    @FormattableElement(format="r")
    public static final ChronoElement<Integer> RELATED_GREGORIAN_YEAR = RelatedGregorianYearElement.SINGLETON;

    private CommonElements() {
    }

    @FormattableElement(format="e", standalone="c")
    public static <T extends ChronoEntity<T>> StdCalendarElement<Weekday, T> localDayOfWeek(Chronology<T> chronology, Weekmodel weekmodel) {
        CommonElements.checkSevenDayWeek(chronology);
        return new DayOfWeekElement(chronology.getChronoType(), weekmodel);
    }

    @FormattableElement(format="w")
    public static <T extends ChronoEntity<T>> StdCalendarElement<Integer, T> weekOfYear(Chronology<T> chronology, Weekmodel weekmodel) {
        ChronoElement<Integer> chronoElement = CommonElements.findDayElement(chronology, "DAY_OF_YEAR");
        if (chronoElement == null) {
            throw new IllegalArgumentException("Cannot derive a rule for given chronology: " + chronology);
        }
        return new CalendarWeekElement("WEEK_OF_YEAR", chronology.getChronoType(), 1, 52, 'w', weekmodel, chronoElement, false);
    }

    @FormattableElement(format="W")
    public static <T extends ChronoEntity<T>> StdCalendarElement<Integer, T> weekOfMonth(Chronology<T> chronology, Weekmodel weekmodel) {
        ChronoElement<Integer> chronoElement = CommonElements.findDayElement(chronology, "DAY_OF_MONTH");
        if (chronoElement == null) {
            throw new IllegalArgumentException("Cannot derive a rule for given chronology: " + chronology);
        }
        return new CalendarWeekElement("WEEK_OF_MONTH", chronology.getChronoType(), 1, 5, 'W', weekmodel, chronoElement, false);
    }

    public static <T extends ChronoEntity<T>> StdCalendarElement<Integer, T> boundedWeekOfYear(Chronology<T> chronology, Weekmodel weekmodel) {
        ChronoElement<Integer> chronoElement = CommonElements.findDayElement(chronology, "DAY_OF_YEAR");
        if (chronoElement == null) {
            throw new IllegalArgumentException("Cannot derive a rule for given chronology: " + chronology);
        }
        return new CalendarWeekElement("BOUNDED_WEEK_OF_YEAR", chronology.getChronoType(), 1, 52, '\u0000', weekmodel, chronoElement, true);
    }

    public static <T extends ChronoEntity<T>> StdCalendarElement<Integer, T> boundedWeekOfMonth(Chronology<T> chronology, Weekmodel weekmodel) {
        ChronoElement<Integer> chronoElement = CommonElements.findDayElement(chronology, "DAY_OF_MONTH");
        if (chronoElement == null) {
            throw new IllegalArgumentException("Cannot derive a rule for given chronology: " + chronology);
        }
        return new CalendarWeekElement("BOUNDED_WEEK_OF_MONTH", chronology.getChronoType(), 1, 5, '\u0000', weekmodel, chronoElement, true);
    }

    private static <D extends ChronoEntity<D>> int getMax(ChronoElement<?> chronoElement, D d) {
        return (Integer)Integer.class.cast(d.getMaximum(chronoElement));
    }

    private static Weekday getDayOfWeek(long l) {
        return Weekday.valueOf((int)((int)(Math.floorMod(l + 5L, 7L) + 1L)));
    }

    private static void checkSevenDayWeek(Chronology<?> chronology) {
        if (CalendarDate.class.isAssignableFrom(chronology.getChronoType())) {
            for (ChronoElement chronoElement : chronology.getRegisteredElements()) {
                T[] TArray;
                if (!chronoElement.name().equals("DAY_OF_WEEK") || (TArray = chronoElement.getType().getEnumConstants()) == null || TArray.length != 7) continue;
                return;
            }
        }
        throw new IllegalArgumentException("No 7-day-week: " + chronology);
    }

    private static <D extends ChronoEntity<D>> ChronoElement<Integer> findDayElement(Chronology<D> chronology, String string) {
        CommonElements.checkSevenDayWeek(chronology);
        for (ChronoElement chronoElement : chronology.getRegisteredElements()) {
            if (!chronoElement.name().equals(string)) continue;
            if (chronoElement.getType() != Integer.class) break;
            return chronoElement;
        }
        return null;
    }

    private static class DayOperator<T extends ChronoEntity<T>>
    implements ChronoOperator<T> {
        private final int amount;

        DayOperator(int n) {
            this.amount = n;
        }

        public T apply(T t) {
            long l = Math.addExact((Long)t.get((ChronoElement)EpochDays.UTC), (long)this.amount);
            return (T)t.with((ChronoElement)EpochDays.UTC, l);
        }
    }

    private static class DRule<T extends ChronoEntity<T>>
    implements ElementRule<T, Weekday> {
        private final DayOfWeekElement<?> element;

        private DRule(DayOfWeekElement<?> dayOfWeekElement) {
            this.element = dayOfWeekElement;
        }

        public Weekday getValue(T t) {
            return CommonElements.getDayOfWeek((Long)t.get((ChronoElement)EpochDays.UTC));
        }

        public Weekday getMinimum(T t) {
            int n;
            Chronology chronology = Chronology.lookup(t.getClass());
            long l = t instanceof CalendarVariant ? chronology.getCalendarSystem(((CalendarVariant)CalendarVariant.class.cast(t)).getVariant()).getMinimumSinceUTC() : chronology.getCalendarSystem().getMinimumSinceUTC();
            long l2 = (Long)t.get((ChronoElement)EpochDays.UTC);
            if (l2 + 1L - (long)(n = CommonElements.getDayOfWeek(l2).getValue(((DayOfWeekElement)this.element).model)) < l) {
                return CommonElements.getDayOfWeek(l);
            }
            return this.element.getDefaultMinimum();
        }

        public Weekday getMaximum(T t) {
            int n;
            Chronology chronology = Chronology.lookup(t.getClass());
            long l = t instanceof CalendarVariant ? chronology.getCalendarSystem(((CalendarVariant)CalendarVariant.class.cast(t)).getVariant()).getMaximumSinceUTC() : chronology.getCalendarSystem().getMaximumSinceUTC();
            long l2 = (Long)t.get((ChronoElement)EpochDays.UTC);
            if (l2 + 7L - (long)(n = CommonElements.getDayOfWeek(l2).getValue(((DayOfWeekElement)this.element).model)) > l) {
                return CommonElements.getDayOfWeek(l);
            }
            return this.element.getDefaultMaximum();
        }

        public boolean isValid(T t, Weekday weekday) {
            if (weekday == null) {
                return false;
            }
            try {
                this.withValue(t, weekday, false);
                return true;
            }
            catch (ArithmeticException | IllegalArgumentException runtimeException) {
                return false;
            }
        }

        public T withValue(T t, Weekday weekday, boolean bl) {
            long l = (Long)t.get((ChronoElement)EpochDays.UTC);
            Weekday weekday2 = CommonElements.getDayOfWeek(l);
            if (weekday == weekday2) {
                return t;
            }
            int n = weekday2.getValue(((DayOfWeekElement)this.element).model);
            int n2 = weekday.getValue(((DayOfWeekElement)this.element).model);
            return (T)t.with((ChronoElement)EpochDays.UTC, l + (long)n2 - (long)n);
        }

        public ChronoElement<?> getChildAtFloor(T t) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(T t) {
            return null;
        }
    }

    private static class DayOfWeekElement<T extends ChronoEntity<T>>
    extends StdEnumDateElement<Weekday, T> {
        private static final long serialVersionUID = 5613494586572932860L;
        private final Weekmodel model;

        DayOfWeekElement(Class<T> clazz, Weekmodel weekmodel) {
            super("LOCAL_DAY_OF_WEEK", clazz, Weekday.class, 'e');
            this.model = weekmodel;
        }

        @Override
        public ChronoOperator<T> decremented() {
            return new DayOperator(-1);
        }

        @Override
        public ChronoOperator<T> incremented() {
            return new DayOperator(1);
        }

        @Override
        public int numerical(Weekday weekday) {
            return weekday.getValue(this.model);
        }

        @Override
        public Weekday getDefaultMinimum() {
            return this.model.getFirstDayOfWeek();
        }

        @Override
        public Weekday getDefaultMaximum() {
            return this.model.getFirstDayOfWeek().roll(6);
        }

        public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
            int n;
            int n2 = ((Weekday)chronoDisplay.get((ChronoElement)this)).getValue(this.model);
            return n2 < (n = ((Weekday)chronoDisplay2.get((ChronoElement)this)).getValue(this.model)) ? -1 : (n2 == n ? 0 : 1);
        }

        @Override
        protected boolean doEquals(BasicElement<?> basicElement) {
            if (super.doEquals(basicElement)) {
                DayOfWeekElement dayOfWeekElement = (DayOfWeekElement)DayOfWeekElement.class.cast(basicElement);
                return this.model.equals((Object)dayOfWeekElement.model);
            }
            return false;
        }

        protected <D extends ChronoEntity<D>> ElementRule<D, Weekday> derive(Chronology<D> chronology) {
            if (this.getChronoType().equals(chronology.getChronoType())) {
                return new DRule(this);
            }
            return null;
        }

        @Override
        protected boolean isWeekdayElement() {
            return true;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return this;
        }
    }

    private static class BWRule<D extends ChronoEntity<D>>
    implements ElementRule<D, Integer> {
        private final CalendarWeekElement<?> owner;

        private BWRule(CalendarWeekElement<?> calendarWeekElement) {
            this.owner = calendarWeekElement;
        }

        public Integer getValue(D d) {
            return this.getWeek(d);
        }

        public Integer getMinimum(D d) {
            return this.getMinWeek(d);
        }

        public Integer getMaximum(D d) {
            return this.getMaxWeek(d);
        }

        public ChronoElement<?> getChildAtFloor(D d) {
            return this.getChild(d, false);
        }

        public ChronoElement<?> getChildAtCeiling(D d) {
            return this.getChild(d, true);
        }

        private ChronoElement<?> getChild(D d, boolean bl) {
            DayOfWeekElement dayOfWeekElement = new DayOfWeekElement(d.getClass(), ((CalendarWeekElement)this.owner).model);
            int n = this.getWeek(d);
            long l = (Long)d.get((ChronoElement)EpochDays.UTC);
            int n2 = d.getInt(((CalendarWeekElement)this.owner).dayElement);
            if (bl) {
                ChronoEntity chronoEntity = d.with(dayOfWeekElement, d.getMaximum(dayOfWeekElement));
                long l2 = (Long)chronoEntity.get((ChronoElement)EpochDays.UTC) - l;
                if ((long)((Integer)d.getMaximum(((CalendarWeekElement)this.owner).dayElement)).intValue() < (long)n2 + l2) {
                    return ((CalendarWeekElement)this.owner).dayElement;
                }
            } else if (n <= 1) {
                ChronoEntity chronoEntity = d.with(dayOfWeekElement, d.getMinimum(dayOfWeekElement));
                long l3 = l - (Long)chronoEntity.get((ChronoElement)EpochDays.UTC);
                if ((long)((Integer)d.getMinimum(((CalendarWeekElement)this.owner).dayElement)).intValue() > (long)n2 - l3) {
                    return ((CalendarWeekElement)this.owner).dayElement;
                }
            }
            return dayOfWeekElement;
        }

        public boolean isValid(D d, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= this.getMinWeek(d) && n2 <= this.getMaxWeek(d);
        }

        public D withValue(D d, Integer n, boolean bl) {
            if (n == null || !bl && !this.isValid(d, n)) {
                throw new IllegalArgumentException("Invalid value: " + n + " (context=" + d + ")");
            }
            return this.setWeek(d, n);
        }

        private int getWeek(D d) {
            return this.getWeek(d, 0);
        }

        private int getMinWeek(D d) {
            return this.getWeek(d, -1);
        }

        private int getMaxWeek(D d) {
            return this.getWeek(d, 1);
        }

        private int getWeek(D d, int n) {
            int n2;
            int n3 = d.getInt(((CalendarWeekElement)this.owner).dayElement);
            Weekday weekday = CommonElements.getDayOfWeek((Long)d.get((ChronoElement)EpochDays.UTC) - (long)n3 + 1L);
            int n4 = weekday.getValue(((CalendarWeekElement)this.owner).model);
            int n5 = n4 <= 8 - ((CalendarWeekElement)this.owner).model.getMinimalDaysInFirstWeek() ? 2 - n4 : 9 - n4;
            switch (n) {
                case -1: {
                    n2 = 1;
                    break;
                }
                case 0: {
                    n2 = n3;
                    break;
                }
                case 1: {
                    n2 = (Integer)d.getMaximum(((CalendarWeekElement)this.owner).dayElement);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected: " + n));
                }
            }
            return MathUtils.floorDivide((int)(n2 - n5), (int)7) + 1;
        }

        private D setWeek(D d, int n) {
            int n2 = this.getWeek(d);
            if (n == n2) {
                return d;
            }
            int n3 = 7 * (n - n2);
            return (D)d.with((ChronoElement)EpochDays.UTC, (Long)d.get((ChronoElement)EpochDays.UTC) + (long)n3);
        }
    }

    private static class CWRule<D extends ChronoEntity<D>>
    implements ElementRule<D, Integer> {
        private final CalendarWeekElement<?> owner;

        private CWRule(CalendarWeekElement<?> calendarWeekElement) {
            this.owner = calendarWeekElement;
        }

        public Integer getValue(D d) {
            return this.getCalendarWeek(d);
        }

        public Integer getMinimum(D d) {
            return 1;
        }

        public Integer getMaximum(D d) {
            return this.getMaxCalendarWeek(d);
        }

        public boolean isValid(D d, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= 1 && n2 <= this.getMaxCalendarWeek(d);
        }

        public D withValue(D d, Integer n, boolean bl) {
            int n2 = n;
            if (!bl && !this.isValid(d, n)) {
                throw new IllegalArgumentException("Invalid value: " + n2 + " (context=" + d + ")");
            }
            return this.setCalendarWeek(d, n2);
        }

        public ChronoElement<?> getChildAtFloor(D d) {
            return new DayOfWeekElement(d.getClass(), ((CalendarWeekElement)this.owner).model);
        }

        public ChronoElement<?> getChildAtCeiling(D d) {
            return new DayOfWeekElement(d.getClass(), ((CalendarWeekElement)this.owner).model);
        }

        private int getMaxCalendarWeek(D d) {
            int n = d.getInt(((CalendarWeekElement)this.owner).dayElement);
            int n2 = this.getFirstCalendarWeekAsDay(d, 0);
            if (n2 <= n) {
                int n3 = this.getFirstCalendarWeekAsDay(d, 1) + this.getLengthOfYM(d, 0);
                if (n3 <= n) {
                    try {
                        int n4 = this.getFirstCalendarWeekAsDay(d, 1);
                        ChronoEntity chronoEntity = d.with((ChronoElement)EpochDays.UTC, (Long)d.get((ChronoElement)EpochDays.UTC) + 7L);
                        n3 = this.getFirstCalendarWeekAsDay(chronoEntity, 1) + this.getLengthOfYM(d, 1);
                        n2 = n4;
                    }
                    catch (RuntimeException runtimeException) {
                        n3 += 7;
                    }
                }
                return (n3 - n2) / 7;
            }
            int n5 = this.getFirstCalendarWeekAsDay(d, -1);
            return ((n2 += this.getLengthOfYM(d, -1)) - n5) / 7;
        }

        private int getFirstCalendarWeekAsDay(D d, int n) {
            Weekmodel weekmodel;
            Weekday weekday = this.getWeekdayStart(d, n);
            int n2 = weekday.getValue(weekmodel = ((CalendarWeekElement)this.owner).model);
            return n2 <= 8 - weekmodel.getMinimalDaysInFirstWeek() ? 2 - n2 : 9 - n2;
        }

        private Weekday getWeekdayStart(D d, int n) {
            int n2 = d.getInt(((CalendarWeekElement)this.owner).dayElement);
            switch (n) {
                case -1: {
                    long l = (Long)d.get((ChronoElement)EpochDays.UTC) - (long)n2;
                    int n3 = d.with((ChronoElement)EpochDays.UTC, l).getInt(((CalendarWeekElement)this.owner).dayElement);
                    return CommonElements.getDayOfWeek(l - (long)n3 + 1L);
                }
                case 0: {
                    return CommonElements.getDayOfWeek((Long)d.get((ChronoElement)EpochDays.UTC) - (long)n2 + 1L);
                }
                case 1: {
                    int n4 = CommonElements.getMax(((CalendarWeekElement)this.owner).dayElement, d);
                    return CommonElements.getDayOfWeek((Long)d.get((ChronoElement)EpochDays.UTC) + (long)n4 + 1L - (long)n2);
                }
            }
            throw new AssertionError((Object)("Unexpected: " + n));
        }

        private int getLengthOfYM(D d, int n) {
            int n2 = d.getInt(((CalendarWeekElement)this.owner).dayElement);
            switch (n) {
                case -1: {
                    return CommonElements.getMax(((CalendarWeekElement)this.owner).dayElement, d.with((ChronoElement)EpochDays.UTC, (Long)d.get((ChronoElement)EpochDays.UTC) - (long)n2));
                }
                case 0: {
                    return CommonElements.getMax(((CalendarWeekElement)this.owner).dayElement, d);
                }
                case 1: {
                    int n3 = CommonElements.getMax(((CalendarWeekElement)this.owner).dayElement, d);
                    return CommonElements.getMax(((CalendarWeekElement)this.owner).dayElement, d.with((ChronoElement)EpochDays.UTC, (Long)d.get((ChronoElement)EpochDays.UTC) + (long)n3 + 1L - (long)n2));
                }
            }
            throw new AssertionError((Object)("Unexpected: " + n));
        }

        private int getCalendarWeek(D d) {
            int n = d.getInt(((CalendarWeekElement)this.owner).dayElement);
            int n2 = this.getFirstCalendarWeekAsDay(d, 0);
            if (n2 <= n) {
                int n3 = this.getFirstCalendarWeekAsDay(d, 1) + this.getLengthOfYM(d, 0);
                if (n3 <= n) {
                    return 1;
                }
                return (n - n2) / 7 + 1;
            }
            int n4 = this.getFirstCalendarWeekAsDay(d, -1);
            int n5 = n + this.getLengthOfYM(d, -1);
            return (n5 - n4) / 7 + 1;
        }

        private D setCalendarWeek(D d, int n) {
            int n2 = this.getCalendarWeek(d);
            if (n == n2) {
                return d;
            }
            return (D)d.with((ChronoElement)EpochDays.UTC, (Long)d.get((ChronoElement)EpochDays.UTC) + (long)(7 * (n - n2)));
        }
    }

    private static class CalendarWeekElement<T extends ChronoEntity<T>>
    extends StdIntegerDateElement<T> {
        private static final long serialVersionUID = -7471192143785466686L;
        private final Weekmodel model;
        private final ChronoElement<Integer> dayElement;
        private final boolean bounded;

        CalendarWeekElement(String string, Class<T> clazz, int n, int n2, char c, Weekmodel weekmodel, ChronoElement<Integer> chronoElement, boolean bl) {
            super(string, clazz, n, n2, c);
            if (weekmodel == null) {
                throw new NullPointerException("Missing week model.");
            }
            this.model = weekmodel;
            this.dayElement = chronoElement;
            this.bounded = bl;
        }

        @Override
        public ChronoOperator<T> decremented() {
            return new DayOperator(-7);
        }

        @Override
        public ChronoOperator<T> incremented() {
            return new DayOperator(7);
        }

        public boolean isLenient() {
            return true;
        }

        @Override
        protected boolean doEquals(BasicElement<?> basicElement) {
            if (super.doEquals(basicElement)) {
                CalendarWeekElement calendarWeekElement = (CalendarWeekElement)CalendarWeekElement.class.cast(basicElement);
                return this.model.equals((Object)calendarWeekElement.model) && this.bounded == calendarWeekElement.bounded;
            }
            return false;
        }

        protected <D extends ChronoEntity<D>> ElementRule<D, Integer> derive(Chronology<D> chronology) {
            if (this.getChronoType().equals(chronology.getChronoType())) {
                return this.bounded ? new BWRule(this) : new CWRule(this);
            }
            return null;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return this;
        }
    }

    static class Weekengine
    implements ChronoExtension {
        private final Class<? extends ChronoEntity> chronoType;
        private final ChronoElement<Integer> dayOfMonthElement;
        private final ChronoElement<Integer> dayOfYearElement;
        private final Weekmodel defaultWeekmodel;

        Weekengine(Class<? extends ChronoEntity> clazz, ChronoElement<Integer> chronoElement, ChronoElement<Integer> chronoElement2, Weekmodel weekmodel) {
            this.chronoType = clazz;
            this.dayOfMonthElement = chronoElement;
            this.dayOfYearElement = chronoElement2;
            this.defaultWeekmodel = weekmodel;
        }

        public boolean accept(Class<?> clazz) {
            return this.chronoType.equals(clazz);
        }

        public Set<ChronoElement<?>> getElements(Locale locale, AttributeQuery attributeQuery) {
            Weekmodel weekmodel = FormatUtils.useDefaultWeekmodel((Locale)locale) ? this.defaultWeekmodel : Weekmodel.of((Locale)locale);
            HashSet<StdDateElement> hashSet = new HashSet<StdDateElement>();
            hashSet.add(new DayOfWeekElement<ChronoEntity>(this.chronoType, weekmodel));
            hashSet.add(new CalendarWeekElement<ChronoEntity>("WEEK_OF_MONTH", this.chronoType, 1, 5, 'W', weekmodel, this.dayOfMonthElement, false));
            hashSet.add(new CalendarWeekElement<ChronoEntity>("WEEK_OF_YEAR", this.chronoType, 1, 52, 'w', weekmodel, this.dayOfYearElement, false));
            hashSet.add(new CalendarWeekElement<ChronoEntity>("BOUNDED_WEEK_OF_MONTH", this.chronoType, 1, 5, '\u0000', weekmodel, this.dayOfMonthElement, true));
            hashSet.add(new CalendarWeekElement<ChronoEntity>("BOUNDED_WEEK_OF_YEAR", this.chronoType, 1, 52, '\u0000', weekmodel, this.dayOfYearElement, true));
            return Collections.unmodifiableSet(hashSet);
        }

        public ChronoEntity<?> resolve(ChronoEntity<?> chronoEntity, Locale locale, AttributeQuery attributeQuery) {
            return chronoEntity;
        }

        public boolean canResolve(ChronoElement<?> chronoElement) {
            return false;
        }
    }
}

