/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.CopticEra;
import net.time4j.calendar.CopticMonth;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.WeekdayRule;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="coptic")
public final class CopticCalendar
extends Calendrical<Unit, CopticCalendar>
implements LocalizedPatternSupport {
    private static final long DIOCLETIAN;
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    @FormattableElement(format="G")
    public static final ChronoElement<CopticEra> ERA;
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, CopticCalendar> YEAR_OF_ERA;
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<CopticMonth, CopticCalendar> MONTH_OF_YEAR;
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, CopticCalendar> DAY_OF_MONTH;
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, CopticCalendar> DAY_OF_YEAR;
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, CopticCalendar> DAY_OF_WEEK;
    private static final WeekdayInMonthElement<CopticCalendar> WIM_ELEMENT;
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<CopticCalendar> WEEKDAY_IN_MONTH;
    private static final EraYearMonthDaySystem<CopticCalendar> CALSYS;
    private static final TimeAxis<Unit, CopticCalendar> ENGINE;
    private static final long serialVersionUID = -8248846000788617742L;
    private final transient int cyear;
    private final transient int cmonth;
    private final transient int cdom;

    private CopticCalendar(int n, int n2, int n3) {
        this.cyear = n;
        this.cmonth = n2;
        this.cdom = n3;
    }

    public static CopticCalendar of(int n, CopticMonth copticMonth, int n2) {
        return CopticCalendar.of(n, copticMonth.getValue(), n2);
    }

    public static CopticCalendar of(int n, int n2, int n3) {
        if (!CALSYS.isValid(CopticEra.ANNO_MARTYRUM, n, n2, n3)) {
            throw new IllegalArgumentException("Invalid Coptic date: year=" + n + ", month=" + n2 + ", day=" + n3);
        }
        return new CopticCalendar(n, n2, n3);
    }

    public static CopticCalendar nowInSystemTime() {
        return (CopticCalendar)SystemClock.inLocalView().now(CopticCalendar.axis());
    }

    public CopticEra getEra() {
        return CopticEra.ANNO_MARTYRUM;
    }

    public int getYear() {
        return this.cyear;
    }

    public CopticMonth getMonth() {
        return CopticMonth.valueOf(this.cmonth);
    }

    public int getDayOfMonth() {
        return this.cdom;
    }

    public Weekday getDayOfWeek() {
        long l = CALSYS.transform((Object)this);
        return Weekday.valueOf((int)(MathUtils.floorModulo((long)(l + 5L), (int)7) + 1));
    }

    public int getDayOfYear() {
        return (Integer)this.get(DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, this.cyear, this.cmonth);
    }

    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    public boolean isLeapYear() {
        return this.cyear % 4 == 3;
    }

    public static boolean isValid(int n, int n2, int n3) {
        return CALSYS.isValid(CopticEra.ANNO_MARTYRUM, n, n2, n3);
    }

    public GeneralTimestamp<CopticCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of((Calendrical)this, (PlainTime)plainTime);
    }

    public GeneralTimestamp<CopticCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of((int)n, (int)n2));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CopticCalendar) {
            CopticCalendar copticCalendar = (CopticCalendar)((Object)object);
            return this.cdom == copticCalendar.cdom && this.cmonth == copticCalendar.cmonth && this.cyear == copticCalendar.cyear;
        }
        return false;
    }

    public int hashCode() {
        return 17 * this.cdom + 31 * this.cmonth + 37 * this.cyear;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("A.M.-");
        String string = String.valueOf(this.cyear);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (this.cmonth < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.cmonth);
        stringBuilder.append('-');
        if (this.cdom < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.cdom);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of((Weekday)Weekday.SATURDAY, (int)1, (Weekday)Weekday.FRIDAY, (Weekday)Weekday.SATURDAY);
    }

    public static TimeAxis<Unit, CopticCalendar> axis() {
        return ENGINE;
    }

    protected TimeAxis<Unit, CopticCalendar> getChronology() {
        return ENGINE;
    }

    protected CopticCalendar getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX((Object)this, 3);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        PlainDate plainDate = ChronoHistory.PROLEPTIC_JULIAN.convert(HistoricDate.of((HistoricEra)HistoricEra.AD, (int)284, (int)8, (int)29));
        DIOCLETIAN = (Long)plainDate.get((ChronoElement)EpochDays.UTC);
        ERA = new StdEnumDateElement<CopticEra, CopticCalendar>("ERA", CopticCalendar.class, CopticEra.class, 'G');
        YEAR_OF_ERA = new StdIntegerDateElement<CopticCalendar>("YEAR_OF_ERA", CopticCalendar.class, 1, 9999, 'y', null, null);
        MONTH_OF_YEAR = new StdEnumDateElement<CopticMonth, CopticCalendar>("MONTH_OF_YEAR", CopticCalendar.class, CopticMonth.class, 'M');
        DAY_OF_MONTH = new StdIntegerDateElement<CopticCalendar>("DAY_OF_MONTH", CopticCalendar.class, 1, 30, 'd');
        DAY_OF_YEAR = new StdIntegerDateElement<CopticCalendar>("DAY_OF_YEAR", CopticCalendar.class, 1, 365, 'D');
        DAY_OF_WEEK = new StdWeekdayElement<CopticCalendar>(CopticCalendar.class, CopticCalendar.getDefaultWeekmodel());
        WIM_ELEMENT = new WeekdayInMonthElement<CopticCalendar>(CopticCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
        WEEKDAY_IN_MONTH = WIM_ELEMENT;
        CALSYS = new Transformer();
        plainDate = TimeAxis.Builder.setUp(Unit.class, CopticCalendar.class, (ChronoMerger)new Merger(), CALSYS).appendElement(ERA, (ElementRule)new EraRule()).appendElement(YEAR_OF_ERA, (ElementRule)new IntegerRule(0), (Object)Unit.YEARS).appendElement(MONTH_OF_YEAR, (ElementRule)new MonthRule(), (Object)Unit.MONTHS).appendElement(DAY_OF_MONTH, (ElementRule)new IntegerRule(2), (Object)Unit.DAYS).appendElement(DAY_OF_YEAR, (ElementRule)new IntegerRule(3), (Object)Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<CopticCalendar>(CopticCalendar.getDefaultWeekmodel(), copticCalendar -> CALSYS), (Object)Unit.DAYS).appendElement(WIM_ELEMENT, WeekdayInMonthElement.getRule(WIM_ELEMENT)).appendElement(CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<CopticCalendar>(CALSYS, DAY_OF_YEAR)).appendUnit((Object)Unit.YEARS, (UnitRule)new CopticUnitRule(Unit.YEARS), Unit.YEARS.getLength(), Collections.singleton(Unit.MONTHS)).appendUnit((Object)Unit.MONTHS, (UnitRule)new CopticUnitRule(Unit.MONTHS), Unit.MONTHS.getLength(), Collections.singleton(Unit.YEARS)).appendUnit((Object)Unit.WEEKS, (UnitRule)new CopticUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit((Object)Unit.DAYS, (UnitRule)new CopticUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS)).appendExtension((ChronoExtension)new CommonElements.Weekengine(CopticCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, CopticCalendar.getDefaultWeekmodel()));
        ENGINE = plainDate.build();
    }

    private static class CopticUnitRule
    implements UnitRule<CopticCalendar> {
        private final Unit unit;

        CopticUnitRule(Unit unit) {
            this.unit = unit;
        }

        public CopticCalendar addTo(CopticCalendar copticCalendar, long l) {
            switch (this.unit) {
                case YEARS: {
                    l = MathUtils.safeMultiply((long)l, (long)13L);
                }
                case MONTHS: {
                    long l2 = MathUtils.safeAdd((long)CopticUnitRule.ymValue(copticCalendar), (long)l);
                    int n = MathUtils.safeCast((long)MathUtils.floorDivide((long)l2, (int)13));
                    int n2 = MathUtils.floorModulo((long)l2, (int)13) + 1;
                    int n3 = Math.min(copticCalendar.cdom, CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, n, n2));
                    return CopticCalendar.of(n, n2, n3);
                }
                case WEEKS: {
                    l = MathUtils.safeMultiply((long)l, (long)7L);
                }
                case DAYS: {
                    long l3 = MathUtils.safeAdd((long)CALSYS.transform((Object)copticCalendar), (long)l);
                    return (CopticCalendar)((Object)CALSYS.transform(l3));
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        public long between(CopticCalendar copticCalendar, CopticCalendar copticCalendar2) {
            switch (this.unit) {
                case YEARS: {
                    return Unit.MONTHS.between(copticCalendar, copticCalendar2) / 13;
                }
                case MONTHS: {
                    long l = CopticUnitRule.ymValue(copticCalendar2) - CopticUnitRule.ymValue(copticCalendar);
                    if (l > 0L && copticCalendar2.cdom < copticCalendar.cdom) {
                        --l;
                    } else if (l < 0L && copticCalendar2.cdom > copticCalendar.cdom) {
                        ++l;
                    }
                    return l;
                }
                case WEEKS: {
                    return Unit.DAYS.between(copticCalendar, copticCalendar2) / 7;
                }
                case DAYS: {
                    return CALSYS.transform((Object)copticCalendar2) - CALSYS.transform((Object)copticCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static int ymValue(CopticCalendar copticCalendar) {
            return copticCalendar.cyear * 13 + copticCalendar.cmonth - 1;
        }
    }

    private static class Merger
    implements ChronoMerger<CopticCalendar> {
        private Merger() {
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("coptic", displayStyle, locale);
        }

        public CopticCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = (StartOfDay)attributeQuery.get(Attributes.START_OF_DAY, (Object)this.getDefaultStartOfDay());
            return (CopticCalendar)((Object)Moment.from((UnixTime)timeSource.currentTime()).toGeneralTimestamp((Chronology)ENGINE, tZID, startOfDay).toDate());
        }

        @Deprecated
        public CopticCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom(chronoEntity, attributeQuery, bl2, bl);
        }

        public CopticCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Missing Coptic year.");
                return null;
            }
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n2 = ((CopticMonth)((Object)chronoEntity.get(MONTH_OF_YEAR))).getValue();
                int n3 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n3 != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(CopticEra.ANNO_MARTYRUM, n, n2, n3)) {
                        return CopticCalendar.of(n, n2, n3);
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Coptic date.");
                }
            } else {
                int n4 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n4 != Integer.MIN_VALUE) {
                    if (n4 > 0) {
                        int n5 = 1;
                        int n6 = 0;
                        while (n5 <= 13) {
                            int n7 = CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, n, n5);
                            if (n4 > n6 + n7) {
                                ++n5;
                                n6 += n7;
                                continue;
                            }
                            return CopticCalendar.of(n, n5, n4 - n6);
                        }
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Coptic date.");
                }
            }
            return null;
        }

        public ChronoDisplay preformat(CopticCalendar copticCalendar, AttributeQuery attributeQuery) {
            return copticCalendar;
        }

        public Chronology<?> preparser() {
            return null;
        }

        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.EVENING;
        }

        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear() - 284;
        }
    }

    private static class EraRule
    implements ElementRule<CopticCalendar, CopticEra> {
        private EraRule() {
        }

        public CopticEra getValue(CopticCalendar copticCalendar) {
            return CopticEra.ANNO_MARTYRUM;
        }

        public CopticEra getMinimum(CopticCalendar copticCalendar) {
            return CopticEra.ANNO_MARTYRUM;
        }

        public CopticEra getMaximum(CopticCalendar copticCalendar) {
            return CopticEra.ANNO_MARTYRUM;
        }

        public boolean isValid(CopticCalendar copticCalendar, CopticEra copticEra) {
            return copticEra != null;
        }

        public CopticCalendar withValue(CopticCalendar copticCalendar, CopticEra copticEra, boolean bl) {
            if (copticEra == null) {
                throw new IllegalArgumentException("Missing era value.");
            }
            return copticCalendar;
        }

        public ChronoElement<?> getChildAtFloor(CopticCalendar copticCalendar) {
            return YEAR_OF_ERA;
        }

        public ChronoElement<?> getChildAtCeiling(CopticCalendar copticCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class MonthRule
    implements ElementRule<CopticCalendar, CopticMonth> {
        private MonthRule() {
        }

        public CopticMonth getValue(CopticCalendar copticCalendar) {
            return copticCalendar.getMonth();
        }

        public CopticMonth getMinimum(CopticCalendar copticCalendar) {
            return CopticMonth.TOUT;
        }

        public CopticMonth getMaximum(CopticCalendar copticCalendar) {
            return CopticMonth.NASIE;
        }

        public boolean isValid(CopticCalendar copticCalendar, CopticMonth copticMonth) {
            return copticMonth != null;
        }

        public CopticCalendar withValue(CopticCalendar copticCalendar, CopticMonth copticMonth, boolean bl) {
            if (copticMonth == null) {
                throw new IllegalArgumentException("Missing month.");
            }
            int n = copticMonth.getValue();
            int n2 = CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, copticCalendar.cyear, n);
            int n3 = Math.min(copticCalendar.cdom, n2);
            return new CopticCalendar(copticCalendar.cyear, n, n3);
        }

        public ChronoElement<?> getChildAtFloor(CopticCalendar copticCalendar) {
            return DAY_OF_MONTH;
        }

        public ChronoElement<?> getChildAtCeiling(CopticCalendar copticCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class IntegerRule
    implements ElementRule<CopticCalendar, Integer> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        public Integer getValue(CopticCalendar copticCalendar) {
            switch (this.index) {
                case 0: {
                    return copticCalendar.cyear;
                }
                case 2: {
                    return copticCalendar.cdom;
                }
                case 3: {
                    int n = 0;
                    for (int i = 1; i < copticCalendar.cmonth; ++i) {
                        n += CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, copticCalendar.cyear, i);
                    }
                    return n + copticCalendar.cdom;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public Integer getMinimum(CopticCalendar copticCalendar) {
            switch (this.index) {
                case 0: 
                case 2: 
                case 3: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public Integer getMaximum(CopticCalendar copticCalendar) {
            switch (this.index) {
                case 0: {
                    return 9999;
                }
                case 2: {
                    return CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, copticCalendar.cyear, copticCalendar.cmonth);
                }
                case 3: {
                    return CALSYS.getLengthOfYear(CopticEra.ANNO_MARTYRUM, copticCalendar.cyear);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public boolean isValid(CopticCalendar copticCalendar, Integer n) {
            if (n == null) {
                return false;
            }
            Integer n2 = this.getMinimum(copticCalendar);
            Integer n3 = this.getMaximum(copticCalendar);
            return n2.compareTo(n) <= 0 && n3.compareTo(n) >= 0;
        }

        public CopticCalendar withValue(CopticCalendar copticCalendar, Integer n, boolean bl) {
            if (!this.isValid(copticCalendar, n)) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            switch (this.index) {
                case 0: {
                    int n2 = n;
                    int n3 = CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, n2, copticCalendar.cmonth);
                    int n4 = Math.min(copticCalendar.cdom, n3);
                    return CopticCalendar.of(n2, copticCalendar.cmonth, n4);
                }
                case 2: {
                    return new CopticCalendar(copticCalendar.cyear, copticCalendar.cmonth, n);
                }
                case 3: {
                    int n5 = n - this.getValue(copticCalendar);
                    return (CopticCalendar)copticCalendar.plus(CalendarDays.of((long)n5));
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public ChronoElement<?> getChildAtFloor(CopticCalendar copticCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(CopticCalendar copticCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }
    }

    private static class Transformer
    implements EraYearMonthDaySystem<CopticCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            return calendarEra == CopticEra.ANNO_MARTYRUM && n >= 1 && n <= 9999 && n2 >= 1 && n2 <= 13 && n3 >= 1 && n3 <= this.getLengthOfMonth(calendarEra, n, n2);
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            if (calendarEra != CopticEra.ANNO_MARTYRUM) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n >= 1 && n <= 9999 && n2 >= 1 && n2 <= 13) {
                if (n2 <= 12) {
                    return 30;
                }
                return n % 4 == 3 ? 6 : 5;
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n + ", month=" + n2);
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            if (calendarEra != CopticEra.ANNO_MARTYRUM) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n >= 1 && n <= 9999) {
                return n % 4 == 3 ? 366 : 365;
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n);
        }

        public CopticCalendar transform(long l) {
            int n = MathUtils.safeCast((long)MathUtils.floorDivide((long)MathUtils.safeAdd((long)MathUtils.safeMultiply((long)4L, (long)MathUtils.safeSubtract((long)l, (long)DIOCLETIAN)), (long)1463L), (int)1461));
            int n2 = MathUtils.safeCast((long)this.transform(new CopticCalendar(n, 1, 1)));
            int n3 = 1 + MathUtils.safeCast((long)MathUtils.floorDivide((long)(l - (long)n2), (int)30));
            int n4 = MathUtils.safeCast((long)this.transform(new CopticCalendar(n, n3, 1)));
            int n5 = 1 + MathUtils.safeCast((long)MathUtils.safeSubtract((long)l, (long)n4));
            return CopticCalendar.of(n, n3, n5);
        }

        public long transform(CopticCalendar copticCalendar) {
            return DIOCLETIAN - 1L + (long)(365 * (copticCalendar.cyear - 1)) + (long)MathUtils.floorDivide((int)copticCalendar.cyear, (int)4) + (long)(30 * (copticCalendar.cmonth - 1)) + (long)copticCalendar.cdom;
        }

        public long getMinimumSinceUTC() {
            CopticCalendar copticCalendar = new CopticCalendar(1, 1, 1);
            return this.transform(copticCalendar);
        }

        public long getMaximumSinceUTC() {
            CopticCalendar copticCalendar = new CopticCalendar(9999, 13, 6);
            return this.transform(copticCalendar);
        }

        public List<CalendarEra> getEras() {
            CopticEra copticEra = CopticEra.ANNO_MARTYRUM;
            return Collections.singletonList(copticEra);
        }
    }

    public static enum Unit implements ChronoUnit
    {
        YEARS(3.15576E7),
        MONTHS(2592000.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        public double getLength() {
            return this.length;
        }

        public boolean isCalendrical() {
            return true;
        }

        public int between(CopticCalendar copticCalendar, CopticCalendar copticCalendar2) {
            return (int)copticCalendar.until((TimePoint)copticCalendar2, (Object)this);
        }
    }
}

