/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.calendar.EastAsianCalendar;
import net.time4j.calendar.EastAsianMonth;
import net.time4j.calendar.SolarTerm;
import net.time4j.calendar.astro.AstronomicalSeason;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.MoonPhase;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.EpochDays;
import net.time4j.tz.TZID;
import net.time4j.tz.ZonalOffset;

abstract class EastAsianCS<D extends EastAsianCalendar<?, D>>
implements CalendarSystem<D> {
    private static final long CALENDAR_REFORM_1645 = PlainDate.of((int)1645, (int)1, (int)28).getDaysSinceEpochUTC();
    private static final long MAX_LIMIT = PlainDate.of((int)3000, (int)1, (int)27).getDaysSinceEpochUTC();
    private static final long EPOCH_CHINESE = PlainDate.of((int)-2636, (int)2, (int)15).getDaysSinceEpochUTC();
    static final double MEAN_SYNODIC_MONTH = 29.530588861;
    static final double MEAN_TROPICAL_YEAR = 365.242189;

    EastAsianCS() {
    }

    public final D transform(long l) {
        int n;
        long l2 = this.winterOnOrBefore(l);
        long l3 = this.winterOnOrBefore(l2 + 370L);
        long l4 = this.newMoonOnOrAfter(l2 + 1L);
        long l5 = this.newMoonBefore(l3 + 1L);
        long l6 = this.newMoonBefore(l + 1L);
        boolean bl = EastAsianCS.lunations(l4, l5) == 12L;
        long l7 = EastAsianCS.lunations(l4, l6);
        if (bl && this.hasLeapMonth(l4, l6)) {
            --l7;
        }
        if ((n = (int)Math.floorMod(l7, 12L)) == 0) {
            n = 12;
        }
        long l8 = (long)Math.floor(1.5 - (double)n / 12.0 + (double)(l - EPOCH_CHINESE) / 365.242189);
        int n2 = (int)Math.floorDiv(l8 - 1L, 60L) + 1;
        int n3 = (int)Math.floorMod(l8, 60L);
        if (n3 == 0) {
            n3 = 60;
        }
        int n4 = (int)(l - l6 + 1L);
        EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(n);
        if (bl && this.hasNoMajorSolarTerm(l6) && !this.hasLeapMonth(l4, this.newMoonBefore(l6))) {
            eastAsianMonth = eastAsianMonth.withLeap();
        }
        return this.create(n2, n3, eastAsianMonth, n4, l);
    }

    public final long transform(D d) {
        return this.transform(((EastAsianCalendar)((Object)d)).getCycle(), ((EastAsianCalendar)((Object)d)).getYear().getNumber(), ((EastAsianCalendar)((Object)d)).getMonth(), ((EastAsianCalendar)((Object)d)).getDayOfMonth());
    }

    public long getMinimumSinceUTC() {
        return CALENDAR_REFORM_1645;
    }

    public final long getMaximumSinceUTC() {
        return MAX_LIMIT;
    }

    abstract D create(int var1, int var2, EastAsianMonth var3, int var4, long var5);

    abstract ZonalOffset getOffset(long var1);

    abstract int[] getLeapMonths();

    final int getLeapMonth(int n, int n2) {
        int n3;
        int[] nArray = this.getLeapMonths();
        int n4 = (n - 1) * 60 + n2 - 1;
        int n5 = 0;
        for (int i = 2 * ((n4 - nArray[0]) / 3); i < nArray.length; i += Math.max(2 * ((n4 - n3) / 3), 2)) {
            n3 = nArray[i];
            if (n3 < n4) {
                continue;
            }
            if (n3 > n4) break;
            n5 = nArray[i + 1];
            break;
        }
        return n5;
    }

    final long transform(int n, int n2, EastAsianMonth eastAsianMonth, int n3) {
        if (!this.isValid(n, n2, eastAsianMonth, n3)) {
            throw new IllegalArgumentException("Invalid date.");
        }
        return this.firstDayOfMonth(n, n2, eastAsianMonth) + (long)n3 - 1L;
    }

    boolean isValid(int n, int n2, EastAsianMonth eastAsianMonth, int n3) {
        if (n < 72 || n > 94 || n2 < 1 || n2 > 60 || n == 72 && n2 < 22 || n == 94 && n2 > 56 || n3 < 1 || n3 > 30 || eastAsianMonth == null || eastAsianMonth.isLeap() && eastAsianMonth.getNumber() != this.getLeapMonth(n, n2)) {
            return false;
        }
        if (n3 == 30) {
            long l = this.firstDayOfMonth(n, n2, eastAsianMonth);
            long l2 = this.newMoonOnOrAfter(l + 1L);
            return l2 - l == 30L;
        }
        return true;
    }

    final long newYear(int n, int n2) {
        long l = (long)Math.floor((double)EPOCH_CHINESE + ((double)((n - 1) * 60 + n2) - 0.5) * 365.242189);
        return this.newYearOnOrBefore(l);
    }

    final int getMajorSolarTerm(long l) {
        double d = JulianDay.ofEphemerisTime(this.midnight(l)).getValue();
        int n = (2 + (int)Math.floor(SolarTerm.solarLongitude(d) / 30.0)) % 12;
        return n == 0 ? 12 : n;
    }

    final boolean hasNoMajorSolarTerm(long l) {
        double d;
        int n;
        double d2 = JulianDay.ofEphemerisTime(this.midnight(l)).getValue();
        int n2 = (2 + (int)Math.floor(SolarTerm.solarLongitude(d2) / 30.0)) % 12;
        return n2 == (n = (2 + (int)Math.floor(SolarTerm.solarLongitude(d = JulianDay.ofEphemerisTime(this.midnight(this.newMoonOnOrAfter(l + 1L))).getValue()) / 30.0)) % 12);
    }

    final long newMoonOnOrAfter(long l) {
        Moment moment = MoonPhase.NEW_MOON.atOrAfter(this.midnight(l));
        return moment.toZonalTimestamp((TZID)this.getOffset(l)).toDate().getDaysSinceEpochUTC();
    }

    Moment midnight(long l) {
        return PlainDate.of((long)l, (EpochDays)EpochDays.UTC).atStartOfDay().at(this.getOffset(l));
    }

    private long newMoonBefore(long l) {
        Moment moment = MoonPhase.NEW_MOON.before(this.midnight(l));
        return moment.toZonalTimestamp((TZID)this.getOffset(l)).toDate().getDaysSinceEpochUTC();
    }

    private static long lunations(long l, long l2) {
        return Math.round((double)(l2 - l) / 29.530588861);
    }

    private long newYearInSui(long l) {
        long l2 = this.winterOnOrBefore(l);
        long l3 = this.winterOnOrBefore(l2 + 370L);
        long l4 = this.newMoonOnOrAfter(l2 + 1L);
        long l5 = this.newMoonOnOrAfter(l4 + 1L);
        long l6 = this.newMoonBefore(l3 + 1L);
        if (EastAsianCS.lunations(l4, l6) == 12L && (this.hasNoMajorSolarTerm(l4) || this.hasNoMajorSolarTerm(l5))) {
            return this.newMoonOnOrAfter(l5 + 1L);
        }
        return l5;
    }

    private long newYearOnOrBefore(long l) {
        long l2 = this.newYearInSui(l);
        if (l >= l2) {
            return l2;
        }
        return this.newYearInSui(l - 180L);
    }

    private boolean hasLeapMonth(long l, long l2) {
        return l2 >= l && (this.hasNoMajorSolarTerm(l2) || this.hasLeapMonth(l, this.newMoonBefore(l2)));
    }

    private long firstDayOfMonth(int n, int n2, EastAsianMonth eastAsianMonth) {
        long l = this.newYear(n, n2);
        long l2 = this.newMoonOnOrAfter(l + (long)((eastAsianMonth.getNumber() - 1) * 29));
        if (eastAsianMonth.equals(((EastAsianCalendar)((Object)this.transform(l2))).getMonth())) {
            return l2;
        }
        return this.newMoonOnOrAfter(l2 + 1L);
    }

    private long winterOnOrBefore(long l) {
        ZonalOffset zonalOffset = this.getOffset(l);
        PlainDate plainDate = PlainDate.of((long)l, (EpochDays)EpochDays.UTC);
        int n = plainDate.getMonth() <= 11 || plainDate.getDayOfMonth() <= 15 ? plainDate.getYear() - 1 : plainDate.getYear();
        Moment moment = AstronomicalSeason.WINTER_SOLSTICE.inYear(n);
        PlainDate plainDate2 = moment.toZonalTimestamp((TZID)zonalOffset).getCalendarDate();
        if (plainDate2.isAfter((CalendarDate)plainDate)) {
            moment = AstronomicalSeason.WINTER_SOLSTICE.inYear(n - 1);
            plainDate2 = moment.toZonalTimestamp((TZID)zonalOffset).getCalendarDate();
        }
        return plainDate2.getDaysSinceEpochUTC();
    }
}

