/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.base.MathUtils;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.CyclicYear;
import net.time4j.calendar.EastAsianCS;
import net.time4j.calendar.EastAsianMonth;
import net.time4j.calendar.EastAsianST;
import net.time4j.calendar.SolarTerm;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ElementRule;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.UnitRule;
import net.time4j.format.CalendarType;

public abstract class EastAsianCalendar<U, D extends EastAsianCalendar<U, D>>
extends Calendrical<U, D> {
    static final int DAY_OF_MONTH_INDEX = 0;
    static final int DAY_OF_YEAR_INDEX = 1;
    static final int MONTH_AS_ORDINAL_INDEX = 2;
    static final int CYCLE_INDEX = 3;
    static final int UNIT_CYCLES = 0;
    static final int UNIT_YEARS = 1;
    static final int UNIT_MONTHS = 2;
    static final int UNIT_WEEKS = 3;
    static final int UNIT_DAYS = 4;
    private final transient int cycle;
    private final transient int yearOfCycle;
    private final transient EastAsianMonth month;
    private final transient int dayOfMonth;
    private final transient long utcDays;
    private final transient int leapMonth;

    EastAsianCalendar(int n, int n2, EastAsianMonth eastAsianMonth, int n3, long l) {
        this.cycle = n;
        this.yearOfCycle = n2;
        this.month = eastAsianMonth;
        this.dayOfMonth = n3;
        this.utcDays = l;
        this.leapMonth = this.getCalendarSystem().getLeapMonth(n, n2);
    }

    public CyclicYear getYear() {
        return CyclicYear.of(this.yearOfCycle);
    }

    public SolarTerm getSolarTerm() {
        return EastAsianST.getInstance().getValue((EastAsianCalendar)this.getContext());
    }

    public EastAsianMonth getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public Weekday getDayOfWeek() {
        return Weekday.valueOf((int)(MathUtils.floorModulo((long)(this.utcDays + 5L), (int)7) + 1));
    }

    public int getDayOfYear() {
        return (int)(this.utcDays - this.getCalendarSystem().newYear(this.cycle, this.yearOfCycle) + 1L);
    }

    public boolean isLeapYear() {
        return this.leapMonth > 0;
    }

    public int lengthOfMonth() {
        long l = this.getCalendarSystem().newMoonOnOrAfter(this.utcDays + 1L);
        return (int)((long)this.dayOfMonth + l - this.utcDays - 1L);
    }

    public int lengthOfYear() {
        int n = this.cycle;
        int n2 = this.yearOfCycle;
        if (++n2 > 60) {
            n2 = 1;
            ++n;
        }
        long l = this.getCalendarSystem().newYear(this.cycle, this.yearOfCycle);
        long l2 = this.getCalendarSystem().newYear(n, n2);
        return (int)(l2 - l);
    }

    public GeneralTimestamp<D> at(PlainTime plainTime) {
        return GeneralTimestamp.of((Calendrical)((Calendrical)this.getContext()), (PlainTime)plainTime);
    }

    public GeneralTimestamp<D> atTime(int n, int n2) {
        return this.at(PlainTime.of((int)n, (int)n2));
    }

    public long getDaysSinceEpochUTC() {
        return this.utcDays;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() == object.getClass()) {
            EastAsianCalendar eastAsianCalendar = (EastAsianCalendar)((Object)object);
            return this.cycle == eastAsianCalendar.cycle && this.yearOfCycle == eastAsianCalendar.yearOfCycle && this.dayOfMonth == eastAsianCalendar.dayOfMonth && this.month.equals(eastAsianCalendar.month) && this.utcDays == eastAsianCalendar.utcDays;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.utcDays);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = ((Object)((Object)this)).getClass().getAnnotation(CalendarType.class).value();
        stringBuilder.append(string.equals("dangi") ? "korean" : string);
        stringBuilder.append('[');
        stringBuilder.append(this.getYear().getDisplayName(Locale.ROOT));
        stringBuilder.append('(');
        stringBuilder.append(this.getInt(CommonElements.RELATED_GREGORIAN_YEAR));
        stringBuilder.append(")-");
        stringBuilder.append(this.month.toString());
        stringBuilder.append('-');
        if (this.dayOfMonth < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.dayOfMonth);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, Integer> getCycleRule(ChronoElement<?> chronoElement) {
        return new IntegerElementRule(3, chronoElement);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, CyclicYear> getYearOfCycleRule(ChronoElement<?> chronoElement) {
        return new CyclicYearRule(chronoElement, false);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, CyclicYear> getVietYearOfCycleRule(ChronoElement<?> chronoElement) {
        return new CyclicYearRule(chronoElement, true);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, EastAsianMonth> getMonthOfYearRule(ChronoElement<?> chronoElement) {
        return new MonthRule(chronoElement);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, Integer> getMonthAsOrdinalRule(ChronoElement<?> chronoElement) {
        return new IntegerElementRule(2, chronoElement);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, Integer> getDayOfMonthRule() {
        return new IntegerElementRule(0, null);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, Integer> getDayOfYearRule() {
        return new IntegerElementRule(1, null);
    }

    static <D extends EastAsianCalendar<?, D>> UnitRule<D> getUnitRule(int n) {
        return new EastAsianUnitRule(n);
    }

    int getCycle() {
        return this.cycle;
    }

    int getLeapMonth() {
        return this.leapMonth;
    }

    abstract EastAsianCS<D> getCalendarSystem();

    private static class EastAsianUnitRule<D extends EastAsianCalendar<?, D>>
    implements UnitRule<D> {
        private final int index;

        EastAsianUnitRule(int n) {
            this.index = n;
        }

        public D addTo(D d, long l) {
            EastAsianCS eastAsianCS = ((EastAsianCalendar)((Object)d)).getCalendarSystem();
            int n = ((EastAsianCalendar)((Object)d)).getDayOfMonth();
            int n2 = ((EastAsianCalendar)((Object)d)).getCycle();
            int n3 = ((EastAsianCalendar)((Object)d)).getYear().getNumber();
            EastAsianMonth eastAsianMonth = ((EastAsianCalendar)((Object)d)).getMonth();
            switch (this.index) {
                case 0: {
                    l = MathUtils.safeMultiply((long)l, (long)60L);
                }
                case 1: {
                    long l2 = MathUtils.safeAdd((long)(n2 * 60 + n3 - 1), (long)l);
                    n2 = MathUtils.safeCast((long)MathUtils.floorDivide((long)l2, (int)60));
                    n3 = MathUtils.floorModulo((long)l2, (int)60) + 1;
                    if (eastAsianMonth.isLeap() && eastAsianCS.getLeapMonth(n2, n3) != eastAsianMonth.getNumber()) {
                        eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
                    }
                    return EastAsianUnitRule.create(n2, n3, eastAsianMonth, n, eastAsianCS);
                }
                case 2: {
                    EastAsianUnitRule.checkAmountOfMonths(l);
                    int n4 = l > 0L ? 1 : -1;
                    int n5 = eastAsianMonth.getNumber();
                    boolean bl = eastAsianMonth.isLeap();
                    int n6 = eastAsianCS.getLeapMonth(n2, n3);
                    while (l != 0L) {
                        if (bl) {
                            bl = false;
                            if (n4 == 1) {
                                ++n5;
                            }
                        } else if (n4 == 1 && n6 == n5) {
                            bl = true;
                        } else if (n4 == -1 && n6 == n5 - 1) {
                            bl = true;
                            --n5;
                        } else {
                            n5 += n4;
                        }
                        if (!bl) {
                            if (n5 == 13) {
                                n5 = 1;
                                if (++n3 == 61) {
                                    n3 = 1;
                                    ++n2;
                                }
                                n6 = eastAsianCS.getLeapMonth(n2, n3);
                            } else if (n5 == 0) {
                                n5 = 12;
                                if (--n3 == 0) {
                                    n3 = 60;
                                    --n2;
                                }
                                n6 = eastAsianCS.getLeapMonth(n2, n3);
                            }
                        }
                        l -= (long)n4;
                    }
                    eastAsianMonth = EastAsianMonth.valueOf(n5);
                    if (bl) {
                        eastAsianMonth = eastAsianMonth.withLeap();
                    }
                    return EastAsianUnitRule.create(n2, n3, eastAsianMonth, n, eastAsianCS);
                }
                case 3: {
                    l = MathUtils.safeMultiply((long)l, (long)7L);
                }
                case 4: {
                    long l3 = MathUtils.safeAdd((long)((EastAsianCalendar)((Object)d)).getDaysSinceEpochUTC(), (long)l);
                    return eastAsianCS.transform(l3);
                }
            }
            throw new UnsupportedOperationException();
        }

        public long between(D d, D d2) {
            return EastAsianUnitRule.between(d, d2, this.index);
        }

        private static <D extends EastAsianCalendar<?, D>> long between(D d, D d2, int n) {
            EastAsianCS<D> eastAsianCS = d.getCalendarSystem();
            switch (n) {
                case 0: {
                    return EastAsianUnitRule.between(d, d2, 1) / 60L;
                }
                case 1: {
                    int n2;
                    int n3 = d2.getCycle() * 60 + d2.getYear().getNumber() - d.getCycle() * 60 - d.getYear().getNumber();
                    if (n3 > 0) {
                        int n4 = d.getMonth().compareTo(d2.getMonth());
                        if (n4 > 0 || n4 == 0 && d.getDayOfMonth() > d2.getDayOfMonth()) {
                            --n3;
                        }
                    } else if (n3 < 0 && ((n2 = d.getMonth().compareTo(d2.getMonth())) < 0 || n2 == 0 && d.getDayOfMonth() < d2.getDayOfMonth())) {
                        ++n3;
                    }
                    return n3;
                }
                case 2: {
                    D d3 = d;
                    D d4 = d2;
                    boolean bl = false;
                    if (d.isAfter((CalendarDate)d2)) {
                        d3 = d2;
                        d4 = d;
                        bl = true;
                    }
                    int n5 = d3.getCycle();
                    int n6 = d3.getYear().getNumber();
                    EastAsianMonth eastAsianMonth = d3.getMonth();
                    int n7 = eastAsianMonth.getNumber();
                    boolean bl2 = eastAsianMonth.isLeap();
                    int n8 = eastAsianCS.getLeapMonth(n5, n6);
                    int n9 = 0;
                    while (n5 != d4.getCycle() || n6 != d4.getYear().getNumber() || !eastAsianMonth.equals(d4.getMonth())) {
                        if (bl2) {
                            bl2 = false;
                            ++n7;
                        } else if (n8 == n7) {
                            bl2 = true;
                        } else {
                            ++n7;
                        }
                        if (!bl2) {
                            if (n7 == 13) {
                                n7 = 1;
                                if (++n6 == 61) {
                                    n6 = 1;
                                    ++n5;
                                }
                                n8 = eastAsianCS.getLeapMonth(n5, n6);
                            } else if (n7 == 0) {
                                n7 = 12;
                                if (--n6 == 0) {
                                    n6 = 60;
                                    --n5;
                                }
                                n8 = eastAsianCS.getLeapMonth(n5, n6);
                            }
                        }
                        eastAsianMonth = EastAsianMonth.valueOf(n7);
                        if (bl2) {
                            eastAsianMonth = eastAsianMonth.withLeap();
                        }
                        ++n9;
                    }
                    if (n9 > 0 && d3.getDayOfMonth() > d4.getDayOfMonth()) {
                        --n9;
                    }
                    return bl ? -n9 : n9;
                }
                case 3: {
                    return (d2.getDaysSinceEpochUTC() - d.getDaysSinceEpochUTC()) / 7L;
                }
                case 4: {
                    return d2.getDaysSinceEpochUTC() - d.getDaysSinceEpochUTC();
                }
            }
            throw new UnsupportedOperationException();
        }

        private static <D extends EastAsianCalendar<?, D>> D create(int n, int n2, EastAsianMonth eastAsianMonth, int n3, EastAsianCS<D> eastAsianCS) {
            if (n3 <= 29) {
                long l = eastAsianCS.transform(n, n2, eastAsianMonth, n3);
                return eastAsianCS.create(n, n2, eastAsianMonth, n3, l);
            }
            long l = eastAsianCS.transform(n, n2, eastAsianMonth, 1);
            D d = eastAsianCS.transform(l);
            n3 = Math.min(n3, ((EastAsianCalendar)((Object)d)).lengthOfMonth());
            return eastAsianCS.create(n, n2, eastAsianMonth, n3, l + (long)n3 - 1L);
        }

        private static void checkAmountOfMonths(long l) {
            if (l > 1200L || l < -1200L) {
                throw new ArithmeticException("Month arithmetic limited to delta not greater than 1200.");
            }
        }
    }

    private static class MonthRule<D extends EastAsianCalendar<?, D>>
    implements ElementRule<D, EastAsianMonth> {
        private final ChronoElement<?> child;

        private MonthRule(ChronoElement<?> chronoElement) {
            this.child = chronoElement;
        }

        public EastAsianMonth getValue(D d) {
            return ((EastAsianCalendar)((Object)d)).getMonth();
        }

        public EastAsianMonth getMinimum(D d) {
            return EastAsianMonth.valueOf(1);
        }

        public EastAsianMonth getMaximum(D d) {
            return EastAsianMonth.valueOf(12);
        }

        public boolean isValid(D d, EastAsianMonth eastAsianMonth) {
            return eastAsianMonth != null && (!eastAsianMonth.isLeap() || eastAsianMonth.getNumber() == ((EastAsianCalendar)((Object)d)).getLeapMonth());
        }

        public D withValue(D d, EastAsianMonth eastAsianMonth, boolean bl) {
            if (this.isValid(d, eastAsianMonth)) {
                return MonthRule.withMonth(d, eastAsianMonth);
            }
            throw new IllegalArgumentException("Invalid month: " + eastAsianMonth);
        }

        public ChronoElement<?> getChildAtFloor(D d) {
            return this.child;
        }

        public ChronoElement<?> getChildAtCeiling(D d) {
            return this.child;
        }

        static <D extends EastAsianCalendar<?, D>> D withMonth(D d, EastAsianMonth eastAsianMonth) {
            EastAsianCS<D> eastAsianCS = d.getCalendarSystem();
            int n = d.getDayOfMonth();
            int n2 = d.getYear().getNumber();
            if (n <= 29) {
                long l = eastAsianCS.transform(d.getCycle(), n2, eastAsianMonth, n);
                return eastAsianCS.create(d.getCycle(), n2, eastAsianMonth, n, l);
            }
            long l = eastAsianCS.transform(d.getCycle(), n2, eastAsianMonth, 1);
            D d2 = eastAsianCS.transform(l);
            n = Math.min(n, ((EastAsianCalendar)((Object)d2)).lengthOfMonth());
            return eastAsianCS.create(d.getCycle(), n2, eastAsianMonth, n, l + (long)n - 1L);
        }
    }

    private static class CyclicYearRule<D extends EastAsianCalendar<?, D>>
    implements ElementRule<D, CyclicYear> {
        private final ChronoElement<?> child;
        private final boolean vietnam;

        private CyclicYearRule(ChronoElement<?> chronoElement, boolean bl) {
            this.child = chronoElement;
            this.vietnam = bl;
        }

        public CyclicYear getValue(D d) {
            return ((EastAsianCalendar)((Object)d)).getYear();
        }

        public CyclicYear getMinimum(D d) {
            if (this.vietnam) {
                return ((EastAsianCalendar)((Object)d)).getCycle() == 75 ? CyclicYear.of(10) : CyclicYear.of(1);
            }
            return ((EastAsianCalendar)((Object)d)).getCycle() == 72 ? CyclicYear.of(22) : CyclicYear.of(1);
        }

        public CyclicYear getMaximum(D d) {
            return ((EastAsianCalendar)((Object)d)).getCycle() == 94 ? CyclicYear.of(56) : CyclicYear.of(60);
        }

        public boolean isValid(D d, CyclicYear cyclicYear) {
            CyclicYear cyclicYear2 = this.getMinimum(d);
            CyclicYear cyclicYear3 = this.getMaximum(d);
            return cyclicYear != null && cyclicYear2.compareTo(cyclicYear) <= 0 && cyclicYear3.compareTo(cyclicYear) >= 0;
        }

        public D withValue(D d, CyclicYear cyclicYear, boolean bl) {
            if (this.isValid(d, cyclicYear)) {
                EastAsianCS eastAsianCS = ((EastAsianCalendar)((Object)d)).getCalendarSystem();
                int n = ((EastAsianCalendar)((Object)d)).getDayOfMonth();
                EastAsianMonth eastAsianMonth = ((EastAsianCalendar)((Object)d)).getMonth();
                int n2 = cyclicYear.getNumber();
                int n3 = ((EastAsianCalendar)((Object)d)).getCycle();
                if (eastAsianMonth.isLeap() && eastAsianMonth.getNumber() != eastAsianCS.getLeapMonth(n3, n2)) {
                    eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
                }
                if (n <= 29) {
                    long l = eastAsianCS.transform(n3, n2, eastAsianMonth, n);
                    return eastAsianCS.create(n3, n2, eastAsianMonth, n, l);
                }
                long l = eastAsianCS.transform(n3, n2, eastAsianMonth, 1);
                Object d2 = eastAsianCS.transform(l);
                n = Math.min(n, ((EastAsianCalendar)((Object)d2)).lengthOfMonth());
                return eastAsianCS.create(n3, n2, eastAsianMonth, n, l + (long)n - 1L);
            }
            throw new IllegalArgumentException("Invalid cyclic year: " + cyclicYear);
        }

        public ChronoElement<?> getChildAtFloor(D d) {
            return this.child;
        }

        public ChronoElement<?> getChildAtCeiling(D d) {
            return this.child;
        }
    }

    private static class IntegerElementRule<D extends EastAsianCalendar<?, D>>
    implements IntElementRule<D> {
        private final ChronoElement<?> child;
        private final int index;

        private IntegerElementRule(int n, ChronoElement<?> chronoElement) {
            this.index = n;
            this.child = chronoElement;
        }

        public int getInt(D d) {
            switch (this.index) {
                case 0: {
                    return ((EastAsianCalendar)((Object)d)).getDayOfMonth();
                }
                case 1: {
                    return ((EastAsianCalendar)((Object)d)).getDayOfYear();
                }
                case 2: {
                    int n = ((EastAsianCalendar)((Object)d)).getMonth().getNumber();
                    int n2 = ((EastAsianCalendar)((Object)d)).getLeapMonth();
                    if (n2 > 0 && n2 < n || ((EastAsianCalendar)((Object)d)).getMonth().isLeap()) {
                        ++n;
                    }
                    return n;
                }
                case 3: {
                    return ((EastAsianCalendar)((Object)d)).getCycle();
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public boolean isValid(D d, int n) {
            if (n < 1) {
                return false;
            }
            if (this.index == 0) {
                if (n > 30) {
                    return false;
                }
                if (n == 30) {
                    return ((EastAsianCalendar)((Object)d)).lengthOfMonth() == 30;
                }
                return true;
            }
            if (this.index == 1) {
                return n <= ((EastAsianCalendar)((Object)d)).lengthOfYear();
            }
            if (this.index == 2) {
                return n <= 12 || n == 13 && ((EastAsianCalendar)((Object)d)).getLeapMonth() > 0;
            }
            if (this.index == 3) {
                EastAsianCS eastAsianCS = ((EastAsianCalendar)((Object)d)).getCalendarSystem();
                int n2 = ((EastAsianCalendar)((Object)eastAsianCS.transform(eastAsianCS.getMinimumSinceUTC()))).getCycle();
                int n3 = ((EastAsianCalendar)((Object)eastAsianCS.transform(eastAsianCS.getMaximumSinceUTC()))).getCycle();
                return n >= n2 && n <= n3;
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public D withValue(D d, int n, boolean bl) {
            switch (this.index) {
                case 0: {
                    if (bl) {
                        long l = ((EastAsianCalendar)((Object)d)).getDaysSinceEpochUTC() + (long)n - (long)((EastAsianCalendar)((Object)d)).getDayOfMonth();
                        return ((EastAsianCalendar)((Object)d)).getCalendarSystem().transform(l);
                    }
                    if (n < 1 || n > 30 || n == 30 && ((EastAsianCalendar)((Object)d)).lengthOfMonth() < 30) {
                        throw new IllegalArgumentException("Day of month out of range: " + n);
                    }
                    long l = ((EastAsianCalendar)((Object)d)).getDaysSinceEpochUTC() + (long)n - (long)((EastAsianCalendar)((Object)d)).getDayOfMonth();
                    return ((EastAsianCalendar)((Object)d)).getCalendarSystem().create(((EastAsianCalendar)((Object)d)).getCycle(), ((EastAsianCalendar)((Object)d)).getYear().getNumber(), ((EastAsianCalendar)((Object)d)).getMonth(), n, l);
                }
                case 1: {
                    if (!(bl || n >= 1 && n <= ((EastAsianCalendar)((Object)d)).lengthOfYear())) {
                        throw new IllegalArgumentException("Day of year out of range: " + n);
                    }
                    long l = ((EastAsianCalendar)((Object)d)).getDaysSinceEpochUTC() + (long)n - (long)((EastAsianCalendar)((Object)d)).getDayOfYear();
                    return ((EastAsianCalendar)((Object)d)).getCalendarSystem().transform(l);
                }
                case 2: {
                    if (this.isValid(d, n)) {
                        int n2 = ((EastAsianCalendar)((Object)d)).getLeapMonth();
                        boolean bl2 = false;
                        if (n2 > 0 && n2 < n) {
                            if (n == n2 + 1) {
                                bl2 = true;
                            }
                            --n;
                        }
                        EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(n);
                        if (bl2) {
                            eastAsianMonth = eastAsianMonth.withLeap();
                        }
                        return MonthRule.withMonth(d, eastAsianMonth);
                    }
                    throw new IllegalArgumentException("Ordinal month out of range: " + n);
                }
                case 3: {
                    if (this.isValid(d, n)) {
                        int n3 = n - ((EastAsianCalendar)((Object)d)).getCycle();
                        UnitRule unitRule = EastAsianCalendar.getUnitRule(0);
                        return (D)((Object)((EastAsianCalendar)((Object)unitRule.addTo(d, (long)n3))));
                    }
                    throw new IllegalArgumentException("Sexagesimal cycle out of range: " + n);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public Integer getValue(D d) {
            return this.getInt(d);
        }

        public Integer getMinimum(D d) {
            if (this.index == 3) {
                EastAsianCS eastAsianCS = ((EastAsianCalendar)((Object)d)).getCalendarSystem();
                return ((EastAsianCalendar)((Object)eastAsianCS.transform(eastAsianCS.getMinimumSinceUTC()))).getCycle();
            }
            return 1;
        }

        public Integer getMaximum(D d) {
            int n;
            switch (this.index) {
                case 0: {
                    n = ((EastAsianCalendar)((Object)d)).lengthOfMonth();
                    break;
                }
                case 1: {
                    n = ((EastAsianCalendar)((Object)d)).lengthOfYear();
                    break;
                }
                case 2: {
                    n = ((EastAsianCalendar)((Object)d)).isLeapYear() ? 13 : 12;
                    break;
                }
                case 3: {
                    EastAsianCS eastAsianCS = ((EastAsianCalendar)((Object)d)).getCalendarSystem();
                    n = ((EastAsianCalendar)((Object)eastAsianCS.transform(eastAsianCS.getMaximumSinceUTC()))).getCycle();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown element index: " + this.index);
                }
            }
            return n;
        }

        public boolean isValid(D d, Integer n) {
            return n != null && this.isValid(d, (int)n);
        }

        public D withValue(D d, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing element value.");
            }
            return this.withValue(d, (int)n, bl);
        }

        public ChronoElement<?> getChildAtFloor(D d) {
            return this.child;
        }

        public ChronoElement<?> getChildAtCeiling(D d) {
            return this.child;
        }
    }
}

