/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Map;
import net.time4j.Month;
import net.time4j.calendar.EastAsianMonth;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.DualFormatElement;

class EastAsianME
implements TextElement<EastAsianMonth>,
Serializable {
    static final EastAsianME SINGLETON_EA = new EastAsianME();
    private static final long serialVersionUID = -5874268477318061153L;

    EastAsianME() {
    }

    public String name() {
        return "MONTH_OF_YEAR";
    }

    public Class<EastAsianMonth> getType() {
        return EastAsianMonth.class;
    }

    public char getSymbol() {
        return 'M';
    }

    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return ((EastAsianMonth)chronoDisplay.get((ChronoElement)this)).compareTo((EastAsianMonth)chronoDisplay2.get((ChronoElement)this));
    }

    public EastAsianMonth getDefaultMinimum() {
        return EastAsianMonth.valueOf(1);
    }

    public EastAsianMonth getDefaultMaximum() {
        return EastAsianMonth.valueOf(12);
    }

    public boolean isDateElement() {
        return true;
    }

    public boolean isTimeElement() {
        return false;
    }

    public boolean isLenient() {
        return false;
    }

    public String getDisplayName(Locale locale) {
        String string = "L_month";
        String string2 = (String)CalendarText.getIsoInstance((Locale)locale).getTextForms().get(string);
        return string2 == null ? this.name() : string2;
    }

    protected Object readResolve() throws ObjectStreamException {
        return SINGLETON_EA;
    }

    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
        Locale locale = (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT);
        EastAsianMonth eastAsianMonth = (EastAsianMonth)chronoDisplay.get((ChronoElement)this);
        if (attributeQuery.contains(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS)) {
            NumberSystem numberSystem = (NumberSystem)attributeQuery.get(Attributes.NUMBER_SYSTEM, (Object)NumberSystem.ARABIC);
            appendable.append(eastAsianMonth.getDisplayName(locale, numberSystem, attributeQuery));
        } else {
            TextWidth textWidth = (TextWidth)attributeQuery.get(Attributes.TEXT_WIDTH, (Object)TextWidth.WIDE);
            OutputContext outputContext = (OutputContext)attributeQuery.get(Attributes.OUTPUT_CONTEXT, (Object)OutputContext.FORMAT);
            TextAccessor textAccessor = eastAsianMonth.isLeap() ? CalendarText.getInstance((String)"chinese", (Locale)locale).getLeapMonths(textWidth, outputContext) : CalendarText.getInstance((String)"chinese", (Locale)locale).getStdMonths(textWidth, outputContext);
            appendable.append(textAccessor.print((Enum)Month.valueOf((int)eastAsianMonth.getNumber())));
        }
    }

    public EastAsianMonth parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        EastAsianMonth eastAsianMonth;
        Locale locale = (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT);
        int n = charSequence.length();
        int n2 = parsePosition.getIndex();
        if (n2 >= n) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        boolean bl = false;
        if (attributeQuery.contains(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS)) {
            Map map = CalendarText.getInstance((String)"generic", (Locale)locale).getTextForms();
            NumberSystem numberSystem = (NumberSystem)attributeQuery.get(Attributes.NUMBER_SYSTEM, (Object)NumberSystem.ARABIC);
            int n3 = n2;
            char c = ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf(numberSystem.getDigits().charAt(0)))).charValue();
            boolean bl2 = (Boolean)attributeQuery.get(EastAsianMonth.LEAP_MONTH_IS_TRAILING, (Object)"R".equals(map.get("leap-alignment")));
            char c2 = ((Character)attributeQuery.get(EastAsianMonth.LEAP_MONTH_INDICATOR, (Object)Character.valueOf(((String)map.get("leap-indicator")).charAt(0)))).charValue();
            if (!bl2 && charSequence.charAt(n3) == c2) {
                ++n3;
                bl = true;
            }
            if (numberSystem.isDecimal()) {
                while (n3 < n && charSequence.charAt(n3) == c) {
                    ++n3;
                }
            }
            int n4 = 0;
            block1: for (int i = 12; i >= 1 && n4 == 0; --i) {
                String string = EastAsianMonth.toNumeral(numberSystem, c, i);
                int n5 = string.length();
                int n6 = 0;
                while (n <= n3 + n6 || charSequence.charAt(n3 + n6) == string.charAt(n6)) {
                    if (n6 + 1 == n5) {
                        n4 = i;
                        n3 += n5;
                        continue block1;
                    }
                    ++n6;
                }
            }
            if (n4 == 0) {
                parsePosition.setErrorIndex(n2);
                return null;
            }
            if (bl2 && n > n3 && charSequence.charAt(n3) == c2) {
                ++n3;
                bl = true;
            }
            eastAsianMonth = EastAsianMonth.valueOf(n4);
            parsePosition.setIndex(n3);
        } else {
            TextWidth textWidth = (TextWidth)attributeQuery.get(Attributes.TEXT_WIDTH, (Object)TextWidth.WIDE);
            OutputContext outputContext = (OutputContext)attributeQuery.get(Attributes.OUTPUT_CONTEXT, (Object)OutputContext.FORMAT);
            TextAccessor textAccessor = CalendarText.getInstance((String)"chinese", (Locale)locale).getStdMonths(textWidth, outputContext);
            Month month = (Month)textAccessor.parse(charSequence, parsePosition, Month.class, attributeQuery);
            if (month == null) {
                parsePosition.setErrorIndex(-1);
                parsePosition.setIndex(n2);
                TextAccessor textAccessor2 = CalendarText.getInstance((String)"chinese", (Locale)locale).getLeapMonths(textWidth, outputContext);
                month = (Month)textAccessor2.parse(charSequence, parsePosition, Month.class, attributeQuery);
                if (month != null) {
                    bl = true;
                }
            }
            if (month == null) {
                parsePosition.setErrorIndex(n2);
                return null;
            }
            eastAsianMonth = EastAsianMonth.valueOf(month.getValue());
        }
        if (bl) {
            eastAsianMonth = eastAsianMonth.withLeap();
        }
        return eastAsianMonth;
    }
}

