/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.Moment;
import net.time4j.calendar.EastAsianCS;
import net.time4j.calendar.EastAsianCalendar;
import net.time4j.calendar.SolarTerm;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ElementRule;
import net.time4j.format.Attributes;
import net.time4j.format.TextElement;

class EastAsianST<D extends EastAsianCalendar<?, D>>
implements TextElement<SolarTerm>,
ElementRule<D, SolarTerm>,
Serializable {
    private static final EastAsianST SINGLETON = new EastAsianST();
    private static final long serialVersionUID = 4572549754637955194L;

    EastAsianST() {
    }

    static <D extends EastAsianCalendar<?, D>> EastAsianST<D> getInstance() {
        return SINGLETON;
    }

    public String name() {
        return "SOLAR_TERM";
    }

    public Class<SolarTerm> getType() {
        return SolarTerm.class;
    }

    public char getSymbol() {
        return '\u0000';
    }

    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return ((SolarTerm)((Object)chronoDisplay.get((ChronoElement)this))).compareTo((Enum)chronoDisplay2.get((ChronoElement)this));
    }

    public SolarTerm getDefaultMinimum() {
        return SolarTerm.MINOR_01_LICHUN_315;
    }

    public SolarTerm getDefaultMaximum() {
        return SolarTerm.MAJOR_12_DAHAN_300;
    }

    public boolean isDateElement() {
        return true;
    }

    public boolean isTimeElement() {
        return false;
    }

    public boolean isLenient() {
        return false;
    }

    public String getDisplayName(Locale locale) {
        String string = locale.getLanguage();
        if (string.equals("zh")) {
            return locale.getCountry().equals("TW") || locale.getScript().equals("Hant") ? "\u7bc0\u6c23" : "\u8282\u6c14";
        }
        if (string.equals("ko")) {
            return "\uc808\uae30";
        }
        if (string.equals("vi")) {
            return "ti\u1ebft kh\u00ed";
        }
        if (string.equals("ja")) {
            return "\u7bc0\u6c17";
        }
        if (string.isEmpty()) {
            return "jieqi";
        }
        return "ji\u00e9q\u00ec";
    }

    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
        Locale locale = (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT);
        SolarTerm solarTerm = (SolarTerm)((Object)chronoDisplay.get((ChronoElement)this));
        appendable.append(solarTerm.getDisplayName(locale));
    }

    public SolarTerm parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        Locale locale = (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT);
        int n = charSequence.length();
        int n2 = parsePosition.getIndex();
        if (n2 >= n) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        return SolarTerm.parse(charSequence, locale, parsePosition);
    }

    public SolarTerm getValue(D d) {
        Moment moment = ((EastAsianCalendar)((Object)d)).getCalendarSystem().midnight(((EastAsianCalendar)((Object)d)).getDaysSinceEpochUTC() + 1L);
        return SolarTerm.of(moment);
    }

    public SolarTerm getMinimum(D d) {
        EastAsianCS eastAsianCS = ((EastAsianCalendar)((Object)d)).getCalendarSystem();
        long l = eastAsianCS.newYear(((EastAsianCalendar)((Object)d)).getCycle(), ((EastAsianCalendar)((Object)d)).getYear().getNumber());
        return SolarTerm.of(eastAsianCS.midnight(l + 1L));
    }

    public SolarTerm getMaximum(D d) {
        EastAsianCS eastAsianCS = ((EastAsianCalendar)((Object)d)).getCalendarSystem();
        long l = eastAsianCS.newYear(((EastAsianCalendar)((Object)d)).getCycle(), ((EastAsianCalendar)((Object)d)).getYear().getNumber());
        return SolarTerm.of(eastAsianCS.midnight(l + (long)((EastAsianCalendar)((Object)d)).lengthOfYear()));
    }

    public boolean isValid(D d, SolarTerm solarTerm) {
        return solarTerm != null;
    }

    public D withValue(D d, SolarTerm solarTerm, boolean bl) {
        if (solarTerm == null) {
            throw new IllegalArgumentException("Missing solar term.");
        }
        long l = ((EastAsianCalendar)((Object)d)).getCalendarSystem().newYear(((EastAsianCalendar)((Object)d)).getCycle(), ((EastAsianCalendar)((Object)d)).getYear().getNumber());
        return (D)((Object)solarTerm.onOrAfter((EastAsianCalendar)d.minus(CalendarDays.of((long)(((EastAsianCalendar)((Object)d)).getDaysSinceEpochUTC() - l)))));
    }

    public ChronoElement<?> getChildAtFloor(D d) {
        throw new AbstractMethodError();
    }

    public ChronoElement<?> getChildAtCeiling(D d) {
        throw new AbstractMethodError();
    }

    protected Object readResolve() throws ObjectStreamException {
        return SINGLETON;
    }
}

