/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import net.time4j.base.MathUtils;
import net.time4j.calendar.CyclicYear;

@FunctionalInterface
public interface EastAsianYear {
    public static EastAsianYear forGregorian(int n) {
        return () -> MathUtils.safeAdd((int)n, (int)2636);
    }

    public static EastAsianYear forMinguo(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Minguo year must not be smaller than 1: " + n);
        }
        return EastAsianYear.forGregorian(MathUtils.safeAdd((int)n, (int)1911));
    }

    public static EastAsianYear forDangi(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Dangi year must not be smaller than 1: " + n);
        }
        return EastAsianYear.forGregorian(MathUtils.safeAdd((int)n, (int)-2333));
    }

    public static EastAsianYear forJuche(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Juche year must not be smaller than 1: " + n);
        }
        return EastAsianYear.forGregorian(MathUtils.safeAdd((int)n, (int)1911));
    }

    default public int getCycle() {
        int n = this.getElapsedCyclicYears() + 1;
        return MathUtils.floorDivide((int)(n - 1), (int)60) + 1;
    }

    default public CyclicYear getYearOfCycle() {
        int n = this.getElapsedCyclicYears() + 1;
        int n2 = MathUtils.floorModulo((int)n, (int)60);
        if (n2 == 0) {
            n2 = 60;
        }
        return CyclicYear.of(n2);
    }

    public int getElapsedCyclicYears();
}

