/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.calendar.IndianCalendar;
import net.time4j.engine.ChronoCondition;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum IndianMonth implements ChronoCondition<IndianCalendar>
{
    CHAITRA,
    VAISHAKHA,
    JYESHTHA,
    ASHADHA,
    SHRAVANA,
    BHAADRA,
    ASHWIN,
    KARTIKA,
    AGRAHAYANA,
    PAUSHA,
    MAGHA,
    PHALGUNA;

    private static final IndianMonth[] ENUMS;

    public static IndianMonth valueOf(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return ENUMS[n - 1];
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        CalendarText calendarText = CalendarText.getInstance((String)"indian", (Locale)locale);
        return calendarText.getStdMonths(textWidth, outputContext).print((Enum)this);
    }

    public boolean test(IndianCalendar indianCalendar) {
        return indianCalendar.getMonth() == this;
    }

    static {
        ENUMS = IndianMonth.values();
    }
}

