/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.time4j.CalendarUnit;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.JucheEra;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.WeekdayRule;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="juche")
public final class JucheCalendar
extends Calendrical<CalendarUnit, JucheCalendar>
implements LocalizedPatternSupport {
    @FormattableElement(format="G")
    public static final ChronoElement<JucheEra> ERA = new StdEnumDateElement<JucheEra, JucheCalendar>("ERA", JucheCalendar.class, JucheEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, JucheCalendar> YEAR_OF_ERA = new StdIntegerDateElement<JucheCalendar>("YEAR_OF_ERA", JucheCalendar.class, 1, 999998088, 'y', null, null);
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<Month, JucheCalendar> MONTH_OF_YEAR = new StdEnumDateElement<Month, JucheCalendar>("MONTH_OF_YEAR", JucheCalendar.class, Month.class, 'M');
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, JucheCalendar> DAY_OF_MONTH = new StdIntegerDateElement<JucheCalendar>("DAY_OF_MONTH", JucheCalendar.class, 1, 31, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, JucheCalendar> DAY_OF_YEAR = new StdIntegerDateElement<JucheCalendar>("DAY_OF_YEAR", JucheCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, JucheCalendar> DAY_OF_WEEK = new StdWeekdayElement<JucheCalendar>(JucheCalendar.class, JucheCalendar.getDefaultWeekmodel());
    private static final WeekdayInMonthElement<JucheCalendar> WIM_ELEMENT = new WeekdayInMonthElement<JucheCalendar>(JucheCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<JucheCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    private static final Map<Object, ChronoElement<?>> CHILDREN;
    private static final EraYearMonthDaySystem<JucheCalendar> CALSYS;
    private static final TimeAxis<CalendarUnit, JucheCalendar> ENGINE;
    private static final long serialVersionUID = 757676060690932159L;
    private final PlainDate iso;

    JucheCalendar(PlainDate plainDate) {
        if (plainDate.getYear() < 1912) {
            throw new IllegalArgumentException("Juche calendar not valid before gregorian year 1912.");
        }
        this.iso = plainDate;
    }

    public static JucheCalendar of(int n, Month month, int n2) {
        return JucheCalendar.of(n, month.getValue(), n2);
    }

    public static JucheCalendar of(int n, int n2, int n3) {
        int n4 = JucheCalendar.toProlepticYear(n);
        PlainDate plainDate = PlainDate.of((int)n4, (int)n2, (int)n3);
        return new JucheCalendar(plainDate);
    }

    public static JucheCalendar nowInSystemTime() {
        return (JucheCalendar)SystemClock.inLocalView().now(JucheCalendar.axis());
    }

    public JucheEra getEra() {
        return JucheEra.JUCHE;
    }

    public int getYear() {
        return this.iso.getYear() - 1911;
    }

    public Month getMonth() {
        return Month.valueOf((int)this.iso.getMonth());
    }

    public int getDayOfMonth() {
        return this.iso.getDayOfMonth();
    }

    public Weekday getDayOfWeek() {
        return (Weekday)this.iso.get((ChronoElement)PlainDate.DAY_OF_WEEK);
    }

    public int getDayOfYear() {
        return this.iso.getInt((ChronoElement)PlainDate.DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return this.iso.lengthOfMonth();
    }

    public int lengthOfYear() {
        return this.iso.lengthOfYear();
    }

    public boolean isLeapYear() {
        return this.iso.isLeapYear();
    }

    public static boolean isValid(int n, int n2, int n3) {
        return CALSYS.isValid(JucheEra.JUCHE, n, n2, n3);
    }

    public GeneralTimestamp<JucheCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of((Calendrical)this, (PlainTime)plainTime);
    }

    public GeneralTimestamp<JucheCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of((int)n, (int)n2));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JucheCalendar) {
            JucheCalendar jucheCalendar = (JucheCalendar)((Object)object);
            return this.iso.equals((Object)jucheCalendar.iso);
        }
        return false;
    }

    public int hashCode() {
        return this.iso.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append((Object)this.getEra());
        stringBuilder.append('-');
        stringBuilder.append(this.getYear());
        stringBuilder.append('-');
        int n = this.getMonth().getValue();
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        stringBuilder.append('-');
        int n2 = this.getDayOfMonth();
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of((Locale)new Locale("ko", "KP"));
    }

    public static TimeAxis<CalendarUnit, JucheCalendar> axis() {
        return ENGINE;
    }

    protected TimeAxis<CalendarUnit, JucheCalendar> getChronology() {
        return ENGINE;
    }

    protected JucheCalendar getContext() {
        return this;
    }

    PlainDate toISO() {
        return this.iso;
    }

    private static int toProlepticYear(int n) {
        return MathUtils.safeAdd((int)n, (int)1911);
    }

    private static void registerUnits(TimeAxis.Builder<CalendarUnit, JucheCalendar> builder) {
        EnumSet<CalendarUnit> enumSet = EnumSet.range(CalendarUnit.MILLENNIA, CalendarUnit.MONTHS);
        EnumSet<CalendarUnit> enumSet2 = EnumSet.range(CalendarUnit.WEEKS, CalendarUnit.DAYS);
        for (CalendarUnit calendarUnit : CalendarUnit.values()) {
            builder.appendUnit((Object)calendarUnit, (UnitRule)new JucheUnitRule(calendarUnit), calendarUnit.getLength(), calendarUnit.compareTo((Enum)CalendarUnit.WEEKS) < 0 ? enumSet : enumSet2);
        }
    }

    private Object writeReplace() {
        return new SPX((Object)this, 17);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        HashMap<Object, StdCalendarElement<Integer, JucheCalendar>> hashMap = new HashMap<Object, StdCalendarElement<Integer, JucheCalendar>>();
        hashMap.put(ERA, YEAR_OF_ERA);
        hashMap.put(YEAR_OF_ERA, MONTH_OF_YEAR);
        hashMap.put(MONTH_OF_YEAR, DAY_OF_MONTH);
        CHILDREN = Collections.unmodifiableMap(hashMap);
        CALSYS = new Transformer();
        TimeAxis.Builder builder = TimeAxis.Builder.setUp(CalendarUnit.class, JucheCalendar.class, (ChronoMerger)new Merger(), CALSYS).appendElement(ERA, FieldRule.of(ERA)).appendElement(YEAR_OF_ERA, FieldRule.of(YEAR_OF_ERA), (Object)CalendarUnit.YEARS).appendElement(MONTH_OF_YEAR, FieldRule.of(MONTH_OF_YEAR), (Object)CalendarUnit.MONTHS).appendElement(CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<JucheCalendar>(CALSYS, DAY_OF_YEAR)).appendElement(DAY_OF_MONTH, FieldRule.of(DAY_OF_MONTH), (Object)CalendarUnit.DAYS).appendElement(DAY_OF_YEAR, FieldRule.of(DAY_OF_YEAR), (Object)CalendarUnit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<JucheCalendar>(JucheCalendar.getDefaultWeekmodel(), jucheCalendar -> CALSYS), (Object)CalendarUnit.DAYS).appendElement(WIM_ELEMENT, WeekdayInMonthElement.getRule(WIM_ELEMENT)).appendExtension((ChronoExtension)new CommonElements.Weekengine(JucheCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, JucheCalendar.getDefaultWeekmodel()));
        JucheCalendar.registerUnits((TimeAxis.Builder<CalendarUnit, JucheCalendar>)builder);
        ENGINE = builder.build();
    }

    private static class Merger
    implements ChronoMerger<JucheCalendar> {
        private Merger() {
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("roc", displayStyle, locale);
        }

        public JucheCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = (StartOfDay)attributeQuery.get(Attributes.START_OF_DAY, (Object)this.getDefaultStartOfDay());
            return (JucheCalendar)((Object)Moment.from((UnixTime)timeSource.currentTime()).toGeneralTimestamp((Chronology)ENGINE, tZID, startOfDay).toDate());
        }

        @Deprecated
        public JucheCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom(chronoEntity, attributeQuery, bl2, bl);
        }

        public JucheCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            if (chronoEntity.contains((ChronoElement)PlainDate.COMPONENT)) {
                return new JucheCalendar((PlainDate)chronoEntity.get((ChronoElement)PlainDate.COMPONENT));
            }
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Missing Juche year.");
                return null;
            }
            int n2 = JucheCalendar.toProlepticYear(n);
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n3 = ((Month)chronoEntity.get(MONTH_OF_YEAR)).getValue();
                int n4 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n4 != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(JucheEra.JUCHE, n, n3, n4)) {
                        return JucheCalendar.of(n, n3, n4);
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Juche date.");
                }
            } else {
                int n5 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n5 != Integer.MIN_VALUE) {
                    if (n5 > 0) {
                        int n6 = 1;
                        int n7 = 0;
                        while (n6 <= 12) {
                            int n8 = GregorianMath.getLengthOfMonth((int)n2, (int)n6);
                            if (n5 > n7 + n8) {
                                ++n6;
                                n7 += n8;
                                continue;
                            }
                            int n9 = n5 - n7;
                            return JucheCalendar.of(n, n6, n9);
                        }
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Juche date.");
                }
            }
            return null;
        }

        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear() - 1911;
        }
    }

    private static class JucheUnitRule
    implements UnitRule<JucheCalendar> {
        private final CalendarUnit unit;

        JucheUnitRule(CalendarUnit calendarUnit) {
            this.unit = calendarUnit;
        }

        public JucheCalendar addTo(JucheCalendar jucheCalendar, long l) {
            return new JucheCalendar(jucheCalendar.iso.plus(l, this.unit));
        }

        public long between(JucheCalendar jucheCalendar, JucheCalendar jucheCalendar2) {
            return this.unit.between((TimePoint)jucheCalendar.iso, (TimePoint)jucheCalendar2.iso);
        }
    }

    private static class FieldRule<V extends Comparable<V>>
    implements ElementRule<JucheCalendar, V> {
        private final ChronoElement<V> element;

        private FieldRule(ChronoElement<V> chronoElement) {
            this.element = chronoElement;
        }

        static <V extends Comparable<V>> FieldRule<V> of(ChronoElement<V> chronoElement) {
            return new FieldRule<V>(chronoElement);
        }

        public V getValue(JucheCalendar jucheCalendar) {
            Object object;
            if (this.element == ERA) {
                object = JucheEra.JUCHE;
            } else if (this.element.equals(YEAR_OF_ERA)) {
                object = jucheCalendar.getYear();
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = jucheCalendar.getMonth();
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = jucheCalendar.getDayOfMonth();
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = jucheCalendar.getDayOfYear();
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        public V getMinimum(JucheCalendar jucheCalendar) {
            Object object;
            if (this.element == ERA) {
                object = JucheEra.JUCHE;
            } else if (Integer.class.isAssignableFrom(this.element.getType())) {
                object = 1;
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = Month.JANUARY;
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        public V getMaximum(JucheCalendar jucheCalendar) {
            Object object;
            if (this.element == ERA) {
                object = JucheEra.JUCHE;
            } else if (this.element.equals(YEAR_OF_ERA)) {
                object = 999998088;
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = Month.DECEMBER;
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = jucheCalendar.iso.getMaximum((ChronoElement)PlainDate.DAY_OF_MONTH);
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = jucheCalendar.iso.getMaximum((ChronoElement)PlainDate.DAY_OF_YEAR);
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        public boolean isValid(JucheCalendar jucheCalendar, V v) {
            if (v == null) {
                return false;
            }
            if (this.element == ERA) {
                return true;
            }
            V v2 = this.getMinimum(jucheCalendar);
            V v3 = this.getMaximum(jucheCalendar);
            return v2.compareTo(v) <= 0 && v.compareTo(v3) <= 0;
        }

        public JucheCalendar withValue(JucheCalendar jucheCalendar, V v, boolean bl) {
            if (!this.isValid(jucheCalendar, v)) {
                throw new IllegalArgumentException("Out of range: " + v);
            }
            if (this.element == ERA) {
                return jucheCalendar;
            }
            if (this.element.equals(YEAR_OF_ERA)) {
                JucheCalendar jucheCalendar2 = JucheCalendar.of(FieldRule.toNumber(v), jucheCalendar.getMonth(), 1);
                return (JucheCalendar)jucheCalendar2.with(DAY_OF_MONTH, Math.min(jucheCalendar.getDayOfMonth(), jucheCalendar2.lengthOfMonth()));
            }
            if (this.element.equals(MONTH_OF_YEAR)) {
                PlainDate plainDate = (PlainDate)jucheCalendar.iso.with((ChronoElement)PlainDate.MONTH_OF_YEAR, Month.class.cast(v));
                return new JucheCalendar(plainDate);
            }
            if (this.element.equals(DAY_OF_MONTH)) {
                PlainDate plainDate = (PlainDate)jucheCalendar.iso.with((ChronoElement)PlainDate.DAY_OF_MONTH, FieldRule.toNumber(v));
                return new JucheCalendar(plainDate);
            }
            if (this.element.equals(DAY_OF_YEAR)) {
                PlainDate plainDate = (PlainDate)jucheCalendar.iso.with((ChronoElement)PlainDate.DAY_OF_YEAR, FieldRule.toNumber(v));
                return new JucheCalendar(plainDate);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        public ChronoElement<?> getChildAtFloor(JucheCalendar jucheCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        public ChronoElement<?> getChildAtCeiling(JucheCalendar jucheCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        private static int toNumber(Object object) {
            return (Integer)Integer.class.cast(object);
        }
    }

    private static class Transformer
    implements EraYearMonthDaySystem<JucheCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            try {
                if (calendarEra instanceof JucheEra) {
                    int n4 = JucheCalendar.toProlepticYear(n);
                    return n >= 1 && n4 <= 999999999 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= GregorianMath.getLengthOfMonth((int)n4, (int)n2);
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            try {
                int n3 = JucheCalendar.toProlepticYear(n);
                return PlainDate.of((int)n3, (int)n2, (int)1).lengthOfMonth();
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(runtimeException.getMessage(), runtimeException);
            }
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            try {
                int n2 = JucheCalendar.toProlepticYear(n);
                return PlainDate.of((int)n2, (Month)Month.JANUARY, (int)1).lengthOfYear();
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(runtimeException.getMessage(), runtimeException);
            }
        }

        public JucheCalendar transform(long l) {
            return new JucheCalendar(PlainDate.of((long)l, (EpochDays)EpochDays.UTC));
        }

        public long transform(JucheCalendar jucheCalendar) {
            return (Long)jucheCalendar.iso.get((ChronoElement)EpochDays.UTC);
        }

        public long getMinimumSinceUTC() {
            return -21915L;
        }

        public long getMaximumSinceUTC() {
            return PlainDate.axis().getCalendarSystem().getMaximumSinceUTC();
        }

        public List<CalendarEra> getEras() {
            return Collections.singletonList(JucheEra.JUCHE);
        }
    }
}

