/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.time4j.PlainDate;
import net.time4j.base.ResourceLoader;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.expert.Iso8601Format;

public final class Nengo
implements CalendarEra,
Serializable {
    private static final byte COURT_NORTHERN = 1;
    private static final byte COURT_STANDARD = 0;
    private static final byte COURT_SOUTHERN = -1;
    private static final String NEW_ERA_PROPERTY = "net.time4j.calendar.japanese.supplemental.era";
    private static final Nengo[] OFFICIAL_NENGOS;
    private static final Nengo[] NORTHERN_NENGOS;
    private static final Nengo NENGO_KENMU;
    private static final Nengo NENGO_OEI;
    private static final Map<String, Nengo> KANJI_TO_NENGO;
    private static final Map<String, Nengo> CHINESE_TO_NENGO;
    private static final TST KOREAN_TO_NENGO;
    private static final TST RUSSIAN_TO_NENGO;
    private static final TST ROMAJI_TO_NENGO;
    public static final Nengo MEIJI;
    public static final Nengo TAISHO;
    public static final Nengo SHOWA;
    public static final Nengo HEISEI;
    public static final Nengo NEWEST;
    public static final AttributeKey<Selector> SELECTOR;
    private static final String MEIJI_KEY = "meiji";
    private static final String TAISHO_KEY = "taisho";
    private static final String SHOWA_KEY = "showa";
    private static final String HEISEI_KEY = "heisei";
    private static final String[] MODERN_KEYS;
    private static final long serialVersionUID = 5696395761628504723L;
    private final transient int relgregyear;
    private final transient long start;
    private final transient String kanji;
    private final transient String chinese;
    private final transient String korean;
    private final transient String russian;
    private final transient String romaji;
    private final byte court;
    private final int index;

    private Nengo(int n, long l, String string, String string2, String string3, String string4, String string5, byte by, int n2) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Missing kanji.");
        }
        if (string5.isEmpty()) {
            throw new IllegalArgumentException("Missing latin transcription.");
        }
        if (by > 1 || by < -1) {
            throw new IllegalArgumentException("Undefined court byte: " + by);
        }
        this.relgregyear = n;
        this.start = l;
        this.kanji = string;
        this.chinese = string2;
        this.korean = string3;
        this.russian = string4;
        this.romaji = string5;
        this.court = by;
        this.index = n2;
    }

    public static Nengo ofRelatedGregorianYear(int n) {
        return Nengo.ofRelatedGregorianYear(n, Selector.OFFICIAL);
    }

    public static Nengo ofRelatedGregorianYear(int n, Selector selector) {
        Nengo nengo = null;
        if (n >= 701) {
            block0 : switch (selector) {
                case OFFICIAL: {
                    if (n >= 1873) {
                        return Nengo.ofRelatedGregorianYear(n, Selector.MODERN);
                    }
                    int n2 = 0;
                    int n3 = OFFICIAL_NENGOS.length - 1;
                    while (n2 <= n3) {
                        int n4 = n2 + n3 >> 1;
                        if (OFFICIAL_NENGOS[n4].getFirstRelatedGregorianYear() <= n) {
                            n2 = n4 + 1;
                            continue;
                        }
                        n3 = n4 - 1;
                    }
                    if (n2 == 0) break;
                    return OFFICIAL_NENGOS[n2 - 1];
                }
                case MODERN: {
                    int n5 = Nengo.getLowerBound(selector);
                    for (int i = OFFICIAL_NENGOS.length - 1; i >= n5; --i) {
                        Nengo nengo2 = OFFICIAL_NENGOS[i];
                        if (nengo2.relgregyear > n) continue;
                        nengo = nengo2;
                        break block0;
                    }
                    break;
                }
                case NORTHERN_COURT: {
                    if (n < 1332 || n > 1394) break;
                    for (int i = NORTHERN_NENGOS.length - 1; i >= 0; --i) {
                        Nengo nengo3 = NORTHERN_NENGOS[i];
                        if (nengo3.relgregyear > n) continue;
                        nengo = nengo3;
                        break block0;
                    }
                    break;
                }
                case SOUTHERN_COURT: {
                    if (n < 1334 || n > 1393) break;
                    int n6 = Nengo.NENGO_OEI.index - 1;
                    while (Nengo.OFFICIAL_NENGOS[n6].court == -1) {
                        Nengo nengo4 = OFFICIAL_NENGOS[n6];
                        if (nengo4.relgregyear <= n) {
                            nengo = nengo4;
                            break block0;
                        }
                        --n6;
                    }
                    break;
                }
                default: {
                    int n7 = Nengo.getLowerBound(selector);
                    int n8 = Nengo.getUpperBound(selector);
                    if (n < Nengo.OFFICIAL_NENGOS[n7].relgregyear || n > Nengo.OFFICIAL_NENGOS[n8 + 1].relgregyear) break;
                    for (int i = n8; i >= n7; --i) {
                        Nengo nengo5 = OFFICIAL_NENGOS[i];
                        if (nengo5.relgregyear > n) continue;
                        nengo = nengo5;
                        break block0;
                    }
                }
            }
        }
        if (nengo == null) {
            throw new IllegalArgumentException("Could not find nengo for year=" + n + ", selector=" + (Object)((Object)selector) + ".");
        }
        return nengo;
    }

    public static Nengo ofKanji(String string) {
        Nengo nengo = KANJI_TO_NENGO.get(string);
        if (nengo == null) {
            throw new IllegalArgumentException("Could not find any nengo for Japanese kanji: " + string);
        }
        return nengo;
    }

    public static List<Nengo> parseRomaji(String string) {
        String string2 = Nengo.hepburn(string, 0);
        String string3 = ROMAJI_TO_NENGO.longestPrefixOf(string2, 0);
        return ROMAJI_TO_NENGO.find(string3);
    }

    public static Stream<Nengo> stream() {
        return Nengo.stream(Selector.OFFICIAL);
    }

    public static Stream<Nengo> stream(Selector selector) {
        switch (selector) {
            case NORTHERN_COURT: {
                return Arrays.stream(NORTHERN_NENGOS);
            }
        }
        int n = Nengo.getLowerBound(selector);
        int n2 = Nengo.getUpperBound(selector);
        return Arrays.stream(OFFICIAL_NENGOS, n, n2 + 1);
    }

    public static List<Nengo> list() {
        return Nengo.list(Selector.OFFICIAL);
    }

    public static List<Nengo> list(Selector selector) {
        List<Nengo> list;
        switch (selector) {
            case OFFICIAL: {
                list = Arrays.asList(OFFICIAL_NENGOS);
                break;
            }
            case NORTHERN_COURT: {
                list = Arrays.asList(NORTHERN_NENGOS);
                break;
            }
            default: {
                int n = Nengo.getLowerBound(selector);
                int n2 = Nengo.getUpperBound(selector);
                list = new ArrayList<Nengo>(n2 - n + 1);
                for (int i = n; i <= n2; ++i) {
                    list.add(OFFICIAL_NENGOS[i]);
                }
            }
        }
        return Collections.unmodifiableList(list);
    }

    public boolean matches(Selector selector) {
        return selector.test(this);
    }

    public int getFirstRelatedGregorianYear() {
        return this.relgregyear;
    }

    public PlainDate getStart() {
        return PlainDate.of((long)this.start, (EpochDays)EpochDays.UTC);
    }

    public boolean isModern() {
        return this.index >= Nengo.MEIJI.index;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth) {
        if (locale.getLanguage().isEmpty()) {
            return this.romaji;
        }
        if (this.index >= Nengo.MEIJI.index && this.index <= Nengo.HEISEI.index && !locale.getLanguage().equals("ru")) {
            String string = this.equals(HEISEI) ? HEISEI_KEY : (this.equals(SHOWA) ? SHOWA_KEY : (this.equals(TAISHO) ? TAISHO_KEY : MEIJI_KEY));
            if (textWidth == TextWidth.NARROW) {
                string = string + "_n";
            }
            Map map = CalendarText.getInstance((String)"japanese", (Locale)locale).getTextForms();
            return (String)map.get(string);
        }
        switch (locale.getLanguage()) {
            case "ja": {
                return this.kanji;
            }
            case "zh": {
                return this.chinese;
            }
            case "ko": {
                return this.korean;
            }
            case "ru": {
                return "\u041f\u0435\u0440\u0438\u043e\u0434 " + this.russian;
            }
        }
        return this.romaji;
    }

    public Optional<Nengo> findNext() {
        if (this.court == 1) {
            if (this.index == NORTHERN_NENGOS.length - 1) {
                return Optional.of(NENGO_OEI);
            }
            return Optional.of(NORTHERN_NENGOS[this.index + 1]);
        }
        if (this.index == OFFICIAL_NENGOS.length - 1) {
            return Optional.empty();
        }
        return Optional.of(OFFICIAL_NENGOS[this.index + 1]);
    }

    public Optional<Nengo> findPrevious() {
        if (this.court == 1) {
            if (this.index == 0) {
                return Optional.of(OFFICIAL_NENGOS[Nengo.NENGO_KENMU.index - 1]);
            }
            return Optional.of(NORTHERN_NENGOS[this.index - 1]);
        }
        if (this.index == 0) {
            return Optional.empty();
        }
        return Optional.of(OFFICIAL_NENGOS[this.index - 1]);
    }

    public String name() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.romaji);
        stringBuilder.append(" (");
        Optional<Nengo> optional = this.findNext();
        if (optional.isPresent()) {
            stringBuilder.append(this.relgregyear);
            stringBuilder.append('-');
            stringBuilder.append(optional.get().relgregyear);
        } else {
            stringBuilder.append("since ");
            stringBuilder.append(this.relgregyear);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public int getValue() {
        if (this.matches(Selector.NORTHERN_COURT)) {
            return this.index - NORTHERN_NENGOS.length + Nengo.NENGO_OEI.index - Nengo.SHOWA.index + 1;
        }
        return this.index - Nengo.SHOWA.index + 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Nengo) {
            Nengo nengo = (Nengo)object;
            return this.relgregyear == nengo.relgregyear && this.start == nengo.start && this.kanji.equals(nengo.kanji) && this.romaji.equals(nengo.romaji) && this.court == nengo.court;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.start ^ this.start >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.romaji);
        stringBuilder.append(' ');
        stringBuilder.append(this.kanji);
        stringBuilder.append(' ');
        Optional<Nengo> optional = this.findNext();
        if (optional.isPresent()) {
            stringBuilder.append(this.relgregyear);
            stringBuilder.append('-');
            stringBuilder.append(optional.get().relgregyear);
        } else {
            stringBuilder.append("since ");
            stringBuilder.append(this.relgregyear);
        }
        if (this.court != 0) {
            stringBuilder.append(" (");
            stringBuilder.append(this.court == 1 ? (char)'N' : 'S');
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    long getStartAsDaysSinceEpochUTC() {
        return this.start;
    }

    int getIndexOfficial() {
        return this.index;
    }

    static Nengo ofIndexOfficial(int n) {
        return OFFICIAL_NENGOS[n];
    }

    static String hepburn(CharSequence charSequence, int n) {
        StringBuilder stringBuilder = null;
        int n2 = Math.min(charSequence.length(), n + 32);
        for (int i = n; i < n2; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (i == n) {
                c = c2 == '\u00d4' || c2 == '\u00f4' || c2 == '\u014d' ? (char)'\u014c' : (char)Character.toUpperCase(c2);
                c = c2 == '\u00db' || c2 == '\u00fb' || c2 == '\u016b' ? (char)'\u016a' : c;
            } else {
                c = c2 == '\u00d4' || c2 == '\u00f4' || c2 == '\u014c' ? (char)'\u014d' : (char)Character.toLowerCase(c2);
                c = c2 == '\u00db' || c2 == '\u00fb' || c2 == '\u016a' ? (char)'\u016b' : c;
            }
            c = c2 == '\'' ? (char)'\u2019' : c;
            char c3 = c = c2 == ' ' ? (char)'-' : c;
            if (stringBuilder == null && c == c2) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(32);
                stringBuilder.append(charSequence.subSequence(n, i));
            }
            stringBuilder.append(c);
        }
        return stringBuilder == null ? charSequence.subSequence(n, n2).toString() : stringBuilder.toString();
    }

    private static String capitalize(CharSequence charSequence, int n) {
        StringBuilder stringBuilder = null;
        int n2 = Math.min(charSequence.length(), n + 32);
        boolean bl = true;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            char c2 = bl ? Character.toUpperCase(c) : Character.toLowerCase(c);
            boolean bl2 = bl = c == ' ';
            if (stringBuilder == null && c2 == c) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(32);
                stringBuilder.append(charSequence.subSequence(n, i));
            }
            stringBuilder.append(c2);
        }
        return stringBuilder == null ? charSequence.subSequence(n, n2).toString() : stringBuilder.toString();
    }

    private static int getUpperBound(Selector selector) {
        switch (selector) {
            case EDO_PERIOD: {
                return Nengo.MEIJI.index - 1;
            }
            case AZUCHI_MOMOYAMA_PERIOD: {
                return 187;
            }
            case MUROMACHI_PERIOD: {
                return 184;
            }
            case NORTHERN_COURT: {
                return NORTHERN_NENGOS.length - 1;
            }
            case SOUTHERN_COURT: {
                return Nengo.NENGO_KENMU.index + 8;
            }
            case KAMAKURA_PERIOD: {
                return Nengo.NENGO_KENMU.index - 1;
            }
            case HEIAN_PERIOD: {
                return 102;
            }
            case NARA_PERIOD: {
                return 14;
            }
            case ASUKA_PERIOD: {
                return 2;
            }
        }
        return OFFICIAL_NENGOS.length - 1;
    }

    private static int getLowerBound(Selector selector) {
        switch (selector) {
            case MODERN: {
                return Nengo.MEIJI.index;
            }
            case EDO_PERIOD: {
                return 188;
            }
            case AZUCHI_MOMOYAMA_PERIOD: {
                return 185;
            }
            case MUROMACHI_PERIOD: {
                return Nengo.NENGO_KENMU.index + 1;
            }
            case SOUTHERN_COURT: {
                return Nengo.NENGO_KENMU.index;
            }
            case KAMAKURA_PERIOD: {
                return 103;
            }
            case HEIAN_PERIOD: {
                return 15;
            }
            case NARA_PERIOD: {
                return 3;
            }
        }
        return 0;
    }

    private static Nengo of(int n, boolean bl) {
        return bl ? NORTHERN_NENGOS[n] : OFFICIAL_NENGOS[n];
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            return Nengo.of(this.index, this.court == 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new StreamCorruptedException();
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    static {
        var0 = new ArrayList<Object>(256);
        var1_1 = new ArrayList<Object>(16);
        var2_2 = null;
        var3_3 = null;
        var4_4 = new HashMap<String, Object>();
        var5_5 = new HashMap<String, Object>();
        var6_6 = new TST();
        var7_7 = new TST();
        var8_8 = new TST();
        var9_9 = "data/nengo.data";
        var10_10 = ResourceLoader.getInstance().locate("calendar", Nengo.class, var9_9);
        var11_11 = ResourceLoader.getInstance().load(var10_10, true);
        try {
            if (var11_11 == null) {
                var11_11 = ResourceLoader.getInstance().load(Nengo.class, var9_9, true);
            }
            var12_12 = new DataInputStream(var11_11);
            block21: while (true) {
                var13_16 = var12_12.readShort();
                var14_18 = var12_12.readInt();
                var15_20 = var12_12.readUTF();
                var16_22 = var12_12.readUTF();
                var17_24 = var12_12.readUTF();
                var18_26 = var12_12.readUTF();
                var19_28 = var12_12.readByte();
                var20_30 = var12_12.readByte();
                var21_32 = new ArrayList<String>(var20_30);
                for (var22_35 = 0; var22_35 < var20_30; ++var22_35) {
                    var23_37 = var12_12.readUTF();
                    var21_32.add((String)var23_37);
                }
                var22_34 = (String)var21_32.get(0);
                if (var19_28 == 1) {
                    var23_37 = new Nengo(var13_16, var14_18, var15_20, var16_22, var17_24, var18_26, var22_34, var19_28, var1_1.size());
                    var1_1.add(var23_37);
                } else {
                    var23_37 = new Nengo(var13_16, var14_18, var15_20, var16_22, var17_24, var18_26, var22_34, var19_28, var0.size());
                    var0.add(var23_37);
                    if (var13_16 == 1334) {
                        var2_2 = var23_37;
                    } else if (var13_16 == 1394) {
                        var3_3 = var23_37;
                    }
                }
                if (var23_37.court == 1 && var23_37.relgregyear == 1334) continue;
                var4_4.put(var15_20, var23_37);
                if (var5_5.put(var16_22, var23_37) != null) {
                    throw new IllegalStateException(var23_37.relgregyear + " " + var23_37.chinese);
                }
                var6_6.insert(var17_24, (Nengo)var23_37);
                var7_7.insert(var18_26, (Nengo)var23_37);
                var24_39 = var21_32.iterator();
                while (true) {
                    if (var24_39.hasNext()) ** break;
                    continue block21;
                    var25_41 = (String)var24_39.next();
                    var8_8.insert(var25_41, (Nengo)var23_37);
                }
                break;
            }
        }
        catch (EOFException var12_13) {
        }
        catch (IOException var12_14) {
            throw new IllegalStateException("Invalid nengo data.", var12_14);
        }
        var12_15 = System.getProperty("net.time4j.calendar.japanese.supplemental.era");
        if (var12_15 != null) {
            var13_17 = var12_15.split(",");
            var14_19 = null;
            var15_21 = null;
            var16_23 = null;
            var17_25 = null;
            var18_27 = null;
            var19_29 = null;
            block24: for (String var23_38 : var13_17) {
                var24_40 = var23_38.split("=");
                if (var24_40.length != 2) continue;
                var25_42 = var24_40[0];
                var26_43 = -1;
                switch (var25_42.hashCode()) {
                    case 3373707: {
                        if (!var25_42.equals("name")) break;
                        var26_43 = 0;
                        break;
                    }
                    case 101815575: {
                        if (!var25_42.equals("kanji")) break;
                        var26_43 = 1;
                        break;
                    }
                    case 746330349: {
                        if (!var25_42.equals("chinese")) break;
                        var26_43 = 2;
                        break;
                    }
                    case -1125640956: {
                        if (!var25_42.equals("korean")) break;
                        var26_43 = 3;
                        break;
                    }
                    case 1555550099: {
                        if (!var25_42.equals("russian")) break;
                        var26_43 = 4;
                        break;
                    }
                    case 109441850: {
                        if (!var25_42.equals("since")) break;
                        var26_43 = 5;
                    }
                }
                switch (var26_43) {
                    case 0: {
                        var14_19 = Nengo.hepburn(var24_40[1], 0);
                        continue block24;
                    }
                    case 1: {
                        var15_21 = var24_40[1];
                        if (var15_21.length() == 2) continue block24;
                        throw new IllegalArgumentException("Japanese kanji must be of length 2.");
                    }
                    case 2: {
                        var16_23 = var24_40[1];
                        if (var16_23.length() == 2) continue block24;
                        throw new IllegalArgumentException("Chinese kanji must be of length 2.");
                    }
                    case 3: {
                        var17_25 = var24_40[1];
                        continue block24;
                    }
                    case 4: {
                        var18_27 = Nengo.capitalize(var24_40[1], 0);
                        continue block24;
                    }
                    case 5: {
                        try {
                            var19_29 = Iso8601Format.parseDate((CharSequence)var24_40[1]);
                            continue block24;
                        }
                        catch (ParseException var27_44) {
                            // empty catch block
                        }
                    }
                }
            }
            if (var14_19 != null && var15_21 != null && var19_29 != null) {
                if (var19_29.isBefore((CalendarDate)PlainDate.of((int)1989, (int)1, (int)9))) {
                    throw new IllegalStateException("New Japanese era must be after Heisei.");
                }
                if (var16_23 == null) {
                    var16_23 = var15_21;
                }
                if (var17_25 == null) {
                    var17_25 = var14_19;
                }
                if (var18_27 == null) {
                    var18_27 = var14_19;
                }
                var20_31 /* !! */  = new Nengo(var19_29.getYear(), var19_29.getDaysSinceEpochUTC(), var15_21, var16_23, var17_25, var18_27, var14_19, 0, var0.size());
                var0.add(var20_31 /* !! */ );
                var4_4.put(var15_21, var20_31 /* !! */ );
                var5_5.put(var16_23, var20_31 /* !! */ );
                var6_6.insert(var17_25, (Nengo)var20_31 /* !! */ );
                var7_7.insert(var18_27, (Nengo)var20_31 /* !! */ );
                var8_8.insert(var14_19, (Nengo)var20_31 /* !! */ );
            } else {
                throw new IllegalStateException("Invalid syntax: " + var12_15);
            }
        }
        Nengo.OFFICIAL_NENGOS = var0.toArray(new Nengo[var0.size()]);
        Nengo.NORTHERN_NENGOS = var1_1.toArray(new Nengo[var1_1.size()]);
        Nengo.NENGO_KENMU = var2_2;
        Nengo.NENGO_OEI = var3_3;
        Nengo.KANJI_TO_NENGO = Collections.unmodifiableMap(var4_4);
        Nengo.CHINESE_TO_NENGO = Collections.unmodifiableMap(var5_5);
        Nengo.KOREAN_TO_NENGO = var6_6;
        Nengo.RUSSIAN_TO_NENGO = var7_7;
        Nengo.ROMAJI_TO_NENGO = var8_8;
        Nengo.MEIJI = Nengo.OFFICIAL_NENGOS[223];
        Nengo.TAISHO = Nengo.OFFICIAL_NENGOS[224];
        Nengo.SHOWA = Nengo.OFFICIAL_NENGOS[225];
        Nengo.HEISEI = Nengo.OFFICIAL_NENGOS[226];
        Nengo.NEWEST = Nengo.OFFICIAL_NENGOS[Nengo.OFFICIAL_NENGOS.length - 1];
        Nengo.SELECTOR = Attributes.createKey((String)"NENGO_SELECTOR", Selector.class);
        Nengo.MODERN_KEYS = new String[]{"heisei", "showa", "taisho", "meiji"};
    }

    private static class Node {
        private char c = '\u0000';
        private Node left = null;
        private Node mid = null;
        private Node right = null;
        private List<Nengo> nengos = null;

        private Node() {
        }
    }

    private static class TST {
        private Node root = null;

        private TST() {
        }

        List<Nengo> find(String string) {
            if (string == null || string.length() == 0) {
                return Collections.emptyList();
            }
            Node node = TST.find(this.root, string, 0);
            if (node == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(node.nengos);
        }

        private static Node find(Node node, String string, int n) {
            if (node == null) {
                return null;
            }
            char c = string.charAt(n);
            if (c < node.c) {
                return TST.find(node.left, string, n);
            }
            if (c > node.c) {
                return TST.find(node.right, string, n);
            }
            if (n < string.length() - 1) {
                return TST.find(node.mid, string, n + 1);
            }
            return node;
        }

        void insert(String string, Nengo nengo) {
            if (string.isEmpty()) {
                throw new IllegalArgumentException("Empty key cannot be inserted.");
            }
            this.root = TST.insert(this.root, string, nengo, 0);
        }

        private static Node insert(Node node, String string, Nengo nengo, int n) {
            char c = string.charAt(n);
            if (node == null) {
                node = new Node();
                node.c = c;
            }
            if (c < node.c) {
                node.left = TST.insert(node.left, string, nengo, n);
            } else if (c > node.c) {
                node.right = TST.insert(node.right, string, nengo, n);
            } else if (n < string.length() - 1) {
                node.mid = TST.insert(node.mid, string, nengo, n + 1);
            } else {
                if (node.nengos == null) {
                    node.nengos = new ArrayList();
                }
                node.nengos.add(nengo);
            }
            return node;
        }

        String longestPrefixOf(CharSequence charSequence, int n) {
            int n2 = n;
            Node node = this.root;
            int n3 = n;
            int n4 = charSequence.length();
            while (node != null && n3 < n4) {
                char c = charSequence.charAt(n3);
                if (c < node.c) {
                    node = node.left;
                    continue;
                }
                if (c > node.c) {
                    node = node.right;
                    continue;
                }
                ++n3;
                if (node.nengos != null) {
                    n2 = n3;
                }
                node = node.mid;
            }
            return n >= n2 ? null : charSequence.subSequence(n, n2).toString();
        }
    }

    static class Element
    implements TextElement<Nengo>,
    Serializable {
        static final Element SINGLETON = new Element();
        private static final long serialVersionUID = -1099321098836107792L;

        private Element() {
        }

        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            Locale locale = (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT);
            TextWidth textWidth = (TextWidth)attributeQuery.get(Attributes.TEXT_WIDTH, (Object)TextWidth.WIDE);
            appendable.append(((Nengo)chronoDisplay.get((ChronoElement)this)).getDisplayName(locale, textWidth));
        }

        public Nengo parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            int n;
            Object object;
            Object object2;
            List<Nengo> list;
            Locale locale = (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT);
            TextWidth textWidth = (TextWidth)attributeQuery.get(Attributes.TEXT_WIDTH, (Object)TextWidth.WIDE);
            Map map = CalendarText.getInstance((String)"japanese", (Locale)locale).getTextForms();
            int n2 = parsePosition.getIndex();
            if (n2 >= charSequence.length()) {
                parsePosition.setErrorIndex(n2);
                return null;
            }
            String string = locale.getLanguage().equals("ru") ? Nengo.capitalize(charSequence, n2) : Nengo.hepburn(charSequence, n2);
            Nengo nengo3 = null;
            int n3 = 0;
            for (int i = 0; i < MODERN_KEYS.length; ++i) {
                String string2 = MODERN_KEYS[i];
                if (textWidth == TextWidth.NARROW) {
                    string2 = string2 + "_n";
                }
                if (!string.startsWith((String)((Object)(list = (String)map.get(string2))))) continue;
                switch (i) {
                    case 0: {
                        nengo3 = HEISEI;
                        break;
                    }
                    case 1: {
                        nengo3 = SHOWA;
                        break;
                    }
                    case 2: {
                        nengo3 = TAISHO;
                        break;
                    }
                    case 3: {
                        nengo3 = MEIJI;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                n3 = ((String)((Object)list)).length();
                if (textWidth == TextWidth.NARROW || nengo3 == SHOWA) break;
                parsePosition.setIndex(n2 + n3);
                return nengo3;
            }
            if (string.length() < 2) {
                if (nengo3 != null) {
                    parsePosition.setIndex(n2 + 1);
                }
                return nengo3;
            }
            String string3 = null;
            int n4 = 0;
            list = Collections.emptyList();
            switch (locale.getLanguage()) {
                case "ja": {
                    int n5 = string.length() >= 4 ? 4 : 2;
                    object2 = string.substring(0, n5);
                    object = (Nengo)KANJI_TO_NENGO.get(object2);
                    if (object == null && n5 == 4) {
                        object2 = string.substring(0, 2);
                        object = (Nengo)KANJI_TO_NENGO.get(object2);
                    }
                    if (object == null) break;
                    string3 = object2;
                    if (object == nengo3) {
                        nengo3 = null;
                    }
                    list = Collections.singletonList(object);
                    break;
                }
                case "zh": {
                    int n5 = string.length() >= 4 ? 4 : 2;
                    object2 = string.substring(0, n5);
                    object = (Nengo)CHINESE_TO_NENGO.get(object2);
                    if (object == null && n5 == 4) {
                        object2 = string.substring(0, 2);
                        object = (Nengo)CHINESE_TO_NENGO.get(object2);
                    }
                    if (object == null) break;
                    string3 = object2;
                    if (object == nengo3) {
                        nengo3 = null;
                    }
                    list = Collections.singletonList(object);
                    break;
                }
                case "ko": {
                    string3 = KOREAN_TO_NENGO.longestPrefixOf(string, n2);
                    list = KOREAN_TO_NENGO.find(string3);
                    break;
                }
                case "ru": {
                    if (string.startsWith("\u041f\u0435\u0440\u0438\u043e\u0434 ")) {
                        string = string.substring(7);
                        n4 = 7;
                    }
                    string3 = RUSSIAN_TO_NENGO.longestPrefixOf(string, n2);
                    list = RUSSIAN_TO_NENGO.find(string3);
                    break;
                }
                default: {
                    string3 = ROMAJI_TO_NENGO.longestPrefixOf(string, n2);
                    list = ROMAJI_TO_NENGO.find(string3);
                }
            }
            if ((n = list.size()) == 0) {
                if (nengo3 == null) {
                    return null;
                }
                parsePosition.setIndex(n2 + n3);
                return nengo3;
            }
            int n6 = string3.length() + n4;
            if (n3 < n6) {
                nengo3 = null;
            } else if (n3 > n6) {
                parsePosition.setIndex(n2 + n3);
                return nengo3;
            }
            assert (nengo3 == null || nengo3 == SHOWA);
            if (n == 1) {
                Nengo nengo4 = list.get(0);
                if (nengo3 == null || nengo4 == nengo3) {
                    parsePosition.setIndex(n2 + n6);
                    return nengo4;
                }
            }
            Selector selector = (Selector)((Object)attributeQuery.get(SELECTOR, (Object)Selector.OFFICIAL));
            object2 = new ArrayList<Nengo>(list);
            if (nengo3 != null && !object2.contains(nengo3)) {
                object2.add(nengo3);
            }
            Collections.sort(object2, (nengo, nengo2) -> ((Nengo)nengo).start < ((Nengo)nengo2).start ? 1 : (((Nengo)nengo).start == ((Nengo)nengo2).start ? 0 : -1));
            object = object2.iterator();
            while (object.hasNext()) {
                Nengo nengo5 = (Nengo)object.next();
                if (nengo5.matches(selector)) continue;
                object.remove();
            }
            if (object2.size() == 1) {
                parsePosition.setIndex(n2 + n6);
                return (Nengo)object2.get(0);
            }
            if (object2.size() > 1 && !((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isStrict()) {
                parsePosition.setIndex(n2 + n6);
                return (Nengo)object2.get(0);
            }
            return null;
        }

        public String name() {
            return "ERA";
        }

        public Class<Nengo> getType() {
            return Nengo.class;
        }

        public char getSymbol() {
            return 'G';
        }

        public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
            Nengo nengo = (Nengo)chronoDisplay.get((ChronoElement)this);
            Nengo nengo2 = (Nengo)chronoDisplay2.get((ChronoElement)this);
            if (nengo.start < nengo2.start) {
                return -1;
            }
            if (nengo.start > nengo2.start) {
                return 1;
            }
            if (nengo.court == 1) {
                return nengo2.court == 1 ? 0 : 1;
            }
            return nengo2.court == 1 ? -1 : 0;
        }

        public Nengo getDefaultMinimum() {
            return OFFICIAL_NENGOS[0];
        }

        public Nengo getDefaultMaximum() {
            return OFFICIAL_NENGOS[OFFICIAL_NENGOS.length - 1];
        }

        public boolean isDateElement() {
            return true;
        }

        public boolean isTimeElement() {
            return false;
        }

        public boolean isLenient() {
            return false;
        }

        public String getDisplayName(Locale locale) {
            String string = "L_era";
            String string2 = (String)CalendarText.getIsoInstance((Locale)locale).getTextForms().get(string);
            return string2 == null ? this.name() : string2;
        }

        private Object readResolve() throws ObjectStreamException {
            return SINGLETON;
        }
    }

    public static enum Selector implements ChronoCondition<Nengo>
    {
        OFFICIAL{

            public boolean test(Nengo nengo) {
                return nengo.court != 1;
            }
        }
        ,
        MODERN{

            public boolean test(Nengo nengo) {
                return nengo.index >= MEIJI.index;
            }
        }
        ,
        EDO_PERIOD{

            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 1603 && nengo.relgregyear < 1868;
            }
        }
        ,
        AZUCHI_MOMOYAMA_PERIOD{

            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 1573 && nengo.relgregyear < 1603;
            }
        }
        ,
        MUROMACHI_PERIOD{

            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 1336 && nengo.relgregyear < 1573 && nengo.court != 1;
            }
        }
        ,
        NORTHERN_COURT{

            public boolean test(Nengo nengo) {
                return nengo.court == 1;
            }
        }
        ,
        SOUTHERN_COURT{

            public boolean test(Nengo nengo) {
                return nengo.court == -1;
            }
        }
        ,
        KAMAKURA_PERIOD{

            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 1185 && nengo.relgregyear < 1332;
            }
        }
        ,
        HEIAN_PERIOD{

            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 794 && nengo.relgregyear < 1185;
            }
        }
        ,
        NARA_PERIOD{

            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 710 && nengo.relgregyear < 794;
            }
        }
        ,
        ASUKA_PERIOD{

            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 538 && nengo.relgregyear < 710;
            }
        };

    }
}

