/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.calendar.PersianCalendar;
import net.time4j.calendar.astro.AstronomicalSeason;
import net.time4j.calendar.astro.SolarTime;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.EpochDays;
import net.time4j.engine.TimePoint;
import net.time4j.format.Attributes;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.ZonalOffset;

public enum PersianAlgorithm {
    BORKOWSKI{

        @Override
        boolean isLeapYear(int n, ZonalOffset zonalOffset) {
            PersianAlgorithm.checkYear(n);
            PersianCalendar persianCalendar = new PersianCalendar(n + 1, 1, 1);
            PersianCalendar persianCalendar2 = new PersianCalendar(n, 1, 1);
            return this.transform(persianCalendar, zonalOffset) - this.transform(persianCalendar2, zonalOffset) == 366L;
        }

        @Override
        PersianCalendar transform(long l, ZonalOffset zonalOffset) {
            int n;
            int n2;
            PlainDate plainDate = PlainDate.of((long)l, (EpochDays)EpochDays.UTC);
            int n3 = plainDate.getYear() - 621;
            if (plainDate.getMonth() < 3) {
                --n3;
            }
            PlainDate plainDate2 = this.vernalEquinox(n3);
            long l2 = CalendarUnit.DAYS.between((TimePoint)plainDate2, (TimePoint)plainDate);
            while (l2 < 0L) {
                plainDate2 = this.vernalEquinox(--n3);
                l2 = CalendarUnit.DAYS.between((TimePoint)plainDate2, (TimePoint)plainDate);
            }
            for (n2 = 1; n2 < 12; ++n2) {
                int n4 = n = n2 <= 6 ? 31 : 30;
                if (l2 < (long)n) break;
                l2 -= (long)n;
            }
            n = (int)(l2 + 1L);
            return PersianCalendar.of(n3, n2, n);
        }

        @Override
        long transform(PersianCalendar persianCalendar, ZonalOffset zonalOffset) {
            int n = persianCalendar.getYear();
            int n2 = persianCalendar.getMonth().getValue();
            long l = this.vernalEquinox(n).getDaysSinceEpochUTC();
            return l += (long)((n2 - 1) * 31 - n2 / 7 * (n2 - 7) + persianCalendar.getDayOfMonth() - 1);
        }

        private PlainDate vernalEquinox(int n) {
            int n2;
            int n3;
            int[] nArray = new int[]{-61, 9, 38, 199, 426, 686, 756, 818, 1111, 1181, 1210, 1635, 2060, 2097, 2192, 2262, 2324, 2394, 2456, 3178};
            int n4 = nArray[nArray.length - 1];
            if (n < 1 || n >= n4) {
                throw new IllegalArgumentException("Persian year out of range 1-" + n4 + ": " + n);
            }
            int n5 = n + 621;
            int n6 = -14;
            int n7 = nArray[0];
            int n8 = 0;
            for (n3 = 1; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                n8 = n2 - n7;
                if (n < n2) break;
                n6 += n8 / 33 * 8 + n8 % 33 / 4;
                n7 = n2;
            }
            n3 = n - n7;
            n6 += n3 / 33 * 8 + (n3 % 33 + 3) / 4;
            if (n8 % 33 == 4 && n8 - n3 == 4) {
                ++n6;
            }
            n2 = n5 / 4 - (n5 / 100 + 1) * 3 / 4 - 150;
            int n9 = 20 + n6 - n2;
            return PlainDate.of((int)n5, (int)3, (int)n9);
        }
    }
    ,
    KHAYYAM{

        @Override
        boolean isLeapYear(int n, ZonalOffset zonalOffset) {
            PersianAlgorithm.checkYear(n);
            int n2 = n % 33;
            return n2 == 1 || n2 == 5 || n2 == 9 || n2 == 13 || n2 == 17 || n2 == 22 || n2 == 26 || n2 == 30;
        }

        @Override
        PersianCalendar transform(long l, ZonalOffset zonalOffset) {
            int n;
            int n2;
            PersianAlgorithm.checkRange(l);
            long l2 = l + 493363L;
            int n3 = (int)(l2 / 12053L);
            int n4 = (int)(l2 % 12053L);
            int n5 = n3 * 33;
            int n6 = 1;
            int n7 = 1;
            for (n2 = 0; n2 < 33; ++n2) {
                int n8 = n = n2 == 1 || n2 == 5 || n2 == 9 || n2 == 13 || n2 == 17 || n2 == 22 || n2 == 26 || n2 == 30 ? 366 : 365;
                if (n4 < n) break;
                n4 -= n;
                ++n5;
            }
            for (n2 = 1; n2 < 12; ++n2) {
                int n9 = n = n2 <= 6 ? 31 : 30;
                if (n4 < n) break;
                n4 -= n;
                ++n6;
            }
            return new PersianCalendar(n5, n6, n7 += n4);
        }

        @Override
        long transform(PersianCalendar persianCalendar, ZonalOffset zonalOffset) {
            int n;
            int n2 = persianCalendar.getYear();
            long l = (long)(n2 / 33 * 12053) - 493363L;
            int n3 = n2 % 33;
            for (n = 0; n < n3; ++n) {
                int n4 = n == 1 || n == 5 || n == 9 || n == 13 || n == 17 || n == 22 || n == 26 || n == 30 ? 366 : 365;
                l += (long)n4;
            }
            n = persianCalendar.getMonth().getValue();
            l = n <= 7 ? (l += (long)(31 * (n - 1))) : (l += (long)(30 * (n - 1) + 6));
            return l + (long)persianCalendar.getDayOfMonth() - 1L;
        }
    }
    ,
    BIRASHK{

        @Override
        boolean isLeapYear(int n, ZonalOffset zonalOffset) {
            PersianAlgorithm.checkYear(n);
            return Math.floorMod((Math.floorMod(n - 474, 2820) + 512) * 31, 128) < 31;
        }

        @Override
        PersianCalendar transform(long l, ZonalOffset zonalOffset) {
            PersianAlgorithm.checkRange(l);
            int n = (int)(l - -319872L);
            int n2 = Math.floorDiv(n, 1029983);
            int n3 = Math.floorMod(n, 1029983);
            int n4 = n3 == 1029982 ? 2820 : Math.floorDiv(128 * n3 + 46878, 46751);
            int n5 = 474 + 2820 * n2 + n4;
            int n6 = 1;
            int n7 = 1;
            int n8 = (int)(l - this.transform(new PersianCalendar(n5, 1, 1), zonalOffset));
            for (int i = 1; i < 12; ++i) {
                int n9;
                int n10 = n9 = i <= 6 ? 31 : 30;
                if (n8 < n9) break;
                n8 -= n9;
                ++n6;
            }
            return new PersianCalendar(n5, n6, n7 += n8);
        }

        @Override
        long transform(PersianCalendar persianCalendar, ZonalOffset zonalOffset) {
            int n = persianCalendar.getYear() - 474;
            int n2 = Math.floorMod(n, 2820) + 474;
            long l = -492998L;
            l += (long)(1029983 * Math.floorDiv(n, 2820));
            l += (long)(365 * (n2 - 1));
            l += (long)Math.floorDiv(31 * n2 - 5, 128);
            int n3 = persianCalendar.getMonth().getValue();
            l = n3 <= 7 ? (l += (long)(31 * (n3 - 1))) : (l += (long)(30 * (n3 - 1) + 6));
            return l + (long)persianCalendar.getDayOfMonth();
        }
    }
    ,
    ASTRONOMICAL{

        @Override
        int getMaxPersianYear() {
            return 2378;
        }

        @Override
        boolean isLeapYear(int n, ZonalOffset zonalOffset) {
            if (n < 1 || n > this.getMaxPersianYear()) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            PersianCalendar persianCalendar = new PersianCalendar(n + 1, 1, 1);
            PersianCalendar persianCalendar2 = new PersianCalendar(n, 1, 1);
            return this.transform(persianCalendar, zonalOffset) - this.transform(persianCalendar2, zonalOffset) == 366L;
        }

        @Override
        PersianCalendar transform(long l, ZonalOffset zonalOffset) {
            int n;
            int n2;
            if (l < -492997L || l > 375548L) {
                throw new IllegalArgumentException("Out of range: " + l);
            }
            PlainDate plainDate = PlainDate.of((long)l, (EpochDays)EpochDays.UTC);
            int n3 = plainDate.getYear() - 621;
            if (plainDate.getMonth() < 3) {
                --n3;
            }
            PlainDate plainDate2 = this.vernalEquinox(n3, zonalOffset);
            long l2 = CalendarUnit.DAYS.between((TimePoint)plainDate2, (TimePoint)plainDate);
            while (l2 < 0L) {
                plainDate2 = this.vernalEquinox(--n3, zonalOffset);
                l2 = CalendarUnit.DAYS.between((TimePoint)plainDate2, (TimePoint)plainDate);
            }
            for (n2 = 1; n2 < 12; ++n2) {
                int n4 = n = n2 <= 6 ? 31 : 30;
                if (l2 < (long)n) break;
                l2 -= (long)n;
            }
            n = (int)(l2 + 1L);
            return new PersianCalendar(n3, n2, n);
        }

        @Override
        long transform(PersianCalendar persianCalendar, ZonalOffset zonalOffset) {
            int n = persianCalendar.getYear();
            int n2 = persianCalendar.getMonth().getValue();
            long l = this.vernalEquinox(n, zonalOffset).getDaysSinceEpochUTC();
            return l += (long)((n2 - 1) * 31 - n2 / 7 * (n2 - 7) + persianCalendar.getDayOfMonth() - 1);
        }

        private PlainDate vernalEquinox(int n, ZonalOffset zonalOffset) {
            PlainTimestamp plainTimestamp = (PlainTimestamp)AstronomicalSeason.VERNAL_EQUINOX.inYear(n + 621).get(SolarTime.apparentAt(zonalOffset));
            if (plainTimestamp.getHour() >= 12) {
                return plainTimestamp.getCalendarDate().plus(1L, CalendarUnit.DAYS);
            }
            return plainTimestamp.getCalendarDate();
        }
    };

    static final ZonalOffset STD_OFFSET;
    private static final int LENGTH_OF_KHAYYAM_CYCLE = 12053;
    private static final long REFERENCE_ZERO_KHAYYAM = 493363L;
    private static final long START_OF_BIRASHK_CYCLE = -319872L;
    private static final AttributeKey<PersianAlgorithm> ATTRIBUTE;

    public static AttributeKey<PersianAlgorithm> attribute() {
        return ATTRIBUTE;
    }

    public boolean isLeapYear(int n) {
        return this.isLeapYear(n, STD_OFFSET);
    }

    abstract boolean isLeapYear(int var1, ZonalOffset var2);

    abstract PersianCalendar transform(long var1, ZonalOffset var3);

    int getMaxPersianYear() {
        return 3000;
    }

    abstract long transform(PersianCalendar var1, ZonalOffset var2);

    boolean isValid(int n, int n2, int n3, ZonalOffset zonalOffset) {
        if (n < 1 || n > this.getMaxPersianYear() || n2 < 1 || n2 > 12 || n3 < 1) {
            return false;
        }
        if (n2 <= 6) {
            return n3 <= 31;
        }
        if (n2 <= 11) {
            return n3 <= 30;
        }
        return n3 <= (this.isLeapYear(n, zonalOffset) ? 30 : 29);
    }

    private static void checkRange(long l) {
        CalendarSystem calendarSystem = PersianCalendar.axis().getCalendarSystem();
        if (l < calendarSystem.getMinimumSinceUTC() || l > calendarSystem.getMaximumSinceUTC()) {
            throw new IllegalArgumentException("Out of range: " + l);
        }
    }

    private static void checkYear(int n) {
        if (n < 1 || n > 3000) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
    }

    static {
        STD_OFFSET = ZonalOffset.ofHoursMinutes((OffsetSign)OffsetSign.AHEAD_OF_UTC, (int)3, (int)30);
        ATTRIBUTE = Attributes.createKey((String)"PERSIAN_ALGORITHM", PersianAlgorithm.class);
    }
}

