/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.PersianAlgorithm;
import net.time4j.calendar.PersianEra;
import net.time4j.calendar.PersianMonth;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.WeekdayRule;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

@CalendarType(value="persian")
public final class PersianCalendar
extends Calendrical<Unit, PersianCalendar>
implements LocalizedPatternSupport {
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    @FormattableElement(format="G")
    public static final ChronoElement<PersianEra> ERA = new StdEnumDateElement<PersianEra, PersianCalendar>("ERA", PersianCalendar.class, PersianEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, PersianCalendar> YEAR_OF_ERA = new StdIntegerDateElement<PersianCalendar>("YEAR_OF_ERA", PersianCalendar.class, 1, 3000, 'y', null, null);
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<PersianMonth, PersianCalendar> MONTH_OF_YEAR = new StdEnumDateElement<PersianMonth, PersianCalendar>("MONTH_OF_YEAR", PersianCalendar.class, PersianMonth.class, 'M');
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, PersianCalendar> DAY_OF_MONTH = new StdIntegerDateElement<PersianCalendar>("DAY_OF_MONTH", PersianCalendar.class, 1, 31, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, PersianCalendar> DAY_OF_YEAR = new StdIntegerDateElement<PersianCalendar>("DAY_OF_YEAR", PersianCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, PersianCalendar> DAY_OF_WEEK = new StdWeekdayElement<PersianCalendar>(PersianCalendar.class, PersianCalendar.getDefaultWeekmodel());
    private static final WeekdayInMonthElement<PersianCalendar> WIM_ELEMENT = new WeekdayInMonthElement<PersianCalendar>(PersianCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<PersianCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    private static final PersianAlgorithm DEFAULT_COMPUTATION = PersianAlgorithm.BORKOWSKI;
    private static final EraYearMonthDaySystem<PersianCalendar> CALSYS = new Transformer();
    private static final TimeAxis<Unit, PersianCalendar> ENGINE;
    public static final StdCalendarElement<Weekday, PersianCalendar> LOCAL_DAY_OF_WEEK;
    public static final StdCalendarElement<Integer, PersianCalendar> WEEK_OF_YEAR;
    public static final StdCalendarElement<Integer, PersianCalendar> WEEK_OF_MONTH;
    public static final StdCalendarElement<Integer, PersianCalendar> BOUNDED_WEEK_OF_YEAR;
    public static final StdCalendarElement<Integer, PersianCalendar> BOUNDED_WEEK_OF_MONTH;
    private static final long serialVersionUID = -411339992208638290L;
    private final transient int pyear;
    private final transient int pmonth;
    private final transient int pdom;

    PersianCalendar(int n, int n2, int n3) {
        this.pyear = n;
        this.pmonth = n2;
        this.pdom = n3;
    }

    public static PersianCalendar of(int n, PersianMonth persianMonth, int n2) {
        return PersianCalendar.of(n, persianMonth.getValue(), n2);
    }

    public static PersianCalendar of(int n, int n2, int n3) {
        if (!CALSYS.isValid(PersianEra.ANNO_PERSICO, n, n2, n3)) {
            throw new IllegalArgumentException("Invalid Persian date: year=" + n + ", month=" + n2 + ", day=" + n3);
        }
        return new PersianCalendar(n, n2, n3);
    }

    public static PersianCalendar nowInSystemTime() {
        return (PersianCalendar)SystemClock.inLocalView().now(PersianCalendar.axis());
    }

    public PersianEra getEra() {
        return PersianEra.ANNO_PERSICO;
    }

    public int getYear() {
        return this.pyear;
    }

    public PersianMonth getMonth() {
        return PersianMonth.valueOf(this.pmonth);
    }

    public int getDayOfMonth() {
        return this.pdom;
    }

    public Weekday getDayOfWeek() {
        long l = CALSYS.transform((Object)this);
        return Weekday.valueOf((int)(MathUtils.floorModulo((long)(l + 5L), (int)7) + 1));
    }

    public int getDayOfYear() {
        return (Integer)this.get(DAY_OF_YEAR);
    }

    public Date getDate(PersianAlgorithm persianAlgorithm) {
        ZonalOffset zonalOffset = PersianAlgorithm.STD_OFFSET;
        if (persianAlgorithm == DEFAULT_COMPUTATION) {
            return new Date(this, DEFAULT_COMPUTATION, zonalOffset);
        }
        long l = DEFAULT_COMPUTATION.transform(this, zonalOffset);
        return new Date(persianAlgorithm.transform(l, zonalOffset), persianAlgorithm, zonalOffset);
    }

    public Date getDate(ZonalOffset zonalOffset) {
        if (zonalOffset == null) {
            throw new NullPointerException("Missing timezone offset.");
        }
        PersianAlgorithm persianAlgorithm = PersianAlgorithm.ASTRONOMICAL;
        long l = DEFAULT_COMPUTATION.transform(this, PersianAlgorithm.STD_OFFSET);
        return new Date(persianAlgorithm.transform(l, zonalOffset), persianAlgorithm, zonalOffset);
    }

    public int lengthOfMonth() {
        return CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, this.pyear, this.pmonth);
    }

    public int lengthOfYear() {
        return CALSYS.getLengthOfYear(PersianEra.ANNO_PERSICO, this.pyear);
    }

    public boolean isLeapYear() {
        return this.lengthOfYear() > 365;
    }

    public static boolean isValid(int n, int n2, int n3) {
        return CALSYS.isValid(PersianEra.ANNO_PERSICO, n, n2, n3);
    }

    public GeneralTimestamp<PersianCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of((Calendrical)this, (PlainTime)plainTime);
    }

    public GeneralTimestamp<PersianCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of((int)n, (int)n2));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PersianCalendar) {
            PersianCalendar persianCalendar = (PersianCalendar)((Object)object);
            return this.pdom == persianCalendar.pdom && this.pmonth == persianCalendar.pmonth && this.pyear == persianCalendar.pyear;
        }
        return false;
    }

    public int hashCode() {
        return 17 * this.pdom + 31 * this.pmonth + 37 * this.pyear;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("AP-");
        String string = String.valueOf(this.pyear);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (this.pmonth < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.pmonth);
        stringBuilder.append('-');
        if (this.pdom < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.pdom);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of((Weekday)Weekday.SATURDAY, (int)1, (Weekday)Weekday.FRIDAY, (Weekday)Weekday.FRIDAY);
    }

    public static TimeAxis<Unit, PersianCalendar> axis() {
        return ENGINE;
    }

    protected TimeAxis<Unit, PersianCalendar> getChronology() {
        return ENGINE;
    }

    protected PersianCalendar getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX((Object)this, 2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        TimeAxis.Builder builder = TimeAxis.Builder.setUp(Unit.class, PersianCalendar.class, (ChronoMerger)new Merger(), CALSYS).appendElement(ERA, (ElementRule)new EraRule()).appendElement(YEAR_OF_ERA, (ElementRule)new IntegerRule(0), (Object)Unit.YEARS).appendElement(MONTH_OF_YEAR, (ElementRule)new MonthRule(), (Object)Unit.MONTHS).appendElement(DAY_OF_MONTH, (ElementRule)new IntegerRule(2), (Object)Unit.DAYS).appendElement(DAY_OF_YEAR, (ElementRule)new IntegerRule(3), (Object)Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<PersianCalendar>(PersianCalendar.getDefaultWeekmodel(), persianCalendar -> CALSYS), (Object)Unit.DAYS).appendElement(WIM_ELEMENT, WeekdayInMonthElement.getRule(WIM_ELEMENT)).appendElement(CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<PersianCalendar>(CALSYS, DAY_OF_YEAR)).appendUnit((Object)Unit.YEARS, (UnitRule)new PersianUnitRule(Unit.YEARS), Unit.YEARS.getLength(), Collections.singleton(Unit.MONTHS)).appendUnit((Object)Unit.MONTHS, (UnitRule)new PersianUnitRule(Unit.MONTHS), Unit.MONTHS.getLength(), Collections.singleton(Unit.YEARS)).appendUnit((Object)Unit.WEEKS, (UnitRule)new PersianUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit((Object)Unit.DAYS, (UnitRule)new PersianUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS)).appendExtension((ChronoExtension)new CommonElements.Weekengine(PersianCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, PersianCalendar.getDefaultWeekmodel()));
        ENGINE = builder.build();
        LOCAL_DAY_OF_WEEK = CommonElements.localDayOfWeek(PersianCalendar.axis(), PersianCalendar.getDefaultWeekmodel());
        WEEK_OF_YEAR = CommonElements.weekOfYear(PersianCalendar.axis(), PersianCalendar.getDefaultWeekmodel());
        WEEK_OF_MONTH = CommonElements.weekOfMonth(PersianCalendar.axis(), PersianCalendar.getDefaultWeekmodel());
        BOUNDED_WEEK_OF_YEAR = CommonElements.boundedWeekOfYear(PersianCalendar.axis(), PersianCalendar.getDefaultWeekmodel());
        BOUNDED_WEEK_OF_MONTH = CommonElements.boundedWeekOfMonth(PersianCalendar.axis(), PersianCalendar.getDefaultWeekmodel());
    }

    private static class PersianUnitRule
    implements UnitRule<PersianCalendar> {
        private final Unit unit;

        PersianUnitRule(Unit unit) {
            this.unit = unit;
        }

        public PersianCalendar addTo(PersianCalendar persianCalendar, long l) {
            switch (this.unit) {
                case YEARS: {
                    l = MathUtils.safeMultiply((long)l, (long)12L);
                }
                case MONTHS: {
                    long l2 = MathUtils.safeAdd((long)PersianUnitRule.ymValue(persianCalendar), (long)l);
                    int n = MathUtils.safeCast((long)MathUtils.floorDivide((long)l2, (int)12));
                    int n2 = MathUtils.floorModulo((long)l2, (int)12) + 1;
                    int n3 = Math.min(persianCalendar.pdom, CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, n, n2));
                    return PersianCalendar.of(n, n2, n3);
                }
                case WEEKS: {
                    l = MathUtils.safeMultiply((long)l, (long)7L);
                }
                case DAYS: {
                    long l3 = MathUtils.safeAdd((long)CALSYS.transform((Object)persianCalendar), (long)l);
                    return (PersianCalendar)((Object)CALSYS.transform(l3));
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        public long between(PersianCalendar persianCalendar, PersianCalendar persianCalendar2) {
            switch (this.unit) {
                case YEARS: {
                    return Unit.MONTHS.between(persianCalendar, persianCalendar2) / 12;
                }
                case MONTHS: {
                    long l = PersianUnitRule.ymValue(persianCalendar2) - PersianUnitRule.ymValue(persianCalendar);
                    if (l > 0L && persianCalendar2.pdom < persianCalendar.pdom) {
                        --l;
                    } else if (l < 0L && persianCalendar2.pdom > persianCalendar.pdom) {
                        ++l;
                    }
                    return l;
                }
                case WEEKS: {
                    return Unit.DAYS.between(persianCalendar, persianCalendar2) / 7;
                }
                case DAYS: {
                    return CALSYS.transform((Object)persianCalendar2) - CALSYS.transform((Object)persianCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static int ymValue(PersianCalendar persianCalendar) {
            return persianCalendar.pyear * 12 + persianCalendar.pmonth - 1;
        }
    }

    private static class Merger
    implements ChronoMerger<PersianCalendar> {
        private Merger() {
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("persian", displayStyle, locale);
        }

        public PersianCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = (StartOfDay)attributeQuery.get(Attributes.START_OF_DAY, (Object)StartOfDay.MIDNIGHT);
            return (PersianCalendar)((Object)Moment.from((UnixTime)timeSource.currentTime()).toGeneralTimestamp((Chronology)ENGINE, tZID, startOfDay).toDate());
        }

        @Deprecated
        public PersianCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom(chronoEntity, attributeQuery, bl2, bl);
        }

        public PersianCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            TZID tZID;
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Missing Persian year.");
                return null;
            }
            PersianAlgorithm persianAlgorithm = (PersianAlgorithm)((Object)attributeQuery.get(PersianAlgorithm.attribute(), (Object)DEFAULT_COMPUTATION));
            ZonalOffset zonalOffset = PersianAlgorithm.STD_OFFSET;
            if (persianAlgorithm == PersianAlgorithm.ASTRONOMICAL && attributeQuery.contains(Attributes.TIMEZONE_ID) && (tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID)) instanceof ZonalOffset) {
                zonalOffset = (ZonalOffset)tZID;
            }
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n2 = ((PersianMonth)((Object)chronoEntity.get(MONTH_OF_YEAR))).getValue();
                int n3 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n3 != Integer.MIN_VALUE) {
                    if (persianAlgorithm.isValid(n, n2, n3, zonalOffset)) {
                        PersianCalendar persianCalendar = new PersianCalendar(n, n2, n3);
                        if (persianAlgorithm != DEFAULT_COMPUTATION) {
                            long l = persianAlgorithm.transform(persianCalendar, zonalOffset);
                            persianCalendar = DEFAULT_COMPUTATION.transform(l, PersianAlgorithm.STD_OFFSET);
                        }
                        return persianCalendar;
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Persian date.");
                }
            } else {
                int n4 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n4 != Integer.MIN_VALUE) {
                    if (n4 > 0) {
                        int n5 = 1;
                        int n6 = 0;
                        while (n5 <= 12) {
                            int n7;
                            if (n5 <= 6) {
                                n7 = 31;
                            } else if (n5 <= 11) {
                                n7 = 30;
                            } else {
                                int n8 = n7 = persianAlgorithm.isLeapYear(n, zonalOffset) ? 30 : 29;
                            }
                            if (n4 > n6 + n7) {
                                ++n5;
                                n6 += n7;
                                continue;
                            }
                            if (!persianAlgorithm.isValid(n, n5, n4 - n6, zonalOffset)) break;
                            PersianCalendar persianCalendar = new PersianCalendar(n, n5, n4 - n6);
                            if (persianAlgorithm != DEFAULT_COMPUTATION) {
                                long l = persianAlgorithm.transform(persianCalendar, zonalOffset);
                                persianCalendar = DEFAULT_COMPUTATION.transform(l, PersianAlgorithm.STD_OFFSET);
                            }
                            return persianCalendar;
                        }
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Persian date.");
                }
            }
            return null;
        }

        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear() - 621;
        }

        public ChronoDisplay preformat(PersianCalendar persianCalendar, AttributeQuery attributeQuery) {
            PersianAlgorithm persianAlgorithm = (PersianAlgorithm)((Object)attributeQuery.get(PersianAlgorithm.attribute(), (Object)DEFAULT_COMPUTATION));
            if (persianAlgorithm == DEFAULT_COMPUTATION) {
                return persianCalendar;
            }
            if (persianAlgorithm == PersianAlgorithm.ASTRONOMICAL && attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                ZonalOffset zonalOffset = PersianAlgorithm.STD_OFFSET;
                TZID tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID);
                if (tZID instanceof ZonalOffset) {
                    zonalOffset = (ZonalOffset)tZID;
                }
                return persianCalendar.getDate(zonalOffset);
            }
            return persianCalendar.getDate(persianAlgorithm);
        }
    }

    private static class EraRule
    implements ElementRule<PersianCalendar, PersianEra> {
        private EraRule() {
        }

        public PersianEra getValue(PersianCalendar persianCalendar) {
            return PersianEra.ANNO_PERSICO;
        }

        public PersianEra getMinimum(PersianCalendar persianCalendar) {
            return PersianEra.ANNO_PERSICO;
        }

        public PersianEra getMaximum(PersianCalendar persianCalendar) {
            return PersianEra.ANNO_PERSICO;
        }

        public boolean isValid(PersianCalendar persianCalendar, PersianEra persianEra) {
            return persianEra != null;
        }

        public PersianCalendar withValue(PersianCalendar persianCalendar, PersianEra persianEra, boolean bl) {
            if (persianEra == null) {
                throw new IllegalArgumentException("Missing era value.");
            }
            return persianCalendar;
        }

        public ChronoElement<?> getChildAtFloor(PersianCalendar persianCalendar) {
            return YEAR_OF_ERA;
        }

        public ChronoElement<?> getChildAtCeiling(PersianCalendar persianCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class MonthRule
    implements ElementRule<PersianCalendar, PersianMonth> {
        private MonthRule() {
        }

        public PersianMonth getValue(PersianCalendar persianCalendar) {
            return persianCalendar.getMonth();
        }

        public PersianMonth getMinimum(PersianCalendar persianCalendar) {
            return PersianMonth.FARVARDIN;
        }

        public PersianMonth getMaximum(PersianCalendar persianCalendar) {
            return PersianMonth.ESFAND;
        }

        public boolean isValid(PersianCalendar persianCalendar, PersianMonth persianMonth) {
            return persianMonth != null;
        }

        public PersianCalendar withValue(PersianCalendar persianCalendar, PersianMonth persianMonth, boolean bl) {
            if (persianMonth == null) {
                throw new IllegalArgumentException("Missing month.");
            }
            int n = persianMonth.getValue();
            int n2 = CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, persianCalendar.pyear, n);
            int n3 = Math.min(persianCalendar.pdom, n2);
            return new PersianCalendar(persianCalendar.pyear, n, n3);
        }

        public ChronoElement<?> getChildAtFloor(PersianCalendar persianCalendar) {
            return DAY_OF_MONTH;
        }

        public ChronoElement<?> getChildAtCeiling(PersianCalendar persianCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class IntegerRule
    implements ElementRule<PersianCalendar, Integer> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        public Integer getValue(PersianCalendar persianCalendar) {
            switch (this.index) {
                case 0: {
                    return persianCalendar.pyear;
                }
                case 2: {
                    return persianCalendar.pdom;
                }
                case 3: {
                    int n = 0;
                    for (int i = 1; i < persianCalendar.pmonth; ++i) {
                        n += CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, persianCalendar.pyear, i);
                    }
                    return n + persianCalendar.pdom;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public Integer getMinimum(PersianCalendar persianCalendar) {
            switch (this.index) {
                case 0: 
                case 2: 
                case 3: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public Integer getMaximum(PersianCalendar persianCalendar) {
            switch (this.index) {
                case 0: {
                    return 3000;
                }
                case 2: {
                    return CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, persianCalendar.pyear, persianCalendar.pmonth);
                }
                case 3: {
                    return CALSYS.getLengthOfYear(PersianEra.ANNO_PERSICO, persianCalendar.pyear);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public boolean isValid(PersianCalendar persianCalendar, Integer n) {
            if (n == null) {
                return false;
            }
            Integer n2 = this.getMinimum(persianCalendar);
            Integer n3 = this.getMaximum(persianCalendar);
            return n2.compareTo(n) <= 0 && n3.compareTo(n) >= 0;
        }

        public PersianCalendar withValue(PersianCalendar persianCalendar, Integer n, boolean bl) {
            if (!this.isValid(persianCalendar, n)) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            switch (this.index) {
                case 0: {
                    int n2 = n;
                    int n3 = CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, n2, persianCalendar.pmonth);
                    int n4 = Math.min(persianCalendar.pdom, n3);
                    return PersianCalendar.of(n2, persianCalendar.pmonth, n4);
                }
                case 2: {
                    return new PersianCalendar(persianCalendar.pyear, persianCalendar.pmonth, n);
                }
                case 3: {
                    int n5 = n - this.getValue(persianCalendar);
                    return (PersianCalendar)persianCalendar.plus(CalendarDays.of((long)n5));
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public ChronoElement<?> getChildAtFloor(PersianCalendar persianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(PersianCalendar persianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }
    }

    private static class Transformer
    implements EraYearMonthDaySystem<PersianCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            return calendarEra == PersianEra.ANNO_PERSICO && n >= 1 && n <= 3000 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= this.getLengthOfMonth(calendarEra, n, n2);
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            if (calendarEra != PersianEra.ANNO_PERSICO) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (calendarEra == PersianEra.ANNO_PERSICO && n >= 1 && n <= 3000 && n2 >= 1 && n2 <= 12) {
                if (n2 <= 6) {
                    return 31;
                }
                if (n2 <= 11) {
                    return 30;
                }
                return this.getLengthOfYear(calendarEra, n) == 365 ? 29 : 30;
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n + ", month=" + n2);
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            if (calendarEra != PersianEra.ANNO_PERSICO) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            return DEFAULT_COMPUTATION.isLeapYear(n) ? 366 : 365;
        }

        public PersianCalendar transform(long l) {
            return DEFAULT_COMPUTATION.transform(l, PersianAlgorithm.STD_OFFSET);
        }

        public long transform(PersianCalendar persianCalendar) {
            return DEFAULT_COMPUTATION.transform(persianCalendar, PersianAlgorithm.STD_OFFSET);
        }

        public long getMinimumSinceUTC() {
            PersianCalendar persianCalendar = new PersianCalendar(1, 1, 1);
            return this.transform(persianCalendar);
        }

        public long getMaximumSinceUTC() {
            PersianCalendar persianCalendar = new PersianCalendar(3001, 1, 1);
            return this.transform(persianCalendar) - 1L;
        }

        public List<CalendarEra> getEras() {
            PersianEra persianEra = PersianEra.ANNO_PERSICO;
            return Collections.singletonList(persianEra);
        }
    }

    public static final class Date
    implements ChronoDisplay {
        private final PersianCalendar delegate;
        private final PersianAlgorithm algorithm;
        private final ZonalOffset offset;

        private Date(PersianCalendar persianCalendar, PersianAlgorithm persianAlgorithm, ZonalOffset zonalOffset) {
            this.delegate = persianCalendar;
            this.algorithm = persianAlgorithm;
            this.offset = zonalOffset;
        }

        public boolean contains(ChronoElement<?> chronoElement) {
            return ENGINE.isRegistered(chronoElement);
        }

        public <V> V get(ChronoElement<V> chronoElement) {
            if (chronoElement == DAY_OF_WEEK) {
                long l = this.algorithm.transform(this.delegate, this.offset);
                return (V)chronoElement.getType().cast(Weekday.valueOf((int)(MathUtils.floorModulo((long)(l + 5L), (int)7) + 1)));
            }
            if (chronoElement == DAY_OF_YEAR) {
                int n = 0;
                for (int i = 1; i < this.delegate.pmonth; ++i) {
                    if (i <= 6) {
                        n += 31;
                        continue;
                    }
                    n += 30;
                }
                return (V)chronoElement.getType().cast(n + this.delegate.pdom);
            }
            if (chronoElement == WEEKDAY_IN_MONTH) {
                return (V)chronoElement.getType().cast(Math.floorDiv(this.delegate.pdom - 1, 7) + 1);
            }
            if (chronoElement == CommonElements.RELATED_GREGORIAN_YEAR) {
                return (V)chronoElement.getType().cast(this.delegate.getYear() + 621);
            }
            if (chronoElement instanceof EpochDays) {
                EpochDays epochDays = (EpochDays)EpochDays.class.cast(chronoElement);
                long l = this.algorithm.transform(this.delegate, this.offset);
                return (V)chronoElement.getType().cast(epochDays.transform(l, EpochDays.UTC));
            }
            if (ENGINE.isRegistered(chronoElement)) {
                return (V)this.delegate.get(chronoElement);
            }
            throw new ChronoException("Persian dates only support registered elements.");
        }

        public int getInt(ChronoElement<Integer> chronoElement) {
            if (chronoElement == DAY_OF_MONTH) {
                return this.delegate.pdom;
            }
            if (chronoElement == YEAR_OF_ERA) {
                return this.delegate.pyear;
            }
            if (chronoElement == DAY_OF_YEAR) {
                int n = 0;
                for (int i = 1; i < this.delegate.pmonth; ++i) {
                    if (i <= 6) {
                        n += 31;
                        continue;
                    }
                    n += 30;
                }
                return n + this.delegate.pdom;
            }
            if (chronoElement == WEEKDAY_IN_MONTH) {
                return Math.floorDiv(this.delegate.pdom - 1, 7) + 1;
            }
            if (chronoElement == CommonElements.RELATED_GREGORIAN_YEAR) {
                return this.delegate.getYear() + 621;
            }
            if (ENGINE.isRegistered(chronoElement)) {
                return this.delegate.getInt(chronoElement);
            }
            return Integer.MIN_VALUE;
        }

        public <V> V getMinimum(ChronoElement<V> chronoElement) {
            if (ENGINE.isRegistered(chronoElement)) {
                return (V)this.delegate.getMinimum(chronoElement);
            }
            throw new ChronoException("Persian dates only support registered elements.");
        }

        public <V> V getMaximum(ChronoElement<V> chronoElement) {
            if (chronoElement == DAY_OF_MONTH) {
                int n = this.delegate.pmonth;
                int n2 = n <= 6 ? 31 : (n <= 11 ? 30 : (this.algorithm.isLeapYear(this.delegate.pyear, this.offset) ? 30 : 29));
                return (V)chronoElement.getType().cast(n2);
            }
            if (chronoElement == DAY_OF_YEAR) {
                int n = this.algorithm.isLeapYear(this.delegate.pyear, this.offset) ? 366 : 365;
                return (V)chronoElement.getType().cast(n);
            }
            if (chronoElement == WEEKDAY_IN_MONTH) {
                int n = this.delegate.pdom;
                int n3 = (Integer)this.getMaximum(DAY_OF_MONTH);
                while (n + 7 <= n3) {
                    n += 7;
                }
                return (V)chronoElement.getType().cast(Math.floorDiv(n - 1, 7) + 1);
            }
            if (ENGINE.isRegistered(chronoElement)) {
                return (V)this.delegate.getMaximum(chronoElement);
            }
            throw new ChronoException("Persian dates only support registered elements.");
        }

        public boolean hasTimezone() {
            return this.algorithm == PersianAlgorithm.ASTRONOMICAL;
        }

        public ZonalOffset getTimezone() {
            if (this.hasTimezone()) {
                return this.offset;
            }
            throw new ChronoException("Timezone offset not defined.");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                if (this.algorithm != date.algorithm) {
                    return false;
                }
                if (this.algorithm == PersianAlgorithm.ASTRONOMICAL && !this.offset.equals((Object)date.offset)) {
                    return false;
                }
                return this.delegate.equals((Object)date.delegate);
            }
            return false;
        }

        public int hashCode() {
            return 7 * this.delegate.hashCode() + 31 * this.algorithm.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((Object)this.delegate);
            stringBuilder.append('[');
            stringBuilder.append((Object)this.algorithm);
            if (this.algorithm == PersianAlgorithm.ASTRONOMICAL) {
                stringBuilder.append(this.offset.toString());
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    public static enum Unit implements ChronoUnit
    {
        YEARS(3.155694336E7),
        MONTHS(2629745.28),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        public double getLength() {
            return this.length;
        }

        public boolean isCalendrical() {
            return true;
        }

        public int between(PersianCalendar persianCalendar, PersianCalendar persianCalendar2) {
            return (int)persianCalendar.until((TimePoint)persianCalendar2, (Object)this);
        }
    }
}

