/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.time4j.CalendarUnit;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.ThaiSolarEra;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.WeekdayRule;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="buddhist")
public final class ThaiSolarCalendar
extends Calendrical<CalendarUnit, ThaiSolarCalendar>
implements LocalizedPatternSupport {
    private static final PlainDate MIN_ISO = PlainDate.of((int)-542, (int)4, (int)1);
    @FormattableElement(format="G")
    public static final ChronoElement<ThaiSolarEra> ERA = new StdEnumDateElement<ThaiSolarEra, ThaiSolarCalendar>("ERA", ThaiSolarCalendar.class, ThaiSolarEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, ThaiSolarCalendar> YEAR_OF_ERA = new StdIntegerDateElement<ThaiSolarCalendar>("YEAR_OF_ERA", ThaiSolarCalendar.class, 1, 1000000542, 'y', null, null);
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<Month, ThaiSolarCalendar> MONTH_OF_YEAR = new StdEnumDateElement<Month, ThaiSolarCalendar>("MONTH_OF_YEAR", ThaiSolarCalendar.class, Month.class, 'M');
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, ThaiSolarCalendar> DAY_OF_MONTH = new StdIntegerDateElement<ThaiSolarCalendar>("DAY_OF_MONTH", ThaiSolarCalendar.class, 1, 31, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, ThaiSolarCalendar> DAY_OF_YEAR = new StdIntegerDateElement<ThaiSolarCalendar>("DAY_OF_YEAR", ThaiSolarCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, ThaiSolarCalendar> DAY_OF_WEEK = new StdWeekdayElement<ThaiSolarCalendar>(ThaiSolarCalendar.class, ThaiSolarCalendar.getDefaultWeekmodel());
    private static final WeekdayInMonthElement<ThaiSolarCalendar> WIM_ELEMENT = new WeekdayInMonthElement<ThaiSolarCalendar>(ThaiSolarCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<ThaiSolarCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    private static final Map<Object, ChronoElement<?>> CHILDREN;
    private static final EraYearMonthDaySystem<ThaiSolarCalendar> CALSYS;
    private static final TimeAxis<CalendarUnit, ThaiSolarCalendar> ENGINE;
    private static final long serialVersionUID = -6628190121085147706L;
    private final PlainDate iso;

    private ThaiSolarCalendar(PlainDate plainDate) {
        if (plainDate.isBefore((CalendarDate)MIN_ISO)) {
            throw new IllegalArgumentException("Before buddhist era: " + plainDate);
        }
        this.iso = plainDate;
    }

    public static ThaiSolarCalendar ofBuddhist(int n, Month month, int n2) {
        return ThaiSolarCalendar.of(ThaiSolarEra.BUDDHIST, n, month.getValue(), n2);
    }

    public static ThaiSolarCalendar ofBuddhist(int n, int n2, int n3) {
        return ThaiSolarCalendar.of(ThaiSolarEra.BUDDHIST, n, n2, n3);
    }

    public static ThaiSolarCalendar of(ThaiSolarEra thaiSolarEra, int n, int n2, int n3) {
        int n4 = thaiSolarEra.toIsoYear(n, n2);
        PlainDate plainDate = PlainDate.of((int)n4, (int)n2, (int)n3);
        return new ThaiSolarCalendar(plainDate);
    }

    public static ThaiSolarCalendar nowInSystemTime() {
        return (ThaiSolarCalendar)SystemClock.inLocalView().now(ThaiSolarCalendar.axis());
    }

    public ThaiSolarEra getEra() {
        return ThaiSolarEra.BUDDHIST;
    }

    public int getYear() {
        int n = this.iso.getYear();
        if (n >= 1941 || this.iso.getMonth() >= 4) {
            return n + 543;
        }
        return n + 542;
    }

    public Month getMonth() {
        return Month.valueOf((int)this.iso.getMonth());
    }

    public int getDayOfMonth() {
        return this.iso.getDayOfMonth();
    }

    public Weekday getDayOfWeek() {
        return this.iso.getDayOfWeek();
    }

    public int getDayOfYear() {
        int n = (Integer)this.iso.get((ChronoElement)PlainDate.DAY_OF_YEAR);
        if (this.iso.getYear() < 1941) {
            n = this.iso.getMonth() >= 4 ? (n -= this.iso.isLeapYear() ? 91 : 90) : (n += 275);
        }
        return n;
    }

    public int lengthOfMonth() {
        return this.iso.lengthOfMonth();
    }

    public int lengthOfYear() {
        int n = this.iso.getYear();
        if (n >= 1941) {
            return this.iso.lengthOfYear();
        }
        if (this.iso.getMonth() >= 4) {
            if (n == 1940) {
                return 275;
            }
            return GregorianMath.isLeapYear((int)(n + 1)) ? 366 : 365;
        }
        return this.iso.isLeapYear() ? 366 : 365;
    }

    public boolean isLeapYear() {
        return this.lengthOfYear() == 366;
    }

    public static boolean isValid(ThaiSolarEra thaiSolarEra, int n, int n2, int n3) {
        return CALSYS.isValid(thaiSolarEra, n, n2, n3);
    }

    public GeneralTimestamp<ThaiSolarCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of((Calendrical)this, (PlainTime)plainTime);
    }

    public GeneralTimestamp<ThaiSolarCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of((int)n, (int)n2));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ThaiSolarCalendar) {
            ThaiSolarCalendar thaiSolarCalendar = (ThaiSolarCalendar)((Object)object);
            return this.iso.equals((Object)thaiSolarCalendar.iso);
        }
        return false;
    }

    public int hashCode() {
        return this.iso.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append((Object)this.getEra());
        stringBuilder.append('-');
        stringBuilder.append(this.getYear());
        stringBuilder.append('-');
        int n = this.getMonth().getValue();
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        stringBuilder.append('-');
        int n2 = this.getDayOfMonth();
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of((Weekday)Weekday.SUNDAY, (int)1);
    }

    public static TimeAxis<CalendarUnit, ThaiSolarCalendar> axis() {
        return ENGINE;
    }

    protected TimeAxis<CalendarUnit, ThaiSolarCalendar> getChronology() {
        return ENGINE;
    }

    protected ThaiSolarCalendar getContext() {
        return this;
    }

    PlainDate toISO() {
        return this.iso;
    }

    private static void registerUnits(TimeAxis.Builder<CalendarUnit, ThaiSolarCalendar> builder) {
        EnumSet<CalendarUnit> enumSet = EnumSet.range(CalendarUnit.MILLENNIA, CalendarUnit.MONTHS);
        EnumSet<CalendarUnit> enumSet2 = EnumSet.range(CalendarUnit.WEEKS, CalendarUnit.DAYS);
        for (CalendarUnit calendarUnit : CalendarUnit.values()) {
            builder.appendUnit((Object)calendarUnit, (UnitRule)new ThaiUnitRule(calendarUnit), calendarUnit.getLength(), calendarUnit.compareTo((Enum)CalendarUnit.WEEKS) < 0 ? enumSet : enumSet2);
        }
    }

    private Object writeReplace() {
        return new SPX((Object)this, 8);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        HashMap<Object, StdCalendarElement<Integer, ThaiSolarCalendar>> hashMap = new HashMap<Object, StdCalendarElement<Integer, ThaiSolarCalendar>>();
        hashMap.put(ERA, YEAR_OF_ERA);
        hashMap.put(YEAR_OF_ERA, MONTH_OF_YEAR);
        hashMap.put(MONTH_OF_YEAR, DAY_OF_MONTH);
        CHILDREN = Collections.unmodifiableMap(hashMap);
        CALSYS = new Transformer();
        TimeAxis.Builder builder = TimeAxis.Builder.setUp(CalendarUnit.class, ThaiSolarCalendar.class, (ChronoMerger)new Merger(), CALSYS).appendElement(ERA, FieldRule.of(ERA)).appendElement(YEAR_OF_ERA, FieldRule.of(YEAR_OF_ERA), (Object)CalendarUnit.YEARS).appendElement(MONTH_OF_YEAR, FieldRule.of(MONTH_OF_YEAR), (Object)CalendarUnit.MONTHS).appendElement(CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<ThaiSolarCalendar>(CALSYS, DAY_OF_YEAR)).appendElement(DAY_OF_MONTH, FieldRule.of(DAY_OF_MONTH), (Object)CalendarUnit.DAYS).appendElement(DAY_OF_YEAR, FieldRule.of(DAY_OF_YEAR), (Object)CalendarUnit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<ThaiSolarCalendar>(ThaiSolarCalendar.getDefaultWeekmodel(), thaiSolarCalendar -> CALSYS), (Object)CalendarUnit.DAYS).appendElement(WIM_ELEMENT, WeekdayInMonthElement.getRule(WIM_ELEMENT)).appendExtension((ChronoExtension)new CommonElements.Weekengine(ThaiSolarCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, ThaiSolarCalendar.getDefaultWeekmodel()));
        ThaiSolarCalendar.registerUnits((TimeAxis.Builder<CalendarUnit, ThaiSolarCalendar>)builder);
        ENGINE = builder.build();
    }

    private static class Merger
    implements ChronoMerger<ThaiSolarCalendar> {
        private Merger() {
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("buddhist", displayStyle, locale);
        }

        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MIDNIGHT;
        }

        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear() + 543;
        }

        public ThaiSolarCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = (StartOfDay)attributeQuery.get(Attributes.START_OF_DAY, (Object)this.getDefaultStartOfDay());
            return (ThaiSolarCalendar)((Object)Moment.from((UnixTime)timeSource.currentTime()).toGeneralTimestamp((Chronology)ENGINE, tZID, startOfDay).toDate());
        }

        @Deprecated
        public ThaiSolarCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom(chronoEntity, attributeQuery, bl2, bl);
        }

        public ThaiSolarCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            ThaiSolarEra thaiSolarEra;
            if (chronoEntity.contains((ChronoElement)PlainDate.COMPONENT)) {
                return new ThaiSolarCalendar((PlainDate)chronoEntity.get((ChronoElement)PlainDate.COMPONENT));
            }
            if (chronoEntity.contains(ERA)) {
                thaiSolarEra = (ThaiSolarEra)((Object)chronoEntity.get(ERA));
            } else if (bl) {
                thaiSolarEra = ThaiSolarEra.BUDDHIST;
            } else {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Missing Thai era.");
                return null;
            }
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Missing Thai year.");
                return null;
            }
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n2 = ((Month)chronoEntity.get(MONTH_OF_YEAR)).getValue();
                int n3 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n3 != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(thaiSolarEra, n, n2, n3)) {
                        return ThaiSolarCalendar.of(thaiSolarEra, n, n2, n3);
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Thai calendar date.");
                }
            } else {
                int n4 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n4 != Integer.MIN_VALUE) {
                    if (n4 > 0) {
                        int n5 = thaiSolarEra == ThaiSolarEra.RATTANAKOSIN || n < 2484 ? 3 : 0;
                        int n6 = thaiSolarEra.toIsoYear(n, 4);
                        int n7 = 1 + n5;
                        int n8 = 0;
                        while (n7 <= 12 + n5) {
                            int n9;
                            int n10 = n6;
                            int n11 = n7;
                            if (n11 > 12) {
                                if (thaiSolarEra == ThaiSolarEra.BUDDHIST && n10 == 1940) break;
                                ++n10;
                                n11 -= 12;
                            }
                            if (n4 > n8 + (n9 = GregorianMath.getLengthOfMonth((int)n10, (int)n11))) {
                                ++n7;
                                n8 += n9;
                                continue;
                            }
                            int n12 = n4 - n8;
                            return ThaiSolarCalendar.of(thaiSolarEra, n, n11, n12);
                        }
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Thai calendar date.");
                }
            }
            return null;
        }

        public ChronoDisplay preformat(ThaiSolarCalendar thaiSolarCalendar, AttributeQuery attributeQuery) {
            return thaiSolarCalendar;
        }

        public Chronology<?> preparser() {
            return null;
        }
    }

    private static class ThaiUnitRule
    implements UnitRule<ThaiSolarCalendar> {
        private final CalendarUnit unit;

        ThaiUnitRule(CalendarUnit calendarUnit) {
            this.unit = calendarUnit;
        }

        public ThaiSolarCalendar addTo(ThaiSolarCalendar thaiSolarCalendar, long l) {
            return new ThaiSolarCalendar(thaiSolarCalendar.iso.plus(l, this.unit));
        }

        public long between(ThaiSolarCalendar thaiSolarCalendar, ThaiSolarCalendar thaiSolarCalendar2) {
            return this.unit.between((TimePoint)thaiSolarCalendar.iso, (TimePoint)thaiSolarCalendar2.iso);
        }
    }

    private static class FieldRule<V extends Comparable<V>>
    implements ElementRule<ThaiSolarCalendar, V> {
        private final ChronoElement<V> element;

        private FieldRule(ChronoElement<V> chronoElement) {
            this.element = chronoElement;
        }

        static <V extends Comparable<V>> FieldRule<V> of(ChronoElement<V> chronoElement) {
            return new FieldRule<V>(chronoElement);
        }

        public V getValue(ThaiSolarCalendar thaiSolarCalendar) {
            Object object;
            if (this.element == ERA) {
                object = thaiSolarCalendar.getEra();
            } else if (this.element.equals(YEAR_OF_ERA)) {
                object = thaiSolarCalendar.getYear();
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = thaiSolarCalendar.getMonth();
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = thaiSolarCalendar.getDayOfMonth();
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = thaiSolarCalendar.getDayOfYear();
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        public V getMinimum(ThaiSolarCalendar thaiSolarCalendar) {
            Object object;
            if (this.element == ERA) {
                object = ThaiSolarEra.BUDDHIST;
            } else if (Integer.class.isAssignableFrom(this.element.getType())) {
                object = 1;
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = thaiSolarCalendar.iso.getYear() >= 1941 ? Month.JANUARY : Month.APRIL;
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        public V getMaximum(ThaiSolarCalendar thaiSolarCalendar) {
            Object object;
            if (this.element == ERA) {
                object = ThaiSolarEra.BUDDHIST;
            } else if (this.element.equals(YEAR_OF_ERA)) {
                object = 1000000542;
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = thaiSolarCalendar.getYear() >= 2483 ? Month.DECEMBER : Month.MARCH;
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = thaiSolarCalendar.lengthOfMonth();
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = thaiSolarCalendar.lengthOfYear();
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        public boolean isValid(ThaiSolarCalendar thaiSolarCalendar, V v) {
            if (v == null) {
                return false;
            }
            if (this.element.getType().isEnum()) {
                if (this.element.equals(MONTH_OF_YEAR) && thaiSolarCalendar.getYear() == 2483) {
                    return ((Month)Month.class.cast(v)).getValue() >= 4;
                }
                return true;
            }
            V v2 = this.getMinimum(thaiSolarCalendar);
            V v3 = this.getMaximum(thaiSolarCalendar);
            return v2.compareTo(v) <= 0 && v.compareTo(v3) <= 0;
        }

        public ThaiSolarCalendar withValue(ThaiSolarCalendar thaiSolarCalendar, V v, boolean bl) {
            if (!this.isValid(thaiSolarCalendar, v)) {
                throw new IllegalArgumentException("Out of range: " + v);
            }
            if (this.element == ERA) {
                return thaiSolarCalendar;
            }
            if (this.element.equals(YEAR_OF_ERA)) {
                ThaiSolarCalendar thaiSolarCalendar2 = ThaiSolarCalendar.ofBuddhist(FieldRule.toNumber(v), thaiSolarCalendar.getMonth(), 1);
                return (ThaiSolarCalendar)thaiSolarCalendar2.with(DAY_OF_MONTH, Math.min(thaiSolarCalendar.getDayOfMonth(), thaiSolarCalendar2.lengthOfMonth()));
            }
            if (this.element.equals(MONTH_OF_YEAR)) {
                ThaiSolarCalendar thaiSolarCalendar3 = ThaiSolarCalendar.ofBuddhist(thaiSolarCalendar.getYear(), (Month)Month.class.cast(v), 1);
                return (ThaiSolarCalendar)thaiSolarCalendar3.with(DAY_OF_MONTH, Math.min(thaiSolarCalendar.getDayOfMonth(), thaiSolarCalendar3.lengthOfMonth()));
            }
            if (this.element.equals(DAY_OF_MONTH)) {
                PlainDate plainDate = (PlainDate)thaiSolarCalendar.iso.with((ChronoElement)PlainDate.DAY_OF_MONTH, FieldRule.toNumber(v));
                return new ThaiSolarCalendar(plainDate);
            }
            if (this.element.equals(DAY_OF_YEAR)) {
                int n = thaiSolarCalendar.iso.getYear() >= 1941 ? 1 : 4;
                ThaiSolarCalendar thaiSolarCalendar4 = ThaiSolarCalendar.ofBuddhist(thaiSolarCalendar.getYear(), n, 1);
                PlainDate plainDate = thaiSolarCalendar4.iso.plus((long)(FieldRule.toNumber(v) - 1), CalendarUnit.DAYS);
                return new ThaiSolarCalendar(plainDate);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        public ChronoElement<?> getChildAtFloor(ThaiSolarCalendar thaiSolarCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        public ChronoElement<?> getChildAtCeiling(ThaiSolarCalendar thaiSolarCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        private static int toNumber(Object object) {
            return (Integer)Integer.class.cast(object);
        }
    }

    private static class Transformer
    implements EraYearMonthDaySystem<ThaiSolarCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            try {
                if (calendarEra instanceof ThaiSolarEra && n >= 1) {
                    int n4 = ((ThaiSolarEra)((Object)ThaiSolarEra.class.cast(calendarEra))).toIsoYear(n, n2);
                    return n4 <= 999999999 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= GregorianMath.getLengthOfMonth((int)n4, (int)n2);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            try {
                int n3 = ((ThaiSolarEra)((Object)ThaiSolarEra.class.cast(calendarEra))).toIsoYear(n, n2);
                return GregorianMath.getLengthOfMonth((int)n3, (int)n2);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(runtimeException.getMessage(), runtimeException);
            }
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Out of bounds: " + n);
            }
            if (calendarEra.equals((Object)ThaiSolarEra.BUDDHIST)) {
                int n2 = n - 543;
                if (n2 == 1940) {
                    return 275;
                }
                if (n2 < 1940) {
                    ++n2;
                }
                return GregorianMath.isLeapYear((int)n2) ? 366 : 365;
            }
            if (calendarEra.equals((Object)ThaiSolarEra.RATTANAKOSIN)) {
                return GregorianMath.isLeapYear((int)(n + 1782)) ? 366 : 365;
            }
            throw new IllegalArgumentException("Invalid calendar era: " + calendarEra);
        }

        public ThaiSolarCalendar transform(long l) {
            return new ThaiSolarCalendar(PlainDate.of((long)l, (EpochDays)EpochDays.UTC));
        }

        public long transform(ThaiSolarCalendar thaiSolarCalendar) {
            return (Long)thaiSolarCalendar.iso.get((ChronoElement)EpochDays.UTC);
        }

        public long getMinimumSinceUTC() {
            return MIN_ISO.getDaysSinceEpochUTC();
        }

        public long getMaximumSinceUTC() {
            return PlainDate.axis().getCalendarSystem().getMaximumSinceUTC();
        }

        public List<CalendarEra> getEras() {
            ThaiSolarEra thaiSolarEra = ThaiSolarEra.RATTANAKOSIN;
            ThaiSolarEra thaiSolarEra2 = ThaiSolarEra.BUDDHIST;
            return Arrays.asList(new CalendarEra[]{thaiSolarEra, thaiSolarEra2});
        }
    }
}

