/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.PlainDate;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.EpochDays;
import net.time4j.format.CalendarText;
import net.time4j.format.TextWidth;

public enum ThaiSolarEra implements CalendarEra
{
    RATTANAKOSIN,
    BUDDHIST;


    public int getValue() {
        return this.ordinal();
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth) {
        CalendarText calendarText = CalendarText.getInstance((String)"buddhist", (Locale)locale);
        return calendarText.getEras(textWidth).print((Enum)this);
    }

    public int getYear(CalendarDate calendarDate) {
        int n;
        PlainDate plainDate = PlainDate.of((long)calendarDate.getDaysSinceEpochUTC(), (EpochDays)EpochDays.UTC);
        if (this == RATTANAKOSIN) {
            n = plainDate.getYear() - 1781;
            if (plainDate.getMonth() < 4) {
                --n;
            }
        } else {
            n = plainDate.getYear() + 543;
            if (n < 2484 && plainDate.getMonth() < 4) {
                --n;
            }
        }
        if (n < 1) {
            throw new IllegalArgumentException("Out of range: " + calendarDate);
        }
        return n;
    }

    int toIsoYear(int n, int n2) {
        int n3;
        if (n < 1) {
            throw new IllegalArgumentException("Out of bounds: " + n);
        }
        if (this == RATTANAKOSIN) {
            n3 = MathUtils.safeAdd((int)n, (int)1781);
            if (n2 < 4) {
                n3 = MathUtils.safeAdd((int)n3, (int)1);
            }
        } else {
            n3 = MathUtils.safeSubtract((int)n, (int)543);
            if (n2 < 4) {
                if (n3 == 1940) {
                    throw new IllegalArgumentException("Buddhist year 2483 does not know month: " + n2);
                }
                if (n3 < 1940) {
                    n3 = MathUtils.safeAdd((int)n3, (int)1);
                }
            }
        }
        return n3;
    }
}

