/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import net.time4j.Weekday;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.IntElementRule;

final class WeekdayInMonthElement<T extends ChronoEntity<T>>
extends StdIntegerDateElement<T>
implements OrdinalWeekdayElement<T> {
    private static final int LAST = Integer.MAX_VALUE;
    private static final long serialVersionUID = 4275169663905222176L;
    private final transient ChronoElement<Integer> domElement;
    private final transient ChronoElement<Weekday> dowElement;

    WeekdayInMonthElement(Class<T> clazz, ChronoElement<Integer> chronoElement, ChronoElement<Weekday> chronoElement2) {
        super("WEEKDAY_IN_MONTH", clazz, 1, (Integer)chronoElement.getDefaultMaximum() / 7, 'F', new WeekOperator(true), new WeekOperator(false));
        this.domElement = chronoElement;
        this.dowElement = chronoElement2;
    }

    @Override
    public ChronoOperator<T> setToFirst(Weekday weekday) {
        return this.setTo(1, weekday);
    }

    @Override
    public ChronoOperator<T> setToLast(Weekday weekday) {
        return this.setTo(Integer.MAX_VALUE, weekday);
    }

    @Override
    public ChronoOperator<T> setTo(int n, Weekday weekday) {
        return new SetOperator(this, n, weekday);
    }

    static <T extends ChronoEntity<T>> ElementRule<T, Integer> getRule(WeekdayInMonthElement<T> weekdayInMonthElement) {
        return new Rule<T>(weekdayInMonthElement);
    }

    private static class WeekOperator<T extends ChronoEntity<T>>
    implements ChronoOperator<T> {
        private final boolean backwards;

        WeekOperator(boolean bl) {
            this.backwards = bl;
        }

        public T apply(T t) {
            long l = (Long)t.get((ChronoElement)EpochDays.UTC);
            l = this.backwards ? (l -= 7L) : (l += 7L);
            return (T)t.with((ChronoElement)EpochDays.UTC, l);
        }
    }

    private static class SetOperator<T extends ChronoEntity<T>>
    implements ChronoOperator<T> {
        private final WeekdayInMonthElement<T> wim;
        private final long ordinal;
        private final Weekday dayOfWeek;

        SetOperator(WeekdayInMonthElement<T> weekdayInMonthElement, int n, Weekday weekday) {
            if (weekday == null) {
                throw new NullPointerException("Missing value.");
            }
            this.wim = weekdayInMonthElement;
            this.ordinal = n;
            this.dayOfWeek = weekday;
        }

        public T apply(T t) {
            long l;
            int n;
            Weekday weekday = (Weekday)t.get(((WeekdayInMonthElement)this.wim).dowElement);
            int n2 = t.getInt(((WeekdayInMonthElement)this.wim).domElement);
            if (this.ordinal == Integer.MAX_VALUE) {
                n = (Integer)t.getMaximum(((WeekdayInMonthElement)this.wim).domElement);
                int n3 = weekday.getValue() + (n - n2) % 7;
                if (n3 > 7) {
                    n3 -= 7;
                }
                int n4 = this.dayOfWeek.getValue() - n3;
                l = n - n2 + n4;
                if (n4 > 0) {
                    l -= 7L;
                }
            } else {
                n = this.dayOfWeek.getValue() - weekday.getValue();
                l = (this.ordinal - (long)(Math.floorDiv(n2 + n - 1, 7) + 1)) * 7L + (long)n;
            }
            long l2 = ((CalendarDate)t).getDaysSinceEpochUTC();
            return (T)t.with((ChronoElement)EpochDays.UTC, l2 + l);
        }
    }

    private static class Rule<T extends ChronoEntity<T>>
    implements IntElementRule<T> {
        private final WeekdayInMonthElement<T> wim;

        Rule(WeekdayInMonthElement<T> weekdayInMonthElement) {
            this.wim = weekdayInMonthElement;
        }

        public Integer getValue(T t) {
            return this.getInt(t);
        }

        public Integer getMinimum(T t) {
            return 1;
        }

        public Integer getMaximum(T t) {
            return this.getMax(t);
        }

        public boolean isValid(T t, Integer n) {
            return n != null && this.isValid(t, (int)n);
        }

        public T withValue(T t, Integer n, boolean bl) {
            if (n != null) {
                return this.withValue(t, (int)n, bl);
            }
            throw new IllegalArgumentException("Missing value.");
        }

        public ChronoElement<?> getChildAtFloor(T t) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(T t) {
            return null;
        }

        public boolean isValid(T t, int n) {
            return n >= 1 && n <= this.getMax(t);
        }

        public T withValue(T t, int n, boolean bl) {
            if (this.isValid(t, n)) {
                Weekday weekday = (Weekday)t.get(((WeekdayInMonthElement)this.wim).dowElement);
                return (T)t.with(this.wim.setTo(n, weekday));
            }
            throw new IllegalArgumentException("Invalid value: " + n);
        }

        public int getInt(T t) {
            int n = t.getInt(((WeekdayInMonthElement)this.wim).domElement);
            return Math.floorDiv(n - 1, 7) + 1;
        }

        private int getMax(T t) {
            int n = t.getInt(((WeekdayInMonthElement)this.wim).domElement);
            int n2 = (Integer)t.getMaximum(((WeekdayInMonthElement)this.wim).domElement);
            while (n + 7 <= n2) {
                n += 7;
            }
            return Math.floorDiv(n - 1, 7) + 1;
        }
    }
}

