/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.util.Optional;
import net.time4j.calendar.ChineseCalendar;
import net.time4j.calendar.CopticCalendar;
import net.time4j.calendar.EthiopianCalendar;
import net.time4j.calendar.HebrewCalendar;
import net.time4j.calendar.HijriCalendar;
import net.time4j.calendar.HistoricCalendar;
import net.time4j.calendar.IndianCalendar;
import net.time4j.calendar.JapaneseCalendar;
import net.time4j.calendar.JucheCalendar;
import net.time4j.calendar.JulianCalendar;
import net.time4j.calendar.KoreanCalendar;
import net.time4j.calendar.MinguoCalendar;
import net.time4j.calendar.PersianCalendar;
import net.time4j.calendar.ThaiSolarCalendar;
import net.time4j.calendar.VietnameseCalendar;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarProvider;
import net.time4j.engine.Chronology;

public class GenericCalendarProviderSPI
implements CalendarProvider {
    public Optional<Chronology<? extends CalendarDate>> findChronology(String string) {
        switch (string) {
            case "buddhist": {
                return Optional.of(ThaiSolarCalendar.axis());
            }
            case "chinese": {
                return Optional.of(ChineseCalendar.axis());
            }
            case "coptic": {
                return Optional.of(CopticCalendar.axis());
            }
            case "dangi": {
                return Optional.of(KoreanCalendar.axis());
            }
            case "ethiopic": 
            case "ethioaa": 
            case "ethiopic-amete-alem": {
                return Optional.of(EthiopianCalendar.axis());
            }
            case "hebrew": {
                return Optional.of(HebrewCalendar.axis());
            }
            case "historic": {
                return Optional.of(HistoricCalendar.family());
            }
            case "indian": {
                return Optional.of(IndianCalendar.axis());
            }
            case "islamic": 
            case "islamic-rgsa": 
            case "islamic-icu4j": 
            case "islamic-diyanet": 
            case "islamicc": 
            case "islamic-civil": 
            case "islamic-tbla": 
            case "islamic-umalqura": {
                return Optional.of(HijriCalendar.family());
            }
            case "japanese": {
                return Optional.of(JapaneseCalendar.axis());
            }
            case "juche": {
                return Optional.of(JucheCalendar.axis());
            }
            case "julian": {
                return Optional.of(JulianCalendar.axis());
            }
            case "persian": {
                return Optional.of(PersianCalendar.axis());
            }
            case "roc": {
                return Optional.of(MinguoCalendar.axis());
            }
            case "vietnam": {
                return Optional.of(VietnameseCalendar.axis());
            }
        }
        return Optional.empty();
    }
}

