/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import net.time4j.base.GregorianDate;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.tz.SPX;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;

final class FallbackTimezone
extends Timezone {
    private static final long serialVersionUID = -2894726563499525332L;
    private final TZID tzid;
    private final Timezone fallback;

    FallbackTimezone(TZID tZID, Timezone timezone) {
        if (tZID == null || timezone == null) {
            throw new NullPointerException();
        }
        this.tzid = tZID;
        this.fallback = timezone;
    }

    @Override
    public TZID getID() {
        return this.tzid;
    }

    @Override
    public ZonalOffset getOffset(UnixTime unixTime) {
        return this.fallback.getOffset(unixTime);
    }

    @Override
    public ZonalOffset getStandardOffset(UnixTime unixTime) {
        return this.fallback.getStandardOffset(unixTime);
    }

    @Override
    public ZonalOffset getDaylightSavingOffset(UnixTime unixTime) {
        return this.fallback.getDaylightSavingOffset(unixTime);
    }

    @Override
    public ZonalOffset getOffset(GregorianDate gregorianDate, WallTime wallTime) {
        return this.fallback.getOffset(gregorianDate, wallTime);
    }

    @Override
    public boolean isInvalid(GregorianDate gregorianDate, WallTime wallTime) {
        return this.fallback.isInvalid(gregorianDate, wallTime);
    }

    @Override
    public boolean isDaylightSaving(UnixTime unixTime) {
        return this.fallback.isDaylightSaving(unixTime);
    }

    @Override
    public boolean isFixed() {
        return this.fallback.isFixed();
    }

    @Override
    public TransitionHistory getHistory() {
        return this.fallback.getHistory();
    }

    @Override
    public TransitionStrategy getStrategy() {
        return this.fallback.getStrategy();
    }

    @Override
    public Timezone with(TransitionStrategy transitionStrategy) {
        return new FallbackTimezone(this.tzid, this.fallback.with(transitionStrategy));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FallbackTimezone) {
            FallbackTimezone fallbackTimezone = (FallbackTimezone)object;
            return this.tzid.canonical().equals(fallbackTimezone.tzid.canonical()) && this.fallback.equals(fallbackTimezone.fallback);
        }
        return false;
    }

    public int hashCode() {
        return this.tzid.canonical().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(':');
        stringBuilder.append(this.tzid.canonical());
        stringBuilder.append(",fallback=");
        stringBuilder.append(this.fallback);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    Timezone getFallback() {
        return this.fallback;
    }

    private Object writeReplace() {
        return new SPX(this, 12);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

