/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.time4j.format.PluralCategory;
import net.time4j.format.TextWidth;
import net.time4j.format.UnitPatternProvider;
import net.time4j.i18n.UTF8ResourceBundle;
import net.time4j.i18n.UnitPatternControl;

public final class UnitPatternSPI
implements UnitPatternProvider {
    public String getYearPattern(Locale language, TextWidth width, PluralCategory category) {
        return this.getUnitPattern(language, 'Y', width, category);
    }

    public String getMonthPattern(Locale language, TextWidth width, PluralCategory category) {
        return this.getUnitPattern(language, 'M', width, category);
    }

    public String getWeekPattern(Locale language, TextWidth width, PluralCategory category) {
        return this.getUnitPattern(language, 'W', width, category);
    }

    public String getDayPattern(Locale language, TextWidth width, PluralCategory category) {
        return this.getUnitPattern(language, 'D', width, category);
    }

    public String getHourPattern(Locale language, TextWidth width, PluralCategory category) {
        return this.getUnitPattern(language, 'H', width, category);
    }

    public String getMinutePattern(Locale language, TextWidth width, PluralCategory category) {
        return this.getUnitPattern(language, 'N', width, category);
    }

    public String getSecondPattern(Locale language, TextWidth width, PluralCategory category) {
        return this.getUnitPattern(language, 'S', width, category);
    }

    public String getMilliPattern(Locale lang, TextWidth width, PluralCategory category) {
        return this.getUnitPattern(lang, '3', width, category);
    }

    public String getMicroPattern(Locale lang, TextWidth width, PluralCategory category) {
        return this.getUnitPattern(lang, '6', width, category);
    }

    public String getNanoPattern(Locale lang, TextWidth width, PluralCategory category) {
        return this.getUnitPattern(lang, '9', width, category);
    }

    public String getYearPattern(Locale language, boolean future, PluralCategory category) {
        return this.getRelativePattern(language, 'Y', future, category);
    }

    public String getMonthPattern(Locale language, boolean future, PluralCategory category) {
        return this.getRelativePattern(language, 'M', future, category);
    }

    public String getWeekPattern(Locale language, boolean future, PluralCategory category) {
        return this.getRelativePattern(language, 'W', future, category);
    }

    public String getDayPattern(Locale language, boolean future, PluralCategory category) {
        return this.getRelativePattern(language, 'D', future, category);
    }

    public String getHourPattern(Locale language, boolean future, PluralCategory category) {
        return this.getRelativePattern(language, 'H', future, category);
    }

    public String getMinutePattern(Locale language, boolean future, PluralCategory category) {
        return this.getRelativePattern(language, 'N', future, category);
    }

    public String getSecondPattern(Locale language, boolean future, PluralCategory category) {
        return this.getRelativePattern(language, 'S', future, category);
    }

    public String getNowWord(Locale lang) {
        return this.getPattern(lang, "reltime/pattern", "now", null, PluralCategory.OTHER);
    }

    public String getListPattern(Locale lang, TextWidth width, int size) {
        String previous;
        String exact;
        ResourceBundle.Control control;
        if (size < 2) {
            throw new IllegalArgumentException("Size must be greater than 1.");
        }
        ClassLoader loader = this.getClass().getClassLoader();
        ResourceBundle rb = ResourceBundle.getBundle("units/pattern", lang, loader, control = UnitPatternControl.SINGLETON);
        if (rb.containsKey(exact = UnitPatternSPI.buildListKey(width, String.valueOf(size)))) {
            return rb.getString(exact);
        }
        String end = rb.getString(UnitPatternSPI.buildListKey(width, "end"));
        if (size == 2) {
            return end;
        }
        String start = rb.getString(UnitPatternSPI.buildListKey(width, "start"));
        String middle = rb.getString(UnitPatternSPI.buildListKey(width, "middle"));
        end = UnitPatternSPI.replace(end, '1', size - 1);
        String result = previous = (end = UnitPatternSPI.replace(end, '0', size - 2));
        for (int i = size - 3; i >= 0; --i) {
            String pattern = i == 0 ? start : middle;
            int pos = -1;
            int n = pattern.length();
            for (int j = n - 1; j >= 0; --j) {
                if (j < 2 || pattern.charAt(j) != '}' || pattern.charAt(j - 1) != '1' || pattern.charAt(j - 2) != '{') continue;
                pos = j - 2;
                break;
            }
            if (pos > -1) {
                result = pattern.substring(0, pos) + previous;
                if (pos < n - 3) {
                    result = result + pattern.substring(pos + 3);
                }
            }
            if (i <= 0) continue;
            previous = UnitPatternSPI.replace(result, '0', i);
        }
        return result;
    }

    private String getUnitPattern(Locale lang, char unitID, TextWidth width, PluralCategory category) {
        return this.getPattern(lang, "units/pattern", UnitPatternSPI.buildKey(unitID, width, category), UnitPatternSPI.buildKey(unitID, width, PluralCategory.OTHER), category);
    }

    private String getRelativePattern(Locale lang, char unitID, boolean future, PluralCategory category) {
        return this.getPattern(lang, "reltime/pattern", UnitPatternSPI.buildKey(unitID, future, category), UnitPatternSPI.buildKey(unitID, future, PluralCategory.OTHER), category);
    }

    private String getPattern(Locale lang, String baseName, String key, String alt, PluralCategory category) {
        ClassLoader loader = this.getClass().getClassLoader();
        ResourceBundle.Control control = UnitPatternControl.SINGLETON;
        boolean init = true;
        ResourceBundle first = null;
        for (Locale locale : control.getCandidateLocales(baseName, lang)) {
            UTF8ResourceBundle bundle;
            ResourceBundle rb;
            ResourceBundle resourceBundle = rb = init && first != null ? first : ResourceBundle.getBundle(baseName, locale, loader, control);
            if (init) {
                if (rb.getLocale().equals(locale)) {
                    init = false;
                } else {
                    first = rb;
                    continue;
                }
            }
            if ((bundle = (UTF8ResourceBundle)UTF8ResourceBundle.class.cast(rb)).getInternalKeys().contains(key)) {
                return bundle.getString(key);
            }
            if (category == PluralCategory.OTHER || !bundle.getInternalKeys().contains(alt)) continue;
            return bundle.getString(alt);
        }
        throw new MissingResourceException("Can't find resource for bundle " + baseName + ".properties, key " + key, baseName + ".properties", key);
    }

    private static String buildKey(char unitID, TextWidth width, PluralCategory category) {
        StringBuilder sb = new StringBuilder(3);
        sb.append(unitID);
        switch (width) {
            case WIDE: {
                sb.append('w');
                break;
            }
            case ABBREVIATED: 
            case SHORT: {
                sb.append('s');
                break;
            }
            case NARROW: {
                sb.append('n');
                break;
            }
            default: {
                throw new UnsupportedOperationException(width.name());
            }
        }
        return sb.append(category.ordinal()).toString();
    }

    private static String buildKey(char unitID, boolean future, PluralCategory category) {
        StringBuilder sb = new StringBuilder(3);
        sb.append(unitID);
        sb.append(future ? (char)'+' : '-');
        return sb.append(category.ordinal()).toString();
    }

    private static String buildListKey(TextWidth width, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append('L');
        switch (width) {
            case WIDE: {
                sb.append('w');
                break;
            }
            case ABBREVIATED: 
            case SHORT: {
                sb.append('s');
                break;
            }
            case NARROW: {
                sb.append('n');
                break;
            }
            default: {
                throw new UnsupportedOperationException(width.name());
            }
        }
        return sb.append('-').append(suffix).toString();
    }

    private static String replace(String s, char search, int value) {
        int n = s.length() - 2;
        for (int i = 0; i < n; ++i) {
            if (s.charAt(i) != '{' || s.charAt(i + 1) != search || s.charAt(i + 2) != '}') continue;
            StringBuilder b = new StringBuilder(n + 10);
            b.append(s);
            b.replace(i + 1, i + 2, String.valueOf(value));
            return b.toString();
        }
        return s;
    }
}

