/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.text.DateFormatSymbols;
import java.text.Normalizer;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;
import net.time4j.i18n.UTF8ResourceControl;

public final class IsoTextProviderSPI
implements TextProvider {
    public String[] getSupportedCalendarTypes() {
        return new String[]{"iso8601"};
    }

    public Locale[] getAvailableLocales() {
        return DateFormatSymbols.getAvailableLocales();
    }

    public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
        String[] stringArray;
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null && !locale.equals(Locale.ROOT)) {
            String string2 = IsoTextProviderSPI.getKey(resourceBundle, "MONTH_OF_YEAR");
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray = outputContext == OutputContext.STANDALONE && "true".equals(resourceBundle.getObject("enableStandalone")) ? IsoTextProviderSPI.lookupBundle(resourceBundle, 12, string2, textWidth, outputContext) : IsoTextProviderSPI.lookupBundle(resourceBundle, 12, string2, textWidth)) != null) {
                return stringArray;
            }
            if (textWidth == TextWidth.NARROW) {
                stringArray = this.months("", locale, TextWidth.SHORT, outputContext, false);
                return IsoTextProviderSPI.narrow(stringArray, 12);
            }
        }
        stringArray = DateFormatSymbols.getInstance(locale);
        switch (textWidth) {
            case WIDE: {
                return stringArray.getMonths();
            }
            case ABBREVIATED: 
            case SHORT: {
                return stringArray.getShortMonths();
            }
            case NARROW: {
                return IsoTextProviderSPI.narrow(stringArray.getShortMonths(), 12);
            }
        }
        throw new UnsupportedOperationException(textWidth.name());
    }

    public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null) {
            String[] stringArray;
            String string2 = IsoTextProviderSPI.getKey(resourceBundle, "QUARTER_OF_YEAR");
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray = outputContext == OutputContext.STANDALONE && "true".equals(resourceBundle.getObject("enableStandalone")) ? IsoTextProviderSPI.lookupBundle(resourceBundle, 4, string2, textWidth, outputContext) : IsoTextProviderSPI.lookupBundle(resourceBundle, 4, string2, textWidth)) != null) {
                return stringArray;
            }
        }
        return new String[]{"Q1", "Q2", "Q3", "Q4"};
    }

    public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        Object object;
        String[] stringArray;
        String[] stringArray2;
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null && !locale.equals(Locale.ROOT)) {
            stringArray2 = IsoTextProviderSPI.getKey(resourceBundle, "DAY_OF_WEEK");
            stringArray = outputContext == OutputContext.STANDALONE && "true".equals(resourceBundle.getObject("enableStandalone")) ? IsoTextProviderSPI.lookupBundle(resourceBundle, 7, (String)stringArray2, textWidth, outputContext) : IsoTextProviderSPI.lookupBundle(resourceBundle, 7, (String)stringArray2, textWidth);
            if (stringArray != null) {
                return stringArray;
            }
            if (textWidth == TextWidth.SHORT) {
                return this.weekdays("", locale, TextWidth.ABBREVIATED, outputContext);
            }
            if (textWidth == TextWidth.NARROW) {
                stringArray = this.weekdays("", locale, TextWidth.SHORT, outputContext);
                return IsoTextProviderSPI.narrow(stringArray, 7);
            }
        }
        stringArray = DateFormatSymbols.getInstance(locale);
        switch (textWidth) {
            case WIDE: {
                stringArray2 = stringArray.getWeekdays();
                break;
            }
            case ABBREVIATED: 
            case SHORT: {
                stringArray2 = stringArray.getShortWeekdays();
                break;
            }
            case NARROW: {
                object = this.weekdays("", locale, TextWidth.SHORT, outputContext);
                stringArray2 = IsoTextProviderSPI.narrow(object, 7);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown text width: " + textWidth);
            }
        }
        if (stringArray2.length > 7) {
            object = stringArray2[1];
            String[] stringArray3 = new String[7];
            for (int i = 2; i < 8; ++i) {
                stringArray3[i - 2] = stringArray2[i];
            }
            stringArray3[6] = object;
            stringArray2 = stringArray3;
        }
        return stringArray2;
    }

    public String[] eras(String string, Locale locale, TextWidth textWidth) {
        Object object;
        String[] stringArray;
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null && !locale.equals(Locale.ROOT) && (stringArray = IsoTextProviderSPI.lookupBundle(resourceBundle, 2, (String)(object = IsoTextProviderSPI.getKey(resourceBundle, "ERA")), textWidth)) != null) {
            return stringArray;
        }
        object = DateFormatSymbols.getInstance(locale);
        if (textWidth == TextWidth.NARROW) {
            stringArray = ((DateFormatSymbols)object).getEras();
            String[] stringArray2 = new String[stringArray.length];
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = !stringArray[i].isEmpty() ? IsoTextProviderSPI.toSingleLetter(stringArray[i]) : (i == 0 && stringArray.length == 2 ? "B" : (i == 1 && stringArray.length == 2 ? "A" : String.valueOf(i)));
            }
            return stringArray2;
        }
        return ((DateFormatSymbols)object).getEras();
    }

    public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
        String string2;
        String[] stringArray;
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null && !locale.equals(Locale.ROOT) && (stringArray = IsoTextProviderSPI.lookupBundle(resourceBundle, 2, string2 = IsoTextProviderSPI.getKey(resourceBundle, "AM_PM_OF_DAY"), textWidth)) != null) {
            return stringArray;
        }
        if (textWidth == TextWidth.NARROW) {
            return new String[]{"A", "P"};
        }
        return DateFormatSymbols.getInstance(locale).getAmPmStrings();
    }

    public String toString() {
        return "IsoTextProviderSPI";
    }

    private static String[] narrow(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = !stringArray[i].isEmpty() ? IsoTextProviderSPI.toSingleLetter(stringArray[i]) : String.valueOf(i + 1);
        }
        return stringArray2;
    }

    private static String toSingleLetter(String string) {
        char c = Normalizer.normalize(string, Normalizer.Form.NFD).charAt(0);
        if (c >= 'A' && c <= 'Z') {
            return String.valueOf(c);
        }
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
            return String.valueOf(c);
        }
        if (c >= '\u0410' && c <= '\u042f') {
            return String.valueOf(c);
        }
        if (c >= '\u0430' && c <= '\u044f') {
            c = (char)(c - 32);
            return String.valueOf(c);
        }
        return string;
    }

    private static ResourceBundle getBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle("calendar/iso8601", locale, IsoTextProviderSPI.getLoader(), UTF8ResourceControl.SINGLETON);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static String[] lookupBundle(ResourceBundle resourceBundle, int n, String string, TextWidth textWidth) {
        return IsoTextProviderSPI.lookupBundle(resourceBundle, n, string, textWidth, null);
    }

    private static String[] lookupBundle(ResourceBundle resourceBundle, int n, String string, TextWidth textWidth, OutputContext outputContext) {
        String[] stringArray = new String[n];
        boolean bl = string.length() == 1;
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append('(');
            if (bl) {
                char c = textWidth.name().charAt(0);
                if (outputContext != OutputContext.STANDALONE) {
                    c = Character.toLowerCase(c);
                }
                stringBuilder.append(c);
            } else {
                stringBuilder.append(textWidth.name());
                if (outputContext == OutputContext.STANDALONE) {
                    stringBuilder.append('|');
                    stringBuilder.append(outputContext.name());
                }
            }
            stringBuilder.append(')');
            stringBuilder.append('_');
            stringBuilder.append(i + 1);
            String string2 = stringBuilder.toString();
            if (!resourceBundle.containsKey(string2)) {
                return null;
            }
            stringArray[i] = resourceBundle.getString(string2);
        }
        return stringArray;
    }

    private static String getKey(ResourceBundle resourceBundle, String string) {
        if (resourceBundle.containsKey("useShortKeys") && "true".equals(resourceBundle.getString("useShortKeys"))) {
            return string.substring(0, 1);
        }
        return string;
    }

    private static ClassLoader getLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = CalendarText.class.getClassLoader();
        }
        return classLoader;
    }
}

