/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.text.DateFormatSymbols;
import java.text.Normalizer;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.UTF8ResourceControl;

public final class IsoTextProviderSPI
implements TextProvider {
    public String[] getSupportedCalendarTypes() {
        return new String[]{"iso8601"};
    }

    public Locale[] getAvailableLocales() {
        return DateFormatSymbols.getAvailableLocales();
    }

    public String[] months(String calendarType, Locale locale, TextWidth tw, OutputContext oc, boolean leapForm) {
        ResourceBundle rb = IsoTextProviderSPI.getBundle(locale);
        if (rb != null && !locale.equals(Locale.ROOT)) {
            String[] names;
            String key = IsoTextProviderSPI.getKey(rb, "MONTH_OF_YEAR");
            if (tw == TextWidth.SHORT) {
                tw = TextWidth.ABBREVIATED;
            }
            if ((names = oc == OutputContext.STANDALONE && "true".equals(rb.getObject("enableStandalone")) ? IsoTextProviderSPI.lookupBundle(rb, 12, key, tw, oc) : IsoTextProviderSPI.lookupBundle(rb, 12, key, tw)) != null) {
                return names;
            }
            if (tw == TextWidth.NARROW) {
                names = this.months("", locale, TextWidth.SHORT, oc, false);
                return IsoTextProviderSPI.narrow(names, 12);
            }
        }
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
        switch (tw) {
            case WIDE: {
                return dfs.getMonths();
            }
            case ABBREVIATED: 
            case SHORT: {
                return dfs.getShortMonths();
            }
            case NARROW: {
                return IsoTextProviderSPI.narrow(dfs.getShortMonths(), 12);
            }
        }
        throw new UnsupportedOperationException(tw.name());
    }

    public String[] quarters(String calendarType, Locale locale, TextWidth tw, OutputContext oc) {
        ResourceBundle rb = IsoTextProviderSPI.getBundle(locale);
        if (rb != null) {
            String[] names;
            String key = IsoTextProviderSPI.getKey(rb, "QUARTER_OF_YEAR");
            if (tw == TextWidth.SHORT) {
                tw = TextWidth.ABBREVIATED;
            }
            if ((names = oc == OutputContext.STANDALONE && "true".equals(rb.getObject("enableStandalone")) ? IsoTextProviderSPI.lookupBundle(rb, 4, key, tw, oc) : IsoTextProviderSPI.lookupBundle(rb, 4, key, tw)) != null) {
                return names;
            }
        }
        return new String[]{"Q1", "Q2", "Q3", "Q4"};
    }

    public String[] weekdays(String calendarType, Locale locale, TextWidth tw, OutputContext oc) {
        String[] result;
        ResourceBundle rb = IsoTextProviderSPI.getBundle(locale);
        if (rb != null && !locale.equals(Locale.ROOT)) {
            String key = IsoTextProviderSPI.getKey(rb, "DAY_OF_WEEK");
            String[] names = oc == OutputContext.STANDALONE && "true".equals(rb.getObject("enableStandalone")) ? IsoTextProviderSPI.lookupBundle(rb, 7, key, tw, oc) : IsoTextProviderSPI.lookupBundle(rb, 7, key, tw);
            if (names != null) {
                return names;
            }
            if (tw == TextWidth.SHORT) {
                return this.weekdays("", locale, TextWidth.ABBREVIATED, oc);
            }
            if (tw == TextWidth.NARROW) {
                names = this.weekdays("", locale, TextWidth.SHORT, oc);
                return IsoTextProviderSPI.narrow(names, 7);
            }
        }
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
        switch (tw) {
            case WIDE: {
                result = dfs.getWeekdays();
                break;
            }
            case ABBREVIATED: 
            case SHORT: {
                result = dfs.getShortWeekdays();
                break;
            }
            case NARROW: {
                String[] names = this.weekdays("", locale, TextWidth.SHORT, oc);
                result = IsoTextProviderSPI.narrow(names, 7);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown text width: " + tw);
            }
        }
        if (result.length > 7) {
            String sunday = result[1];
            String[] arr = new String[7];
            for (int i = 2; i < 8; ++i) {
                arr[i - 2] = result[i];
            }
            arr[6] = sunday;
            result = arr;
        }
        return result;
    }

    public String[] eras(String calendarType, Locale locale, TextWidth textWidth) {
        String key;
        String[] names;
        ResourceBundle rb = IsoTextProviderSPI.getBundle(locale);
        if (rb != null && !locale.equals(Locale.ROOT) && (names = IsoTextProviderSPI.lookupBundle(rb, 2, key = IsoTextProviderSPI.getKey(rb, "ERA"), textWidth)) != null) {
            return names;
        }
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
        if (textWidth == TextWidth.NARROW) {
            String[] eras = dfs.getEras();
            String[] ret = new String[eras.length];
            int n = eras.length;
            for (int i = 0; i < n; ++i) {
                ret[i] = !eras[i].isEmpty() ? IsoTextProviderSPI.toSingleLetter(eras[i]) : (i == 0 && eras.length == 2 ? "B" : (i == 1 && eras.length == 2 ? "A" : String.valueOf(i)));
            }
            return ret;
        }
        return dfs.getEras();
    }

    public String[] meridiems(String calendarType, Locale locale, TextWidth textWidth) {
        String key;
        String[] names;
        ResourceBundle rb = IsoTextProviderSPI.getBundle(locale);
        if (rb != null && !locale.equals(Locale.ROOT) && (names = IsoTextProviderSPI.lookupBundle(rb, 2, key = IsoTextProviderSPI.getKey(rb, "AM_PM_OF_DAY"), textWidth)) != null) {
            return names;
        }
        if (textWidth == TextWidth.NARROW) {
            return new String[]{"A", "P"};
        }
        return DateFormatSymbols.getInstance(locale).getAmPmStrings();
    }

    public String toString() {
        return "IsoTextProviderSPI";
    }

    private static String[] narrow(String[] names, int len) {
        String[] ret = new String[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = !names[i].isEmpty() ? IsoTextProviderSPI.toSingleLetter(names[i]) : String.valueOf(i + 1);
        }
        return ret;
    }

    private static String toSingleLetter(String input) {
        char c = Normalizer.normalize(input, Normalizer.Form.NFD).charAt(0);
        if (c >= 'A' && c <= 'Z') {
            return String.valueOf(c);
        }
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
            return String.valueOf(c);
        }
        if (c >= '\u0410' && c <= '\u042f') {
            return String.valueOf(c);
        }
        if (c >= '\u0430' && c <= '\u044f') {
            c = (char)(c - 32);
            return String.valueOf(c);
        }
        return input;
    }

    private static ResourceBundle getBundle(Locale desired) {
        Locale lang = LanguageMatch.getAlias(desired);
        try {
            return ResourceBundle.getBundle("calendar/iso8601", lang, IsoTextProviderSPI.getLoader(), UTF8ResourceControl.SINGLETON);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    private static String[] lookupBundle(ResourceBundle rb, int len, String elementName, TextWidth tw) {
        return IsoTextProviderSPI.lookupBundle(rb, len, elementName, tw, null);
    }

    private static String[] lookupBundle(ResourceBundle rb, int len, String elementName, TextWidth tw, OutputContext oc) {
        String[] names = new String[len];
        boolean shortKey = elementName.length() == 1;
        for (int i = 0; i < len; ++i) {
            StringBuilder b = new StringBuilder();
            b.append(elementName);
            b.append('(');
            if (shortKey) {
                char c = tw.name().charAt(0);
                if (oc != OutputContext.STANDALONE) {
                    c = Character.toLowerCase(c);
                }
                b.append(c);
            } else {
                b.append(tw.name());
                if (oc == OutputContext.STANDALONE) {
                    b.append('|');
                    b.append(oc.name());
                }
            }
            b.append(')');
            b.append('_');
            b.append(i + 1);
            String key = b.toString();
            if (!rb.containsKey(key)) {
                return null;
            }
            names[i] = rb.getString(key);
        }
        return names;
    }

    private static String getKey(ResourceBundle bundle, String elementName) {
        if (bundle.containsKey("useShortKeys") && "true".equals(bundle.getString("useShortKeys"))) {
            return elementName.substring(0, 1);
        }
        return elementName;
    }

    private static ClassLoader getLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = CalendarText.class.getClassLoader();
        }
        return cl;
    }
}

