/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.UTF8ResourceControl;

public final class SymbolProviderSPI
implements NumberSymbolProvider {
    public Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public char getZeroDigit(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "zero", SymbolProviderSPI.getSymbols(locale).getZeroDigit());
    }

    public char getDecimalSeparator(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "separator", SymbolProviderSPI.getSymbols(locale).getDecimalSeparator());
    }

    public String getMinusSign(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "minus", String.valueOf(SymbolProviderSPI.getSymbols(locale).getMinusSign()));
    }

    public String toString() {
        return "SymbolProviderSPI";
    }

    private static DecimalFormatSymbols getSymbols(Locale loc) {
        return DecimalFormatSymbols.getInstance(loc);
    }

    private static char lookup(Locale locale, String key, char standard) {
        ResourceBundle rb = SymbolProviderSPI.getBundle(locale);
        if (rb != null && rb.containsKey(key)) {
            return rb.getString(key).charAt(0);
        }
        return standard;
    }

    private static String lookup(Locale locale, String key, String standard) {
        ResourceBundle rb = SymbolProviderSPI.getBundle(locale);
        if (rb != null && rb.containsKey(key)) {
            return rb.getString(key);
        }
        return standard;
    }

    private static ResourceBundle getBundle(Locale desired) {
        Locale lang = LanguageMatch.getAlias(desired);
        try {
            return ResourceBundle.getBundle("numbers/symbol", lang, SymbolProviderSPI.getLoader(), UTF8ResourceControl.SINGLETON);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    private static ClassLoader getLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = NumberSymbolProvider.class.getClassLoader();
        }
        return cl;
    }
}

