/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.time4j.i18n.UTF8ResourceBundle;

class UTF8ResourceControl
extends ResourceBundle.Control {
    public static final ResourceBundle.Control SINGLETON = new UTF8ResourceControl();

    private UTF8ResourceControl() {
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        if (baseName == null || locale == null) {
            throw new NullPointerException();
        }
        return null;
    }

    @Override
    public List<String> getFormats(String baseName) {
        return ResourceBundle.Control.FORMAT_PROPERTIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (format.equals("java.properties")) {
            UTF8ResourceBundle bundle = null;
            InputStream stream = null;
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            if (reload) {
                URL url = loader.getResource(resourceName);
                if (url != null) {
                    URLConnection uconn = url.openConnection();
                    uconn.setUseCaches(false);
                    stream = uconn.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                Reader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                    bundle = new UTF8ResourceBundle(reader);
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            return bundle;
        }
        throw new UnsupportedOperationException("Unknown resource bundle format: " + format);
    }
}

