/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.UTF8ResourceControl;

public final class SymbolProviderSPI
implements NumberSymbolProvider {
    public Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public char getZeroDigit(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "zero", SymbolProviderSPI.getSymbols(locale).getZeroDigit());
    }

    public char getDecimalSeparator(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "separator", SymbolProviderSPI.getSymbols(locale).getDecimalSeparator());
    }

    public String getMinusSign(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "minus", String.valueOf(SymbolProviderSPI.getSymbols(locale).getMinusSign()));
    }

    public String toString() {
        return "SymbolProviderSPI";
    }

    private static DecimalFormatSymbols getSymbols(Locale locale) {
        return DecimalFormatSymbols.getInstance(locale);
    }

    private static char lookup(Locale locale, String string, char c) {
        ResourceBundle resourceBundle = SymbolProviderSPI.getBundle(locale);
        if (resourceBundle != null && resourceBundle.containsKey(string)) {
            return resourceBundle.getString(string).charAt(0);
        }
        return c;
    }

    private static String lookup(Locale locale, String string, String string2) {
        ResourceBundle resourceBundle = SymbolProviderSPI.getBundle(locale);
        if (resourceBundle != null && resourceBundle.containsKey(string)) {
            return resourceBundle.getString(string);
        }
        return string2;
    }

    private static ResourceBundle getBundle(Locale locale) {
        Locale locale2 = LanguageMatch.getAlias(locale);
        try {
            return ResourceBundle.getBundle("numbers/symbol", locale2, SymbolProviderSPI.getLoader(), UTF8ResourceControl.SINGLETON);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static ClassLoader getLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = NumberSymbolProvider.class.getClassLoader();
        }
        return classLoader;
    }
}

