/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.Chronology;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;
import net.time4j.history.ChronoHistory;

final class AttributeSet
implements AttributeQuery {
    private static final NumberSymbolProvider NUMBER_SYMBOLS;
    private static final char ISO_DECIMAL_SEPARATOR;
    private static final ConcurrentMap<Locale, NumericalSymbols> NUMBER_SYMBOL_CACHE;
    private static final NumericalSymbols DEFAULT_NUMERICAL_SYMBOLS;
    private static final AttributeQuery EMPTY;
    private final Attributes attributes;
    private final Locale locale;
    private final int level;
    private final int section;
    private final ChronoCondition<ChronoDisplay> printCondition;
    private final PlainDate cutover;

    AttributeSet(Attributes attributes) {
        this(attributes, Locale.ROOT, 0, 0, null, null);
    }

    AttributeSet(Attributes attributes, Locale locale, int n, int n2, ChronoCondition<ChronoDisplay> chronoCondition, PlainDate plainDate) {
        if (attributes == null) {
            throw new NullPointerException("Missing format attributes.");
        }
        this.attributes = attributes;
        this.locale = locale == null ? Locale.ROOT : locale;
        this.level = n;
        this.section = n2;
        this.printCondition = chronoCondition;
        this.cutover = plainDate;
    }

    public boolean contains(AttributeKey<?> attributeKey) {
        if (attributeKey == ChronoHistory.ATTRIBUTE_CUTOVER_DATE) {
            return this.cutover != null;
        }
        return this.attributes.contains(attributeKey);
    }

    public <A> A get(AttributeKey<A> attributeKey) {
        if (attributeKey == ChronoHistory.ATTRIBUTE_CUTOVER_DATE) {
            if (this.cutover == null) {
                throw new NoSuchElementException(attributeKey.name());
            }
            return (A)attributeKey.type().cast(this.cutover);
        }
        return (A)this.attributes.get(attributeKey);
    }

    public <A> A get(AttributeKey<A> attributeKey, A a) {
        if (attributeKey == ChronoHistory.ATTRIBUTE_CUTOVER_DATE) {
            if (this.cutover == null) {
                throw new NoSuchElementException(attributeKey.name());
            }
            return a;
        }
        return (A)this.attributes.get(attributeKey, a);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AttributeSet) {
            AttributeSet attributeSet = (AttributeSet)object;
            return this.attributes.equals((Object)attributeSet.attributes) && this.locale.equals(attributeSet.locale) && this.level == attributeSet.level && this.section == attributeSet.section && AttributeSet.isEqual(this.printCondition, attributeSet.printCondition) && AttributeSet.isEqual(this.cutover, attributeSet.cutover);
        }
        return false;
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('[');
        stringBuilder.append(this.attributes);
        stringBuilder.append(",locale=");
        stringBuilder.append(this.locale);
        stringBuilder.append(",level=");
        stringBuilder.append(this.level);
        stringBuilder.append(",section=");
        stringBuilder.append(this.section);
        stringBuilder.append(",print-condition=");
        stringBuilder.append(this.printCondition);
        stringBuilder.append(",cutover-date=");
        stringBuilder.append(this.cutover);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    Attributes getAttributes() {
        return this.attributes;
    }

    Locale getLocale() {
        return this.locale;
    }

    int getLevel() {
        return this.level;
    }

    int getSection() {
        return this.section;
    }

    ChronoCondition<ChronoDisplay> getCondition() {
        return this.printCondition;
    }

    static AttributeSet createDefaults(Chronology<?> chronology, Locale locale) {
        Attributes.Builder builder = new Attributes.Builder(chronology);
        builder.set(Attributes.LENIENCY, (Enum)Leniency.SMART);
        builder.set(Attributes.TEXT_WIDTH, (Enum)TextWidth.WIDE);
        builder.set(Attributes.OUTPUT_CONTEXT, (Enum)OutputContext.FORMAT);
        builder.set(Attributes.PAD_CHAR, ' ');
        AttributeSet attributeSet = new AttributeSet(builder.build());
        return attributeSet.withLocale(locale);
    }

    AttributeSet withAttributes(Attributes attributes) {
        return new AttributeSet(attributes, this.locale, this.level, this.section, this.printCondition, this.cutover);
    }

    AttributeSet withLocale(Locale locale) {
        Attributes.Builder builder = new Attributes.Builder();
        builder.setAll(this.attributes);
        if (locale.getLanguage().isEmpty() && locale.getCountry().isEmpty()) {
            locale = Locale.ROOT;
            builder.set(Attributes.ZERO_DIGIT, '0');
            builder.set(Attributes.DECIMAL_SEPARATOR, ISO_DECIMAL_SEPARATOR);
        } else {
            Object object = NUMBER_SYMBOL_CACHE.get(locale);
            if (object == null) {
                object = DEFAULT_NUMERICAL_SYMBOLS;
                Object object2 = NUMBER_SYMBOLS.getAvailableLocales();
                int n = ((Locale[])object2).length;
                for (int i = 0; i < n; ++i) {
                    Locale locale2 = object2[i];
                    if (!locale.equals(locale2)) continue;
                    object = new NumericalSymbols(NUMBER_SYMBOLS.getZeroDigit(locale), NUMBER_SYMBOLS.getDecimalSeparator(locale));
                    break;
                }
                if ((object2 = NUMBER_SYMBOL_CACHE.putIfAbsent(locale, (NumericalSymbols)object)) != null) {
                    object = object2;
                }
            }
            builder.set(Attributes.ZERO_DIGIT, ((NumericalSymbols)object).zeroDigit);
            builder.set(Attributes.DECIMAL_SEPARATOR, ((NumericalSymbols)object).decimalSeparator);
        }
        builder.setLanguage(locale);
        return new AttributeSet(builder.build(), locale, this.level, this.section, this.printCondition, this.cutover);
    }

    private static boolean isEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    static {
        Iterator<NumberSymbolProvider> iterator;
        NumberSymbolProvider numberSymbolProvider = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = NumberSymbolProvider.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((iterator = ServiceLoader.load(NumberSymbolProvider.class, classLoader).iterator()).hasNext()) {
            NumberSymbolProvider numberSymbolProvider2;
            numberSymbolProvider = numberSymbolProvider2 = iterator.next();
        }
        if (numberSymbolProvider == null) {
            numberSymbolProvider = NumberSymbolProvider.DEFAULT;
        }
        NUMBER_SYMBOLS = numberSymbolProvider;
        ISO_DECIMAL_SEPARATOR = (char)(Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? 46 : 44);
        NUMBER_SYMBOL_CACHE = new ConcurrentHashMap<Locale, NumericalSymbols>();
        DEFAULT_NUMERICAL_SYMBOLS = new NumericalSymbols('0', ISO_DECIMAL_SEPARATOR);
        EMPTY = new Attributes.Builder().build();
    }

    private static class NumericalSymbols {
        private final char zeroDigit;
        private final char decimalSeparator;

        NumericalSymbols(char c, char c2) {
            this.zeroDigit = c;
            this.decimalSeparator = c2;
        }
    }
}

