/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.EpochDays;
import net.time4j.engine.TimePoint;
import net.time4j.format.TextElement;
import net.time4j.history.CalendarAlgorithm;
import net.time4j.history.CutOverEvent;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.HistoricalEraElement;
import net.time4j.history.HistoricalIntegerElement;
import net.time4j.history.SPX;

public final class ChronoHistory
implements Serializable {
    public static final AttributeKey<PlainDate> ATTRIBUTE_CUTOVER_DATE = Key.valueOf("CUTOVER_DATE", PlainDate.class);
    public static final AttributeKey<Boolean> ATTRIBUTE_COMMON_ERA = Key.valueOf("COMMON_ERA", Boolean.class);
    static final int VARIANT_PROLEPTIC_GREGORIAN = 1;
    static final int VARIANT_PROLEPTIC_JULIAN = 2;
    static final int VARIANT_SWEDEN = 4;
    static final int VARIANT_FIRST_GREGORIAN_REFORM = 7;
    static final int VARIANT_OTHER = 0;
    public static final ChronoHistory PROLEPTIC_GREGORIAN = new ChronoHistory(1, Collections.singletonList(new CutOverEvent(Long.MIN_VALUE, CalendarAlgorithm.GREGORIAN, CalendarAlgorithm.GREGORIAN)));
    public static final ChronoHistory PROLEPTIC_JULIAN = new ChronoHistory(2, Collections.singletonList(new CutOverEvent(Long.MIN_VALUE, CalendarAlgorithm.JULIAN, CalendarAlgorithm.JULIAN)));
    private static final long EARLIEST_CUTOVER = (Long)PlainDate.of((int)1582, (int)10, (int)15).get((ChronoElement)EpochDays.MODIFIED_JULIAN_DATE);
    private static final ChronoHistory INTRODUCTION_BY_POPE_GREGOR = ChronoHistory.ofGregorianReform(EARLIEST_CUTOVER);
    private static final ChronoHistory SWEDEN;
    private static final Map<String, ChronoHistory> LOOKUP;
    private static final long serialVersionUID = 1L;
    private final transient int variant;
    private final transient List<CutOverEvent> events;
    private final transient TextElement<HistoricEra> eraElement;
    private final transient TextElement<Integer> yearOfEraElement;
    private final transient TextElement<Integer> monthElement;
    private final transient TextElement<Integer> dayOfMonthElement;
    private final transient Set<ChronoElement<?>> elements;

    private ChronoHistory(int n, List<CutOverEvent> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("At least one cutover event must be present in chronological history.");
        }
        this.variant = n;
        this.events = list;
        this.eraElement = new HistoricalEraElement(this);
        this.yearOfEraElement = HistoricalIntegerElement.forYearOfEra(this);
        this.monthElement = HistoricalIntegerElement.forMonth(this);
        this.dayOfMonthElement = HistoricalIntegerElement.forDayOfMonth(this);
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(this.eraElement);
        hashSet.add(this.yearOfEraElement);
        hashSet.add(this.monthElement);
        hashSet.add(this.dayOfMonthElement);
        this.elements = Collections.unmodifiableSet(hashSet);
    }

    public static ChronoHistory ofFirstGregorianReform() {
        return INTRODUCTION_BY_POPE_GREGOR;
    }

    public static ChronoHistory ofGregorianReform(PlainDate plainDate) {
        long l = (Long)plainDate.get((ChronoElement)EpochDays.MODIFIED_JULIAN_DATE);
        ChronoHistory.check(l);
        if (l == EARLIEST_CUTOVER) {
            return INTRODUCTION_BY_POPE_GREGOR;
        }
        return ChronoHistory.ofGregorianReform(l);
    }

    public static ChronoHistory of(Locale locale) {
        ChronoHistory chronoHistory = LOOKUP.get(locale.getCountry());
        if (chronoHistory == null) {
            return ChronoHistory.ofFirstGregorianReform();
        }
        return chronoHistory;
    }

    public static ChronoHistory ofSweden() {
        return SWEDEN;
    }

    public boolean isValid(HistoricDate historicDate) {
        if (historicDate == null) {
            return false;
        }
        CalendarAlgorithm calendarAlgorithm = this.getAlgorithm(historicDate);
        if (calendarAlgorithm == null) {
            return false;
        }
        return calendarAlgorithm.isValid(historicDate);
    }

    public PlainDate convert(HistoricDate historicDate) {
        CalendarAlgorithm calendarAlgorithm = this.getAlgorithm(historicDate);
        if (calendarAlgorithm == null) {
            throw new IllegalArgumentException("Invalid historical date: " + historicDate);
        }
        return PlainDate.of((long)calendarAlgorithm.toMJD(historicDate), (EpochDays)EpochDays.MODIFIED_JULIAN_DATE);
    }

    public HistoricDate convert(PlainDate plainDate) {
        long l = (Long)plainDate.get((ChronoElement)EpochDays.MODIFIED_JULIAN_DATE);
        for (int i = this.events.size() - 1; i >= 0; --i) {
            CutOverEvent cutOverEvent = this.events.get(i);
            if (l < cutOverEvent.start) continue;
            return cutOverEvent.algorithm.fromMJD(l);
        }
        return CalendarAlgorithm.JULIAN.fromMJD(l);
    }

    public PlainDate getGregorianCutOverDate() {
        return PlainDate.of((long)this.events.get((int)(this.events.size() - 1)).start, (EpochDays)EpochDays.MODIFIED_JULIAN_DATE);
    }

    public int getLengthOfYear(HistoricEra historicEra, int n) {
        try {
            HistoricDate historicDate = HistoricDate.of(historicEra, n, 1, 1);
            HistoricDate historicDate2 = HistoricDate.of(historicEra, n, 12, 31);
            return (int)(CalendarUnit.DAYS.between((TimePoint)this.convert(historicDate), (TimePoint)this.convert(historicDate2)) + 1L);
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    public TextElement<HistoricEra> era() {
        return this.eraElement;
    }

    public TextElement<Integer> yearOfEra() {
        return this.yearOfEraElement;
    }

    public TextElement<Integer> month() {
        return this.monthElement;
    }

    public TextElement<Integer> dayOfMonth() {
        return this.dayOfMonthElement;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoHistory) {
            ChronoHistory chronoHistory = (ChronoHistory)object;
            if (this.variant != chronoHistory.variant) {
                return false;
            }
            if (this.variant == 0) {
                return this.events.get((int)0).start == chronoHistory.events.get((int)0).start;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.variant == 0) {
            long l = this.events.get((int)0).start;
            return (int)(l ^ l << 32);
        }
        return this.variant;
    }

    public String toString() {
        switch (this.variant) {
            case 1: {
                return "ChronoHistory[PROLEPTIC-GREGORIAN]";
            }
            case 2: {
                return "ChronoHistory[PROLEPTIC-JULIAN]";
            }
            case 4: {
                return "ChronoHistory[SWEDEN]";
            }
        }
        PlainDate plainDate = this.getGregorianCutOverDate();
        return "ChronoHistory[" + plainDate + "]";
    }

    CalendarAlgorithm getAlgorithm(HistoricDate historicDate) {
        for (int i = this.events.size() - 1; i >= 0; --i) {
            CutOverEvent cutOverEvent = this.events.get(i);
            if (historicDate.compareTo(cutOverEvent.dateAtCutOver) >= 0) {
                return cutOverEvent.algorithm;
            }
            if (historicDate.compareTo(cutOverEvent.dateBeforeCutOver) <= 0) continue;
            return null;
        }
        return CalendarAlgorithm.JULIAN;
    }

    HistoricDate adjustDayOfMonth(HistoricDate historicDate) {
        CalendarAlgorithm calendarAlgorithm = this.getAlgorithm(historicDate);
        if (calendarAlgorithm == null) {
            return historicDate;
        }
        int n = calendarAlgorithm.getMaximumDayOfMonth(historicDate);
        if (n < historicDate.getDayOfMonth()) {
            return HistoricDate.of(historicDate.getEra(), historicDate.getYearOfEra(), historicDate.getMonth(), n);
        }
        return historicDate;
    }

    List<CutOverEvent> getEvents() {
        return this.events;
    }

    int getVariant() {
        return this.variant;
    }

    Set<ChronoElement<?>> getElements() {
        return this.elements;
    }

    private static void check(long l) {
        if (l < EARLIEST_CUTOVER) {
            throw new IllegalArgumentException("Gregorian calendar did not exist before 1582-10-15");
        }
    }

    private static ChronoHistory ofGregorianReform(long l) {
        return new ChronoHistory(l == EARLIEST_CUTOVER ? 7 : 0, Collections.singletonList(new CutOverEvent(l, CalendarAlgorithm.JULIAN, CalendarAlgorithm.GREGORIAN)));
    }

    private Object writeReplace() {
        return new SPX(this, 1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        ArrayList<CutOverEvent> arrayList = new ArrayList<CutOverEvent>();
        arrayList.add(new CutOverEvent(-57959L, CalendarAlgorithm.JULIAN, CalendarAlgorithm.SWEDISH));
        arrayList.add(new CutOverEvent(-53575L, CalendarAlgorithm.SWEDISH, CalendarAlgorithm.JULIAN));
        arrayList.add(new CutOverEvent(-38611L, CalendarAlgorithm.JULIAN, CalendarAlgorithm.GREGORIAN));
        SWEDEN = new ChronoHistory(4, Collections.unmodifiableList(arrayList));
        HashMap<String, ChronoHistory> hashMap = new HashMap<String, ChronoHistory>();
        hashMap.put("GB", ChronoHistory.ofGregorianReform(PlainDate.of((int)1752, (int)9, (int)14)));
        hashMap.put("RU", ChronoHistory.ofGregorianReform(PlainDate.of((int)1918, (int)2, (int)14)));
        hashMap.put("SE", SWEDEN);
        LOOKUP = Collections.unmodifiableMap(hashMap);
    }

    private static class Key<T>
    implements AttributeKey<T> {
        private final String name;
        private final Class<T> type;

        private Key(String string, Class<T> clazz) {
            this.name = string;
            this.type = clazz;
        }

        static <T> Key<T> valueOf(String string, Class<T> clazz) {
            return new Key<T>(string, clazz);
        }

        public String name() {
            return this.name;
        }

        public Class<T> type() {
            return this.type;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.name.equals(key.name) && this.type.equals(key.type);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.type.getName() + "@" + this.name;
        }
    }
}

