/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.util.Locale;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoExtension;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;

public class HistoricExtension
implements ChronoExtension {
    public boolean accept(Class<?> clazz) {
        return clazz == PlainDate.class;
    }

    public Set<ChronoElement<?>> getElements(Locale locale, AttributeQuery attributeQuery) {
        return HistoricExtension.getHistory(locale, attributeQuery).getElements();
    }

    public <T extends ChronoEntity<T>> T resolve(T t, Locale locale, AttributeQuery attributeQuery) {
        ChronoHistory chronoHistory = HistoricExtension.getHistory(locale, attributeQuery);
        if (t.contains(chronoHistory.era()) && t.contains(chronoHistory.yearOfEra()) && t.contains(chronoHistory.month()) && t.contains(chronoHistory.dayOfMonth())) {
            HistoricEra historicEra = (HistoricEra)((Object)t.get(chronoHistory.era()));
            int n = (Integer)t.get(chronoHistory.yearOfEra());
            int n2 = (Integer)t.get(chronoHistory.month());
            int n3 = (Integer)t.get(chronoHistory.dayOfMonth());
            HistoricDate historicDate = HistoricDate.of(historicEra, n, n2, n3);
            PlainDate plainDate = chronoHistory.convert(historicDate);
            t.with(chronoHistory.era(), null);
            t.with(chronoHistory.yearOfEra(), null);
            t.with(chronoHistory.month(), null);
            t.with(chronoHistory.dayOfMonth(), null);
            return (T)t.with((ChronoElement)PlainDate.COMPONENT, (Object)plainDate);
        }
        return t;
    }

    private static ChronoHistory getHistory(Locale locale, AttributeQuery attributeQuery) {
        if (attributeQuery.contains(ChronoHistory.ATTRIBUTE_CUTOVER_DATE)) {
            PlainDate plainDate = (PlainDate)attributeQuery.get(ChronoHistory.ATTRIBUTE_CUTOVER_DATE);
            return ChronoHistory.ofGregorianReform(plainDate);
        }
        return ChronoHistory.of(locale);
    }
}

