/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.NumericalElement;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;

final class HistoricalEraElement
extends BasicElement<HistoricEra>
implements NumericalElement<HistoricEra>,
TextElement<HistoricEra> {
    private final ChronoHistory history;

    HistoricalEraElement(ChronoHistory chronoHistory) {
        super("ERA");
        this.history = chronoHistory;
    }

    public Class<HistoricEra> getType() {
        return HistoricEra.class;
    }

    public char getSymbol() {
        return 'G';
    }

    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return ((HistoricEra)((Object)chronoDisplay.get((ChronoElement)this))).compareTo((Enum)chronoDisplay2.get((ChronoElement)this));
    }

    public HistoricEra getDefaultMinimum() {
        return HistoricEra.BC;
    }

    public HistoricEra getDefaultMaximum() {
        return HistoricEra.AD;
    }

    public boolean isDateElement() {
        return true;
    }

    public boolean isTimeElement() {
        return false;
    }

    public int numerical(HistoricEra historicEra) {
        return historicEra.getValue();
    }

    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        appendable.append(this.accessor(attributeQuery).print((Enum)chronoDisplay.get((ChronoElement)this)));
    }

    public HistoricEra parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        return (HistoricEra)this.accessor(attributeQuery).parse(charSequence, parsePosition, this.getType(), attributeQuery);
    }

    protected <T extends ChronoEntity<T>> ElementRule<T, HistoricEra> derive(Chronology<T> chronology) {
        if (chronology.isRegistered((ChronoElement)PlainDate.COMPONENT)) {
            return new Rule(this.history);
        }
        return null;
    }

    private TextAccessor accessor(AttributeQuery attributeQuery) {
        CalendarText calendarText = CalendarText.getInstance((String)((String)attributeQuery.get(Attributes.CALENDAR_TYPE, (Object)"iso8601")), (Locale)((Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT)));
        TextWidth textWidth = (TextWidth)attributeQuery.get(Attributes.TEXT_WIDTH, (Object)TextWidth.WIDE);
        if (((Boolean)attributeQuery.get(ChronoHistory.ATTRIBUTE_COMMON_ERA, (Object)Boolean.FALSE)).booleanValue()) {
            return calendarText.getTextForms((ChronoElement)this, new String[]{textWidth == TextWidth.WIDE ? "w" : "a", "alt"});
        }
        return calendarText.getEras(textWidth);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.history.era();
    }

    private static class Rule<C extends ChronoEntity<C>>
    implements ElementRule<C, HistoricEra> {
        private final ChronoHistory history;

        Rule(ChronoHistory chronoHistory) {
            this.history = chronoHistory;
        }

        public HistoricEra getValue(C c) {
            return this.history.convert((PlainDate)c.get((ChronoElement)PlainDate.COMPONENT)).getEra();
        }

        public HistoricEra getMinimum(C c) {
            return HistoricEra.BC;
        }

        public HistoricEra getMaximum(C c) {
            return HistoricEra.AD;
        }

        public boolean isValid(C c, HistoricEra historicEra) {
            if (historicEra == null) {
                return false;
            }
            HistoricDate historicDate = this.history.convert((PlainDate)c.get((ChronoElement)PlainDate.COMPONENT));
            HistoricDate historicDate2 = HistoricDate.of(historicEra, historicDate.getYearOfEra(), historicDate.getMonth(), historicDate.getDayOfMonth());
            historicDate2 = this.history.adjustDayOfMonth(historicDate2);
            return this.history.isValid(historicDate2);
        }

        public C withValue(C c, HistoricEra historicEra, boolean bl) {
            HistoricDate historicDate = this.history.convert((PlainDate)c.get((ChronoElement)PlainDate.COMPONENT));
            HistoricDate historicDate2 = HistoricDate.of(historicEra, historicDate.getYearOfEra(), historicDate.getMonth(), historicDate.getDayOfMonth());
            historicDate2 = this.history.adjustDayOfMonth(historicDate2);
            return (C)c.with((ChronoElement)PlainDate.COMPONENT, (Object)this.history.convert(historicDate2));
        }

        public ChronoElement<?> getChildAtFloor(C c) {
            throw new UnsupportedOperationException("Never called.");
        }

        public ChronoElement<?> getChildAtCeiling(C c) {
            throw new UnsupportedOperationException("Never called.");
        }
    }
}

