/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import net.time4j.PlainDate;
import net.time4j.engine.EpochDays;
import net.time4j.history.ChronoHistory;

final class SPX
implements Externalizable {
    static final int VERSION_1 = 1;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        switch (this.type) {
            case 1: {
                this.writeHistory(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch ((by & 0xFF) >> 4) {
            case 1: {
                this.obj = this.readHistory(objectInput, by);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeHistory(ObjectOutput objectOutput) throws IOException {
        ChronoHistory chronoHistory = (ChronoHistory)this.obj;
        int n = chronoHistory.getVariant();
        int n2 = this.type;
        n2 <<= 4;
        objectOutput.writeByte(n2 |= n);
        if (n == 0) {
            objectOutput.writeLong(chronoHistory.getEvents().get((int)0).start);
        }
    }

    private ChronoHistory readHistory(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        int n = by & 0xF;
        switch (n) {
            case 0: {
                long l = objectInput.readLong();
                return ChronoHistory.ofGregorianReform(PlainDate.of((long)l, (EpochDays)EpochDays.MODIFIED_JULIAN_DATE));
            }
            case 1: {
                return ChronoHistory.PROLEPTIC_GREGORIAN;
            }
            case 2: {
                return ChronoHistory.PROLEPTIC_JULIAN;
            }
            case 4: {
                return ChronoHistory.ofSweden();
            }
            case 7: {
                return ChronoHistory.ofFirstGregorianReform();
            }
        }
        throw new StreamCorruptedException("Unknown variant of chronological history.");
    }
}

