/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.UTF8ResourceBundle;

class UTF8ResourceControl
extends ResourceBundle.Control {
    public static final ResourceBundle.Control SINGLETON = new UTF8ResourceControl();

    private UTF8ResourceControl() {
    }

    @Override
    public Locale getFallbackLocale(String string, Locale locale) {
        if (string == null || locale == null) {
            throw new NullPointerException();
        }
        return null;
    }

    @Override
    public List<String> getFormats(String string) {
        return ResourceBundle.Control.FORMAT_PROPERTIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
        if (string2.equals("java.properties")) {
            Object object;
            UTF8ResourceBundle uTF8ResourceBundle = null;
            InputStream inputStream = null;
            String string3 = this.toBundleName(string, locale);
            String string4 = this.toResourceName(string3, "properties");
            if (bl) {
                object = classLoader.getResource(string4);
                if (object != null) {
                    URLConnection uRLConnection = ((URL)object).openConnection();
                    uRLConnection.setUseCaches(false);
                    inputStream = uRLConnection.getInputStream();
                }
            } else {
                inputStream = classLoader.getResourceAsStream(string4);
            }
            if (inputStream != null) {
                object = null;
                try {
                    object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    uTF8ResourceBundle = new UTF8ResourceBundle((Reader)object);
                }
                finally {
                    if (object != null) {
                        ((Reader)object).close();
                    }
                }
            }
            return uTF8ResourceBundle;
        }
        throw new UnsupportedOperationException("Unknown resource bundle format: " + string2);
    }

    @Override
    public String toBundleName(String string, Locale locale) {
        if (locale == Locale.ROOT) {
            return string;
        }
        String string2 = LanguageMatch.getAlias(locale);
        String string3 = locale.getCountry();
        String string4 = locale.getVariant();
        if (string2.isEmpty() && string3.isEmpty() && string4.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('_').append(string2);
        if (!string4.isEmpty()) {
            stringBuilder.append('_').append(string3).append('_').append(string4);
        } else if (!string3.isEmpty()) {
            stringBuilder.append('_').append(string3);
        }
        return stringBuilder.toString();
    }
}

