/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.CalendarUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.ValidationElement;
import net.time4j.engine.VariantSource;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.DisplayMode;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.PluralCategory;
import net.time4j.format.RawValues;
import net.time4j.format.TemporalFormatter;
import net.time4j.format.TextElement;
import net.time4j.format.expert.AmbivalentValueException;
import net.time4j.format.expert.AttributeSet;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.CustomizedProcessor;
import net.time4j.format.expert.DecimalProcessor;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.FractionProcessor;
import net.time4j.format.expert.IgnorableWhitespaceProcessor;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.LocalizedGMTProcessor;
import net.time4j.format.expert.LookupProcessor;
import net.time4j.format.expert.NonAmbivalentMap;
import net.time4j.format.expert.NumberProcessor;
import net.time4j.format.expert.OrdinalProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedValues;
import net.time4j.format.expert.PatternType;
import net.time4j.format.expert.SignPolicy;
import net.time4j.format.expert.TextProcessor;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.format.expert.TimezoneIDProcessor;
import net.time4j.format.expert.TimezoneNameProcessor;
import net.time4j.format.expert.TimezoneOffsetProcessor;
import net.time4j.format.expert.TwoDigitYearProcessor;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricVariant;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class ChronoFormatter<T extends ChronoEntity<T>>
implements ChronoPrinter<T>,
ChronoParser<T>,
TemporalFormatter<T> {
    private final Chronology<T> chronology;
    private final AttributeSet globalAttributes;
    private final List<FormatStep> steps;
    private final Map<ChronoElement<?>, Object> defaults;
    private final FractionProcessor fracproc;

    private ChronoFormatter(Chronology<T> chronology, Locale locale, List<FormatStep> list) {
        if (chronology == null) {
            throw new NullPointerException("Missing chronology.");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No format processors defined.");
        }
        this.chronology = chronology;
        this.globalAttributes = AttributeSet.createDefaults(chronology, locale);
        this.steps = Collections.unmodifiableList(list);
        this.defaults = Collections.emptyMap();
        FractionProcessor fractionProcessor = null;
        for (FormatStep formatStep : this.steps) {
            if (!(formatStep.getProcessor() instanceof FractionProcessor)) continue;
            fractionProcessor = (FractionProcessor)FractionProcessor.class.cast(formatStep.getProcessor());
            break;
        }
        this.fracproc = fractionProcessor;
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, Attributes attributes) {
        this(chronoFormatter, chronoFormatter.globalAttributes.withAttributes(attributes), null);
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, AttributeSet attributeSet) {
        this(chronoFormatter, attributeSet, null);
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, AttributeSet attributeSet, ChronoHistory chronoHistory) {
        if (attributeSet == null) {
            throw new NullPointerException("Missing global format attributes.");
        }
        this.chronology = chronoFormatter.chronology;
        this.globalAttributes = attributeSet;
        this.defaults = Collections.unmodifiableMap(new NonAmbivalentMap((Map<? extends ChronoElement<?>, ?>)chronoFormatter.defaults));
        this.fracproc = chronoFormatter.fracproc;
        int n = chronoFormatter.steps.size();
        ArrayList<FormatStep> arrayList = new ArrayList<FormatStep>(chronoFormatter.steps);
        for (int i = 0; i < n; ++i) {
            FormatStep formatStep = (FormatStep)arrayList.get(i);
            ChronoElement<?> chronoElement = formatStep.getProcessor().getElement();
            if (chronoElement != null && !this.chronology.isRegistered(chronoElement)) {
                block1: for (ChronoExtension chronoExtension : this.chronology.getExtensions()) {
                    if (!chronoExtension.getElements(chronoFormatter.getLocale(), (AttributeQuery)chronoFormatter.globalAttributes).contains(chronoElement)) continue;
                    Set set = chronoExtension.getElements(attributeSet.getLocale(), (AttributeQuery)attributeSet);
                    for (ChronoElement chronoElement2 : set) {
                        if (!chronoElement2.name().equals(chronoElement.name())) continue;
                        if (chronoElement2 == chronoElement) break block1;
                        arrayList.set(i, formatStep.updateElement(chronoElement2));
                        break block1;
                    }
                }
            }
            if (chronoHistory == null) continue;
            Iterator iterator = null;
            if (chronoElement == PlainDate.YEAR) {
                iterator = chronoHistory.yearOfEra();
            } else if (chronoElement == PlainDate.MONTH_OF_YEAR || chronoElement == PlainDate.MONTH_AS_NUMBER) {
                iterator = chronoHistory.month();
            } else if (chronoElement == PlainDate.DAY_OF_MONTH) {
                iterator = chronoHistory.dayOfMonth();
            }
            if (iterator == null) continue;
            arrayList.set(i, formatStep.updateElement((ChronoElement<?>)iterator));
        }
        this.steps = Collections.unmodifiableList(arrayList);
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, ChronoElement<?> chronoElement, Object object) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        ChronoFormatter.checkElement(chronoFormatter.chronology, chronoElement);
        this.chronology = chronoFormatter.chronology;
        this.globalAttributes = chronoFormatter.globalAttributes;
        this.fracproc = chronoFormatter.fracproc;
        NonAmbivalentMap nonAmbivalentMap = new NonAmbivalentMap((Map<? extends ChronoElement<?>, ?>)chronoFormatter.defaults);
        if (object == null) {
            nonAmbivalentMap.remove(chronoElement);
        } else {
            nonAmbivalentMap.put(chronoElement, object);
        }
        this.defaults = Collections.unmodifiableMap(nonAmbivalentMap);
        ArrayList<FormatStep> arrayList = new ArrayList<FormatStep>(chronoFormatter.steps);
        this.steps = Collections.unmodifiableList(arrayList);
    }

    public Chronology<T> getChronology() {
        return this.chronology;
    }

    public Locale getLocale() {
        return this.globalAttributes.getLocale();
    }

    public AttributeQuery getAttributes() {
        return this.globalAttributes;
    }

    public String format(T t) {
        ChronoDisplay chronoDisplay = this.chronology.preformat(t, (AttributeQuery)this.globalAttributes);
        StringBuilder stringBuilder = new StringBuilder(this.steps.size() * 8);
        try {
            this.print(chronoDisplay, (Appendable)stringBuilder, (AttributeQuery)this.globalAttributes, false);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return stringBuilder.toString();
    }

    public void formatToBuffer(T t, Appendable appendable) throws IOException {
        this.print(t, appendable, this.globalAttributes);
    }

    public Set<ElementPosition> print(T t, StringBuilder stringBuilder) {
        ChronoDisplay chronoDisplay = this.chronology.preformat(t, (AttributeQuery)this.globalAttributes);
        try {
            return this.print(chronoDisplay, (Appendable)stringBuilder, (AttributeQuery)this.globalAttributes, true);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public Set<ElementPosition> print(T t, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        ChronoDisplay chronoDisplay = this.chronology.preformat(t, attributeQuery);
        return this.print(chronoDisplay, appendable, attributeQuery, true);
    }

    @Override
    public <R> R print(T t, Appendable appendable, AttributeQuery attributeQuery, ChronoFunction<ChronoDisplay, R> chronoFunction) throws IOException {
        ChronoDisplay chronoDisplay = this.chronology.preformat(t, attributeQuery);
        this.print(chronoDisplay, appendable, attributeQuery, false);
        return (R)chronoFunction.apply((Object)chronoDisplay);
    }

    private Set<ElementPosition> print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, boolean bl) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("Missing text result buffer.");
        }
        LinkedHashSet<ElementPosition> linkedHashSet = null;
        if (bl) {
            linkedHashSet = new LinkedHashSet<ElementPosition>(this.steps.size());
        }
        try {
            for (FormatStep formatStep : this.steps) {
                formatStep.print(chronoDisplay, appendable, attributeQuery, linkedHashSet);
            }
        }
        catch (ChronoException chronoException) {
            throw new IllegalArgumentException("Not formattable: " + chronoDisplay, chronoException);
        }
        if (bl) {
            return Collections.unmodifiableSet(linkedHashSet);
        }
        return Collections.emptySet();
    }

    public T parse(CharSequence charSequence) throws ParseException {
        ParseLog parseLog = new ParseLog();
        T t = this.parse(charSequence, parseLog, this.globalAttributes);
        if (t == null) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        return t;
    }

    public T parse(CharSequence charSequence, ParsePosition parsePosition) {
        return this.parse(charSequence, new ParseLog(parsePosition), this.globalAttributes);
    }

    public T parse(CharSequence charSequence, ParsePosition parsePosition, RawValues rawValues) {
        ParseLog parseLog = new ParseLog(parsePosition);
        T t = this.parse(charSequence, parseLog, this.globalAttributes);
        rawValues.accept(parseLog.getRawValues());
        return t;
    }

    public T parse(CharSequence charSequence, ParseLog parseLog) {
        return this.parse(charSequence, parseLog, this.globalAttributes);
    }

    @Override
    public T parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        ChronoEntity chronoEntity;
        Chronology chronology;
        AttributeQuery attributeQuery2 = attributeQuery;
        if (attributeQuery != this.globalAttributes) {
            attributeQuery2 = new AttributeWrapper(attributeQuery, this.globalAttributes);
        }
        if ((chronology = this.chronology.preparser()) == null) {
            return ChronoFormatter.parse(this, this.chronology, charSequence, parseLog, attributeQuery2, false);
        }
        ChronoFormatter.parse(this, chronology, charSequence, parseLog, attributeQuery2, true);
        if (parseLog.isError()) {
            return null;
        }
        ParsedValues parsedValues = parseLog.getRawValues0();
        try {
            chronoEntity = this.chronology.createFrom((ChronoEntity)parsedValues, attributeQuery2, false);
        }
        catch (RuntimeException runtimeException) {
            parseLog.setError(charSequence.length(), runtimeException.getMessage() + ChronoFormatter.getDescription(parsedValues.toMap()));
            return null;
        }
        if (chronoEntity == null) {
            if (!parseLog.isError()) {
                parseLog.setError(charSequence.length(), ChronoFormatter.getReason(parsedValues) + ChronoFormatter.getDescription(parsedValues.toMap()));
            }
            return null;
        }
        return (T)ChronoFormatter.checkConsistency(parsedValues, chronoEntity, charSequence, parseLog, attributeQuery2);
    }

    public ChronoEntity<?> parseRaw(String string) {
        return this.parseRaw(string, 0);
    }

    public ChronoEntity<?> parseRaw(CharSequence charSequence, int n) {
        ParsedValues parsedValues;
        Chronology<T> chronology;
        AttributeSet attributeSet;
        ParseLog parseLog;
        block8: {
            if (n >= charSequence.length()) {
                return new ParsedValues();
            }
            parseLog = new ParseLog(n);
            attributeSet = this.globalAttributes;
            chronology = this.chronology.preparser();
            if (chronology == null) {
                chronology = this.chronology;
            }
            LinkedList<NonAmbivalentMap> linkedList = new LinkedList<NonAmbivalentMap>();
            parsedValues = parseLog.getRawValues0();
            try {
                parsedValues = this.parseElements(charSequence, parseLog, attributeSet, linkedList);
                parsedValues.setNoAmbivalentCheck();
                parseLog.setRawValues(parsedValues);
            }
            catch (AmbivalentValueException ambivalentValueException) {
                if (parseLog.isError()) break block8;
                parseLog.setError(parseLog.getPosition(), ambivalentValueException.getMessage());
            }
        }
        if (parseLog.isError()) {
            return new ParsedValues();
        }
        assert (parsedValues != null);
        for (ChronoElement<?> chronoExtension : this.defaults.keySet()) {
            if (parsedValues.contains(chronoExtension)) continue;
            ChronoFormatter.fill(parsedValues, chronoExtension, this.defaults.get(chronoExtension));
        }
        for (ChronoExtension chronoExtension : chronology.getExtensions()) {
            parsedValues = (ParsedValues)chronoExtension.resolve((ChronoEntity)parsedValues, this.getLocale(), (AttributeQuery)attributeSet);
        }
        return parsedValues;
    }

    public ChronoFormatter<T> with(Locale locale) {
        if (locale.equals(this.globalAttributes.getLocale())) {
            return this;
        }
        return new ChronoFormatter<T>(this, this.globalAttributes.withLocale(locale));
    }

    public ChronoFormatter<T> with(Leniency leniency) {
        return this.with(Attributes.LENIENCY, leniency);
    }

    public ChronoFormatter<T> withAlternativeEraNames() {
        return this.with((AttributeKey)ChronoHistory.ATTRIBUTE_COMMON_ERA, (Enum)((Object)Boolean.TRUE)).with((AttributeKey)ChronoHistory.ATTRIBUTE_LATIN_ERA, (Enum)((Object)Boolean.FALSE));
    }

    public ChronoFormatter<T> withLatinEraNames() {
        return this.with((AttributeKey)ChronoHistory.ATTRIBUTE_COMMON_ERA, (Enum)((Object)Boolean.FALSE)).with((AttributeKey)ChronoHistory.ATTRIBUTE_LATIN_ERA, (Enum)((Object)Boolean.TRUE));
    }

    public ChronoFormatter<T> withGregorianCutOver(PlainDate plainDate) {
        return this.with(ChronoHistory.ofGregorianReform(plainDate));
    }

    public ChronoFormatter<T> with(ChronoHistory chronoHistory) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(ChronoHistory.ATTRIBUTE_HISTORIC_VARIANT, (Enum)chronoHistory.getVariant()).build();
        PlainDate plainDate = null;
        if (chronoHistory.getVariant() == HistoricVariant.SINGLE_CUTOVER_DATE) {
            plainDate = chronoHistory.getGregorianCutOverDate();
        }
        AttributeSet attributeSet = new AttributeSet(attributes, this.globalAttributes.getLocale(), this.globalAttributes.getLevel(), this.globalAttributes.getSection(), this.globalAttributes.getCondition(), plainDate);
        return new ChronoFormatter<T>(this, attributeSet, chronoHistory);
    }

    public ChronoFormatter<T> withTimezone(TZID tZID) {
        if (tZID == null) {
            throw new NullPointerException("Missing timezone id.");
        }
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).setTimezone(tZID).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> withTimezone(String string) {
        return this.withTimezone(Timezone.of((String)string).getID());
    }

    public ChronoFormatter<T> withStdTimezone() {
        return this.withTimezone(Timezone.ofSystem().getID());
    }

    public ChronoFormatter<T> withCalendarVariant(String string) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).setCalendarVariant(string).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> withCalendarVariant(VariantSource variantSource) {
        return this.withCalendarVariant(variantSource.getVariant());
    }

    public ChronoFormatter<T> withStartOfDay(StartOfDay startOfDay) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).setStartOfDay(startOfDay).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public <V> ChronoFormatter<T> withDefault(ChronoElement<V> chronoElement, V v) {
        return new ChronoFormatter<T>(this, chronoElement, v);
    }

    public ChronoFormatter<T> with(AttributeKey<Boolean> attributeKey, boolean bl) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, bl).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(AttributeKey<Integer> attributeKey, int n) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, n).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(AttributeKey<Character> attributeKey, char c) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, c).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public <A extends Enum<A>> ChronoFormatter<T> with(AttributeKey<A> attributeKey, A a) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, a).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(Attributes attributes) {
        Attributes attributes2 = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).setAll(attributes).build();
        return new ChronoFormatter<T>(this, attributes2);
    }

    public Format toFormat() {
        return new TraditionalFormat(this);
    }

    public static ChronoFormatter<PlainDate> ofDatePattern(String string, PatternType patternType, Locale locale) {
        Builder builder = new Builder((Chronology)PlainDate.axis(), locale);
        builder.addPattern(string, patternType);
        return builder.build();
    }

    public static ChronoFormatter<PlainTime> ofTimePattern(String string, PatternType patternType, Locale locale) {
        Builder builder = new Builder((Chronology)PlainTime.axis(), locale);
        builder.addPattern(string, patternType);
        return builder.build();
    }

    public static ChronoFormatter<PlainTimestamp> ofTimestampPattern(String string, PatternType patternType, Locale locale) {
        Builder builder = new Builder((Chronology)PlainTimestamp.axis(), locale);
        builder.addPattern(string, patternType);
        return builder.build();
    }

    public static ChronoFormatter<Moment> ofMomentPattern(String string, PatternType patternType, Locale locale, TZID tZID) {
        Builder builder = new Builder((Chronology)Moment.axis(), locale);
        builder.addPattern(string, patternType);
        return builder.build().withTimezone(tZID);
    }

    public static ChronoFormatter<PlainDate> ofDateStyle(DisplayMode displayMode, Locale locale) {
        String string = CalendarText.getFormatPatterns().getDatePattern(displayMode, locale);
        return ChronoFormatter.ofDatePattern(string, PatternType.CLDR, locale);
    }

    public static ChronoFormatter<PlainTime> ofTimeStyle(DisplayMode displayMode, Locale locale) {
        String string = CalendarText.getFormatPatterns().getTimePattern(displayMode, locale);
        return ChronoFormatter.ofTimePattern(string, PatternType.CLDR, locale);
    }

    public static ChronoFormatter<PlainTimestamp> ofTimestampStyle(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
        String string = CalendarText.getTimestampPattern((DisplayMode)displayMode, (DisplayMode)displayMode2, (Locale)locale);
        return ChronoFormatter.ofTimestampPattern(string, PatternType.CLDR, locale);
    }

    public static ChronoFormatter<Moment> ofMomentStyle(DisplayMode displayMode, DisplayMode displayMode2, Locale locale, TZID tZID) {
        String string = CalendarText.getFormatPatterns().getDateTimePattern(displayMode, displayMode2, locale);
        return ChronoFormatter.ofMomentPattern(string, PatternType.CLDR, locale, tZID);
    }

    public static <T extends ChronoEntity<T>> ChronoFormatter<T> ofStyle(DisplayStyle displayStyle, Locale locale, Chronology<T> chronology) {
        if (LocalizedPatternSupport.class.isAssignableFrom(chronology.getChronoType())) {
            String string = chronology.getFormatPattern(displayStyle, locale);
            Builder builder = new Builder(chronology, locale);
            builder.addPattern(string, PatternType.CLDR);
            return builder.build();
        }
        if (chronology.equals((Object)Moment.axis())) {
            throw new UnsupportedOperationException("Timezone required, use 'ofMomentStyle()' instead.");
        }
        throw new UnsupportedOperationException("Localized format patterns not available: " + chronology);
    }

    public static <T extends ChronoEntity<T>> Builder<T> setUp(Class<T> clazz, Locale locale) {
        if (clazz == null) {
            throw new NullPointerException("Missing chronological type.");
        }
        Chronology chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Not formattable: " + clazz);
        }
        return new Builder(chronology, locale);
    }

    public static <T extends ChronoEntity<T>> Builder<T> setUp(Chronology<T> chronology, Locale locale) {
        return new Builder(chronology, locale);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoFormatter) {
            ChronoFormatter chronoFormatter = (ChronoFormatter)object;
            return this.chronology.equals(chronoFormatter.chronology) && this.globalAttributes.equals(chronoFormatter.globalAttributes) && this.defaults.equals(chronoFormatter.defaults) && this.steps.equals(chronoFormatter.steps);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.chronology.hashCode() + 31 * this.globalAttributes.hashCode() + 37 * this.steps.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("net.time4j.format.ChronoFormatter[chronology=");
        stringBuilder.append(this.chronology.getChronoType().getName());
        stringBuilder.append(", default-attributes=");
        stringBuilder.append(this.globalAttributes);
        stringBuilder.append(", default-values=");
        stringBuilder.append(this.defaults);
        stringBuilder.append(", processors=");
        boolean bl = true;
        for (FormatStep formatStep : this.steps) {
            if (bl) {
                bl = false;
                stringBuilder.append('{');
            } else {
                stringBuilder.append('|');
            }
            stringBuilder.append(formatStep);
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    private static <T extends ChronoEntity<T>> T parse(ChronoFormatter<?> chronoFormatter, Chronology<T> chronology, CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, boolean bl) {
        Iterator<Object> iterator;
        ParsedValues parsedValues;
        LinkedList<NonAmbivalentMap> linkedList;
        block14: {
            if (parseLog.getPosition() >= charSequence.length()) {
                throw new IndexOutOfBoundsException("[" + parseLog.getPosition() + "]: " + charSequence.toString());
            }
            linkedList = new LinkedList<NonAmbivalentMap>();
            parsedValues = parseLog.getRawValues0();
            try {
                parsedValues = super.parseElements(charSequence, parseLog, attributeQuery, linkedList);
                parsedValues.setNoAmbivalentCheck();
                parseLog.setRawValues(parsedValues);
            }
            catch (AmbivalentValueException ambivalentValueException) {
                if (parseLog.isError()) break block14;
                parseLog.setError(parseLog.getPosition(), ambivalentValueException.getMessage());
            }
        }
        if (parseLog.isError()) {
            return null;
        }
        int n = parseLog.getPosition();
        assert (parsedValues != null);
        if (n < charSequence.length() && !((Boolean)attributeQuery.get(Attributes.TRAILING_CHARACTERS, (Object)Boolean.FALSE)).booleanValue()) {
            parseLog.setError(n, "Unparsed trailing characters: " + ChronoFormatter.sub(n, charSequence));
            return null;
        }
        for (ChronoElement<?> chronoExtension : chronoFormatter.defaults.keySet()) {
            if (parsedValues.contains(chronoExtension)) continue;
            ChronoFormatter.fill(parsedValues, chronoExtension, chronoFormatter.defaults.get(chronoExtension));
        }
        for (ChronoExtension chronoExtension : chronology.getExtensions()) {
            parsedValues = (ParsedValues)chronoExtension.resolve((ChronoEntity)parsedValues, chronoFormatter.getLocale(), attributeQuery);
        }
        try {
            iterator = chronology.createFrom((ChronoEntity)parsedValues, attributeQuery, bl);
        }
        catch (RuntimeException runtimeException) {
            parseLog.setError(charSequence.length(), runtimeException.getMessage() + ChronoFormatter.getDescription((Map)linkedList.peek()));
            return null;
        }
        if (chronoFormatter.fracproc != null && iterator != null) {
            iterator = chronoFormatter.fracproc.update(iterator, parsedValues);
        }
        if (bl && iterator != null && chronology instanceof TimeAxis) {
            ChronoElement chronoElement = ((TimeAxis)TimeAxis.class.cast(chronology)).element();
            ChronoFormatter.updateSelf(parsedValues, chronoElement, iterator);
        }
        if (iterator == null) {
            if (!bl) {
                parseLog.setError(charSequence.length(), ChronoFormatter.getReason(parsedValues) + ChronoFormatter.getDescription((Map)linkedList.peek()));
            }
            return null;
        }
        return (T)ChronoFormatter.checkConsistency(parsedValues, iterator, charSequence, parseLog, attributeQuery);
    }

    private static String getReason(ParsedValues parsedValues) {
        String string;
        if (parsedValues.contains((ChronoElement<?>)ValidationElement.ERROR_MESSAGE)) {
            string = "Validation failed => " + (String)parsedValues.get(ValidationElement.ERROR_MESSAGE);
            parsedValues.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)null);
        } else {
            string = "Insufficient data:";
        }
        return string;
    }

    private static <T> void updateSelf(ParsedValues parsedValues, ChronoElement<T> chronoElement, Object object) {
        parsedValues.with((ChronoElement)chronoElement, chronoElement.getType().cast(object));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends ChronoEntity<T>> T checkConsistency(ParsedValues parsedValues, T t, CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        Leniency leniency = (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART);
        if (!leniency.isStrict()) return t;
        if (t instanceof UnixTime) {
            TZID tZID;
            UnixTime unixTime = (UnixTime)UnixTime.class.cast(t);
            if (parsedValues.contains(TimezoneElement.TIMEZONE_ID) && parsedValues.contains(TimezoneElement.TIMEZONE_OFFSET)) {
                tZID = parsedValues.get(TimezoneElement.TIMEZONE_ID);
                TZID tZID2 = parsedValues.get(TimezoneElement.TIMEZONE_OFFSET);
                if (!Timezone.of((TZID)tZID).getOffset(unixTime).equals((Object)tZID2)) {
                    parseLog.setError(charSequence.length(), "Ambivalent offset information: " + tZID + " versus " + tZID2);
                    return null;
                }
            }
            if (parseLog.getDSTInfo() == null) return t;
            tZID = parsedValues.getTimezone();
            try {
                boolean bl = Timezone.of((TZID)tZID).isDaylightSaving(unixTime);
                if (bl == parseLog.getDSTInfo()) return t;
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Conflict found: ");
                stringBuilder.append("Parsed entity is ");
                if (!bl) {
                    stringBuilder.append("not ");
                }
                stringBuilder.append("daylight-saving, but timezone name");
                stringBuilder.append(" has not the appropriate form in {");
                stringBuilder.append(charSequence.toString());
                stringBuilder.append("}.");
                parseLog.setError(charSequence.length(), stringBuilder.toString());
                t = null;
                return t;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Unable to check timezone name: ");
                stringBuilder.append(illegalArgumentException.getMessage());
                parseLog.setError(charSequence.length(), stringBuilder.toString());
                return null;
            }
        } else {
            TimePoint timePoint = null;
            if (t instanceof PlainTimestamp && (Integer)t.get((ChronoElement)PlainTime.ISO_HOUR) == 0 && (parsedValues.contains((ChronoElement<?>)PlainTime.ISO_HOUR) && (Integer)parsedValues.get(PlainTime.ISO_HOUR) == 24 || parsedValues.contains((ChronoElement<?>)PlainTime.COMPONENT) && ((PlainTime)parsedValues.get(PlainTime.COMPONENT)).getHour() == 24)) {
                timePoint = ((PlainTimestamp)PlainTimestamp.class.cast(t)).toDate().minus(1L, (Object)CalendarUnit.DAYS);
            }
            for (ChronoElement<?> chronoElement : parsedValues.toMap().keySet()) {
                void var10_17;
                Object obj = parsedValues.get(chronoElement);
                T t2 = t;
                if (timePoint != null) {
                    if (chronoElement.isDateElement()) {
                        TimePoint timePoint2 = timePoint;
                    } else if (chronoElement.isTimeElement()) {
                        PlainTime plainTime = PlainTime.midnightAtEndOfDay();
                    }
                }
                if (!var10_17.contains(chronoElement) || var10_17.get(chronoElement).equals(obj)) continue;
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Conflict found: ");
                stringBuilder.append("Text {");
                stringBuilder.append(charSequence.toString());
                stringBuilder.append("} with element ");
                stringBuilder.append(chronoElement.name());
                stringBuilder.append(" {");
                stringBuilder.append(obj);
                stringBuilder.append("}, but parsed entity ");
                stringBuilder.append("has element value {");
                stringBuilder.append(var10_17.get(chronoElement));
                stringBuilder.append("}.");
                parseLog.setError(charSequence.length(), stringBuilder.toString());
                return null;
            }
        }
        return t;
    }

    private ParsedValues parseElements(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Deque<NonAmbivalentMap> deque) {
        NonAmbivalentMap nonAmbivalentMap = new NonAmbivalentMap();
        nonAmbivalentMap.put(null, (Object)parseLog.getPosition());
        deque.push(nonAmbivalentMap);
        int n = 0;
        int n2 = 0;
        int n3 = this.steps.size();
        for (int i = 0; i < n3; ++i) {
            ChronoElement<?> chronoElement;
            int n4;
            FormatStep formatStep = this.steps.get(i);
            for (n4 = n2 = formatStep.getLevel(); n4 > n; --n4) {
                nonAmbivalentMap = new NonAmbivalentMap();
                nonAmbivalentMap.put(null, (Object)parseLog.getPosition());
                deque.push(nonAmbivalentMap);
            }
            while (n4 < n) {
                nonAmbivalentMap = deque.pop();
                nonAmbivalentMap.remove(null);
                deque.peek().putAll(nonAmbivalentMap);
                ++n4;
            }
            Map map = deque.peek();
            parseLog.clearWarning();
            formatStep.parse(charSequence, parseLog, attributeQuery, map);
            if (parseLog.isWarning() && (chronoElement = formatStep.getProcessor().getElement()) != null && this.defaults.containsKey(chronoElement)) {
                map.put(chronoElement, this.defaults.get(chronoElement));
                parseLog.clearError();
                parseLog.clearWarning();
            }
            if (parseLog.isError()) {
                if (n2 == 0) {
                    nonAmbivalentMap = deque.peek();
                    nonAmbivalentMap.remove(null);
                    return new ParsedValues(nonAmbivalentMap);
                }
                int n5 = formatStep.getSection();
                int n6 = i;
                for (int j = n3 - 1; j > i; --j) {
                    if (this.steps.get(j).getSection() != n5) continue;
                    n6 = j;
                    break;
                }
                i = n6;
                nonAmbivalentMap = deque.pop();
                parseLog.clearError();
                parseLog.setPosition((Integer)nonAmbivalentMap.get(null));
            }
            n = --n2;
        }
        while (n2 > 0) {
            nonAmbivalentMap = deque.pop();
            nonAmbivalentMap.remove(null);
            deque.peek().putAll(nonAmbivalentMap);
            --n2;
        }
        nonAmbivalentMap = deque.peek();
        nonAmbivalentMap.remove(null);
        return new ParsedValues(nonAmbivalentMap);
    }

    private static String sub(int n, CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 - n <= 10) {
            return charSequence.subSequence(n, n2).toString();
        }
        return charSequence.subSequence(n, n + 10).toString() + "...";
    }

    private static String getDescription(Map<ChronoElement<?>, Object> map) {
        StringBuilder stringBuilder = new StringBuilder(map.size() * 16);
        stringBuilder.append(" [parsed={");
        boolean bl = true;
        for (ChronoElement<?> chronoElement : map.keySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(chronoElement.name());
            stringBuilder.append('=');
            stringBuilder.append(map.get(chronoElement));
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    private static <V> void fill(ChronoEntity<?> chronoEntity, ChronoElement<V> chronoElement, Object object) {
        chronoEntity.with(chronoElement, chronoElement.getType().cast(object));
    }

    private static void checkElement(Chronology<?> chronology, ChronoElement<?> chronoElement) {
        Chronology chronology2;
        if (!(chronology.isSupported(chronoElement) || (chronology2 = chronology.preparser()) != null && chronology2.isSupported(chronoElement))) {
            throw new IllegalArgumentException("Unsupported element: " + chronoElement.name());
        }
    }

    private static class AttributeWrapper
    implements AttributeQuery {
        private final AttributeQuery attributes;
        private final AttributeSet globals;

        AttributeWrapper(AttributeQuery attributeQuery, AttributeSet attributeSet) {
            this.attributes = attributeQuery;
            this.globals = attributeSet;
        }

        public boolean contains(AttributeKey<?> attributeKey) {
            return this.attributes.contains(attributeKey) || this.globals.contains(attributeKey);
        }

        public <A> A get(AttributeKey<A> attributeKey) {
            if (this.attributes.contains(attributeKey)) {
                return (A)this.attributes.get(attributeKey);
            }
            return this.globals.get(attributeKey);
        }

        public <A> A get(AttributeKey<A> attributeKey, A a) {
            if (this.attributes.contains(attributeKey)) {
                return (A)this.attributes.get(attributeKey);
            }
            return this.globals.get(attributeKey, a);
        }
    }

    private static class TraditionalFormat<T extends ChronoEntity<T>>
    extends Format {
        private static final Map<String, DateFormat.Field> FIELD_MAP;
        private final ChronoFormatter<T> formatter;

        TraditionalFormat(ChronoFormatter<T> chronoFormatter) {
            this.formatter = chronoFormatter;
        }

        @Override
        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            fieldPosition.setBeginIndex(0);
            fieldPosition.setEndIndex(0);
            try {
                AttributeSet attributeSet = ((ChronoFormatter)this.formatter).globalAttributes;
                String string = (String)attributeSet.get(Attributes.CALENDAR_TYPE, "iso8601");
                ChronoEntity chronoEntity = (ChronoEntity)this.formatter.getChronology().getChronoType().cast(object);
                Set<ElementPosition> set = this.formatter.print(chronoEntity, stringBuffer, attributeSet);
                if (string.equals("iso8601")) {
                    for (ElementPosition elementPosition : set) {
                        DateFormat.Field field = TraditionalFormat.toField(elementPosition.getElement());
                        if (field == null || !(field.equals(fieldPosition.getFieldAttribute()) || field.getCalendarField() == fieldPosition.getField() && fieldPosition.getField() != -1 || field.equals(DateFormat.Field.TIME_ZONE) && fieldPosition.getField() == 17 || field.equals(DateFormat.Field.HOUR_OF_DAY1) && fieldPosition.getField() == 4) && (!field.equals(DateFormat.Field.HOUR1) || fieldPosition.getField() != 15)) continue;
                        fieldPosition.setBeginIndex(elementPosition.getStartIndex());
                        fieldPosition.setEndIndex(elementPosition.getEndIndex());
                        break;
                    }
                }
                return stringBuffer;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Not formattable: " + object, classCastException);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Cannot print object: " + object, iOException);
            }
        }

        @Override
        public AttributedCharacterIterator formatToCharacterIterator(Object object) {
            String string = ((ChronoFormatter)this.formatter).globalAttributes.get(Attributes.CALENDAR_TYPE, "iso8601");
            if (string.equals("iso8601")) {
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    ChronoEntity chronoEntity = (ChronoEntity)this.formatter.getChronology().getChronoType().cast(object);
                    Set<ElementPosition> set = this.formatter.print(chronoEntity, stringBuilder);
                    AttributedString attributedString = new AttributedString(stringBuilder.toString());
                    for (ElementPosition elementPosition : set) {
                        DateFormat.Field field = TraditionalFormat.toField(elementPosition.getElement());
                        if (field == null) continue;
                        attributedString.addAttribute(field, field, elementPosition.getStartIndex(), elementPosition.getEndIndex());
                    }
                    return attributedString.getIterator();
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("Not formattable: " + object, classCastException);
                }
            }
            return super.formatToCharacterIterator(object);
        }

        @Override
        public Object parseObject(String string, ParsePosition parsePosition) {
            ParseLog parseLog = new ParseLog(parsePosition.getIndex());
            T t = this.formatter.parse((CharSequence)string, parseLog);
            if (t == null) {
                parsePosition.setErrorIndex(parseLog.getErrorIndex());
            } else {
                parsePosition.setIndex(parseLog.getPosition());
            }
            return t;
        }

        private static DateFormat.Field toField(ChronoElement<?> chronoElement) {
            return FIELD_MAP.get(chronoElement.name());
        }

        static {
            HashMap<String, DateFormat.Field> hashMap = new HashMap<String, DateFormat.Field>();
            hashMap.put("YEAR", DateFormat.Field.YEAR);
            hashMap.put("YEAR_OF_ERA", DateFormat.Field.YEAR);
            hashMap.put("YEAR_OF_WEEKDATE", DateFormat.Field.YEAR);
            hashMap.put("WEEK_OF_YEAR", DateFormat.Field.WEEK_OF_YEAR);
            hashMap.put("WEEK_OF_MONTH", DateFormat.Field.WEEK_OF_MONTH);
            hashMap.put("BOUNDED_WEEK_OF_YEAR", DateFormat.Field.WEEK_OF_YEAR);
            hashMap.put("BOUNDED_WEEK_OF_MONTH", DateFormat.Field.WEEK_OF_MONTH);
            hashMap.put("MONTH_OF_YEAR", DateFormat.Field.MONTH);
            hashMap.put("MONTH_AS_NUMBER", DateFormat.Field.MONTH);
            hashMap.put("HISTORIC_MONTH", DateFormat.Field.MONTH);
            hashMap.put("WEEKDAY_IN_MONTH", DateFormat.Field.DAY_OF_WEEK_IN_MONTH);
            hashMap.put("SECOND_OF_MINUTE", DateFormat.Field.SECOND);
            hashMap.put("MINUTE_OF_HOUR", DateFormat.Field.MINUTE);
            hashMap.put("MILLI_OF_SECOND", DateFormat.Field.MILLISECOND);
            hashMap.put("DIGITAL_HOUR_OF_DAY", DateFormat.Field.HOUR_OF_DAY0);
            hashMap.put("DIGITAL_HOUR_OF_AMPM", DateFormat.Field.HOUR0);
            hashMap.put("CLOCK_HOUR_OF_DAY", DateFormat.Field.HOUR_OF_DAY1);
            hashMap.put("CLOCK_HOUR_OF_AMPM", DateFormat.Field.HOUR1);
            hashMap.put("AM_PM_OF_DAY", DateFormat.Field.AM_PM);
            hashMap.put("DAY_OF_MONTH", DateFormat.Field.DAY_OF_MONTH);
            hashMap.put("HISTORIC_DAY_OF_MONTH", DateFormat.Field.DAY_OF_MONTH);
            hashMap.put("DAY_OF_WEEK", DateFormat.Field.DAY_OF_WEEK);
            hashMap.put("LOCAL_DAY_OF_WEEK", DateFormat.Field.DAY_OF_WEEK);
            hashMap.put("DAY_OF_YEAR", DateFormat.Field.DAY_OF_YEAR);
            hashMap.put("TIMEZONE_ID", DateFormat.Field.TIME_ZONE);
            hashMap.put("ERA", DateFormat.Field.ERA);
            FIELD_MAP = Collections.unmodifiableMap(hashMap);
        }
    }

    public static final class Builder<T extends ChronoEntity<T>> {
        private final Chronology<T> chronology;
        private final Locale locale;
        private List<FormatStep> steps;
        private LinkedList<AttributeSet> stack;
        private int sectionID;
        private int reservedIndex;
        private int leftPadWidth;

        private Builder(Chronology<T> chronology, Locale locale) {
            if (chronology == null) {
                throw new NullPointerException("Missing chronology.");
            }
            if (locale == null) {
                throw new NullPointerException("Missing locale.");
            }
            this.chronology = chronology;
            this.locale = locale;
            this.steps = new ArrayList<FormatStep>();
            this.stack = new LinkedList();
            this.sectionID = 0;
            this.reservedIndex = -1;
            this.leftPadWidth = 0;
        }

        public Chronology<T> getChronology() {
            return this.chronology;
        }

        public Builder<T> addInteger(ChronoElement<Integer> chronoElement, int n, int n2) {
            return this.addNumber(chronoElement, false, n, n2, SignPolicy.SHOW_NEVER);
        }

        public Builder<T> addInteger(ChronoElement<Integer> chronoElement, int n, int n2, SignPolicy signPolicy) {
            return this.addNumber(chronoElement, false, n, n2, signPolicy);
        }

        public Builder<T> addLongNumber(ChronoElement<Long> chronoElement, int n, int n2, SignPolicy signPolicy) {
            return this.addNumber(chronoElement, false, n, n2, signPolicy);
        }

        public Builder<T> addFixedInteger(ChronoElement<Integer> chronoElement, int n) {
            return this.addNumber(chronoElement, true, n, n, SignPolicy.SHOW_NEVER);
        }

        public <V extends Enum<V>> Builder<T> addNumerical(ChronoElement<V> chronoElement, int n, int n2) {
            return this.addNumber(chronoElement, false, n, n2, SignPolicy.SHOW_NEVER);
        }

        public <V extends Enum<V>> Builder<T> addFixedNumerical(ChronoElement<V> chronoElement, int n) {
            return this.addNumber(chronoElement, true, n, n, SignPolicy.SHOW_NEVER);
        }

        public Builder<T> addFraction(ChronoElement<Integer> chronoElement, int n, int n2, boolean bl) {
            this.checkElement(chronoElement);
            boolean bl2 = !bl && n == n2;
            this.ensureOnlyOneFractional(bl2, bl);
            FractionProcessor fractionProcessor = new FractionProcessor(chronoElement, n, n2, bl);
            if (this.reservedIndex != -1 && bl2) {
                int n3 = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n3);
                this.addProcessor(fractionProcessor);
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n3;
                    this.steps.set(n3, formatStep.reserve(n));
                }
            } else {
                this.addProcessor(fractionProcessor);
            }
            return this;
        }

        public Builder<T> addFixedDecimal(ChronoElement<BigDecimal> chronoElement, int n, int n2) {
            this.checkElement(chronoElement);
            this.ensureDecimalDigitsOnlyOnce();
            DecimalProcessor decimalProcessor = new DecimalProcessor(chronoElement, n, n2);
            if (this.reservedIndex != -1) {
                int n3 = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n3);
                this.addProcessor(decimalProcessor);
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n3;
                    this.steps.set(n3, formatStep.reserve(n - n2));
                }
            } else {
                this.addProcessor(decimalProcessor);
            }
            return this;
        }

        public Builder<T> addEnglishOrdinal(ChronoElement<Integer> chronoElement) {
            return this.addOrdinalProcessor(chronoElement, null);
        }

        public Builder<T> addOrdinal(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map) {
            if (map == null) {
                throw new NullPointerException("Missing ordinal indicators.");
            }
            return this.addOrdinalProcessor(chronoElement, map);
        }

        public Builder<T> addLiteral(char c) {
            return this.addLiteral(String.valueOf(c));
        }

        public Builder<T> addLiteral(char c, char c2) {
            this.addProcessor(new LiteralProcessor(c, c2));
            return this;
        }

        public Builder<T> addLiteral(String string) {
            this.addProcessor(new LiteralProcessor(string));
            return this;
        }

        public Builder<T> addLiteral(AttributeKey<Character> attributeKey) {
            this.addProcessor(new LiteralProcessor(attributeKey));
            return this;
        }

        public Builder<T> addIgnorableWhitespace() {
            this.addProcessor(IgnorableWhitespaceProcessor.SINGLETON);
            return this;
        }

        public Builder<T> addPattern(String string, PatternType patternType) {
            ChronoElement chronoElement;
            ChronoElement<?> chronoElement2;
            int n;
            int n2;
            if (patternType == null) {
                throw new NullPointerException("Missing pattern type.");
            }
            Map<Object, Object> map = Collections.emptyMap();
            int n3 = string.length();
            Locale locale = this.locale;
            if (!this.stack.isEmpty()) {
                locale = this.stack.getLast().getLocale();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                n = string.charAt(n2);
                if (Builder.isSymbol((char)n)) {
                    n4 = n2++;
                    while (n2 < n3 && string.charAt(n2) == n) {
                        ++n2;
                    }
                    chronoElement2 = patternType.registerSymbol(this, locale, (char)n, n2 - n4);
                    if (map.isEmpty()) {
                        map = chronoElement2;
                    } else {
                        chronoElement = new HashMap(map);
                        chronoElement.putAll(chronoElement2);
                        map = chronoElement;
                    }
                    --n2;
                    continue;
                }
                if (n == 39) {
                    n4 = n2++;
                    while (n2 < n3) {
                        if (string.charAt(n2) == '\'') {
                            if (n2 + 1 >= n3 || string.charAt(n2 + 1) != '\'') break;
                            ++n2;
                        }
                        ++n2;
                    }
                    if (n2 >= n3) {
                        throw new IllegalArgumentException("String literal in pattern not closed: " + string);
                    }
                    if (n4 + 1 == n2) {
                        this.addLiteral('\'');
                        continue;
                    }
                    chronoElement2 = string.substring(n4 + 1, n2);
                    this.addLiteral(chronoElement2.replace((CharSequence)"''", (CharSequence)"'"));
                    continue;
                }
                if (n == 91) {
                    this.startOptionalSection();
                    continue;
                }
                if (n == 93) {
                    this.endSection();
                    continue;
                }
                if (n == 35 || n == 123 || n == 125) {
                    throw new IllegalArgumentException("Pattern contains reserved character: '" + (char)n + "'");
                }
                this.addLiteral((char)n);
            }
            if (!map.isEmpty()) {
                n2 = this.steps.size();
                for (n = 0; n < n2; ++n) {
                    FormatStep formatStep = this.steps.get(n);
                    chronoElement2 = formatStep.getProcessor().getElement();
                    if (!this.chronology.isRegistered(chronoElement2) || !map.containsKey(chronoElement2)) continue;
                    chronoElement = (ChronoElement)map.get(chronoElement2);
                    this.steps.set(n, formatStep.updateElement(chronoElement));
                }
            }
            return this;
        }

        public Builder<T> addText(TextElement<?> textElement) {
            this.checkElement((ChronoElement<?>)textElement);
            this.addProcessor(TextProcessor.create(textElement));
            return this;
        }

        public <V extends Enum<V>> Builder<T> addText(ChronoElement<V> chronoElement) {
            this.checkElement(chronoElement);
            if (chronoElement instanceof TextElement) {
                TextElement textElement = (TextElement)TextElement.class.cast(chronoElement);
                this.addProcessor(TextProcessor.create(textElement));
            } else {
                Map map = Collections.emptyMap();
                this.addProcessor(new LookupProcessor<V>(chronoElement, map));
            }
            return this;
        }

        public <V extends Enum<V>> Builder<T> addText(ChronoElement<V> chronoElement, Map<V, String> map) {
            this.checkElement(chronoElement);
            this.addProcessor(new LookupProcessor<V>(chronoElement, map));
            return this;
        }

        public <V extends ChronoEntity<V>> Builder<T> addCustomized(ChronoElement<V> chronoElement, ChronoFormatter<V> chronoFormatter) {
            return this.addCustomized(chronoElement, chronoFormatter, chronoFormatter);
        }

        public <V> Builder<T> addCustomized(ChronoElement<V> chronoElement, ChronoPrinter<V> chronoPrinter, ChronoParser<V> chronoParser) {
            this.checkElement(chronoElement);
            this.startSection((AttributeKey)Attributes.TRAILING_CHARACTERS, (Enum)true);
            this.addProcessor(new CustomizedProcessor<V>(chronoElement, chronoPrinter, chronoParser));
            this.endSection();
            return this;
        }

        public Builder<T> addTwoDigitYear(ChronoElement<Integer> chronoElement) {
            this.checkElement(chronoElement);
            this.checkAfterDecimalDigits(chronoElement);
            TwoDigitYearProcessor twoDigitYearProcessor = new TwoDigitYearProcessor(chronoElement);
            if (this.reservedIndex == -1) {
                this.addProcessor(twoDigitYearProcessor);
                this.reservedIndex = this.steps.size() - 1;
            } else {
                int n = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n);
                this.startSection(Attributes.LENIENCY, Leniency.STRICT);
                this.addProcessor(twoDigitYearProcessor);
                this.endSection();
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n;
                    this.steps.set(n, formatStep.reserve(2));
                }
            }
            return this;
        }

        public Builder<T> addTimezoneID() {
            Class clazz = this.getChronology().getChronoType();
            if (UnixTime.class.isAssignableFrom(clazz)) {
                this.addProcessor(TimezoneIDProcessor.INSTANCE);
                return this;
            }
            throw new IllegalStateException("Only unix timestamps can have a timezone id.");
        }

        public Builder<T> addShortTimezoneName() {
            this.addProcessor(new TimezoneNameProcessor(true));
            return this;
        }

        public Builder<T> addLongTimezoneName() {
            this.addProcessor(new TimezoneNameProcessor(false));
            return this;
        }

        public Builder<T> addShortTimezoneName(Set<TZID> set) {
            this.addProcessor(new TimezoneNameProcessor(true, set));
            return this;
        }

        public Builder<T> addLongTimezoneName(Set<TZID> set) {
            this.addProcessor(new TimezoneNameProcessor(false, set));
            return this;
        }

        public Builder<T> addTimezoneOffset() {
            return this.addTimezoneOffset(DisplayMode.MEDIUM, true, Collections.singletonList("Z"));
        }

        public Builder<T> addTimezoneOffset(DisplayMode displayMode, boolean bl, List<String> list) {
            this.addProcessor(new TimezoneOffsetProcessor(displayMode, bl, list));
            return this;
        }

        public Builder<T> addShortLocalizedOffset() {
            this.addProcessor(new LocalizedGMTProcessor(true));
            return this;
        }

        public Builder<T> addLongLocalizedOffset() {
            this.addProcessor(new LocalizedGMTProcessor(false));
            return this;
        }

        public Builder<T> padNext(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative pad width: " + n);
            }
            if (n > 0) {
                this.leftPadWidth = n;
            }
            return this;
        }

        public Builder<T> padPrevious(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative pad width: " + n);
            }
            if (!this.steps.isEmpty() && n > 0) {
                int n2 = this.steps.size() - 1;
                FormatStep formatStep = this.steps.get(n2);
                int n3 = 0;
                if (!this.stack.isEmpty()) {
                    n3 = this.stack.getLast().getSection();
                }
                if (n3 == formatStep.getSection()) {
                    this.steps.set(n2, formatStep.pad(0, n));
                }
            }
            return this;
        }

        public Builder<T> startOptionalSection() {
            return this.startOptionalSection(null);
        }

        public Builder<T> startOptionalSection(final ChronoCondition<ChronoDisplay> chronoCondition) {
            ChronoCondition<ChronoDisplay> chronoCondition2;
            this.resetPadding();
            Attributes.Builder builder = new Attributes.Builder(this.chronology);
            AttributeSet attributeSet = null;
            ChronoCondition<ChronoDisplay> chronoCondition3 = null;
            if (!this.stack.isEmpty()) {
                attributeSet = this.stack.getLast();
                builder.setAll(attributeSet.getAttributes());
                chronoCondition3 = attributeSet.getCondition();
            }
            int n = Builder.getLevel(attributeSet) + 1;
            int n2 = ++this.sectionID;
            if (chronoCondition != null) {
                chronoCondition2 = chronoCondition3;
                chronoCondition3 = chronoCondition2 == null ? chronoCondition : new ChronoCondition<ChronoDisplay>(){

                    public boolean test(ChronoDisplay chronoDisplay) {
                        return chronoCondition2.test((Object)chronoDisplay) && chronoCondition.test((Object)chronoDisplay);
                    }
                };
            }
            chronoCondition2 = new AttributeSet(builder.build(), this.locale, n, n2, chronoCondition3, null);
            this.stack.addLast((AttributeSet)chronoCondition2);
            return this;
        }

        public Builder<T> startSection(AttributeKey<Boolean> attributeKey, boolean bl) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder(this.chronology);
                attributeSet = new AttributeSet(builder.set(attributeKey, bl).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, bl);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public Builder<T> startSection(AttributeKey<Integer> attributeKey, int n) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder(this.chronology);
                attributeSet = new AttributeSet(builder.set(attributeKey, n).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, n);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public Builder<T> startSection(AttributeKey<Character> attributeKey, char c) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder(this.chronology);
                attributeSet = new AttributeSet(builder.set(attributeKey, c).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, c);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public <A extends Enum<A>> Builder<T> startSection(AttributeKey<A> attributeKey, A a) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder(this.chronology);
                attributeSet = new AttributeSet(builder.set(attributeKey, a).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, a);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public Builder<T> endSection() {
            this.stack.removeLast();
            this.resetPadding();
            return this;
        }

        public ChronoFormatter<T> build() {
            return new ChronoFormatter(this.chronology, this.locale, this.steps);
        }

        Builder<T> addYear(ChronoElement<Integer> chronoElement, int n, boolean bl) {
            if (this.steps.isEmpty() || !this.steps.get(this.steps.size() - 1).isNumerical() || n != 4) {
                SignPolicy signPolicy = n < 4 ? SignPolicy.SHOW_WHEN_NEGATIVE : SignPolicy.SHOW_WHEN_BIG_NUMBER;
                return this.addNumber(chronoElement, false, n, 9, signPolicy, bl);
            }
            assert (n == 4);
            return this.addNumber(chronoElement, true, 4, 4, SignPolicy.SHOW_NEVER, bl);
        }

        private <V> Builder<T> addNumber(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy) {
            return this.addNumber(chronoElement, bl, n, n2, signPolicy, false);
        }

        private <V> Builder<T> addNumber(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy, boolean bl2) {
            this.checkElement(chronoElement);
            FormatStep formatStep = this.checkAfterDecimalDigits(chronoElement);
            NumberProcessor<V> numberProcessor = new NumberProcessor<V>(chronoElement, bl, n, n2, signPolicy, bl2);
            if (bl) {
                if (this.reservedIndex == -1) {
                    this.addProcessor(numberProcessor);
                } else {
                    int n3 = this.reservedIndex;
                    FormatStep formatStep2 = this.steps.get(n3);
                    this.addProcessor(numberProcessor);
                    FormatStep formatStep3 = this.steps.get(this.steps.size() - 1);
                    if (formatStep2.getSection() == formatStep3.getSection()) {
                        this.reservedIndex = n3;
                        this.steps.set(n3, formatStep2.reserve(n));
                    }
                }
            } else {
                if (formatStep != null && formatStep.isNumerical()) {
                    throw new IllegalStateException("Numerical element with variable width can't be inserted after another numerical element. Consider \"addFixedXXX()\" instead.");
                }
                this.addProcessor(numberProcessor);
                this.reservedIndex = this.steps.size() - 1;
            }
            return this;
        }

        private Builder<T> addOrdinalProcessor(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map) {
            this.checkElement(chronoElement);
            FormatStep formatStep = this.checkAfterDecimalDigits(chronoElement);
            OrdinalProcessor ordinalProcessor = new OrdinalProcessor(chronoElement, map);
            if (formatStep != null && formatStep.isNumerical()) {
                throw new IllegalStateException("Ordinal element with variable width can't be inserted after another numerical element.");
            }
            this.addProcessor(ordinalProcessor);
            return this;
        }

        private void addProcessor(FormatProcessor<?> formatProcessor) {
            this.reservedIndex = -1;
            AttributeSet attributeSet = null;
            int n = 0;
            int n2 = 0;
            if (!this.stack.isEmpty()) {
                attributeSet = this.stack.getLast();
                n = attributeSet.getLevel();
                n2 = attributeSet.getSection();
            }
            FormatStep formatStep = new FormatStep(formatProcessor, n, n2, attributeSet);
            if (this.leftPadWidth > 0) {
                formatStep = formatStep.pad(this.leftPadWidth, 0);
                this.leftPadWidth = 0;
            }
            this.steps.add(formatStep);
        }

        private static int getLevel(AttributeSet attributeSet) {
            if (attributeSet == null) {
                return 0;
            }
            return attributeSet.getLevel();
        }

        private static void checkAttribute(AttributeKey<?> attributeKey) {
            if (attributeKey.name().charAt(0) == '_') {
                throw new IllegalArgumentException("Internal attribute not allowed: " + attributeKey.name());
            }
        }

        private void resetPadding() {
            this.leftPadWidth = 0;
        }

        private static boolean isSymbol(char c) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
        }

        private void checkElement(ChronoElement<?> chronoElement) {
            ChronoFormatter.checkElement(this.chronology, chronoElement);
        }

        private void ensureDecimalDigitsOnlyOnce() {
            for (FormatStep formatStep : this.steps) {
                if (!formatStep.isDecimal()) continue;
                throw new IllegalArgumentException("Cannot define more than one element with decimal digits.");
            }
        }

        private void ensureOnlyOneFractional(boolean bl, boolean bl2) {
            this.ensureDecimalDigitsOnlyOnce();
            if (!bl && !bl2 && this.reservedIndex != -1) {
                throw new IllegalArgumentException("Cannot add fractional element with variable width after another numerical element with variable width.");
            }
        }

        private FormatStep checkAfterDecimalDigits(ChronoElement<?> chronoElement) {
            FormatStep formatStep;
            FormatStep formatStep2 = formatStep = this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
            if (formatStep == null) {
                return null;
            }
            if (formatStep.isDecimal()) {
                throw new IllegalStateException(chronoElement.name() + " can't be inserted after an element" + " with decimal digits.");
            }
            return formatStep;
        }
    }
}

