/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.DisplayMode;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class TimezoneOffsetProcessor
implements FormatProcessor<TZID> {
    static final TimezoneOffsetProcessor EXTENDED_LONG_PARSER = new TimezoneOffsetProcessor();
    private final DisplayMode precision;
    private final boolean extended;
    private final List<String> zeroOffsets;

    TimezoneOffsetProcessor(DisplayMode displayMode, boolean bl, List<String> list) {
        if (displayMode == null) {
            throw new NullPointerException("Missing display mode.");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Missing zero offsets.");
        }
        ArrayList<String> arrayList = new ArrayList<String>(list);
        for (String string : arrayList) {
            if (!string.trim().isEmpty()) continue;
            throw new IllegalArgumentException("Zero offset must not be white-space-only.");
        }
        this.precision = displayMode;
        this.extended = bl;
        this.zeroOffsets = Collections.unmodifiableList(arrayList);
    }

    private TimezoneOffsetProcessor() {
        this.precision = DisplayMode.LONG;
        this.extended = true;
        this.zeroOffsets = Collections.emptyList();
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        ZonalOffset zonalOffset;
        int n = -1;
        int n2 = 0;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        TZID tZID = null;
        if (chronoDisplay.hasTimezone()) {
            tZID = chronoDisplay.getTimezone();
        }
        if (tZID == null) {
            zonalOffset = TimezoneOffsetProcessor.getOffset(chronoDisplay, formatStep, attributeQuery);
        } else if (tZID instanceof ZonalOffset) {
            zonalOffset = (ZonalOffset)tZID;
        } else if (chronoDisplay instanceof UnixTime) {
            zonalOffset = Timezone.of((TZID)tZID).getOffset((UnixTime)chronoDisplay);
        } else {
            throw new IllegalArgumentException("Cannot extract timezone offset from: " + chronoDisplay);
        }
        int n3 = zonalOffset.getIntegralAmount();
        int n4 = zonalOffset.getFractionalAmount();
        if ((n3 | n4) == 0) {
            String string = this.zeroOffsets.get(0);
            appendable.append(string);
            n2 = string.length();
        } else {
            boolean bl = n3 < 0 || n4 < 0;
            appendable.append(bl ? (char)'-' : '+');
            ++n2;
            int n5 = Math.abs(n3);
            int n6 = n5 / 3600;
            int n7 = n5 / 60 % 60;
            int n8 = n5 % 60;
            if (n6 < 10) {
                appendable.append('0');
                ++n2;
            }
            String string = String.valueOf(n6);
            appendable.append(string);
            n2 += string.length();
            if (this.precision != DisplayMode.SHORT || n7 != 0) {
                if (this.extended) {
                    appendable.append(':');
                    ++n2;
                }
                if (n7 < 10) {
                    appendable.append('0');
                    ++n2;
                }
                String string2 = String.valueOf(n7);
                appendable.append(string2);
                n2 += string2.length();
                if (this.precision != DisplayMode.SHORT && this.precision != DisplayMode.MEDIUM && (this.precision == DisplayMode.FULL || (n8 | n4) != 0)) {
                    if (this.extended) {
                        appendable.append(':');
                        ++n2;
                    }
                    if (n8 < 10) {
                        appendable.append('0');
                        ++n2;
                    }
                    String string3 = String.valueOf(n8);
                    appendable.append(string3);
                    n2 += string3.length();
                    if (n4 != 0) {
                        appendable.append('.');
                        ++n2;
                        String string4 = String.valueOf(Math.abs(n4));
                        int n9 = 9 - string4.length();
                        for (int i = 0; i < n9; ++i) {
                            appendable.append('0');
                            ++n2;
                        }
                        appendable.append(string4);
                        n2 += string4.length();
                    }
                }
            }
        }
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n, n + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        ZonalOffset zonalOffset;
        int n;
        int n2;
        String string2;
        int n3 = charSequence.length();
        int n4 = parseLog.getPosition();
        int n5 = n4;
        if (n5 >= n3) {
            parseLog.setError(n4, "Missing timezone offset.");
            return;
        }
        for (String string2 : this.zeroOffsets) {
            int n6 = string2.length();
            if (n3 - n5 < n6) continue;
            String string3 = charSequence.subSequence(n5, n5 + n6).toString();
            n2 = formatStep.getAttribute(Attributes.PARSE_CASE_INSENSITIVE, attributeQuery, Boolean.TRUE).booleanValue() ? 1 : 0;
            if ((n2 == 0 || !string3.equalsIgnoreCase(string2)) && (n2 != 0 || !string3.equals(string2))) continue;
            map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
            parseLog.setPosition(n5 + n6);
            return;
        }
        char c = charSequence.charAt(n5);
        ++n5;
        if (c == '+') {
            string2 = OffsetSign.AHEAD_OF_UTC;
        } else if (c == '-') {
            string2 = OffsetSign.BEHIND_UTC;
        } else {
            parseLog.setError(n4, "Missing sign of timezone offset.");
            return;
        }
        Leniency leniency = formatStep.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART);
        int n7 = TimezoneOffsetProcessor.parseNum(charSequence, n5, leniency);
        if (n7 == -1000) {
            parseLog.setError(n5, "Hour part in timezone offset does not match expected pattern HH.");
            return;
        }
        if (n7 < 0) {
            n7 ^= 0xFFFFFFFF;
            ++n5;
        } else {
            n5 += 2;
        }
        if (n5 >= n3) {
            if (this.precision == DisplayMode.SHORT) {
                map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours((OffsetSign)string2, (int)n7));
                parseLog.setPosition(n5);
            } else {
                parseLog.setError(n5, "Missing minute part in timezone offset.");
            }
            return;
        }
        n2 = 0;
        if (this.extended) {
            if (charSequence.charAt(n5) == ':') {
                n2 = 1;
            } else {
                if (this.precision == DisplayMode.SHORT) {
                    map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours((OffsetSign)string2, (int)n7));
                    parseLog.setPosition(n5);
                    return;
                }
                parseLog.setError(n5, "Colon expected in timezone offset.");
                return;
            }
        }
        int n8 = TimezoneOffsetProcessor.parseNum(charSequence, n5 + n2, Leniency.STRICT);
        int n9 = 0;
        int n10 = 0;
        if (n8 == -1000) {
            if (this.precision == DisplayMode.SHORT) {
                map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours((OffsetSign)string2, (int)n7));
                parseLog.setPosition(n5);
            } else {
                parseLog.setError(n5 + n2, "Minute part in timezone offset does not match expected pattern mm.");
            }
            return;
        }
        n5 += n2;
        if ((n5 += 2) < n3 && (this.precision == DisplayMode.LONG || this.precision == DisplayMode.FULL)) {
            n2 = 0;
            if (this.extended) {
                if (charSequence.charAt(n5) == ':') {
                    n2 = 1;
                    n9 = TimezoneOffsetProcessor.parseNum(charSequence, n5 + n2, Leniency.STRICT);
                } else {
                    if (this.precision == DisplayMode.FULL) {
                        parseLog.setError(n5, "Colon expected in timezone offset.");
                        return;
                    }
                    n9 = -1000;
                }
            } else {
                n9 = TimezoneOffsetProcessor.parseNum(charSequence, n5, Leniency.STRICT);
            }
            if (n9 == -1000) {
                if (this.precision == DisplayMode.FULL) {
                    parseLog.setError(n5, "Second part in timezone offset does not match expected pattern ss.");
                    return;
                }
                n9 = 0;
            } else {
                char c2;
                n5 += n2;
                if ((n5 += 2) + 10 <= n3 && (c2 = charSequence.charAt(n5)) == '.') {
                    int n11 = n5 + 9;
                    for (n = ++n5; n < n11; ++n) {
                        char c3 = charSequence.charAt(n);
                        if (c3 >= '0' && c3 <= '9') {
                            n10 = n10 * 10 + (c3 - 48);
                            ++n5;
                            continue;
                        }
                        parseLog.setError(n5, "9 digits in fractional part of timezone offset expected.");
                        return;
                    }
                }
            }
        }
        if (n9 == 0 && n10 == 0) {
            zonalOffset = ZonalOffset.ofHoursMinutes((OffsetSign)string2, (int)n7, (int)n8);
        } else {
            n = n7 * 3600 + n8 * 60 + n9;
            if (string2 == OffsetSign.BEHIND_UTC) {
                n = -n;
                n10 = -n10;
            }
            zonalOffset = ZonalOffset.ofTotalSeconds((int)n, (int)n10);
        }
        map.put(TimezoneElement.TIMEZONE_OFFSET, zonalOffset);
        parseLog.setPosition(n5);
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_OFFSET;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    private static ZonalOffset getOffset(ChronoDisplay chronoDisplay, FormatStep formatStep, AttributeQuery attributeQuery) {
        AttributeQuery attributeQuery2 = formatStep.getQuery(attributeQuery);
        if (attributeQuery2.contains(Attributes.TIMEZONE_ID)) {
            TZID tZID = (TZID)attributeQuery2.get(Attributes.TIMEZONE_ID);
            if (tZID instanceof ZonalOffset) {
                return (ZonalOffset)tZID;
            }
            if (tZID != null) {
                throw new IllegalArgumentException("Use a timezone offset instead of [" + tZID.canonical() + "] when formatting [" + chronoDisplay + "].");
            }
        }
        throw new IllegalArgumentException("Cannot extract timezone offset from format attributes for: " + chronoDisplay);
    }

    private static int parseNum(CharSequence charSequence, int n, Leniency leniency) {
        int n2 = 0;
        for (int i = 0; i < 2; ++i) {
            int n3 = n + i >= charSequence.length() ? 0 : (int)charSequence.charAt(n + i);
            if (n3 < 48 || n3 > 57) {
                if (i == 0 || leniency.isStrict()) {
                    return -1000;
                }
                return ~n2;
            }
            n2 = n2 * 10 + (n3 - 48);
        }
        return n2;
    }
}

