/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.history.HistoricEra;

public final class HistoricDate
implements Comparable<HistoricDate> {
    private final HistoricEra era;
    private final int yearOfEra;
    private final int month;
    private final int dom;

    HistoricDate(HistoricEra historicEra, int n, int n2, int n3) {
        this.era = historicEra;
        this.yearOfEra = n;
        this.month = n2;
        this.dom = n3;
    }

    public static HistoricDate of(HistoricEra historicEra, int n, int n2, int n3) {
        if (n3 < 1 || n3 > 31 || n2 < 1 || n2 > 12 || n < 1 || n > 999999999 + (historicEra == HistoricEra.BC ? 1 : 0)) {
            throw new IllegalArgumentException("Out of range: " + HistoricDate.toString(historicEra, n, n2, n3));
        }
        if (historicEra == null) {
            throw new NullPointerException("Missing historical era.");
        }
        return new HistoricDate(historicEra, n, n2, n3);
    }

    public HistoricEra getEra() {
        return this.era;
    }

    public int getYearOfEra() {
        return this.yearOfEra;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.dom;
    }

    @Override
    public int compareTo(HistoricDate historicDate) {
        if (this.getEra() == HistoricEra.BC) {
            if (historicDate.getEra() == HistoricEra.AD) {
                return -1;
            }
            int n = this.getYearOfEra() - historicDate.getYearOfEra();
            if (n < 0) {
                return 1;
            }
            if (n > 0) {
                return -1;
            }
            n = this.getMonth() - historicDate.getMonth();
            if (n == 0) {
                n = this.getDayOfMonth() - historicDate.getDayOfMonth();
            }
            return n < 0 ? -1 : (n > 0 ? 1 : 0);
        }
        if (historicDate.getEra() == HistoricEra.BC) {
            return 1;
        }
        int n = this.getYearOfEra() - historicDate.getYearOfEra();
        if (n == 0 && (n = this.getMonth() - historicDate.getMonth()) == 0) {
            n = this.getDayOfMonth() - historicDate.getDayOfMonth();
        }
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HistoricDate) {
            HistoricDate historicDate = (HistoricDate)object;
            return this.era == historicDate.era && this.yearOfEra == historicDate.yearOfEra && this.month == historicDate.month && this.dom == historicDate.dom;
        }
        return false;
    }

    public int hashCode() {
        int n = this.yearOfEra * 1000 + this.month * 32 + this.dom;
        return this.era == HistoricEra.AD ? n : -n;
    }

    public String toString() {
        return HistoricDate.toString(this.era, this.yearOfEra, this.month, this.dom);
    }

    private static String toString(HistoricEra historicEra, int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)historicEra);
        stringBuilder.append('-');
        String string = String.valueOf(n);
        for (int i = 4 - string.length(); i > 0; --i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append('-');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }
}

