/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history.internal;

import net.time4j.PlainDate;
import net.time4j.engine.AttributeKey;
import net.time4j.history.internal.HistoricVariant;

public final class HistoricAttribute<T>
implements AttributeKey<T> {
    public static final AttributeKey<HistoricVariant> HISTORIC_VARIANT = HistoricAttribute.of("HISTORIC_VARIANT", HistoricVariant.class);
    public static final AttributeKey<PlainDate> CUTOVER_DATE = HistoricAttribute.of("CUTOVER_DATE", PlainDate.class);
    public static final AttributeKey<Boolean> COMMON_ERA = HistoricAttribute.of("COMMON_ERA", Boolean.class);
    public static final AttributeKey<Boolean> LATIN_ERA = HistoricAttribute.of("LATIN_ERA", Boolean.class);
    public static final AttributeKey<Object> ANCIENT_JULIAN_LEAP_YEARS = HistoricAttribute.of("ANCIENT_JULIAN_LEAP_YEARS", Object.class);
    private final String name;
    private final Class<T> type;

    private HistoricAttribute(String string, Class<T> clazz) {
        this.name = string;
        this.type = clazz;
    }

    private static <T> HistoricAttribute<T> of(String string, Class<T> clazz) {
        return new HistoricAttribute<T>(string, clazz);
    }

    public String name() {
        return this.name;
    }

    public Class<T> type() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HistoricAttribute) {
            HistoricAttribute historicAttribute = (HistoricAttribute)object;
            return this.name.equals(historicAttribute.name) && this.type.equals(historicAttribute.type);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.type.getName() + "@" + this.name;
    }
}

