/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Collections;
import java.util.Locale;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekmodel;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.DisplayMode;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.SignPolicy;
import net.time4j.tz.TZID;
import net.time4j.tz.ZonalOffset;

public class Iso8601Format {
    private static final NonZeroCondition NON_ZERO_SECOND = new NonZeroCondition((ChronoElement<Integer>)PlainTime.SECOND_OF_MINUTE);
    private static final NonZeroCondition NON_ZERO_FRACTION = new NonZeroCondition((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND);
    private static final ChronoCondition<ChronoDisplay> SECOND_PART = NON_ZERO_SECOND.or(NON_ZERO_FRACTION);
    public static final ChronoFormatter<PlainDate> BASIC_CALENDAR_DATE = Iso8601Format.calendarFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_CALENDAR_DATE = Iso8601Format.calendarFormat(true);
    public static final ChronoFormatter<PlainDate> BASIC_ORDINAL_DATE = Iso8601Format.ordinalFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_ORDINAL_DATE = Iso8601Format.ordinalFormat(true);
    public static final ChronoFormatter<PlainDate> BASIC_WEEK_DATE = Iso8601Format.weekdateFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_WEEK_DATE = Iso8601Format.weekdateFormat(true);
    public static final ChronoFormatter<PlainTime> BASIC_WALL_TIME = Iso8601Format.timeFormat(false);
    public static final ChronoFormatter<PlainTime> EXTENDED_WALL_TIME = Iso8601Format.timeFormat(true);
    public static final ChronoFormatter<PlainTimestamp> BASIC_DATE_TIME = Iso8601Format.timestampFormat(false);
    public static final ChronoFormatter<PlainTimestamp> EXTENDED_DATE_TIME = Iso8601Format.timestampFormat(true);
    public static final ChronoFormatter<Moment> BASIC_DATE_TIME_OFFSET = Iso8601Format.momentFormat(false);
    public static final ChronoFormatter<Moment> EXTENDED_DATE_TIME_OFFSET = Iso8601Format.momentFormat(true);

    private Iso8601Format() {
    }

    private static ChronoFormatter<PlainDate> calendarFormat(boolean bl) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT);
        Iso8601Format.addCalendarDate(builder, bl);
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainDate> ordinalFormat(boolean bl) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT).addInteger((ChronoElement<Integer>)PlainDate.YEAR, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        return builder.addFixedInteger((ChronoElement<Integer>)PlainDate.DAY_OF_YEAR, 3).build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainDate> weekdateFormat(boolean bl) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT).addInteger((ChronoElement<Integer>)PlainDate.YEAR_OF_WEEKDATE, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addLiteral('W');
        builder.addFixedInteger((ChronoElement<Integer>)Weekmodel.ISO.weekOfYear(), 2);
        if (bl) {
            builder.addLiteral('-');
        }
        return builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, 1).build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainTime> timeFormat(boolean bl) {
        ChronoFormatter.Builder<PlainTime> builder = ChronoFormatter.setUp(PlainTime.class, Locale.ROOT);
        Iso8601Format.addWallTime(builder, bl);
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainTimestamp> timestampFormat(boolean bl) {
        ChronoFormatter.Builder<PlainTimestamp> builder = ChronoFormatter.setUp(PlainTimestamp.class, Locale.ROOT);
        Iso8601Format.addCalendarDate(builder, bl);
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, bl);
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<Moment> momentFormat(boolean bl) {
        ChronoFormatter.Builder<Moment> builder = ChronoFormatter.setUp(Moment.class, Locale.ROOT);
        builder.addCustomized(Moment.axis().element(), Iso8601Format.momentFormat(DisplayMode.MEDIUM, bl), Iso8601Format.momentFormat(DisplayMode.SHORT, bl));
        return builder.build().withTimezone((TZID)ZonalOffset.UTC).with(Leniency.STRICT);
    }

    private static ChronoFormatter<Moment> momentFormat(DisplayMode displayMode, boolean bl) {
        ChronoFormatter.Builder<Moment> builder = ChronoFormatter.setUp(Moment.class, Locale.ROOT);
        Iso8601Format.addCalendarDate(builder, bl);
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, bl);
        builder.addTimezoneOffset(displayMode, bl, Collections.singletonList("Z"));
        return builder.build().withTimezone((TZID)ZonalOffset.UTC);
    }

    private static <T extends ChronoEntity<T>> void addCalendarDate(ChronoFormatter.Builder<T> builder, boolean bl) {
        builder.addInteger((ChronoElement<Integer>)PlainDate.YEAR, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addFixedInteger((ChronoElement<Integer>)PlainDate.MONTH_AS_NUMBER, 2);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addFixedInteger((ChronoElement<Integer>)PlainDate.DAY_OF_MONTH, 2);
    }

    private static <T extends ChronoEntity<T>> void addWallTime(ChronoFormatter.Builder<T> builder, boolean bl) {
        builder.addFixedInteger((ChronoElement<Integer>)PlainTime.ISO_HOUR, 2);
        builder.startOptionalSection();
        if (bl) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger((ChronoElement<Integer>)PlainTime.MINUTE_OF_HOUR, 2);
        builder.startOptionalSection(SECOND_PART);
        if (bl) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger((ChronoElement<Integer>)PlainTime.SECOND_OF_MINUTE, 2);
        builder.startOptionalSection(NON_ZERO_FRACTION);
        builder.addFraction((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, 0, 9, true);
        builder.endSection();
        builder.endSection();
        builder.endSection();
    }

    private static class NonZeroCondition
    implements ChronoCondition<ChronoDisplay> {
        private final ChronoElement<Integer> element;

        NonZeroCondition(ChronoElement<Integer> chronoElement) {
            this.element = chronoElement;
        }

        public boolean test(ChronoDisplay chronoDisplay) {
            return chronoDisplay.contains(this.element) && (Integer)chronoDisplay.get(this.element) != 0;
        }

        ChronoCondition<ChronoDisplay> or(final NonZeroCondition nonZeroCondition) {
            return new ChronoCondition<ChronoDisplay>(){

                public boolean test(ChronoDisplay chronoDisplay) {
                    return NonZeroCondition.this.test(chronoDisplay) || nonZeroCondition.test(chronoDisplay);
                }
            };
        }
    }
}

