/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.expert.AttributeSet;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class LocalizedGMTProcessor
implements FormatProcessor<TZID> {
    private static final char UNICODE_LRM = '\u200e';
    private final boolean abbreviated;

    LocalizedGMTProcessor(boolean bl) {
        this.abbreviated = bl;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        boolean bl;
        ZonalOffset zonalOffset;
        int n = -1;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        TZID tZID = null;
        if (chronoDisplay.hasTimezone()) {
            tZID = chronoDisplay.getTimezone();
        }
        if (tZID == null) {
            zonalOffset = LocalizedGMTProcessor.getOffset(chronoDisplay, formatStep, attributeQuery);
        } else if (tZID instanceof ZonalOffset) {
            zonalOffset = (ZonalOffset)tZID;
        } else if (chronoDisplay instanceof UnixTime) {
            zonalOffset = Timezone.of((TZID)tZID).getOffset((UnixTime)chronoDisplay);
        } else {
            throw new IllegalArgumentException("Cannot extract timezone offset from: " + chronoDisplay);
        }
        Locale locale = formatStep.getAttribute(Attributes.LANGUAGE, attributeQuery, Locale.ROOT);
        char c = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        String string = formatStep.getAttribute(AttributeSet.PLUS_SIGN, attributeQuery, "+");
        String string2 = formatStep.getAttribute(AttributeSet.MINUS_SIGN, attributeQuery, "-");
        if ("ar".equals(locale.getLanguage()) && c == '0') {
            string = "\u200e+";
            string2 = "\u200e-";
        }
        String string3 = (bl = formatStep.getAttribute(Attributes.NO_GMT_PREFIX, attributeQuery, Boolean.FALSE).booleanValue()) ? "" : LocalizedGMTProcessor.getGMTPrefix(locale);
        appendable.append(string3);
        int n2 = string3.length();
        int n3 = zonalOffset.getIntegralAmount();
        int n4 = zonalOffset.getFractionalAmount();
        if (bl || n3 != 0 || n4 != 0) {
            int n5;
            if (zonalOffset.getSign() == OffsetSign.BEHIND_UTC) {
                appendable.append(string2);
                n2 += string2.length();
            } else {
                appendable.append(string);
                n2 += string.length();
            }
            int n6 = zonalOffset.getAbsoluteHours();
            int n7 = zonalOffset.getAbsoluteMinutes();
            int n8 = zonalOffset.getAbsoluteSeconds();
            if (n6 < 10 && !this.abbreviated) {
                appendable.append(c);
                ++n2;
            }
            String string4 = String.valueOf(n6);
            for (int i = 0; i < string4.length(); ++i) {
                n5 = string4.charAt(i) - 48 + c;
                appendable.append((char)n5);
                ++n2;
            }
            if (n7 != 0 || n8 != 0 || !this.abbreviated) {
                int n9;
                appendable.append(':');
                ++n2;
                if (n7 < 10) {
                    appendable.append(c);
                    ++n2;
                }
                String string5 = String.valueOf(n7);
                for (n5 = 0; n5 < string5.length(); ++n5) {
                    n9 = string5.charAt(n5) - 48 + c;
                    appendable.append((char)n9);
                    ++n2;
                }
                if (n8 != 0) {
                    appendable.append(':');
                    ++n2;
                    if (n8 < 10) {
                        appendable.append(c);
                        ++n2;
                    }
                    String string6 = String.valueOf(n8);
                    for (n9 = 0; n9 < string6.length(); ++n9) {
                        char c2 = (char)(string6.charAt(n9) - 48 + c);
                        appendable.append(c2);
                        ++n2;
                    }
                }
            }
        }
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n, n + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        ZonalOffset zonalOffset;
        int n;
        String string;
        int n2;
        int n3;
        OffsetSign offsetSign;
        Object object;
        int n4 = charSequence.length();
        int n5 = parseLog.getPosition();
        int n6 = n5;
        if (n6 >= n4) {
            parseLog.setError(n5, "Missing localized time zone offset.");
            return;
        }
        Locale locale = formatStep.getAttribute(Attributes.LANGUAGE, attributeQuery, Locale.ROOT);
        boolean bl = formatStep.getAttribute(Attributes.NO_GMT_PREFIX, attributeQuery, Boolean.FALSE);
        boolean bl2 = formatStep.getAttribute(Attributes.PARSE_CASE_INSENSITIVE, attributeQuery, Boolean.TRUE);
        if (!bl) {
            String string2 = LocalizedGMTProcessor.getGMTPrefix(locale);
            object = new OffsetSign[]{"GMT", string2, "UTC", "UT"};
            boolean bl3 = false;
            offsetSign = object;
            n3 = ((String[])offsetSign).length;
            for (n2 = 0; n2 < n3; ++n2) {
                string = offsetSign[n2];
                n = string.length();
                if (n4 - n6 < n) continue;
                String string3 = charSequence.subSequence(n6, n6 + n).toString();
                if ((!bl2 || !string3.equalsIgnoreCase(string)) && (bl2 || !string3.equals(string))) continue;
                bl3 = true;
                n6 += n;
                break;
            }
            if (!bl3) {
                parseLog.setError(n5, "Missing prefix in localized time zone offset: " + string2);
                return;
            }
            if (n6 >= n4) {
                map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
                parseLog.setPosition(n6);
                return;
            }
        }
        char c = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        object = formatStep.getAttribute(AttributeSet.PLUS_SIGN, attributeQuery, "+");
        String string4 = formatStep.getAttribute(AttributeSet.MINUS_SIGN, attributeQuery, "-");
        if ("ar".equals(locale.getLanguage()) && c == '0') {
            object = "\u200e+";
            string4 = "\u200e-";
        }
        if ((n3 = LiteralProcessor.subSequenceEquals(charSequence, n6, (CharSequence)object, bl2)) == -1) {
            n3 = LiteralProcessor.subSequenceEquals(charSequence, n6, string4, bl2);
            if (n3 == -1) {
                if (bl) {
                    parseLog.setError(n5, "Missing sign in localized time zone offset.");
                    return;
                }
                map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
                parseLog.setPosition(n6);
                return;
            }
            offsetSign = OffsetSign.BEHIND_UTC;
        } else {
            offsetSign = OffsetSign.AHEAD_OF_UTC;
        }
        n2 = LocalizedGMTProcessor.parseHours(charSequence, n6 += n3, c);
        if (n2 == -1000) {
            parseLog.setError(n6, "Missing hour part in localized time zone offset.");
            return;
        }
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
            ++n6;
        } else {
            n6 += 2;
        }
        if (n6 >= n4) {
            if (this.abbreviated) {
                map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours((OffsetSign)offsetSign, (int)n2));
                parseLog.setPosition(n6);
            } else {
                parseLog.setError(n6, "Missing minute part in localized time zone offset.");
            }
            return;
        }
        string = formatStep.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART);
        if (charSequence.charAt(n6) == ':') {
            ++n6;
        } else {
            if (this.abbreviated) {
                map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours((OffsetSign)offsetSign, (int)n2));
                parseLog.setPosition(n6);
                return;
            }
            if (string.isStrict()) {
                parseLog.setError(n6, "Colon expected in localized time zone offset.");
                return;
            }
        }
        n = LocalizedGMTProcessor.parseTwoDigits(charSequence, n6, c);
        if (n == -1000) {
            parseLog.setError(n6, "Minute part in localized time zone offset does not match expected pattern mm.");
            return;
        }
        int n7 = 0;
        if ((n6 += 2) < n4 && charSequence.charAt(n6) == ':') {
            n6 = (n7 = LocalizedGMTProcessor.parseTwoDigits(charSequence, ++n6, c)) == -1000 ? --n6 : (n6 += 2);
        }
        if (n7 == 0 || n7 == -1000) {
            zonalOffset = ZonalOffset.ofHoursMinutes((OffsetSign)offsetSign, (int)n2, (int)n);
        } else {
            int n8 = n2 * 3600 + n * 60 + n7;
            if (offsetSign == OffsetSign.BEHIND_UTC) {
                n8 = -n8;
            }
            zonalOffset = ZonalOffset.ofTotalSeconds((int)n8);
        }
        map.put(TimezoneElement.TIMEZONE_OFFSET, zonalOffset);
        parseLog.setPosition(n6);
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_OFFSET;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    private static String getGMTPrefix(Locale locale) {
        CalendarText calendarText = CalendarText.getIsoInstance((Locale)locale);
        if (calendarText.getTextForms().isEmpty()) {
            return "GMT";
        }
        return (String)calendarText.getTextForms().get("prefixGMTOffset");
    }

    private static ZonalOffset getOffset(ChronoDisplay chronoDisplay, FormatStep formatStep, AttributeQuery attributeQuery) {
        TZID tZID;
        AttributeQuery attributeQuery2 = formatStep.getQuery(attributeQuery);
        if (attributeQuery2.contains(Attributes.TIMEZONE_ID) && (tZID = (TZID)attributeQuery2.get(Attributes.TIMEZONE_ID)) instanceof ZonalOffset) {
            return (ZonalOffset)tZID;
        }
        throw new IllegalArgumentException("Cannot extract timezone offset from format attributes for: " + chronoDisplay);
    }

    private static int parseTwoDigits(CharSequence charSequence, int n, char c) {
        int n2 = 0;
        for (int i = 0; i < 2; ++i) {
            if (n + i >= charSequence.length()) {
                return -1000;
            }
            int n3 = charSequence.charAt(n + i) - c;
            if (n3 < 0 || n3 > 9) {
                return -1000;
            }
            n2 = n2 * 10 + n3;
        }
        return n2;
    }

    private static int parseHours(CharSequence charSequence, int n, char c) {
        int n2 = 0;
        for (int i = 0; i < 2; ++i) {
            if (n + i >= charSequence.length()) {
                if (i == 0) {
                    return -1000;
                }
                return ~n2;
            }
            int n3 = charSequence.charAt(n + i) - c;
            if (n3 < 0 || n3 > 9) {
                if (i == 0) {
                    return -1000;
                }
                return ~n2;
            }
            n2 = n2 * 10 + n3;
        }
        return n2;
    }
}

