/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.NumericalElement;
import net.time4j.format.TextElement;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.SignPolicy;
import net.time4j.history.internal.HistorizedElement;

final class NumberProcessor<V>
implements FormatProcessor<V> {
    private final ChronoElement<V> element;
    private final boolean fixedWidth;
    private final int minDigits;
    private final int maxDigits;
    private final SignPolicy signPolicy;
    private final boolean protectedMode;
    private final boolean yearOfEra;

    NumberProcessor(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy, boolean bl2) {
        this.element = chronoElement;
        this.fixedWidth = bl;
        this.minDigits = n;
        this.maxDigits = n2;
        this.signPolicy = signPolicy;
        this.protectedMode = bl2;
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (signPolicy == null) {
            throw new NullPointerException("Missing sign policy.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Not positive: " + n);
        }
        if (n > n2) {
            throw new IllegalArgumentException("Max smaller than min: " + n2 + " < " + n);
        }
        if (bl && n != n2) {
            throw new IllegalArgumentException("Variable width in fixed-width-mode: " + n2 + " != " + n);
        }
        if (bl && signPolicy != SignPolicy.SHOW_NEVER) {
            throw new IllegalArgumentException("Sign policy must be SHOW_NEVER in fixed-width-mode.");
        }
        int n3 = this.getScale(NumberSystem.ARABIC);
        if (n > n3) {
            throw new IllegalArgumentException("Min digits out of range: " + n);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Max digits out of range: " + n2);
        }
        this.yearOfEra = this.element.name().equals("YEAR_OF_ERA");
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        int n = appendable instanceof CharSequence ? ((CharSequence)((Object)appendable)).length() : -1;
        int n2 = 0;
        if (this.yearOfEra && this.element instanceof HistorizedElement) {
            TextElement textElement = (TextElement)TextElement.class.cast(this.element);
            StringBuilder stringBuilder = new StringBuilder();
            textElement.print(chronoDisplay, (Appendable)stringBuilder, formatStep.getQuery(attributeQuery, this.minDigits, this.maxDigits));
            appendable.append(stringBuilder.toString());
            n2 = stringBuilder.length();
        } else {
            int n3;
            int n4;
            String string;
            int n5;
            Class clazz = this.element.getType();
            Object object = chronoDisplay.get(this.element);
            boolean bl = false;
            NumberSystem numberSystem = this.getNumberSystem(attributeQuery, formatStep);
            if (clazz == Integer.class) {
                n5 = (Integer)Integer.class.cast(object);
                bl = n5 < 0;
                string = NumberProcessor.toNumeral(numberSystem, n5);
            } else if (clazz == Long.class) {
                long l = (Long)Long.class.cast(object);
                bl = l < 0L;
                string = l == Long.MIN_VALUE ? "9223372036854775808" : Long.toString(Math.abs(l));
            } else if (Enum.class.isAssignableFrom(clazz)) {
                int n6 = -1;
                if (this.element instanceof NumericalElement) {
                    n6 = ((NumericalElement)this.element).numerical(object);
                    bl = n6 < 0;
                } else {
                    T[] TArray = clazz.getEnumConstants();
                    n4 = TArray.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        Object t = TArray[n3];
                        if (!t.equals(object)) continue;
                        n6 = ((Enum)Enum.class.cast(t)).ordinal();
                        break;
                    }
                    if (n6 == -1) {
                        throw new AssertionError((Object)("Enum broken: " + object + " / " + clazz.getName()));
                    }
                }
                string = NumberProcessor.toNumeral(numberSystem, n6);
            } else {
                throw new IllegalArgumentException("Not formattable: " + this.element);
            }
            if (string.length() > this.maxDigits) {
                throw new IllegalArgumentException("Element " + this.element.name() + " cannot be printed as the value " + object + " exceeds the maximum width of " + this.maxDigits + ".");
            }
            n5 = 0;
            if (numberSystem == NumberSystem.ARABIC && (n5 = (int)formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue()) != 48) {
                int n7 = n5 - 48;
                char[] cArray = string.toCharArray();
                for (n3 = 0; n3 < cArray.length; ++n3) {
                    cArray[n3] = (char)(cArray[n3] + n7);
                }
                string = new String(cArray);
            }
            if (bl) {
                if (this.signPolicy == SignPolicy.SHOW_NEVER) {
                    throw new IllegalArgumentException("Negative value not allowed according to sign policy.");
                }
                appendable.append('-');
                ++n2;
            } else {
                switch (this.signPolicy) {
                    case SHOW_ALWAYS: {
                        appendable.append('+');
                        ++n2;
                        break;
                    }
                    case SHOW_WHEN_BIG_NUMBER: {
                        if (string.length() <= this.minDigits) break;
                        appendable.append('+');
                        ++n2;
                        break;
                    }
                }
            }
            if (numberSystem == NumberSystem.ARABIC) {
                n4 = this.minDigits - string.length();
                for (int i = 0; i < n4; ++i) {
                    appendable.append((char)n5);
                    ++n2;
                }
            }
            appendable.append(string);
            n2 += string.length();
        }
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(this.element, n, n + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        int n;
        int n2;
        int n3;
        int n4 = charSequence.length();
        int n5 = parseLog.getPosition();
        int n6 = formatStep.getAttribute(Attributes.PROTECTED_CHARACTERS, attributeQuery, 0);
        if (n6 > 0) {
            n4 -= n6;
        }
        if (n5 >= n4) {
            parseLog.setError(n5, "Missing digits for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        if (this.yearOfEra && this.element instanceof HistorizedElement) {
            TextElement textElement = (TextElement)TextElement.class.cast(this.element);
            Object object = textElement.parse(charSequence, parseLog.getPP(), formatStep.getQuery(attributeQuery, this.minDigits, this.maxDigits));
            if (parseLog.isError()) {
                parseLog.setError(parseLog.getErrorIndex(), "Unparseable element: " + this.element.name());
            } else if (object == null) {
                parseLog.setError(n5, "No interpretable value.");
            } else {
                map.put(this.element, object);
            }
            return;
        }
        NumberSystem numberSystem = this.getNumberSystem(attributeQuery, formatStep);
        Leniency leniency = formatStep.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART);
        int n7 = 1;
        int n8 = this.getScale(numberSystem);
        if (this.fixedWidth || !leniency.isLax()) {
            n7 = this.minDigits;
            n8 = this.maxDigits;
        }
        int n9 = n5;
        boolean bl = false;
        char c = charSequence.charAt(n9);
        if (c == '-' || c == '+') {
            if (this.signPolicy == SignPolicy.SHOW_NEVER && (this.fixedWidth || leniency.isStrict())) {
                parseLog.setError(n5, "Sign not allowed due to sign policy.");
                return;
            }
            if (this.signPolicy == SignPolicy.SHOW_WHEN_NEGATIVE && c == '+' && leniency.isStrict()) {
                parseLog.setError(n5, "Positive sign not allowed due to sign policy.");
                return;
            }
            bl = c == '-';
            ++n9;
            ++n5;
        } else if (this.signPolicy == SignPolicy.SHOW_ALWAYS && leniency.isStrict()) {
            parseLog.setError(n5, "Missing sign of number.");
            return;
        }
        if (n9 >= n4) {
            parseLog.setError(n5, "Missing digits for: " + this.element.name());
            return;
        }
        char c2 = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        int n10 = formatStep.getReserved();
        if (!this.fixedWidth && n10 > 0 && n6 <= 0) {
            n3 = 0;
            if (numberSystem == NumberSystem.ARABIC) {
                int n11;
                for (n2 = n9; n2 < n4 && (n11 = charSequence.charAt(n2) - c2) >= 0 && n11 <= 9; ++n2) {
                    ++n3;
                }
            } else {
                for (n2 = n9; n2 < n4 && numberSystem.contains(charSequence.charAt(n2)); ++n2) {
                    ++n3;
                }
            }
            n8 = Math.min(n8, n3 - n10);
        }
        n3 = n9 + n7;
        n2 = Math.min(n4, n9 + n8);
        long l = 0L;
        boolean bl2 = true;
        if (numberSystem == NumberSystem.ARABIC) {
            while (n9 < n2) {
                n = charSequence.charAt(n9) - c2;
                if (n >= 0 && n <= 9) {
                    l = l * 10L + (long)n;
                    ++n9;
                    bl2 = false;
                    continue;
                }
                if (bl2) {
                    parseLog.setError(n5, "Digit expected.");
                    return;
                }
                break;
            }
        } else {
            n = 0;
            while (n9 < n2) {
                if (numberSystem.contains(charSequence.charAt(n9))) {
                    ++n;
                    ++n9;
                    bl2 = false;
                    continue;
                }
                if (!bl2) break;
                parseLog.setError(n5, "Digit expected.");
                return;
            }
            l = numberSystem.toInteger(charSequence.subSequence(n9 - n, n9).toString());
        }
        if (n9 < n3 && (bl2 || this.fixedWidth || !leniency.isLax())) {
            parseLog.setError(n5, "Not enough digits found for: " + this.element.name());
            return;
        }
        if (bl) {
            if (l == 0L && leniency.isStrict()) {
                parseLog.setError(n5 - 1, "Negative zero is not allowed.");
                return;
            }
            l = -l;
        } else if (this.signPolicy == SignPolicy.SHOW_WHEN_BIG_NUMBER && leniency.isStrict() && numberSystem == NumberSystem.ARABIC) {
            if (c == '+' && n9 <= n3) {
                parseLog.setError(n5 - 1, "Positive sign only allowed for big number.");
            } else if (c != '+' && n9 > n3) {
                parseLog.setError(n5, "Positive sign must be present for big number.");
            }
        }
        Number number = null;
        Class clazz = this.element.getType();
        if (clazz == Integer.class) {
            number = (int)l;
        } else if (clazz == Long.class) {
            number = l;
        } else if (Enum.class.isAssignableFrom(clazz)) {
            if (this.element instanceof NumericalElement) {
                NumericalElement numericalElement = (NumericalElement)this.element;
                for (Object t : clazz.getEnumConstants()) {
                    if ((long)numericalElement.numerical(clazz.cast(t)) != l) continue;
                    number = t;
                    break;
                }
            } else {
                for (Object t : clazz.getEnumConstants()) {
                    if ((long)((Enum)Enum.class.cast(t)).ordinal() != l) continue;
                    number = t;
                    break;
                }
            }
            if (number == null) {
                parseLog.setError(c == '-' || c == '+' ? n5 - 1 : n5, "[" + this.element.name() + "] No enum found for value: " + l);
                return;
            }
        } else {
            throw new IllegalArgumentException("Not parseable: " + this.element);
        }
        map.put(this.element, number);
        parseLog.setPosition(n9);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NumberProcessor) {
            NumberProcessor numberProcessor = (NumberProcessor)object;
            return this.element.equals(numberProcessor.element) && this.fixedWidth == numberProcessor.fixedWidth && this.minDigits == numberProcessor.minDigits && this.maxDigits == numberProcessor.maxDigits && this.signPolicy == numberProcessor.signPolicy && this.protectedMode == numberProcessor.protectedMode;
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * (this.minDigits + this.maxDigits * 10);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", fixed-width-mode=");
        stringBuilder.append(this.fixedWidth);
        stringBuilder.append(", min-digits=");
        stringBuilder.append(this.minDigits);
        stringBuilder.append(", max-digits=");
        stringBuilder.append(this.maxDigits);
        stringBuilder.append(", sign-policy=");
        stringBuilder.append((Object)this.signPolicy);
        stringBuilder.append(", protected-mode=");
        stringBuilder.append(this.protectedMode);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.protectedMode || this.element == chronoElement) {
            return this;
        }
        return new NumberProcessor<V>(chronoElement, this.fixedWidth, this.minDigits, this.maxDigits, this.signPolicy, false);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    private int getScale(NumberSystem numberSystem) {
        if (numberSystem == NumberSystem.ARABIC) {
            return this.element.getType() == Long.class ? 18 : 9;
        }
        return Integer.MAX_VALUE;
    }

    private static String toNumeral(NumberSystem numberSystem, int n) {
        if (n == Integer.MIN_VALUE && numberSystem == NumberSystem.ARABIC) {
            return "2147483648";
        }
        return numberSystem.toNumeral(Math.abs(n));
    }

    private NumberSystem getNumberSystem(AttributeQuery attributeQuery, FormatStep formatStep) {
        NumberSystem numberSystem = NumberSystem.ARABIC;
        if (this.yearOfEra && formatStep.getAttribute(Attributes.LANGUAGE, attributeQuery, Locale.ROOT).getLanguage().equals("am") && formatStep.getAttribute(Attributes.CALENDAR_TYPE, attributeQuery, "iso8601").equals("ethiopic")) {
            numberSystem = NumberSystem.ETHIOPIC;
        }
        return formatStep.getAttribute(Attributes.NUMBER_SYSTEM, attributeQuery, numberSystem);
    }
}

