/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.LocalizedGMTProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedValues;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class TimezoneNameProcessor
implements FormatProcessor<TZID> {
    private static final ConcurrentMap<Locale, TZNames> CACHE_ABBREVIATIONS = new ConcurrentHashMap<Locale, TZNames>();
    private static final ConcurrentMap<Locale, TZNames> CACHE_ZONENAMES = new ConcurrentHashMap<Locale, TZNames>();
    private static final int MAX = 25;
    private static final String DEFAULT_PROVIDER = "DEFAULT";
    private final boolean abbreviated;
    private final FormatProcessor<TZID> fallback;
    private final Set<TZID> preferredZones;
    private final Leniency lenientMode;
    private final Locale locale;

    TimezoneNameProcessor(boolean bl) {
        this.abbreviated = bl;
        this.fallback = new LocalizedGMTProcessor(bl);
        this.preferredZones = null;
        this.lenientMode = Leniency.SMART;
        this.locale = Locale.ROOT;
    }

    TimezoneNameProcessor(boolean bl, Set<TZID> set) {
        this.abbreviated = bl;
        this.fallback = new LocalizedGMTProcessor(bl);
        this.preferredZones = Collections.unmodifiableSet(new LinkedHashSet<TZID>(set));
        this.lenientMode = Leniency.SMART;
        this.locale = Locale.ROOT;
    }

    private TimezoneNameProcessor(boolean bl, FormatProcessor<TZID> formatProcessor, Set<TZID> set, Leniency leniency, Locale locale) {
        this.abbreviated = bl;
        this.fallback = formatProcessor;
        this.preferredZones = set;
        this.lenientMode = leniency;
        this.locale = locale;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        if (!chronoDisplay.hasTimezone()) {
            throw new IllegalArgumentException("Cannot extract timezone id from: " + chronoDisplay);
        }
        TZID tZID = chronoDisplay.getTimezone();
        if (tZID instanceof ZonalOffset) {
            this.fallback.print(chronoDisplay, appendable, attributeQuery, set, bl);
            return;
        }
        if (!(chronoDisplay instanceof UnixTime)) {
            throw new IllegalArgumentException("Cannot extract timezone name from: " + chronoDisplay);
        }
        Timezone timezone = Timezone.of((TZID)tZID);
        UnixTime unixTime = (UnixTime)UnixTime.class.cast(chronoDisplay);
        String string = timezone.getDisplayName(this.getStyle(timezone.isDaylightSaving(unixTime)), bl ? this.locale : (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT));
        int n = -1;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        appendable.append(string);
        int n2 = string.length();
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n, n + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedValues parsedValues, boolean bl) {
        int n;
        List<TZID> list;
        List<TZID> list2;
        List<TZID> list3;
        Object object;
        char c;
        int n2 = charSequence.length();
        int n3 = parseLog.getPosition();
        int n4 = n3;
        if (n4 >= n2) {
            parseLog.setError(n3, "Missing timezone name.");
            return;
        }
        Locale locale = bl ? this.locale : (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT);
        Leniency leniency = bl ? this.lenientMode : (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART);
        StringBuilder stringBuilder = new StringBuilder();
        while (n4 < n2 && (Character.isLetter(c = charSequence.charAt(n4)) || !this.abbreviated && n4 > n3 && !Character.isDigit(c))) {
            stringBuilder.append(c);
            ++n4;
        }
        String string = stringBuilder.toString().trim();
        n4 = n3 + string.length();
        if (string.startsWith("GMT") || string.startsWith("UT")) {
            this.fallback.parse(charSequence, parseLog, attributeQuery, parsedValues, bl);
            return;
        }
        ConcurrentMap<Locale, TZNames> concurrentMap = this.abbreviated ? CACHE_ABBREVIATIONS : CACHE_ZONENAMES;
        Object object2 = (TZNames)concurrentMap.get(locale);
        if (object2 == null) {
            object = this.getTimezoneNameMap(locale, false);
            list3 = this.getTimezoneNameMap(locale, true);
            object2 = new TZNames((Map<String, List<TZID>>)object, (Map<String, List<TZID>>)((Object)list3));
            if (concurrentMap.size() < 25 && (list2 = concurrentMap.putIfAbsent(locale, (TZNames)object2)) != null) {
                object2 = list2;
            }
        }
        object = new int[]{n4, n4};
        list3 = TimezoneNameProcessor.readZones((TZNames)object2, string, false, object);
        list2 = TimezoneNameProcessor.readZones((TZNames)object2, string, true, object);
        int n5 = list3.size() + list2.size();
        if (n5 == 0) {
            parseLog.setError(n3, "Unknown timezone name: " + string);
            return;
        }
        if (n5 > 1 && !leniency.isStrict()) {
            list3 = TimezoneNameProcessor.excludeWinZones(list3);
            list2 = TimezoneNameProcessor.excludeWinZones(list2);
            n5 = list3.size() + list2.size();
        }
        List<TZID> list4 = list3;
        List<TZID> list5 = list2;
        if (n5 > 1 && !leniency.isLax()) {
            if (list3.size() > 0) {
                list3 = this.resolveUsingPreferred(list3, locale, leniency);
            }
            if (list2.size() > 0) {
                list2 = this.resolveUsingPreferred(list2, locale, leniency);
            }
        }
        if ((n5 = list3.size() + list2.size()) == 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TZID tZID : list4) {
                arrayList.add(tZID.canonical());
            }
            for (TZID tZID : list5) {
                arrayList.add(tZID.canonical());
            }
            parseLog.setError(n3, "Time zone name \"" + string + "\" not found among preferred timezones in locale " + locale + ", candidates=" + arrayList);
            return;
        }
        if (list3.size() > 0) {
            list = list3;
            n = 0;
            if (n5 == 2 && list2.size() > 0 && list3.get(0).canonical().equals(list2.get(0).canonical())) {
                list2.remove(0);
                --n5;
            } else if (!list2.isEmpty()) {
                list = new ArrayList<TZID>(list);
                list.addAll(list2);
            }
        } else {
            list = list2;
            n = 1;
        }
        if (n5 > 1) {
            ArrayList<TZID> arrayList = null;
            for (TZID tZID : list) {
                if (tZID.canonical().indexOf(126) != -1) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<TZID>();
                }
                arrayList.add(tZID);
            }
            if (arrayList != null) {
                list = arrayList;
                n5 = list.size();
            }
        }
        if (n5 == 1 || leniency.isLax()) {
            parsedValues.put(TimezoneElement.TIMEZONE_ID, list.get(0));
            parseLog.setPosition(object[n]);
            if (((TZNames)object2).isDaylightSensitive()) {
                parseLog.setDaylightSaving(n == 1);
            }
        } else {
            parseLog.setError(n3, "Time zone name is not unique: \"" + string + "\" in " + TimezoneNameProcessor.toString(list));
        }
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_ID;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<TZID> quickPath(AttributeQuery attributeQuery, int n) {
        return new TimezoneNameProcessor(this.abbreviated, this.fallback, this.preferredZones, (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART), (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT));
    }

    private Map<String, List<TZID>> getTimezoneNameMap(Locale locale, boolean bl) {
        HashMap<String, ArrayList<TZID>> hashMap = new HashMap<String, ArrayList<TZID>>();
        for (TZID tZID : Timezone.getAvailableIDs()) {
            Timezone timezone = Timezone.of((TZID)tZID);
            String string = timezone.getDisplayName(this.getStyle(bl), locale);
            if (string.equals(tZID.canonical())) continue;
            ArrayList<TZID> arrayList = (ArrayList<TZID>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<TZID>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(tZID);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static List<TZID> readZones(TZNames tZNames, String string, boolean bl, int[] nArray) {
        int n;
        List<TZID> list = tZNames.search(string, bl);
        if (list.isEmpty() && !Character.isLetter(string.charAt(n = string.length() - 1)) && !(list = tZNames.search(string.substring(0, n), bl)).isEmpty()) {
            int n2;
            int n3 = n2 = bl ? 1 : 0;
            nArray[n3] = nArray[n3] - 1;
        }
        return list;
    }

    private static List<TZID> excludeWinZones(List<TZID> list) {
        if (list.size() > 1) {
            ArrayList<TZID> arrayList = new ArrayList<TZID>(list);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                TZID tZID = list.get(i);
                if (!tZID.canonical().startsWith("WINDOWS~")) continue;
                arrayList.remove(tZID);
            }
            if (!arrayList.isEmpty()) {
                return arrayList;
            }
        }
        return list;
    }

    private List<TZID> resolveUsingPreferred(List<TZID> list, Locale locale, Leniency leniency) {
        Object object2;
        HashMap hashMap = new HashMap();
        hashMap.put(DEFAULT_PROVIDER, new ArrayList());
        block0: for (Object object2 : list) {
            String string = object2.canonical();
            Object object3 = this.preferredZones;
            String string2 = DEFAULT_PROVIDER;
            int n = string.indexOf(126);
            if (n >= 0) {
                string2 = string.substring(0, n);
            }
            if (object3 == null) {
                object3 = Timezone.getPreferredIDs((Locale)locale, (boolean)leniency.isSmart(), (String)string2);
            }
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                TZID tZID = (TZID)iterator.next();
                if (!tZID.canonical().equals(string)) continue;
                ArrayList<TZID> arrayList = (ArrayList<TZID>)hashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<TZID>();
                    hashMap.put(string2, arrayList);
                }
                arrayList.add(tZID);
                continue block0;
            }
        }
        Object object4 = (List)hashMap.get(DEFAULT_PROVIDER);
        object2 = list;
        if (object4.isEmpty()) {
            hashMap.remove(DEFAULT_PROVIDER);
            boolean bl = false;
            for (String string2 : hashMap.keySet()) {
                object4 = (List)hashMap.get(string2);
                if (object4.isEmpty()) continue;
                bl = true;
                object2 = object4;
                break;
            }
            if (!bl) {
                object2 = Collections.emptyList();
            }
        } else {
            object2 = object4;
        }
        return object2;
    }

    private NameStyle getStyle(boolean bl) {
        if (bl) {
            return this.abbreviated ? NameStyle.SHORT_DAYLIGHT_TIME : NameStyle.LONG_DAYLIGHT_TIME;
        }
        return this.abbreviated ? NameStyle.SHORT_STANDARD_TIME : NameStyle.LONG_STANDARD_TIME;
    }

    private static String toString(List<TZID> list) {
        StringBuilder stringBuilder = new StringBuilder(list.size() * 16);
        stringBuilder.append('{');
        boolean bl = true;
        for (TZID tZID : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(tZID.canonical());
        }
        return stringBuilder.append('}').toString();
    }

    private static class TZNames {
        private final boolean dstSensitive;
        private final Map<String, List<TZID>> stdNames;
        private final Map<String, List<TZID>> dstNames;

        TZNames(Map<String, List<TZID>> map, Map<String, List<TZID>> map2) {
            this.stdNames = map;
            this.dstNames = map2;
            this.dstSensitive = !map.keySet().equals(map2.keySet());
        }

        boolean isDaylightSensitive() {
            return this.dstSensitive;
        }

        List<TZID> search(String string, boolean bl) {
            Map<String, List<TZID>> map;
            Map<String, List<TZID>> map2 = map = bl ? this.dstNames : this.stdNames;
            if (map.containsKey(string)) {
                return map.get(string);
            }
            return Collections.emptyList();
        }
    }
}

