/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.ObjectStreamException;
import net.time4j.PlainDate;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;

final class HistoricalDateElement
extends BasicElement<HistoricDate> {
    private static final int YMAX = 999999999;
    private static final long serialVersionUID = -5386613740709845550L;
    private final ChronoHistory history;

    HistoricalDateElement(ChronoHistory chronoHistory) {
        super("HISTORIC_DATE");
        this.history = chronoHistory;
    }

    public Class<HistoricDate> getType() {
        return HistoricDate.class;
    }

    public HistoricDate getDefaultMinimum() {
        return HistoricDate.of(HistoricEra.BC, 999999999, 1, 1);
    }

    public HistoricDate getDefaultMaximum() {
        return HistoricDate.of(HistoricEra.AD, 999999999, 12, 31);
    }

    public boolean isDateElement() {
        return true;
    }

    public boolean isTimeElement() {
        return false;
    }

    protected <T extends ChronoEntity<T>> ElementRule<T, HistoricDate> derive(Chronology<T> chronology) {
        if (chronology.isRegistered((ChronoElement)PlainDate.COMPONENT)) {
            return new Rule(this.history);
        }
        return null;
    }

    protected boolean doEquals(BasicElement<?> basicElement) {
        return this.history.equals(((HistoricalDateElement)basicElement).history);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.history.date();
    }

    private static class Rule<C extends ChronoEntity<C>>
    implements ElementRule<C, HistoricDate> {
        private final ChronoHistory history;

        Rule(ChronoHistory chronoHistory) {
            this.history = chronoHistory;
        }

        public HistoricDate getValue(C c) {
            try {
                return this.history.convert((PlainDate)c.get((ChronoElement)PlainDate.COMPONENT));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), (Exception)illegalArgumentException);
            }
        }

        public HistoricDate getMinimum(C c) {
            try {
                return this.history.convert((PlainDate)PlainDate.axis().getMinimum());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), (Exception)illegalArgumentException);
            }
        }

        public HistoricDate getMaximum(C c) {
            try {
                return this.history.convert((PlainDate)PlainDate.axis().getMaximum());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), (Exception)illegalArgumentException);
            }
        }

        public boolean isValid(C c, HistoricDate historicDate) {
            return this.history.isValid(historicDate);
        }

        public C withValue(C c, HistoricDate historicDate, boolean bl) {
            if (historicDate != null) {
                PlainDate plainDate = this.history.convert(historicDate);
                return (C)c.with((ChronoElement)PlainDate.COMPONENT, (Object)plainDate);
            }
            throw new IllegalArgumentException("Missing historic date.");
        }

        public ChronoElement<?> getChildAtFloor(C c) {
            throw new UnsupportedOperationException("Never called.");
        }

        public ChronoElement<?> getChildAtCeiling(C c) {
            throw new UnsupportedOperationException("Never called.");
        }
    }
}

